/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.osgi;

import java.net.InetSocketAddress;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.ConnectorFactory;
import org.eclipse.californium.osgi.EndpointFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServerEndpointFactory
implements EndpointFactory {
    private final Logger log = LoggerFactory.getLogger(SimpleServerEndpointFactory.class);
    private ConnectorFactory secureConnectorFactory;

    public SimpleServerEndpointFactory(ConnectorFactory secureConnectorFactory) {
        this.secureConnectorFactory = secureConnectorFactory;
    }

    @Override
    public final Endpoint getEndpoint(NetworkConfig config, InetSocketAddress address) {
        CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
        builder.setNetworkConfig(config);
        builder.setInetSocketAddress(address);
        return builder.build();
    }

    @Override
    public final Endpoint getSecureEndpoint(NetworkConfig config, InetSocketAddress address) {
        CoapEndpoint endpoint = null;
        if (this.secureConnectorFactory != null) {
            Connector connector = this.secureConnectorFactory.newConnector(address);
            CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
            builder.setNetworkConfig(config);
            builder.setConnector(connector);
            endpoint = builder.build();
        } else {
            this.log.debug("A secure ConnectorFactory is required to create secure Endpoints.");
        }
        return endpoint;
    }
}

