/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;

public final class XR {
    @Nullable
    private static FunctionProvider functionProvider;
    @Nullable
    private static GlobalCommands globalCommands;

    private XR() {
    }

    public static void create() {
        XR.create((FunctionProvider)Library.loadNative(XR.class, (String)"org.lwjgl.openxr", (String)((String)Configuration.OPENXR_LIBRARY_NAME.get((Object)Platform.mapLibraryNameBundled((String)(Platform.get() == Platform.WINDOWS ? "openxr-loader" : "openxr_loader")))), (boolean)true));
    }

    public static void create(String libName) {
        XR.create((FunctionProvider)Library.loadNative(XR.class, (String)"org.lwjgl.openxr", (String)libName));
    }

    public static void create(FunctionProvider functionProvider) {
        if (XR.functionProvider != null) {
            throw new IllegalStateException("OpenXR has already been created.");
        }
        XR.functionProvider = functionProvider;
        globalCommands = new GlobalCommands(functionProvider);
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)functionProvider).free();
        }
        functionProvider = null;
        globalCommands = null;
    }

    private static <T> T check(@Nullable T t) {
        if (t == null) {
            throw new IllegalStateException("OpenXR library has not been loaded.");
        }
        return t;
    }

    public static FunctionProvider getFunctionProvider() {
        return XR.check(functionProvider);
    }

    static GlobalCommands getGlobalCommands() {
        return XR.check(globalCommands);
    }

    static Set<String> getEnabledExtensionSet(long apiVersion, @Nullable PointerBuffer extensionNames) {
        HashSet<String> enabledExtensions = new HashSet<String>(16);
        short majorVersion = XR10.XR_VERSION_MAJOR(apiVersion);
        short minorVersion = XR10.XR_VERSION_MINOR(apiVersion);
        int[] XR_VERSIONS = new int[]{0};
        int maxMajor = Math.min(majorVersion, XR_VERSIONS.length);
        for (int M = 1; M <= maxMajor; ++M) {
            int maxMinor = XR_VERSIONS[M - 1];
            if (M == majorVersion) {
                maxMinor = Math.min(minorVersion, maxMinor);
            }
            for (int m = 0; m <= maxMinor; ++m) {
                enabledExtensions.add(String.format("OpenXR%d%d", M, m));
            }
        }
        if (extensionNames != null) {
            for (int i = extensionNames.position(); i < extensionNames.limit(); ++i) {
                enabledExtensions.add(extensionNames.getStringUTF8(i));
            }
        }
        return enabledExtensions;
    }

    static {
        if (!((Boolean)Configuration.OPENXR_EXPLICIT_INIT.get((Object)false)).booleanValue()) {
            XR.create();
        }
    }

    static class GlobalCommands {
        final long xrGetInstanceProcAddr;
        final long xrCreateInstance;
        final long xrEnumerateInstanceExtensionProperties;
        final long xrEnumerateApiLayerProperties;
        final long xrInitializeLoaderKHR;

        GlobalCommands(FunctionProvider library) {
            this.xrGetInstanceProcAddr = library.getFunctionAddress((CharSequence)"xrGetInstanceProcAddr");
            if (this.xrGetInstanceProcAddr == 0L) {
                throw new IllegalArgumentException("A critical function is missing. Make sure that OpenXR is available.");
            }
            this.xrCreateInstance = this.getFunctionAddress("xrCreateInstance");
            this.xrEnumerateInstanceExtensionProperties = this.getFunctionAddress("xrEnumerateInstanceExtensionProperties");
            this.xrEnumerateApiLayerProperties = this.getFunctionAddress("xrEnumerateApiLayerProperties");
            this.xrInitializeLoaderKHR = this.getFunctionAddress("xrInitializeLoaderKHR", false);
        }

        private long getFunctionAddress(String name) {
            return this.getFunctionAddress(name, true);
        }

        private long getFunctionAddress(String name, boolean required) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer pp = stack.mallocPointer(1);
                int result = JNI.callPPPI((long)0L, (long)MemoryUtil.memAddress((ByteBuffer)stack.ASCII((CharSequence)name)), (long)pp.address(), (long)this.xrGetInstanceProcAddr);
                if (result != 0 && required) {
                    throw new IllegalArgumentException("A critical function is missing. Make sure that OpenXR is available.");
                }
                long l = pp.get(0);
                return l;
            }
        }
    }
}

