/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.jdbc.MergeOperation;

public abstract class SqlAstTranslatorWithMerge<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public SqlAstTranslatorWithMerge(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    public MergeOperation createMergeOperation(OptionalTableUpdate optionalTableUpdate) {
        this.renderMergeStatement(optionalTableUpdate);
        return new MergeOperation(optionalTableUpdate.getMutatingTable().getTableMapping(), optionalTableUpdate.getMutationTarget(), this.getSql(), this.getParameterBinders());
    }

    protected void renderMergeStatement(OptionalTableUpdate optionalTableUpdate) {
        this.renderMergeInto(optionalTableUpdate);
        this.appendSql(" ");
        this.renderMergeUsing(optionalTableUpdate);
        this.appendSql(" ");
        this.renderMergeOn(optionalTableUpdate);
        this.appendSql(" ");
        this.renderMergeInsert(optionalTableUpdate);
        this.appendSql(" ");
        if (optionalTableUpdate.getMutatingTable().isOptional()) {
            this.renderMergeDelete(optionalTableUpdate);
            this.appendSql(" ");
        }
        this.renderMergeUpdate(optionalTableUpdate);
    }

    protected void renderMergeInto(OptionalTableUpdate optionalTableUpdate) {
        this.appendSql("merge into ");
        this.renderMergeTarget(optionalTableUpdate);
    }

    private void renderMergeTarget(OptionalTableUpdate optionalTableUpdate) {
        this.appendSql(optionalTableUpdate.getMutatingTable().getTableName());
        this.appendSql(" ");
        this.renderMergeTargetAlias();
    }

    protected void renderMergeTargetAlias() {
        this.appendSql("as t");
    }

    protected void renderMergeUsing(OptionalTableUpdate optionalTableUpdate) {
        this.appendSql("using (");
        this.renderMergeUsingQuery(optionalTableUpdate);
        this.appendSql(") ");
        this.renderMergeSourceAlias();
    }

    protected void renderMergeSourceAlias() {
        this.appendSql("as s");
    }

    private void renderMergeUsingQuery(OptionalTableUpdate optionalTableUpdate) {
        int i;
        List<ColumnValueBinding> valueBindings = optionalTableUpdate.getValueBindings();
        List<ColumnValueBinding> keyBindings = optionalTableUpdate.getKeyBindings();
        this.appendSql("select ");
        for (i = 0; i < keyBindings.size(); ++i) {
            if (i > 0) {
                this.appendSql(", ");
            }
            this.renderMergeUsingQuerySelection(keyBindings.get(i));
        }
        for (i = 0; i < valueBindings.size(); ++i) {
            this.appendSql(", ");
            this.renderMergeUsingQuerySelection(valueBindings.get(i));
        }
        String selectionTable = StringHelper.nullIfEmpty(this.getFromDualForSelectOnly());
        if (selectionTable != null) {
            this.appendSql(" ");
            this.appendSql(selectionTable);
        }
    }

    protected void renderMergeUsingQuerySelection(ColumnValueBinding selectionBinding) {
        this.renderCasted(selectionBinding.getValueExpression());
        this.appendSql(" ");
        this.appendSql(selectionBinding.getColumnReference().getColumnExpression());
    }

    protected void renderMergeOn(OptionalTableUpdate optionalTableUpdate) {
        this.appendSql("on (");
        List<ColumnValueBinding> keyBindings = optionalTableUpdate.getKeyBindings();
        for (int i = 0; i < keyBindings.size(); ++i) {
            ColumnValueBinding keyBinding = keyBindings.get(i);
            if (i > 0) {
                this.appendSql(" and ");
            }
            keyBinding.getColumnReference().appendReadExpression(this, "t");
            this.appendSql("=");
            keyBinding.getColumnReference().appendReadExpression(this, "s");
        }
        this.appendSql(")");
    }

    protected void renderMergeInsert(OptionalTableUpdate optionalTableUpdate) {
        int i;
        List<ColumnValueBinding> valueBindings = optionalTableUpdate.getValueBindings();
        List<ColumnValueBinding> keyBindings = optionalTableUpdate.getKeyBindings();
        StringBuilder valuesList = new StringBuilder();
        this.appendSql("when not matched then insert (");
        for (i = 0; i < keyBindings.size(); ++i) {
            if (i > 0) {
                this.appendSql(", ");
                valuesList.append(", ");
            }
            ColumnValueBinding keyBinding = keyBindings.get(i);
            this.appendSql(keyBinding.getColumnReference().getColumnExpression());
            keyBinding.getColumnReference().appendReadExpression("s", valuesList::append);
        }
        for (i = 0; i < valueBindings.size(); ++i) {
            this.appendSql(", ");
            valuesList.append(", ");
            ColumnValueBinding valueBinding = valueBindings.get(i);
            this.appendSql(valueBinding.getColumnReference().getColumnExpression());
            valueBinding.getColumnReference().appendReadExpression("s", valuesList::append);
        }
        this.appendSql(") values (");
        this.appendSql(valuesList.toString());
        this.appendSql(")");
    }

    protected void renderMergeDelete(OptionalTableUpdate optionalTableUpdate) {
        List<ColumnValueBinding> valueBindings = optionalTableUpdate.getValueBindings();
        this.appendSql(" when matched ");
        for (int i = 0; i < valueBindings.size(); ++i) {
            ColumnValueBinding binding = valueBindings.get(i);
            this.appendSql(" and ");
            binding.getColumnReference().appendReadExpression(this, "s");
            this.appendSql(" is null");
        }
        this.appendSql(" then delete");
    }

    protected void renderMergeUpdate(OptionalTableUpdate optionalTableUpdate) {
        List<ColumnValueBinding> valueBindings = optionalTableUpdate.getValueBindings();
        this.appendSql(" when matched then update set ");
        for (int i = 0; i < valueBindings.size(); ++i) {
            ColumnValueBinding binding = valueBindings.get(i);
            if (i > 0) {
                this.appendSql(", ");
            }
            binding.getColumnReference().appendColumnForWrite(this, null);
            this.appendSql("=");
            binding.getColumnReference().appendColumnForWrite(this, "s");
        }
    }
}

