/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class BeforeSuiteEventProcessor
extends AbstractTestEventProcessor {
    private static final Pattern GRADLE_PARTITION_SUITE_NAME = Pattern.compile("Partition \\d+ in session \\d+");

    public BeforeSuiteEventProcessor(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    protected boolean isSuite() {
        return true;
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        if (eventXml == null) {
            BeforeSuiteEventProcessor.$$$reportNull$$$0(0);
        }
        String testId = eventXml.getTestId();
        String parentTestId = eventXml.getTestParentId();
        String suiteName = (String)ObjectUtils.coalesce((Object)StringUtil.nullize((String)eventXml.getTestClassName()), (Object)eventXml.getTestDisplayName());
        String fqClassName = eventXml.getTestClassName();
        String displayName = eventXml.getTestDisplayName();
        this.doProcess(testId, parentTestId, suiteName, fqClassName, displayName);
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
        if (testEvent == null) {
            BeforeSuiteEventProcessor.$$$reportNull$$$0(1);
        }
        TestOperationDescriptor testDescriptor = (TestOperationDescriptor)testEvent.getDescriptor();
        String testId = testEvent.getEventId();
        String parentTestId = testEvent.getParentEventId();
        String suiteName = StringUtil.notNullize((String)testDescriptor.getSuiteName());
        String fqClassName = StringUtil.notNullize((String)testDescriptor.getClassName());
        String displayName = testDescriptor.getDisplayName();
        this.doProcess(testId, parentTestId, suiteName, fqClassName, displayName);
    }

    private void doProcess(@NotNull String testId, @Nullable String parentTestId, @NotNull String suiteName, @NotNull String fqClassName, @NotNull String displayName) {
        GradleSMTestProxy testProxy;
        boolean isCombineSameTests;
        if (testId == null) {
            BeforeSuiteEventProcessor.$$$reportNull$$$0(2);
        }
        if (suiteName == null) {
            BeforeSuiteEventProcessor.$$$reportNull$$$0(3);
        }
        if (fqClassName == null) {
            BeforeSuiteEventProcessor.$$$reportNull$$$0(4);
        }
        if (displayName == null) {
            BeforeSuiteEventProcessor.$$$reportNull$$$0(5);
        }
        boolean bl = isCombineSameTests = !this.showInternalTestNodes();
        if (isCombineSameTests && BeforeSuiteEventProcessor.isHiddenTestNode(suiteName)) {
            SMTestProxy parentTestProxy = this.findParentTestProxy(parentTestId);
            this.registerTestProxy(testId, parentTestProxy);
            return;
        }
        if (isCombineSameTests && (testProxy = this.findSuiteTestProxy(suiteName, parentTestId)) != null) {
            this.registerTestProxy(testId, testProxy);
            return;
        }
        testProxy = this.createTestProxy(parentTestId, suiteName, fqClassName, null, displayName);
        this.registerTestProxy(testId, testProxy);
        if (isCombineSameTests) {
            this.registerTestProxy(fqClassName, testProxy);
        }
    }

    @Nullable
    private GradleSMTestProxy findSuiteTestProxy(@NotNull String suiteId, @Nullable String parentTestId) {
        if (suiteId == null) {
            BeforeSuiteEventProcessor.$$$reportNull$$$0(6);
        }
        SMTestProxy parentTestProxy = this.findParentTestProxy(parentTestId);
        SMTestProxy testProxy = this.findTestProxy(suiteId);
        if (testProxy instanceof GradleSMTestProxy && Objects.equals(testProxy.getParent(), parentTestProxy)) {
            return (GradleSMTestProxy)testProxy;
        }
        return null;
    }

    private static boolean isHiddenTestNode(@Nullable String suiteName) {
        return suiteName == null || suiteName.startsWith("Gradle Test Executor") || suiteName.startsWith("Gradle Test Run") || GRADLE_PARTITION_SUITE_NAME.matcher(suiteName).lookingAt();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventXml";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testEvent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqClassName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/BeforeSuiteEventProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findSuiteTestProxy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

