/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.externalSystem.psi.search.ExternalModuleBuildGlobalSearchScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageDirectoryCache;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;

public final class GradleClassFinder
extends NonClasspathClassFinder {
    private static final String KOTLIN_DEFAULT_EXTENSION = "kt";

    public GradleClassFinder(@NotNull Project project) {
        if (project == null) {
            GradleClassFinder.$$$reportNull$$$0(0);
        }
        super(project, new String[]{"java", "groovy", KOTLIN_DEFAULT_EXTENSION});
    }

    protected List<VirtualFile> calcClassRoots() {
        return GradleBuildClasspathManager.getInstance(this.myProject).getAllClasspathEntries();
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope) {
        if (scope instanceof ExternalModuleBuildGlobalSearchScope) {
            GradleBuildClasspathManager buildClasspathManager = GradleBuildClasspathManager.getInstance(this.myProject);
            Map<String, PackageDirectoryCache> classFinderCache = buildClasspathManager.getClassFinderCache();
            PackageDirectoryCache packageDirectoryCache = classFinderCache.get(((ExternalModuleBuildGlobalSearchScope)scope).getExternalModulePath());
            if (packageDirectoryCache == null) {
                GradleClassFinder.$$$reportNull$$$0(1);
            }
            return packageDirectoryCache;
        }
        PackageDirectoryCache packageDirectoryCache = super.getCache(scope);
        if (packageDirectoryCache == null) {
            GradleClassFinder.$$$reportNull$$$0(2);
        }
        return packageDirectoryCache;
    }

    public void clearCache() {
        super.clearCache();
        GradleBuildClasspathManager buildClasspathManager = GradleBuildClasspathManager.getInstance(this.myProject);
        Map<String, PackageDirectoryCache> classFinderCache = buildClasspathManager.getClassFinderCache();
        classFinderCache.clear();
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass aClass;
        if (qualifiedName == null) {
            GradleClassFinder.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            GradleClassFinder.$$$reportNull$$$0(4);
        }
        if ((aClass = super.findClass(qualifiedName, scope)) == null || scope instanceof ExternalModuleBuildGlobalSearchScope || scope instanceof EverythingGlobalScope) {
            return aClass;
        }
        PsiFile containingFile = aClass.getContainingFile();
        VirtualFile file = containingFile != null ? containingFile.getVirtualFile() : null;
        return file != null && !ProjectFileIndex.getInstance((Project)this.myProject).isInContent(file) && !ProjectFileIndex.getInstance((Project)this.myProject).isInLibrary(file) ? aClass : null;
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            GradleClassFinder.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            GradleClassFinder.$$$reportNull$$$0(6);
        }
        PsiPackage[] psiPackageArray = scope instanceof ExternalModuleBuildGlobalSearchScope ? super.getSubPackages(psiPackage, scope) : PsiPackage.EMPTY_ARRAY;
        if (psiPackageArray == null) {
            GradleClassFinder.$$$reportNull$$$0(7);
        }
        return psiPackageArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/config/GradleClassFinder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/config/GradleClassFinder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 7 -> new IllegalStateException(string);
        };
    }
}

