/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.ComboBoxPropertyEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.LayoutManagerRegistry;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class LayoutManagerProperty
extends Property<RadContainer, String> {
    private final PropertyRenderer<String> myRenderer = new LabelPropertyRenderer<String>(){

        @Override
        protected void customize(@NotNull String value) {
            if (value == null) {
                1.$$$reportNull$$$0(0);
            }
            this.setText(LayoutManagerRegistry.getLayoutManagerDisplayName(value));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/uiDesigner/propertyInspector/properties/LayoutManagerProperty$1", "customize"));
        }
    };
    private final PropertyEditor<String> myEditor = new LayoutManagerEditor();

    public LayoutManagerProperty() {
        super(null, "Layout Manager");
    }

    @Override
    public String getValue(RadContainer component) {
        for (RadContainer container = component; container != null; container = container.getParent()) {
            RadLayoutManager layoutManager = container.getLayoutManager();
            if (layoutManager == null) continue;
            return layoutManager.getName();
        }
        return "GridLayoutManager";
    }

    @Override
    protected void setValueImpl(RadContainer component, String value) throws Exception {
        RadLayoutManager oldLayout = component.getLayoutManager();
        if (oldLayout != null && Objects.equals(oldLayout.getName(), value)) {
            return;
        }
        RadLayoutManager newLayoutManager = LayoutManagerRegistry.createLayoutManager(value);
        newLayoutManager.changeContainerLayout(component);
    }

    @Override
    @NotNull
    public PropertyRenderer<String> getRenderer() {
        PropertyRenderer<String> propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            LayoutManagerProperty.$$$reportNull$$$0(0);
        }
        return propertyRenderer;
    }

    @Override
    public PropertyEditor<String> getEditor() {
        return this.myEditor;
    }

    @Override
    public boolean needRefreshPropertyList() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/LayoutManagerProperty", "getRenderer"));
    }

    private static class LayoutManagerEditor
    extends ComboBoxPropertyEditor<String> {
        LayoutManagerEditor() {
            this.myCbx.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", LayoutManagerRegistry::getLayoutManagerDisplayName));
        }

        @Override
        public JComponent getComponent(RadComponent component, @NlsSafe String value, InplaceContext inplaceContext) {
            if ("XYLayout".equals(value)) {
                this.myCbx.setModel(new DefaultComboBoxModel<String>(LayoutManagerRegistry.getLayoutManagerNames()));
            } else {
                this.myCbx.setModel(new DefaultComboBoxModel<String>(LayoutManagerRegistry.getNonDeprecatedLayoutManagerNames()));
            }
            this.myCbx.setSelectedItem((Object)value);
            return this.myCbx;
        }
    }
}

