/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.projectView;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uiDesigner.GuiFormFileType;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.projectView.Form;
import com.intellij.uiDesigner.projectView.FormNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class FormMergerTreeStructureProvider
implements TreeStructureProvider {
    private final Project myProject;

    public FormMergerTreeStructureProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        ProjectViewNode[] copy;
        if (parent == null) {
            FormMergerTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children == null) {
            FormMergerTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (parent.getValue() instanceof Form) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                FormMergerTreeStructureProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }
        boolean formsFound = false;
        for (AbstractTreeNode<?> node : children) {
            PsiFile file;
            Object object = node.getValue();
            if (!(object instanceof PsiFile) || (file = (PsiFile)object).getFileType() != GuiFormFileType.INSTANCE) continue;
            formsFound = true;
            break;
        }
        if (!formsFound) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                FormMergerTreeStructureProvider.$$$reportNull$$$0(3);
            }
            return collection;
        }
        LinkedHashSet<AbstractTreeNode<BasePsiNode<? extends PsiElement>>> result = new LinkedHashSet<AbstractTreeNode<BasePsiNode<? extends PsiElement>>>(children);
        for (ProjectViewNode element : copy = children.toArray(new ProjectViewNode[0])) {
            List<PsiFile> forms;
            Collection<BasePsiNode<? extends PsiElement>> formNodes;
            String qName;
            PsiClass[] psiClasses;
            PsiClass psiClass = null;
            if (element.getValue() instanceof PsiClass) {
                psiClass = (PsiClass)element.getValue();
            } else if (element.getValue() instanceof PsiClassOwner && (psiClasses = ((PsiClassOwner)element.getValue()).getClasses()).length == 1) {
                psiClass = psiClasses[0];
            }
            if (psiClass == null || (qName = psiClass.getQualifiedName()) == null || (formNodes = FormMergerTreeStructureProvider.findFormsIn(children, forms = FormClassIndex.findFormsBoundToClass(this.myProject, qName))).isEmpty()) continue;
            Collection<PsiFile> formFiles = FormMergerTreeStructureProvider.convertToFiles(formNodes);
            ArrayList<BasePsiNode<? extends PsiElement>> subNodes = new ArrayList<BasePsiNode<? extends PsiElement>>();
            subNodes.add((BasePsiNode)element);
            subNodes.addAll(formNodes);
            result.add((AbstractTreeNode<BasePsiNode<? extends PsiElement>>)new FormNode(this.myProject, new Form(psiClass, formFiles), settings, subNodes));
            result.remove(element);
            result.removeAll(formNodes);
        }
        LinkedHashSet<AbstractTreeNode<BasePsiNode<? extends PsiElement>>> linkedHashSet = result;
        if (linkedHashSet == null) {
            FormMergerTreeStructureProvider.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    public Object getData(@NotNull Collection<? extends AbstractTreeNode<?>> selected, @NotNull String dataId) {
        if (selected == null) {
            FormMergerTreeStructureProvider.$$$reportNull$$$0(5);
        }
        if (dataId == null) {
            FormMergerTreeStructureProvider.$$$reportNull$$$0(6);
        }
        if (Form.DATA_KEY.is(dataId)) {
            ArrayList<Form> result = new ArrayList<Form>();
            for (AbstractTreeNode<?> node : selected) {
                if (!(node instanceof FormNode)) continue;
                result.add((Form)((FormNode)node).getValue());
            }
            if (!result.isEmpty()) {
                return result.toArray(new Form[0]);
            }
        } else if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            for (AbstractTreeNode<?> node : selected) {
                if (!(node instanceof FormNode)) continue;
                return new MyDeleteProvider(selected);
            }
        }
        return null;
    }

    private static Collection<PsiFile> convertToFiles(Collection<? extends BasePsiNode<? extends PsiElement>> formNodes) {
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (AbstractTreeNode abstractTreeNode : formNodes) {
            psiFiles.add((PsiFile)abstractTreeNode.getValue());
        }
        return psiFiles;
    }

    private static Collection<BasePsiNode<? extends PsiElement>> findFormsIn(Collection<? extends AbstractTreeNode<?>> children, List<? extends PsiFile> forms) {
        if (children.isEmpty() || forms.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BasePsiNode<? extends PsiElement>> result = new ArrayList<BasePsiNode<? extends PsiElement>>();
        HashSet<? extends PsiFile> psiFiles = new HashSet<PsiFile>(forms);
        for (AbstractTreeNode<?> child : children) {
            BasePsiNode treeNode;
            if (!(child instanceof BasePsiNode) || !psiFiles.contains((treeNode = (BasePsiNode)child).getValue())) continue;
            result.add((BasePsiNode<? extends PsiElement>)treeNode);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/projectView/FormMergerTreeStructureProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/projectView/FormMergerTreeStructureProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyDeleteProvider
    implements DeleteProvider {
        private final AbstractTreeNode<?>[] myNodes;

        MyDeleteProvider(Collection<? extends AbstractTreeNode<?>> nodes) {
            this.myNodes = (AbstractTreeNode[])nodes.toArray(AbstractTreeNode[]::new);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyDeleteProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeleteProvider.$$$reportNull$$$0(1);
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            PsiElement[] elements = MyDeleteProvider.collectFormPsiElements(this.myNodes);
            DeleteHandler.deletePsiElement((PsiElement[])elements, (Project)project);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeleteProvider.$$$reportNull$$$0(2);
            }
            PsiElement[] elements = MyDeleteProvider.collectFormPsiElements(this.myNodes);
            return DeleteHandler.shouldEnableDeleteAction((PsiElement[])elements);
        }

        private static PsiElement[] collectFormPsiElements(AbstractTreeNode<?>[] selected) {
            HashSet<Object> result = new HashSet<Object>();
            for (AbstractTreeNode<?> node : selected) {
                Object object = node.getValue();
                if (object instanceof Form) {
                    Form form = (Form)object;
                    result.add(form.getClassToBind());
                    ContainerUtil.addAll(result, (Object[])form.getFormFiles());
                    continue;
                }
                if (!(node.getValue() instanceof PsiElement)) continue;
                result.add((PsiElement)node.getValue());
            }
            return PsiUtilCore.toPsiElementArray(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uiDesigner/projectView/FormMergerTreeStructureProvider$MyDeleteProvider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uiDesigner/projectView/FormMergerTreeStructureProvider$MyDeleteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

