/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.coverage.ConditionCoverageExpression;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageNotifications;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.IDEACoverageRunner;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.JavaCoveragePsiUtilsKt;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.SourceLineCounterUtil;
import com.intellij.coverage.SwitchCoverageExpression;
import com.intellij.coverage.analysis.AnalysisUtils;
import com.intellij.coverage.analysis.JavaCoverageAnnotator;
import com.intellij.coverage.analysis.JavaCoverageClassesEnumerator;
import com.intellij.coverage.listeners.java.CoverageListener;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.JavaCoverageViewExtension;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.target.RunTargetsEnabled;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.stream.IntStream;
import jetbrains.coverage.report.ReportGenerationFailedException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class JavaCoverageEngine
extends CoverageEngine {
    private static final Logger LOG = Logger.getInstance((String)JavaCoverageEngine.class.getName());
    private static final String indent = "  ";
    private static final int MAX_EXPRESSION_LENGTH = 100;

    public static JavaCoverageEngine getInstance() {
        return (JavaCoverageEngine)((Object)EP_NAME.findExtensionOrFail(JavaCoverageEngine.class));
    }

    public boolean isApplicableTo(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            JavaCoverageEngine.$$$reportNull$$$0(0);
        }
        if (conf instanceof CommonJavaRunConfigurationParameters) {
            return true;
        }
        if (RunTargetsEnabled.get() && conf instanceof TargetEnvironmentAwareRunProfile && JavaCoverageEngine.willRunOnTarget((TargetEnvironmentAwareRunProfile)conf)) {
            return false;
        }
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.isApplicableTo(conf)) continue;
            return true;
        }
        return false;
    }

    private static boolean willRunOnTarget(@NotNull TargetEnvironmentAwareRunProfile configuration) {
        Project project;
        if (configuration == null) {
            JavaCoverageEngine.$$$reportNull$$$0(1);
        }
        return TargetEnvironmentConfigurations.getEffectiveTargetName((TargetEnvironmentAwareRunProfile)configuration, (Project)(project = ((RunConfigurationBase)configuration).getProject())) != null || JavaCoverageEngine.isProjectUnderWsl(project);
    }

    private static boolean isProjectUnderWsl(@NotNull Project project) {
        Sdk projectSdk;
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(2);
        }
        if ((projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) == null) {
            return false;
        }
        String projectSdkHomePath = projectSdk.getHomePath();
        return projectSdkHomePath != null && WslPath.isWslUncPath((String)projectSdkHomePath);
    }

    public boolean canHavePerTestCoverage(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            JavaCoverageEngine.$$$reportNull$$$0(3);
        }
        return !(conf instanceof ApplicationConfiguration) && conf instanceof CommonJavaRunConfigurationParameters;
    }

    public Set<String> getTestsForLine(Project project, CoverageSuitesBundle bundle, String classFQName, int lineNumber) {
        return JavaCoverageEngine.extractTracedTests(bundle, classFQName, lineNumber);
    }

    public boolean wasTestDataCollected(Project project, CoverageSuitesBundle bundle) {
        File[] files = JavaCoverageEngine.getTraceFiles(bundle);
        return files != null && files.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> extractTracedTests(CoverageSuitesBundle bundle, String classFQName, int lineNumber) {
        HashSet<String> tests = new HashSet<String>();
        File[] traceFiles = JavaCoverageEngine.getTraceFiles(bundle);
        if (traceFiles == null) {
            return tests;
        }
        for (File traceFile : traceFiles) {
            FilterInputStream in = null;
            try {
                in = new DataInputStream(new FileInputStream(traceFile));
                JavaCoverageEngine.extractTests(traceFile, (DataInputStream)in, tests, classFQName, lineNumber);
            }
            catch (Exception ex) {
                LOG.error(traceFile.getName(), (Throwable)ex);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    LOG.error((Throwable)ex);
                }
            }
        }
        return tests;
    }

    private static void extractTests(File traceFile, DataInputStream in, Set<? super String> tests, String classFQName, int lineNumber) throws IOException {
        long traceSize = in.readInt();
        int i = 0;
        while ((long)i < traceSize) {
            String className2 = in.readUTF();
            int linesSize = in.readInt();
            for (int l = 0; l < linesSize; ++l) {
                int line = in.readInt();
                if (!Comparing.strEqual((String)className2, (String)classFQName) || lineNumber != line) continue;
                tests.add(FileUtilRt.getNameWithoutExtension((String)traceFile.getName()));
                return;
            }
            ++i;
        }
    }

    private static File @Nullable [] getTraceFiles(CoverageSuitesBundle bundle) {
        ArrayList files = new ArrayList();
        for (CoverageSuite coverageSuite : bundle.getSuites()) {
            File tracesDir = JavaCoverageEngine.getTracesDirectory(coverageSuite);
            File[] suiteFiles = tracesDir.listFiles();
            if (suiteFiles == null) continue;
            Collections.addAll(files, suiteFiles);
        }
        return files.isEmpty() ? null : files.toArray(new File[0]);
    }

    private static File getTracesDirectory(CoverageSuite coverageSuite) {
        String filePath = coverageSuite.getCoverageDataFileName();
        String dirName = FileUtilRt.getNameWithoutExtension((String)new File(filePath).getName());
        File parentDir = new File(filePath).getParentFile();
        return new File(parentDir, dirName);
    }

    public void collectTestLines(List<String> sanitizedTestNames, CoverageSuite suite, Map<String, Set<Integer>> executionTrace) {
        File tracesDir = JavaCoverageEngine.getTracesDirectory(suite);
        for (String testName : sanitizedTestNames) {
            File file = new File(tracesDir, testName + ".tr");
            if (!file.exists()) continue;
            try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
                int traceSize = in.readInt();
                for (int i = 0; i < traceSize; ++i) {
                    String className2 = in.readUTF();
                    int linesSize = in.readInt();
                    Set lines = executionTrace.computeIfAbsent(className2, k -> new HashSet());
                    for (int l = 0; l < linesSize; ++l) {
                        lines.add(in.readInt());
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void deleteAssociatedTraces(CoverageSuite suite) {
        File tracesDirectory;
        if (suite.isCoverageByTestEnabled() && (tracesDirectory = JavaCoverageEngine.getTracesDirectory(suite)).exists()) {
            FileUtil.delete((File)tracesDirectory);
        }
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            JavaCoverageEngine.$$$reportNull$$$0(4);
        }
        return new JavaCoverageEnabledConfiguration(conf);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMerge, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, Project project) {
        void project2;
        if (covRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(5);
        }
        if (name == null) {
            JavaCoverageEngine.$$$reportNull$$$0(6);
        }
        if (coverageDataFileProvider == null) {
            JavaCoverageEngine.$$$reportNull$$$0(7);
        }
        return this.createSuite(covRunner, name, coverageDataFileProvider, filters, null, lastCoverageTimeStamp, coverageByTestEnabled, branchCoverage, trackTestFolders, (Project)project2);
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageEnabledConfiguration config) {
        Project project;
        CoverageRunner runner;
        if (config == null) {
            JavaCoverageEngine.$$$reportNull$$$0(8);
        }
        if ((runner = JavaCoverageOptionsProvider.getInstance(project = config.getConfiguration().getProject()).getCoverageRunner()) == null) {
            return null;
        }
        config.setCoverageRunner(runner);
        return this.createCoverageSuite(runner, config.createSuiteName(), config.createFileProvider(), config);
    }

    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        if (covRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(9);
        }
        if (name == null) {
            JavaCoverageEngine.$$$reportNull$$$0(10);
        }
        if (coverageDataFileProvider == null) {
            JavaCoverageEngine.$$$reportNull$$$0(11);
        }
        if (config == null) {
            JavaCoverageEngine.$$$reportNull$$$0(12);
        }
        if (config instanceof JavaCoverageEnabledConfiguration) {
            JavaCoverageEnabledConfiguration javaConfig = (JavaCoverageEnabledConfiguration)config;
            Project project = config.getConfiguration().getProject();
            JavaCoverageOptionsProvider optionsProvider = JavaCoverageOptionsProvider.getInstance(project);
            return this.createSuite(covRunner, name, coverageDataFileProvider, javaConfig.getPatterns(), javaConfig.getExcludePatterns(), javaConfig.createTimestamp(), optionsProvider.getTestTracking() && this.canHavePerTestCoverage(config.getConfiguration()), optionsProvider.getBranchCoverage(), optionsProvider.getTestModulesCoverage(), project);
        }
        return null;
    }

    @Nullable
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        if (coverageRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(13);
        }
        return new JavaCoverageSuite(this);
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(@NotNull Project project) {
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(14);
        }
        JavaCoverageAnnotator javaCoverageAnnotator = JavaCoverageAnnotator.getInstance(project);
        if (javaCoverageAnnotator == null) {
            JavaCoverageEngine.$$$reportNull$$$0(15);
        }
        return javaCoverageAnnotator;
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(16);
        }
        if (!(psiFile instanceof PsiClassOwner)) {
            return false;
        }
        Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile));
        return module != null;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(17);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(18);
        }
        if ((virtualFile = psiFile.getVirtualFile()) == null) {
            return false;
        }
        Project project = psiFile.getProject();
        if (!suite.isTrackTestFolders() && ((Boolean)ReadAction.compute(() -> TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)project))).booleanValue()) {
            return false;
        }
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            if (psiFile instanceof PsiClassOwner && javaSuite.isPackageFiltered((String)ReadAction.compute(() -> ((PsiClassOwner)psiFile).getPackageName()))) {
                return true;
            }
            List<PsiClass> classes2 = javaSuite.getCurrentSuiteClasses(project);
            for (PsiClass aClass : classes2) {
                PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiClass)aClass).getContainingFile());
                VirtualFile classVirtualFile = containingFile.getVirtualFile();
                if (!virtualFile.equals(classVirtualFile)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        boolean rootsExist;
        if (module == null) {
            JavaCoverageEngine.$$$reportNull$$$0(19);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(20);
        }
        if (chooseSuiteAction == null) {
            JavaCoverageEngine.$$$reportNull$$$0(21);
        }
        if (suite.isModuleChecked(module)) {
            return false;
        }
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            Module moduleCandidate = extension.getModuleWithOutput(module);
            if (moduleCandidate == null) continue;
            module = moduleCandidate;
            break;
        }
        CoverageDataManager dataManager = CoverageDataManager.getInstance((Project)module.getProject());
        boolean includeTests = suite.isTrackTestFolders();
        Object[] roots = JavaCoverageClassesEnumerator.getRoots(dataManager, module, includeTests);
        boolean bl = rootsExist = roots.length >= (includeTests ? 2 : 1) && ContainerUtil.all((Object[])roots, root -> root != null && root.exists());
        if (!rootsExist) {
            Project project = module.getProject();
            suite.checkModule(module);
            LOG.debug("Going to ask to rebuild project. Include tests:" + includeTests + ". Module: " + module.getName() + ".  Output roots are: ");
            for (Object root2 : roots) {
                LOG.debug(root2.getPath() + " exists: " + root2.exists());
            }
            Notification notification = new Notification("Coverage", JavaCoverageBundle.message("project.is.out.of.date", new Object[0]), JavaCoverageBundle.message("project.class.files.are.out.of.date", new Object[0]), NotificationType.INFORMATION);
            notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)JavaCoverageBundle.message("coverage.recompile", new Object[0]), () -> {
                ProjectTaskManagerImpl.putBuildOriginator((Project)project, ((Object)((Object)this)).getClass());
                ProjectTaskManager taskManager = ProjectTaskManager.getInstance((Project)project);
                Promise promise = taskManager.buildAllModules();
                promise.onSuccess(result -> ApplicationManager.getApplication().invokeLater(() -> CoverageDataManager.getInstance((Project)project).chooseSuitesBundle(suite), o -> project.isDisposed()));
            }));
            CoverageNotifications.getInstance(project).addNotification(notification);
            notification.notify(project);
        }
        return false;
    }

    @Nullable
    private static File getOutputpath(CompilerModuleExtension compilerModuleExtension) {
        @Nullable String outputpathUrl = compilerModuleExtension.getCompilerOutputUrl();
        @Nullable File outputpath = outputpathUrl != null ? new File(VfsUtilCore.urlToPath((String)outputpathUrl)) : null;
        return outputpath;
    }

    @Nullable
    private static File getTestOutputpath(CompilerModuleExtension compilerModuleExtension) {
        @Nullable String outputpathUrl = compilerModuleExtension.getCompilerOutputUrlForTests();
        @Nullable File outputpath = outputpathUrl != null ? new File(VfsUtilCore.urlToPath((String)outputpathUrl)) : null;
        return outputpath;
    }

    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        byte[] content;
        if (classFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(22);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(23);
        }
        try {
            content = FileUtil.loadFileBytes((File)classFile);
        }
        catch (IOException e) {
            return null;
        }
        ArrayList<Integer> uncoveredLines = new ArrayList<Integer>();
        try {
            SourceLineCounterUtil.collectSrcLinesForUntouchedFiles(uncoveredLines, content, suite.getProject());
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LOG.error("Fail to process class from: " + classFile.getPath(), (Throwable)e);
        }
        return uncoveredLines;
    }

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        if (qualifiedName == null) {
            JavaCoverageEngine.$$$reportNull$$$0(24);
        }
        if (outputFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(25);
        }
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(26);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(27);
        }
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            if (!javaSuite.isClassFiltered(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(28);
        }
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(29);
        }
        String packageFQName = JavaCoverageEngine.getPackageName(sourceFile);
        String string = StringUtil.getQualifiedName((String)packageFQName, (String)FileUtilRt.getNameWithoutExtension((String)outputFile.getName()));
        if (string == null) {
            JavaCoverageEngine.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(31);
        }
        PsiClass[] classes2 = (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)sourceFile).getClasses());
        HashSet<String> qNames = new HashSet<String>();
        for (JavaCoverageEngineExtension nameExtension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!((Boolean)ReadAction.compute(() -> nameExtension.suggestQualifiedName(sourceFile, classes2, qNames))).booleanValue()) continue;
            HashSet<String> hashSet = qNames;
            if (hashSet == null) {
                JavaCoverageEngine.$$$reportNull$$$0(32);
            }
            return hashSet;
        }
        for (PsiClass aClass : classes2) {
            String qName = (String)ReadAction.compute(() -> aClass.getQualifiedName());
            if (qName == null) continue;
            qNames.add(qName);
        }
        HashSet<String> hashSet = qNames;
        if (hashSet == null) {
            JavaCoverageEngine.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    @NotNull
    public Set<File> getCorrespondingOutputFiles(@NotNull PsiFile srcFile, @Nullable Module module, @NotNull CoverageSuitesBundle suite) {
        PsiClass[] classes2;
        if (srcFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(34);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(35);
        }
        if (module == null) {
            Set<File> set = Collections.emptySet();
            if (set == null) {
                JavaCoverageEngine.$$$reportNull$$$0(36);
            }
            return set;
        }
        HashSet<File> classFiles = new HashSet<File>();
        CompilerModuleExtension moduleExtension = Objects.requireNonNull(CompilerModuleExtension.getInstance((Module)module));
        @Nullable File outputpath = JavaCoverageEngine.getOutputpath(moduleExtension);
        @Nullable File testOutputpath = JavaCoverageEngine.getTestOutputpath(moduleExtension);
        @Nullable VirtualFile outputpathVirtualFile = JavaCoverageEngine.fileToVirtualFileWithRefresh(outputpath);
        @Nullable VirtualFile testOutputpathVirtualFile = JavaCoverageEngine.fileToVirtualFileWithRefresh(testOutputpath);
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.collectOutputFiles(srcFile, outputpathVirtualFile, testOutputpathVirtualFile, suite, classFiles)) continue;
            HashSet<File> hashSet = classFiles;
            if (hashSet == null) {
                JavaCoverageEngine.$$$reportNull$$$0(37);
            }
            return hashSet;
        }
        Project project = module.getProject();
        CoverageDataManager dataManager = CoverageDataManager.getInstance((Project)project);
        boolean includeTests = suite.isTrackTestFolders();
        VirtualFile[] roots = JavaCoverageClassesEnumerator.getRoots(dataManager, module, includeTests);
        String packageVmName = AnalysisUtils.fqnToInternalName(JavaCoverageEngine.getPackageName(srcFile));
        ArrayList children = new ArrayList();
        for (VirtualFile root : roots) {
            File[] files;
            File dir;
            VirtualFile packageDir;
            if (root == null || (packageDir = root.findFileByRelativePath(packageVmName)) == null || !(dir = VfsUtilCore.virtualToIoFile((VirtualFile)packageDir)).exists() || (files = dir.listFiles()) == null) continue;
            Collections.addAll(children, files);
        }
        for (PsiClass psiClass : classes2 = (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)srcFile).getClasses())) {
            String className2 = (String)ReadAction.compute(() -> psiClass.getName());
            if (className2 == null) continue;
            for (File child : children) {
                String childName;
                if (!FileUtilRt.extensionEquals((String)child.getName(), (String)JavaClassFileType.INSTANCE.getDefaultExtension()) || !(childName = FileUtilRt.getNameWithoutExtension((String)child.getName())).equals(className2) && (!childName.startsWith(className2) || childName.charAt(className2.length()) != '$')) continue;
                classFiles.add(child);
            }
        }
        HashSet<File> hashSet = classFiles;
        if (hashSet == null) {
            JavaCoverageEngine.$$$reportNull$$$0(38);
        }
        return hashSet;
    }

    @Nullable
    private static VirtualFile fileToVirtualFileWithRefresh(@Nullable File file) {
        if (file == null) {
            return null;
        }
        return (VirtualFile)WriteAction.computeAndWait(() -> VfsUtil.findFileByIoFile((File)file, (boolean)true));
    }

    public String generateBriefReport(@NotNull CoverageSuitesBundle bundle, @NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull TextRange range, @Nullable LineData lineData) {
        if (bundle == null) {
            JavaCoverageEngine.$$$reportNull$$$0(39);
        }
        if (editor == null) {
            JavaCoverageEngine.$$$reportNull$$$0(40);
        }
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(41);
        }
        if (range == null) {
            JavaCoverageEngine.$$$reportNull$$$0(42);
        }
        if (lineData == null) {
            return CoverageBundle.message((String)"hits.title", (Object[])new Object[]{0});
        }
        if (ContainerUtil.exists((Object[])bundle.getSuites(), suite -> !(suite.getRunner() instanceof IDEACoverageRunner))) {
            return JavaCoverageEngine.createDefaultHitsMessage(lineData);
        }
        try {
            int lineNumber = editor.getDocument().getLineNumber(range.getStartOffset());
            for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
                String report = extension.generateBriefReport(editor, psiFile, lineNumber, range.getStartOffset(), range.getEndOffset(), lineData);
                if (report == null) continue;
                return report;
            }
            List<SwitchCoverageExpression> switches = JavaCoveragePsiUtilsKt.getSwitches(psiFile, range);
            List<ConditionCoverageExpression> conditions = JavaCoveragePsiUtilsKt.getConditions(psiFile, range);
            return JavaCoverageEngine.createBriefReport(lineData, conditions, switches);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return JavaCoverageEngine.createDefaultHitsMessage(lineData);
        }
    }

    @NotNull
    public static String createBriefReport(@NotNull LineData lineData, List<ConditionCoverageExpression> conditions, List<SwitchCoverageExpression> switches) {
        Object expression;
        if (lineData == null) {
            JavaCoverageEngine.$$$reportNull$$$0(43);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(CoverageBundle.message((String)"hits.title", (Object[])new Object[]{lineData.getHits()}));
        int idx = 0;
        int hits = 0;
        if (lineData.getJumps() != null) {
            for (JumpData jumpData : lineData.getJumps()) {
                if (idx >= conditions.size()) {
                    LOG.info("Cannot map coverage report data with PSI: there are more branches in report then in PSI");
                    return JavaCoverageEngine.createDefaultHitsMessage(lineData);
                }
                expression = conditions.get(idx++);
                JavaCoverageEngine.addJumpDataInfo(buf, jumpData, (ConditionCoverageExpression)expression);
                hits += jumpData.getTrueHits() + jumpData.getFalseHits();
            }
        }
        if (lineData.getSwitches() != null) {
            for (JumpData jumpData : lineData.getSwitches()) {
                if (idx >= switches.size()) {
                    LOG.info("Cannot map coverage report data with PSI: there are more switches in report then in PSI");
                    return JavaCoverageEngine.createDefaultHitsMessage(lineData);
                }
                expression = switches.get(idx++);
                JavaCoverageEngine.addSwitchDataInfo(buf, (SwitchData)jumpData, (SwitchCoverageExpression)expression, lineData.getStatus());
                hits += IntStream.of(jumpData.getHits()).sum() + jumpData.getDefaultHits();
            }
        }
        if (lineData.getHits() > hits && hits > 0) {
            buf.append("\n").append(JavaCoverageBundle.message("report.unknown.outcome", lineData.getHits() - hits));
        }
        String string = buf.toString();
        if (string == null) {
            JavaCoverageEngine.$$$reportNull$$$0(44);
        }
        return string;
    }

    private static String preprocessExpression(String expression) {
        String preprocessed = expression.replaceAll("[\\s\n]+", " ");
        return preprocessed.length() > 100 ? expression : preprocessed;
    }

    private static void addJumpDataInfo(StringBuilder buf, JumpData jumpData, ConditionCoverageExpression expression) {
        buf.append("\n").append(indent).append(JavaCoverageEngine.preprocessExpression(expression.getExpression()));
        boolean reverse = expression.isReversed();
        int trueHits = reverse ? jumpData.getFalseHits() : jumpData.getTrueHits();
        buf.append("\n").append(indent).append(indent).append("true").append(" ").append(CoverageBundle.message((String)"hits.message", (Object[])new Object[]{trueHits}));
        int falseHits = reverse ? jumpData.getTrueHits() : jumpData.getFalseHits();
        buf.append("\n").append(indent).append(indent).append("false").append(" ").append(CoverageBundle.message((String)"hits.message", (Object[])new Object[]{falseHits}));
    }

    private static void addSwitchDataInfo(StringBuilder buf, SwitchData switchData, SwitchCoverageExpression expression, int coverageStatus) {
        boolean defaultCausesLinePartiallyCovered;
        buf.append("\n").append(indent).append(JavaCoverageEngine.preprocessExpression(expression.getExpression()));
        boolean allBranchesHit = true;
        for (int i = 0; i < switchData.getKeys().length; ++i) {
            String key = expression.getCases() != null && i < expression.getCases().size() ? expression.getCases().get(i) : Integer.toString(switchData.getKeys()[i]);
            int switchHits = switchData.getHits()[i];
            allBranchesHit &= switchHits > 0;
            buf.append("\n").append(indent).append(indent).append("case").append(" ").append(key).append(": ").append(switchHits);
        }
        int defaultHits = switchData.getDefaultHits();
        boolean bl = defaultCausesLinePartiallyCovered = allBranchesHit && coverageStatus != 2;
        if (expression.getHasDefault() || defaultCausesLinePartiallyCovered || defaultHits > 0) {
            buf.append("\n").append(indent).append(indent).append("default").append(": ").append(defaultHits);
        }
    }

    @NotNull
    private static String createDefaultHitsMessage(@NotNull LineData lineData) {
        BranchData branchData;
        if (lineData == null) {
            JavaCoverageEngine.$$$reportNull$$$0(45);
        }
        if ((branchData = lineData.getBranchData()) == null) {
            String string = CoverageBundle.message((String)"hits.title", (Object[])new Object[]{lineData.getHits()});
            if (string == null) {
                JavaCoverageEngine.$$$reportNull$$$0(46);
            }
            return string;
        }
        String string = CoverageBundle.message((String)"branch.coverage.message", (Object[])new Object[]{lineData.getHits(), branchData.getCoveredBranches(), branchData.getTotalBranches()});
        if (string == null) {
            JavaCoverageEngine.$$$reportNull$$$0(47);
        }
        return string;
    }

    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        String qualifiedName;
        PsiMethod method;
        PsiClass aClass;
        if (element == null) {
            JavaCoverageEngine.$$$reportNull$$$0(48);
        }
        if (testProxy == null) {
            JavaCoverageEngine.$$$reportNull$$$0(49);
        }
        if (element instanceof PsiMethod && (aClass = (method = (PsiMethod)element).getContainingClass()) != null && (qualifiedName = ClassUtil.getJVMClassName((PsiClass)aClass)) != null) {
            return qualifiedName + "," + CoverageListener.sanitize((String)method.getName(), (int)qualifiedName.length());
        }
        return testProxy.toString();
    }

    @NotNull
    public List<PsiElement> findTestsByNames(String @NotNull [] testNames, @NotNull Project project) {
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(50);
        }
        if (testNames == null) {
            JavaCoverageEngine.$$$reportNull$$$0(51);
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (String testName : testNames) {
            int index = testName.indexOf(",");
            if (index <= 0) {
                ArrayList<PsiElement> arrayList = elements;
                if (arrayList == null) {
                    JavaCoverageEngine.$$$reportNull$$$0(52);
                }
                return arrayList;
            }
            JavaCoverageEngine.collectTestsByName(elements, testName.substring(index + 1), testName.substring(0, index), psiManager);
        }
        ArrayList<PsiElement> arrayList = elements;
        if (arrayList == null) {
            JavaCoverageEngine.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    private static void collectTestsByName(List<? super PsiElement> elements, String testName, String className2, PsiManager psiManager) {
        ReadAction.run(() -> {
            PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)psiManager, (String)className2);
            if (psiClass == null) {
                return;
            }
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)psiClass);
            if (testFramework == null) {
                return;
            }
            Arrays.stream(psiClass.getAllMethods()).filter(method -> testFramework.isTestMethod((PsiElement)method) && testName.equals(CoverageListener.sanitize((String)method.getName(), (int)className2.length()))).forEach(elements::add);
        });
    }

    public JavaCoverageSuite createSuite(CoverageRunner acceptedCovRunner, String name, CoverageFileProvider coverageDataFileProvider, String[] filters, String[] excludePatterns, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, Project project) {
        return new JavaCoverageSuite(name, coverageDataFileProvider, filters, excludePatterns, lastCoverageTimeStamp, coverageByTestEnabled, branchCoverage, trackTestFolders, acceptedCovRunner, this, project);
    }

    @NotNull
    protected static String getPackageName(PsiFile sourceFile) {
        String string = (String)ReadAction.compute(() -> ((PsiClassOwner)sourceFile).getPackageName());
        if (string == null) {
            JavaCoverageEngine.$$$reportNull$$$0(54);
        }
        return string;
    }

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        Sdk projectSdk;
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(55);
        }
        if (dataContext == null) {
            JavaCoverageEngine.$$$reportNull$$$0(56);
        }
        if (currentSuite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(57);
        }
        return (projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null;
    }

    public final void generateReport(final @NotNull Project project, @NotNull DataContext dataContext, final @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(58);
        }
        if (dataContext == null) {
            JavaCoverageEngine.$$$reportNull$$$0(59);
        }
        if (currentSuite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(60);
        }
        final ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JavaCoverageBundle.message("generating.coverage.report", new Object[0])){
            final Exception[] myExceptions;
            {
                super(arg0, arg1);
                this.myExceptions = new Exception[1];
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    ((JavaCoverageRunner)currentSuite.getSuites()[0].getRunner()).generateReport(currentSuite, project);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (ReportGenerationFailedException e) {
                    this.myExceptions[0] = e;
                }
            }

            public void onSuccess() {
                if (this.myExceptions[0] != null) {
                    Messages.showErrorDialog((Project)project, (String)this.myExceptions[0].getMessage(), (String)CommonBundle.getErrorTitle());
                    return;
                }
                if (settings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((File)new File(settings.OUTPUT_DIRECTORY, "index.html"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/coverage/JavaCoverageEngine$1", "run"));
            }
        });
    }

    @Nls
    public String getPresentableText() {
        return JavaCoverageBundle.message("java.coverage.engine.presentable.text", new Object[0]);
    }

    protected boolean isGeneratedCode(Project project, String qualifiedName, Object lineData) {
        if (JavaCoverageOptionsProvider.getInstance(project).isGeneratedConstructor(qualifiedName, ((LineData)lineData).getMethodSignature())) {
            return true;
        }
        return super.isGeneratedCode(project, qualifiedName, lineData);
    }

    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle) {
        return new JavaCoverageViewExtension((JavaCoverageAnnotator)this.getCoverageAnnotator(project), project, suiteBundle);
    }

    public static boolean isSourceMapNeeded(RunConfigurationBase<?> configuration) {
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.isSourceMapNeeded(configuration)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 30, 32, 33, 36, 37, 38, 44, 46, 47, 52, 53, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 14: 
            case 50: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covRunner";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDataFileProvider";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageRunner";
                break;
            }
            case 15: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 52: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/JavaCoverageEngine";
                break;
            }
            case 16: 
            case 17: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooseSuiteAction";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineData";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/JavaCoverageEngine";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageAnnotator";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingOutputFiles";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createBriefReport";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultHitsMessage";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsByNames";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "willRunOnTarget";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isProjectUnderWsl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canHavePerTestCoverage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageEnabledConfiguration";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyCoverageSuite";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageAnnotator";
                break;
            }
            case 15: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 52: 
            case 53: 
            case 54: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "coverageEditorHighlightingApplicableTo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "recompileProjectAndRerunAction";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcLinesForUntouchedFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "includeUntouchedFileInCoverage";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNames";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingOutputFiles";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generateBriefReport";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createBriefReport";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultHitsMessage";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodName";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findTestsByNames";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isReportGenerationAvailable";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "generateReport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 30, 32, 33, 36, 37, 38, 44, 46, 47, 52, 53, 54 -> new IllegalStateException(string);
        };
    }
}

