/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.navbar.NavBarItemPresentationData;
import com.intellij.platform.navbar.frontend.actions.ActionsKt;
import com.intellij.platform.navbar.frontend.ui.AbstractNavBarUI;
import com.intellij.platform.navbar.frontend.ui.ImageType;
import com.intellij.platform.navbar.frontend.ui.NavBarDialogFocusListener;
import com.intellij.platform.navbar.frontend.ui.NavBarItemComponentTabKeyListener;
import com.intellij.platform.navbar.frontend.ui.NewNavBarPanel;
import com.intellij.platform.navbar.frontend.ui.UiKt;
import com.intellij.platform.navbar.frontend.vm.NavBarItemVm;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextCache;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.Map;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 12\u00020\u0001:\u00040123B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020\u001bJ\b\u0010#\u001a\u00020$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\tH\u0016J\b\u0010.\u001a\u00020\tH\u0014J\u0006\u0010/\u001a\u00020\u001bR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/platform/navbar/frontend/ui/NavBarItemComponent;", "Lcom/intellij/ui/SimpleColoredComponent;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "vm", "Lcom/intellij/platform/navbar/frontend/vm/NavBarItemVm;", "panel", "Lcom/intellij/platform/navbar/frontend/ui/NewNavBarPanel;", "installPopupHandler", "", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/platform/navbar/frontend/vm/NavBarItemVm;Lcom/intellij/platform/navbar/frontend/ui/NewNavBarPanel;Z)V", "cache", "", "Lcom/intellij/platform/navbar/frontend/ui/ImageType;", "Lcom/intellij/ui/scale/ScaleContextCache;", "Ljava/awt/image/BufferedImage;", "isFloating", "()Z", "isFocused", "isHovered", "isSelected", "text", "", "Lorg/jetbrains/annotations/Nls;", "getText", "()Ljava/lang/String;", "doPaint", "", "g", "Ljava/awt/Graphics2D;", "effectiveIcon", "Ljavax/swing/Icon;", "presentation", "Lcom/intellij/platform/navbar/NavBarItemPresentationData;", "focusItem", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "getFont", "Ljava/awt/Font;", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "highlightColor", "Ljava/awt/Color;", "setOpaque", "isOpaque", "shouldDrawBackground", "update", "AccessibleNavBarItem", "Companion", "ItemMouseListener", "ItemPopupHandler", "intellij.platform.navbar.frontend"})
public final class NavBarItemComponent
extends SimpleColoredComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NavBarItemVm vm;
    @NotNull
    private final NewNavBarPanel panel;
    private boolean isHovered;
    @NotNull
    private final Map<ImageType, ScaleContextCache<BufferedImage>> cache;

    public NavBarItemComponent(@NotNull CoroutineScope cs, @NotNull NavBarItemVm vm, @NotNull NewNavBarPanel panel, boolean installPopupHandler) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        this.vm = vm;
        this.panel = panel;
        this.setOpaque(false);
        this.setIpad(UiKt.navBarItemInsets());
        if (ExperimentalUI.Companion.isNewUI()) {
            this.setIconTextGap(JBUIScale.scale((int)4));
        }
        this.setMyBorder(null);
        this.setBorder(null);
        if (Companion.isItemComponentFocusable$intellij_platform_navbar_frontend()) {
            this.setFocusable(true);
            this.setFocusTraversalKeysEnabled(false);
            this.addKeyListener(new NavBarItemComponentTabKeyListener(this.panel));
            if (this.isFloating()) {
                this.addFocusListener(new NavBarDialogFocusListener(this.panel));
            }
        } else {
            this.setFocusable(false);
        }
        this.setFont(RelativeFont.NORMAL.fromResource("NavBar.fontSizeOffset", 0).derive(this.getFont()));
        BuildersKt.launch((CoroutineScope)cs, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NavBarItemComponent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.vm.getSelected().collect(new FlowCollector(){

                            @Nullable
                            public final Object emit(boolean it, @NotNull Continuation<? super Unit> $completion) {
                                this$0.update();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (installPopupHandler) {
            this.addMouseListener((MouseListener)((Object)new ItemPopupHandler()));
        }
        this.addMouseListener(new ItemMouseListener());
        this.cache = new EnumMap(ImageType.class);
    }

    public /* synthetic */ NavBarItemComponent(CoroutineScope coroutineScope, NavBarItemVm navBarItemVm, NewNavBarPanel newNavBarPanel, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(coroutineScope, navBarItemVm, newNavBarPanel, bl);
    }

    @NotNull
    public final String getText() {
        return this.vm.getPresentation().getText();
    }

    private final boolean isFloating() {
        return this.panel.isFloating();
    }

    private final boolean isSelected() {
        return (Boolean)this.vm.getSelected().getValue();
    }

    private final boolean isFocused() {
        return this.panel.isItemFocused();
    }

    @Nullable
    public Font getFont() {
        return UiKt.navBarItemFont();
    }

    public void setOpaque(boolean isOpaque) {
        super.setOpaque(false);
    }

    @NotNull
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        Dimension size = dimension;
        Dimension offsets = new Dimension();
        JBInsets.addTo((Dimension)offsets, (Insets)UiKt.navBarItemPadding(this.isFloating()));
        boolean newUI = ExperimentalUI.Companion.isNewUI();
        offsets.width = newUI ? offsets.width + (this.vm.isFirst() ? 0 : AllIcons.General.ChevronRight.getIconWidth() + JBUI.CurrentTheme.StatusBar.Breadcrumbs.CHEVRON_INSET.get()) : offsets.width + (AbstractNavBarUI.getDecorationOffset() + (this.vm.isFirst() ? AbstractNavBarUI.getFirstElementLeftOffset() : 0));
        return new Dimension(size.width + offsets.width, size.height + offsets.height);
    }

    public final void focusItem() {
        JComponent focusComponent = this.isFocusable() ? (JComponent)((Object)this) : (JComponent)this.panel;
        IdeFocusManager.getInstance((Project)this.panel.getProject()).requestFocus((Component)focusComponent, true);
    }

    public final void update() {
        Color color;
        this.clear();
        boolean selected = this.isSelected();
        boolean focused = this.isFocused();
        NavBarItemPresentationData presentation = this.vm.getPresentation();
        SimpleTextAttributes simpleTextAttributes = presentation.getTextAttributes();
        if (simpleTextAttributes == null) {
            simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        SimpleTextAttributes attributes = simpleTextAttributes;
        if (!ExperimentalUI.Companion.isNewUI()) {
            color = UiKt.navBarItemForeground(selected, focused, this.vm.isInactive());
            if (color == null) {
                SimpleTextAttributes simpleTextAttributes2 = attributes;
                color = simpleTextAttributes2 != null ? simpleTextAttributes2.getFgColor() : null;
            }
        } else {
            color = this.isHovered ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.HOVER_FOREGROUND : (selected ? (focused ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_FOREGROUND : JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_INACTIVE_FOREGROUND) : (this.isFloating() ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.FLOATING_FOREGROUND : JBUI.CurrentTheme.StatusBar.Breadcrumbs.FOREGROUND));
        }
        Color fg = color;
        Color bg = UiKt.navBarItemBackground(selected, focused);
        Color waveColor = ExperimentalUI.Companion.isNewUI() ? null : attributes.getWaveColor();
        int style = ExperimentalUI.Companion.isNewUI() ? 0 : attributes.getStyle();
        this.setIcon(this.effectiveIcon(presentation));
        this.setBackground(bg);
        this.append(presentation.getText(), new SimpleTextAttributes(bg, fg, waveColor, style));
    }

    private final Icon effectiveIcon(NavBarItemPresentationData presentation) {
        return ExperimentalUI.Companion.isNewUI() && presentation.isModuleContentRoot() ? AllIcons.Nodes.Module8x8 : (Registry.is((String)"navBar.show.icons") || this.vm.isLast() || presentation.getHasContainingFile() ? presentation.getIcon() : null);
    }

    protected boolean shouldDrawBackground() {
        return this.isSelected() && this.isFocused();
    }

    protected void doPaint(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        JBInsets jBInsets = JBInsets.create((Insets)UiKt.navBarItemPadding(this.isFloating()));
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"create(...)");
        JBInsets paddings = jBInsets;
        boolean isFirst = this.vm.isFirst();
        if (ExperimentalUI.Companion.isNewUI()) {
            Icon icon;
            Color highlightColor;
            Rectangle rect = new Rectangle(this.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)((Insets)paddings));
            int offset = rect.x;
            if (!isFirst) {
                AllIcons.General.ChevronRight.paintIcon((Component)((Object)this), g, offset, rect.y + (rect.height - AllIcons.General.ChevronRight.getIconHeight()) / 2);
                int delta = AllIcons.General.ChevronRight.getIconWidth() + JBUI.CurrentTheme.StatusBar.Breadcrumbs.CHEVRON_INSET.get();
                offset += delta;
                rect.width -= delta;
            }
            if ((highlightColor = this.highlightColor()) != null) {
                AbstractNavBarUI.paintHighlight(g, new Rectangle(offset, rect.y, rect.width, rect.height), highlightColor);
            }
            if ((icon = this.getIcon()) == null) {
                offset += this.getIpad().left;
            } else {
                icon.paintIcon((Component)((Object)this), g, offset += this.getIpad().left, rect.y + (rect.height - icon.getIconHeight()) / 2 + (Intrinsics.areEqual((Object)icon, (Object)AllIcons.Nodes.Module8x8) ? JBUI.scale((int)1) : 0));
                offset += icon.getIconWidth();
                offset += this.getIconTextGap();
            }
            this.doPaintText(g, offset, false);
        } else {
            boolean toolbarVisible = UISettings.Companion.getInstance().getShowMainToolbar();
            boolean selected = this.isSelected() && this.isFocused();
            boolean nextSelected = this.vm.isNextSelected() && this.isFocused();
            ImageType imageType = ImageType.from(this.isFloating(), toolbarVisible, selected, nextSelected);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)imageType), (String)"from(...)");
            ImageType type = imageType;
            ScaleContextCache scaleContextCache = this.cache.computeIfAbsent(type, arg_0 -> NavBarItemComponent.doPaint$lambda$0((Function1)new Function1<ImageType, ScaleContextCache<BufferedImage>>(this, toolbarVisible, selected, nextSelected){
                final /* synthetic */ NavBarItemComponent this$0;
                final /* synthetic */ boolean $toolbarVisible;
                final /* synthetic */ boolean $selected;
                final /* synthetic */ boolean $nextSelected;
                {
                    this.this$0 = $receiver;
                    this.$toolbarVisible = $toolbarVisible;
                    this.$selected = $selected;
                    this.$nextSelected = $nextSelected;
                    super(1);
                }

                @NotNull
                public final ScaleContextCache<BufferedImage> invoke(@NotNull ImageType it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return new ScaleContextCache((Function1)new Function1<ScaleContext, BufferedImage>(this.this$0, this.$toolbarVisible, this.$selected, this.$nextSelected){
                        final /* synthetic */ NavBarItemComponent this$0;
                        final /* synthetic */ boolean $toolbarVisible;
                        final /* synthetic */ boolean $selected;
                        final /* synthetic */ boolean $nextSelected;
                        {
                            this.this$0 = $receiver;
                            this.$toolbarVisible = $toolbarVisible;
                            this.$selected = $selected;
                            this.$nextSelected = $nextSelected;
                            super(1);
                        }

                        @NotNull
                        public final BufferedImage invoke(@NotNull ScaleContext scaleContext) {
                            Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
                            BufferedImage bufferedImage = AbstractNavBarUI.drawToBuffer((Component)((Object)this.this$0), scaleContext, NavBarItemComponent.access$isFloating(this.this$0), this.$toolbarVisible, this.$selected, this.$nextSelected, NavBarItemComponent.access$getVm$p(this.this$0).isLast());
                            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"drawToBuffer(...)");
                            return bufferedImage;
                        }
                    });
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)scaleContextCache, (String)"computeIfAbsent(...)");
            ScaleContextCache imageCache2 = scaleContextCache;
            BufferedImage bufferedImage = (BufferedImage)imageCache2.getOrProvide(ScaleContext.Companion.create(g));
            if (bufferedImage == null) {
                return;
            }
            BufferedImage image = bufferedImage;
            StartupUiUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
            int offset = isFirst ? AbstractNavBarUI.getFirstElementLeftOffset() : 0;
            int textOffset = paddings.width() + offset;
            Icon icon = this.getIcon();
            if (icon != null) {
                int iconOffset = paddings.left + offset;
                icon.paintIcon((Component)((Object)this), g, iconOffset, (this.getHeight() - icon.getIconHeight()) / 2);
                textOffset += icon.getIconWidth();
            }
            this.doPaintText(g, textOffset, false);
        }
    }

    private final Color highlightColor() {
        return this.isHovered ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.HOVER_BACKGROUND : (this.isSelected() ? (this.isFocused() ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_BACKGROUND : JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_INACTIVE_BACKGROUND) : null);
    }

    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = (AccessibleContext)((Object)new AccessibleNavBarItem());
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    private static final ScaleContextCache doPaint$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ScaleContextCache)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isFloating(NavBarItemComponent $this) {
        return $this.isFloating();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/navbar/frontend/ui/NavBarItemComponent$AccessibleNavBarItem;", "Lcom/intellij/ui/SimpleColoredComponent$AccessibleSimpleColoredComponent;", "Lcom/intellij/ui/SimpleColoredComponent;", "Ljavax/accessibility/AccessibleAction;", "(Lcom/intellij/platform/navbar/frontend/ui/NavBarItemComponent;)V", "doAccessibleAction", "", "i", "", "getAccessibleAction", "getAccessibleActionCount", "getAccessibleActionDescription", "", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "intellij.platform.navbar.frontend"})
    private final class AccessibleNavBarItem
    extends SimpleColoredComponent.AccessibleSimpleColoredComponent
    implements AccessibleAction {
        public AccessibleNavBarItem() {
            super((SimpleColoredComponent)NavBarItemComponent.this);
        }

        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.PUSH_BUTTON;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"PUSH_BUTTON");
            return accessibleRole;
        }

        @NotNull
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        @Nullable
        public String getAccessibleActionDescription(int i) {
            if (i == 0) {
                return UIManager.getString("AbstractButton.clickText");
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            if (i == 0) {
                NavBarItemComponent.this.vm.select();
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/navbar/frontend/ui/NavBarItemComponent$Companion;", "", "()V", "isItemComponentFocusable", "", "isItemComponentFocusable$intellij_platform_navbar_frontend", "intellij.platform.navbar.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isItemComponentFocusable$intellij_platform_navbar_frontend() {
            return ScreenReader.isActive();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/navbar/frontend/ui/NavBarItemComponent$ItemMouseListener;", "Ljava/awt/event/MouseAdapter;", "(Lcom/intellij/platform/navbar/frontend/ui/NavBarItemComponent;)V", "click", "", "e", "Ljava/awt/event/MouseEvent;", "mouseEntered", "mouseExited", "mousePressed", "mouseReleased", "intellij.platform.navbar.frontend"})
    private final class ItemMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!SystemInfo.isWindows) {
                this.click(e);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (SystemInfo.isWindows) {
                this.click(e);
            }
        }

        private final void click(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (e.isPopupTrigger()) {
                return;
            }
            if (e.getClickCount() == 1) {
                NavBarItemComponent.this.focusItem();
                NavBarItemComponent.this.vm.select();
                NavBarItemComponent.this.vm.showPopup();
                e.consume();
            } else if (e.getClickCount() == 2 && e.getButton() == 1) {
                NavBarItemComponent.this.vm.activate();
                e.consume();
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.isConsumed() || !ExperimentalUI.Companion.isNewUI()) {
                return;
            }
            NavBarItemComponent.this.isHovered = true;
            NavBarItemComponent.this.update();
            e.consume();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.isConsumed() || !ExperimentalUI.Companion.isNewUI()) {
                return;
            }
            NavBarItemComponent.this.isHovered = false;
            NavBarItemComponent.this.update();
            e.consume();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/navbar/frontend/ui/NavBarItemComponent$ItemPopupHandler;", "Lcom/intellij/ui/PopupHandler;", "(Lcom/intellij/platform/navbar/frontend/ui/NavBarItemComponent;)V", "invokePopup", "", "comp", "Ljava/awt/Component;", "x", "", "y", "intellij.platform.navbar.frontend"})
    private final class ItemPopupHandler
    extends PopupHandler {
        public void invokePopup(@Nullable Component comp, int x, int y) {
            NavBarItemComponent.this.focusItem();
            NavBarItemComponent.this.vm.select();
            ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("NavBar", ActionsKt.navBarContextMenuActionGroup());
            NavBarItemComponent navBarItemComponent = NavBarItemComponent.this;
            ActionPopupMenu it = actionPopupMenu;
            boolean bl = false;
            it.setTargetComponent((JComponent)navBarItemComponent.panel);
            actionPopupMenu.getComponent().show(NavBarItemComponent.this.panel, NavBarItemComponent.this.getX() + x, NavBarItemComponent.this.getY() + y);
        }
    }
}

