/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewItemState;
import com.intellij.execution.services.ServiceViewOptions;
import com.intellij.ide.DataManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Key;
import com.intellij.platform.execution.serviceView.ServiceModel;
import com.intellij.platform.execution.serviceView.ServiceViewDragHelper;
import com.intellij.platform.execution.serviceView.ServiceViewTreeCellRendererBase;
import com.intellij.platform.execution.serviceView.ServiceViewTreeLinkMouseListener;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ServiceViewTree
extends Tree {
    private static final Function<TreePath, String> DISPLAY_NAME_CONVERTER = path -> {
        Object node = path.getLastPathComponent();
        if (node instanceof ServiceModel.ServiceViewItem) {
            return ServiceViewDragHelper.getDisplayName(((ServiceModel.ServiceViewItem)node).getViewDescriptor().getPresentation());
        }
        return node.toString();
    };
    private final TreeModel myTreeModel;

    ServiceViewTree(@NotNull TreeModel treeModel, @NotNull Disposable parent) {
        if (treeModel == null) {
            ServiceViewTree.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            ServiceViewTree.$$$reportNull$$$0(1);
        }
        this.myTreeModel = treeModel;
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel(this.myTreeModel, parent);
        this.setModel((TreeModel)asyncTreeModel);
        this.initTree();
    }

    private void initTree() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer((TreeCellRenderer)((Object)new ServiceViewTreeCellRenderer()));
        ComponentUtil.putClientProperty((JComponent)((Object)this), (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)true, DISPLAY_NAME_CONVERTER);
        ServiceViewTreeLinkMouseListener mouseListener = new ServiceViewTreeLinkMouseListener(this);
        mouseListener.installOn((Component)((Object)this));
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                TreePath path;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((path = ServiceViewTree.this.getClosestPathForLocation(e.getX(), e.getY())) == null) {
                    return false;
                }
                Object lastComponent = path.getLastPathComponent();
                if (lastComponent instanceof LoadingNode) {
                    return false;
                }
                return ServiceViewTree.this.myTreeModel.isLeaf(lastComponent) && lastComponent instanceof ServiceModel.ServiceViewItem && ((ServiceModel.ServiceViewItem)lastComponent).getViewDescriptor().handleDoubleClick(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/platform/execution/serviceView/ServiceViewTree$1", "onDoubleClick"));
            }
        }.installOn((Component)((Object)this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "treeModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/platform/execution/serviceView/ServiceViewTree";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ServiceViewTreeCellRenderer
    extends ServiceViewTreeCellRendererBase {
        private ServiceViewDescriptor myDescriptor;
        private ServiceViewItemState myItemState;
        private JComponent myComponent;

        private ServiceViewTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                ServiceViewTreeCellRenderer.$$$reportNull$$$0(0);
            }
            this.myDescriptor = value instanceof ServiceModel.ServiceViewItem ? ((ServiceModel.ServiceViewItem)value).getViewDescriptor() : null;
            this.myComponent = tree;
            this.myItemState = new ServiceViewItemState(selected, expanded, leaf, hasFocus);
            super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
            this.myDescriptor = null;
        }

        @Nullable
        protected ItemPresentation getPresentation(Object node) {
            if (!(node instanceof ServiceModel.ServiceViewItem)) {
                return null;
            }
            ServiceViewOptions viewOptions = (ServiceViewOptions)DataManager.getInstance().getDataContext((Component)this.myComponent).getData(ServiceViewActionUtils.OPTIONS_KEY);
            assert (this.myItemState != null);
            return ((ServiceModel.ServiceViewItem)node).getItemPresentation(viewOptions, this.myItemState);
        }

        @Override
        protected Object getTag(String fragment) {
            return this.myDescriptor == null ? null : this.myDescriptor.getPresentationTag((Object)fragment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/platform/execution/serviceView/ServiceViewTree$ServiceViewTreeCellRenderer", "customizeCellRenderer"));
        }
    }
}

