/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.onboarding.k2;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.KotlinK2ModeCompatibilityCheckerKt;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginMode;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.base.util.DumbModeUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinPluginKindSwitcherController;
import org.jetbrains.kotlin.onboarding.FeedbackBundle;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2UserTracker;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2UserTrackerState;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService;", "", "()V", "applicableVersions", "", "", "productName", "Lcom/intellij/openapi/util/NlsSafe;", "getProductName", "()Ljava/lang/String;", "hasIncompatibleWithK2ModeThirdPartyPluginsEnabled", "", "showEnableK2Notification", "", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTrackerState;", "showNotification", "Companion", "kotlin.onboarding"})
@SourceDebugExtension(value={"SMAP\nEnableK2NotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnableK2NotificationService.kt\norg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n766#2:117\n857#2,2:118\n1747#2,3:120\n*S KotlinDebug\n*F\n+ 1 EnableK2NotificationService.kt\norg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService\n*L\n73#1:117\n73#1:118,2\n74#1:120,3\n*E\n"})
public final class EnableK2NotificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> applicableVersions;

    public EnableK2NotificationService() {
        Object[] objectArray = new String[]{"2024.2", "2024.3"};
        this.applicableVersions = SetsKt.setOf((Object[])objectArray);
    }

    private final String getProductName() {
        String string = ApplicationNamesInfo.getInstance().getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductName(...)");
        return string;
    }

    public final void showEnableK2Notification(@NotNull Project project2, @NotNull K2UserTrackerState state) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        if (KotlinPluginModeProvider.Companion.getCurrentPluginMode() == KotlinPluginMode.K2) {
            return;
        }
        if (!Registry.is((String)"test.enable.k2.notification", (boolean)false)) {
            if (state.getUserSawEnableK2Notification()) {
                return;
            }
            if (state.getK2UserSince() != -1L) {
                return;
            }
        }
        if (!StringsKt.startsWith$default((String)KotlinJpsPluginSettings.Companion.jpsVersion(project2), (String)"2.0", (boolean)false, (int)2, null)) {
            return;
        }
        String ideShortVersion = ApplicationInfo.getInstance().getShortVersion();
        if (!this.applicableVersions.contains(ideShortVersion) || ideShortVersion.equals("2024.3") && (!ApplicationInfo.getInstance().isEAP() || !ApplicationManager.getApplication().isInternal())) {
            return;
        }
        boolean projectContainsNonScriptKotlinFile2 = (Boolean)DumbModeUtils.runReadActionInSmartMode(project2, (Function0)new Function0<Boolean>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return ProjectStructureUtils.containsNonScriptKotlinFile(this.$project);
            }
        });
        if (!projectContainsNonScriptKotlinFile2) {
            return;
        }
        if (this.hasIncompatibleWithK2ModeThirdPartyPluginsEnabled()) {
            return;
        }
        this.showNotification(project2, state);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasIncompatibleWithK2ModeThirdPartyPluginsEnabled() {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = PluginManagerCore.INSTANCE.getPluginSet().allPlugins;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IdeaPluginDescriptorImpl it = (IdeaPluginDescriptorImpl)element$iv$iv;
                boolean bl2 = false;
                if (!(!it.isBundled() && it.isEnabled())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List allEnabledThirdPartyPlugins = (List)destination$iv$iv;
            Iterable $this$any$iv = allEnabledThirdPartyPlugins;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IdeaPluginDescriptorImpl it = (IdeaPluginDescriptorImpl)element$iv;
                    boolean bl3 = false;
                    if (!KotlinK2ModeCompatibilityCheckerKt.isPluginWhichDependsOnKotlinPluginInK2ModeAndItDoesNotSupportK2Mode((IdeaPluginDescriptorImpl)it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void showNotification(Project project2, K2UserTrackerState state) {
        Notification notification2 = NotificationGroupManager.getInstance().getNotificationGroup("Configure K2").createNotification(FeedbackBundle.INSTANCE.message("enable.k2.mode", new Object[0]), FeedbackBundle.INSTANCE.message("enable.k2.mode.notification.text", new Object[0]), NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createExpiring((String)FeedbackBundle.INSTANCE.message("enable.action.name", new Object[0]), (arg_0, arg_1) -> EnableK2NotificationService.showNotification$lambda$2((Function2)new Function2<AnActionEvent, Notification, Unit>(this){
            final /* synthetic */ EnableK2NotificationService this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(AnActionEvent anActionEvent, Notification notification2) {
                VMOptions.setOption((String)"-Didea.kotlin.plugin.use.k2=", (String)"true");
                KotlinPluginKindSwitcherController.Companion.suggestRestart(EnableK2NotificationService.access$getProductName(this.this$0));
            }
        }, arg_0, arg_1))).setIcon(KotlinIcons.SMALL_LOGO);
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"setIcon(...)");
        Notification notification3 = notification2;
        notification3.notify(project2);
        state.setUserSawEnableK2Notification(true);
    }

    private static final void showNotification$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ String access$getProductName(EnableK2NotificationService $this) {
        return $this.getProductName();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker;", "kotlin.onboarding"})
    @SourceDebugExtension(value={"SMAP\nEnableK2NotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnableK2NotificationService.kt\norg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,116:1\n40#2,3:117\n*S KotlinDebug\n*F\n+ 1 EnableK2NotificationService.kt\norg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService$Companion\n*L\n113#1:117,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final K2UserTracker getInstance() {
            boolean $i$f$service = false;
            Class<K2UserTracker> serviceClass$iv = K2UserTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (K2UserTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

