/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.onboarding.gradle;

import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.feedback.dialog.BaseFeedbackSystemInfoDialogKt;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialogWithEmail;
import com.intellij.platform.feedback.dialog.CommonFeedbackSystemData;
import com.intellij.platform.feedback.dialog.uiBlocks.DescriptionBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.FeedbackBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.RatingBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TextAreaBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TopLabelBlock;
import com.intellij.platform.feedback.impl.notification.ThanksForFeedbackNotification;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.onboarding.gradle.BuildProcessSatisfactionDialogData;
import org.jetbrains.kotlin.onboarding.gradle.GradleFeedbackBundle;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010'\u001a\u00020\u0002H\u0002J\n\u0010(\u001a\u0004\u0018\u00010)H\u0002J\n\u0010*\u001a\u0004\u0018\u00010)H\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bH\u0002J\b\u0010,\u001a\u00020\u0006H\u0014J\b\u0010-\u001a\u00020\u0019H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\u00020\u00028TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010!\u001a\u00020\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R\u0014\u0010%\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0016\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionDialog;", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialogWithEmail;", "Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionDialogData;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "(Lcom/intellij/openapi/project/Project;Z)V", "distributionUrlRegex", "Lkotlin/text/Regex;", "myBlocks", "", "Lcom/intellij/platform/feedback/dialog/uiBlocks/FeedbackBlock;", "getMyBlocks", "()Ljava/util/List;", "myFeedbackJsonVersion", "", "getMyFeedbackJsonVersion", "()I", "myFeedbackReportId", "", "getMyFeedbackReportId", "()Ljava/lang/String;", "myShowFeedbackSystemInfoDialog", "Lkotlin/Function0;", "", "getMyShowFeedbackSystemInfoDialog", "()Lkotlin/jvm/functions/Function0;", "mySystemInfoData", "getMySystemInfoData", "()Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionDialogData;", "mySystemInfoData$delegate", "Lkotlin/Lazy;", "myTitle", "getMyTitle", "zendeskFeedbackType", "getZendeskFeedbackType", "zendeskTicketTitle", "getZendeskTicketTitle", "collectData", "getGradleVersion", "Lorg/gradle/util/GradleVersion;", "getGradleWrapperVersion", "getKotlinVersions", "shouldAutoCloseZendeskTicket", "showThanksNotification", "kotlin.onboarding.gradle"})
@SourceDebugExtension(value={"SMAP\nBuildProcessSatisfactionDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildProcessSatisfactionDialog.kt\norg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,140:1\n1603#2,9:141\n1855#2:150\n1856#2:152\n1612#2:153\n1774#2,4:172\n1#3:151\n1#3:164\n1#3:169\n11383#4,9:154\n13309#4:163\n13310#4:165\n11392#4:166\n11391#4:167\n13309#4:168\n13310#4:170\n11392#4:171\n*S KotlinDebug\n*F\n+ 1 BuildProcessSatisfactionDialog.kt\norg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionDialog\n*L\n56#1:141,9\n56#1:150\n56#1:152\n56#1:153\n71#1:172,4\n56#1:151\n63#1:164\n67#1:169\n63#1:154,9\n63#1:163\n63#1:165\n63#1:166\n67#1:167\n67#1:168\n67#1:170\n67#1:171\n*E\n"})
public final class BuildProcessSatisfactionDialog
extends BlockBasedFeedbackDialogWithEmail<BuildProcessSatisfactionDialogData> {
    @NotNull
    private final Project project;
    private final int myFeedbackJsonVersion;
    @NotNull
    private final Regex distributionUrlRegex;
    @NotNull
    private final Lazy mySystemInfoData$delegate;
    @NotNull
    private final String zendeskTicketTitle;
    @NotNull
    private final String zendeskFeedbackType;
    @NotNull
    private final String myFeedbackReportId;
    @NotNull
    private final Function0<Unit> myShowFeedbackSystemInfoDialog;
    @NotNull
    private final String myTitle;
    @NotNull
    private final List<FeedbackBlock> myBlocks;

    public BuildProcessSatisfactionDialog(@NotNull Project project2, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2, forTest);
        this.project = project2;
        this.myFeedbackJsonVersion = super.getMyFeedbackJsonVersion() + 1;
        this.distributionUrlRegex = new Regex("://services\\.gradle\\.org/distributions/gradle-([\\w.\\-_]+)-(?:all|bin)\\.zip");
        this.mySystemInfoData$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BuildProcessSatisfactionDialogData>(this){
            final /* synthetic */ BuildProcessSatisfactionDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BuildProcessSatisfactionDialogData invoke() {
                return BuildProcessSatisfactionDialog.access$collectData(this.this$0);
            }
        }));
        this.zendeskTicketTitle = "Kotlin Build Process in-IDE Feedback";
        this.zendeskFeedbackType = "Kotlin Build Process Feedback";
        this.myFeedbackReportId = "kotlin_gradle_build_process_feedback";
        this.myShowFeedbackSystemInfoDialog = (Function0)new Function0<Unit>(this){
            final /* synthetic */ BuildProcessSatisfactionDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BaseFeedbackSystemInfoDialogKt.showFeedbackSystemInfoDialog((Project)BuildProcessSatisfactionDialog.access$getMyProject(this.this$0), (CommonFeedbackSystemData)this.this$0.getMySystemInfoData().getCommonData(), (Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ BuildProcessSatisfactionDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$showFeedbackSystemInfoDialog) {
                        Intrinsics.checkNotNullParameter((Object)$this$showFeedbackSystemInfoDialog, (String)"$this$showFeedbackSystemInfoDialog");
                        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.gradle.version", new Object[0]), (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ BuildProcessSatisfactionDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.label(this.this$0.getMySystemInfoData().getGradleVersion());
                            }
                        });
                        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.kotlin.version", new Object[0]), (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ BuildProcessSatisfactionDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.label(this.this$0.getMySystemInfoData().getKotlinVersion());
                            }
                        });
                        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.groovy.build.file.count", new Object[0]), (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ BuildProcessSatisfactionDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.label(String.valueOf(this.this$0.getMySystemInfoData().getGroovyBuildFileCount()));
                            }
                        });
                        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.kts.build.file.count", new Object[0]), (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ BuildProcessSatisfactionDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.label(String.valueOf(this.this$0.getMySystemInfoData().getKtsBuildFileCount()));
                            }
                        });
                    }
                }));
            }
        };
        this.myTitle = GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.top.title", new Object[0]);
        Object[] objectArray = new FeedbackBlock[]{new TopLabelBlock(GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.title", new Object[0])), new DescriptionBlock(GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.description", new Object[0])), new RatingBlock(GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.rating.label", new Object[0]), "rating"), new TextAreaBlock(GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.improve.label", new Object[0]), "improvements")};
        this.myBlocks = CollectionsKt.listOf((Object[])objectArray);
        this.init();
    }

    protected int getMyFeedbackJsonVersion() {
        return this.myFeedbackJsonVersion;
    }

    private final GradleVersion getGradleWrapperVersion() {
        WrapperConfiguration wrapperConfiguration = GradleUtil.getWrapperConfiguration((String)this.project.getBasePath());
        URI uRI = wrapperConfiguration != null ? wrapperConfiguration.getDistribution() : null;
        if (uRI == null) {
            return null;
        }
        URI wrapperConfiguration2 = uRI;
        String string = wrapperConfiguration2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        MatchResult matchResult2 = Regex.find$default((Regex)this.distributionUrlRegex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult2 == null) {
            return null;
        }
        MatchResult matchResult3 = matchResult2;
        String versionPart = (String)matchResult3.getGroupValues().get(1);
        return GradleVersion.version((String)versionPart);
    }

    /*
     * WARNING - void declaration
     */
    private final GradleVersion getGradleVersion() {
        void $this$mapNotNullTo$iv$iv;
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gradleSettings, (String)"getInstance(...)");
        GradleSettings settings2 = gradleSettings;
        Collection collection = settings2.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            GradleVersion it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            GradleProjectSettings it = (GradleProjectSettings)element$iv$iv;
            boolean bl2 = false;
            if (GradleInstallationManager.guessGradleVersion((GradleProjectSettings)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        GradleVersion linkedVersion = (GradleVersion)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        GradleVersion gradleVersion2 = linkedVersion;
        if (gradleVersion2 == null) {
            gradleVersion2 = this.getGradleWrapperVersion();
        }
        return gradleVersion2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getKotlinVersions() {
        void $this$mapNotNullTo$iv$iv;
        Module[] $this$mapNotNull$iv = ProjectUtil.getModules((Project)this.project);
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (ConfigureKotlinInProjectUtilsKt.getGradleKotlinVersion((Module)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final BuildProcessSatisfactionDialogData collectData() {
        String string;
        String gradleVersion2;
        void $this$mapNotNullTo$iv;
        Module[] moduleArray = ProjectUtil.getModules((Project)this.project);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            Path path2;
            String string2;
            void element$iv$iv;
            void element$iv = element$iv$iv = $this$forEach$iv$iv[j];
            boolean bl = false;
            void it = element$iv;
            boolean bl2 = false;
            String string3 = string2 = ExternalSystemApiUtil.getExternalProjectPath((Module)it);
            if (string3 != null) {
                Intrinsics.checkNotNull((Object)string3);
                path2 = NioPathUtil.toNioPathOrNull((String)string2);
            } else {
                path2 = null;
            }
            if (path2 == null) continue;
            Path it$iv = path2;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set allExternalModulePaths = (Set)destination$iv;
        int groovyCount = BuildProcessSatisfactionDialog.collectData$countExistingFiles(allExternalModulePaths, "build.gradle");
        int ktsCount = BuildProcessSatisfactionDialog.collectData$countExistingFiles(allExternalModulePaths, "build.gradle.kts");
        GradleVersion gradleVersion3 = this.getGradleVersion();
        String string4 = gradleVersion3 != null ? gradleVersion3.getVersion() : null;
        if (string4 == null) {
            string4 = gradleVersion2 = "UNKNOWN";
        }
        if ((string = (String)((Object)CollectionsKt.maxOrNull((Iterable)this.getKotlinVersions()))) == null) {
            string = "UNKNOWN";
        }
        String kotlinVersion2 = string;
        return new BuildProcessSatisfactionDialogData(gradleVersion2, kotlinVersion2, groovyCount, ktsCount, CommonFeedbackSystemData.Companion.getCurrentData());
    }

    @NotNull
    protected BuildProcessSatisfactionDialogData getMySystemInfoData() {
        Lazy lazy = this.mySystemInfoData$delegate;
        return (BuildProcessSatisfactionDialogData)lazy.getValue();
    }

    @NotNull
    public String getZendeskTicketTitle() {
        return this.zendeskTicketTitle;
    }

    @NotNull
    public String getZendeskFeedbackType() {
        return this.zendeskFeedbackType;
    }

    @NotNull
    protected String getMyFeedbackReportId() {
        return this.myFeedbackReportId;
    }

    protected boolean shouldAutoCloseZendeskTicket() {
        return false;
    }

    @NotNull
    protected Function0<Unit> getMyShowFeedbackSystemInfoDialog() {
        return this.myShowFeedbackSystemInfoDialog;
    }

    @NotNull
    protected String getMyTitle() {
        return this.myTitle;
    }

    @NotNull
    protected List<FeedbackBlock> getMyBlocks() {
        return this.myBlocks;
    }

    protected void showThanksNotification() {
        new ThanksForFeedbackNotification(null, GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.feedback.content", new Object[0]), 1, null).notify(this.getMyProject());
    }

    private static final int collectData$countExistingFiles(Set<Path> allExternalModulePaths, String filename) {
        int n;
        Iterable $this$count$iv = allExternalModulePaths;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Path path2 = (Path)element$iv;
                boolean bl = false;
                VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                Path path3 = path2.resolve(filename);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                if (!(virtualFileManager.findFileByNioPath(path3) != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    public static final /* synthetic */ BuildProcessSatisfactionDialogData access$collectData(BuildProcessSatisfactionDialog $this) {
        return $this.collectData();
    }

    public static final /* synthetic */ Project access$getMyProject(BuildProcessSatisfactionDialog $this) {
        return $this.getMyProject();
    }
}

