/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.statistics.KotlinASStatisticsEventFlags;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "buildEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "eventFlags", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "isMPPBuild", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "languageLevelField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "platformField", "pluginInfoField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "systemField", "composePlatformFields", "", "", "getBuildSystemType", "it", "Lcom/intellij/openapi/module/Module;", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nProjectConfigurationCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectConfigurationCollector.kt\norg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1855#2,2:99\n1549#2:101\n1620#2,3:102\n*S KotlinDebug\n*F\n+ 1 ProjectConfigurationCollector.kt\norg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector\n*L\n30#1:99,2\n84#1:101\n84#1:102,3\n*E\n"})
public final class ProjectConfigurationCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("kotlin.project.configuration", 11, null, 4, null);
    @NotNull
    private final StringEventField systemField;
    @NotNull
    private final StringEventField platformField;
    @NotNull
    private final StringEventField languageLevelField;
    @NotNull
    private final BooleanEventField isMPPBuild;
    @NotNull
    private final PrimitiveEventField<PluginInfo> pluginInfoField;
    @NotNull
    private final LongEventField eventFlags;
    @NotNull
    private final VarargEventId buildEvent;

    public ProjectConfigurationCollector() {
        Object[] objectArray = new String[]{"JPS", "Maven", "Gradle", "unknown"};
        this.systemField = EventFields.String((String)"system", (List)CollectionsKt.listOf((Object[])objectArray));
        this.platformField = EventFields.String((String)"platform", this.composePlatformFields());
        this.languageLevelField = EventFields.StringValidatedByRegexpReference$default((String)"languageLevel", (String)"version", null, (int)4, null);
        this.isMPPBuild = EventFields.Boolean((String)"isMPP");
        this.pluginInfoField = EventFields.PluginInfo;
        this.eventFlags = EventFields.Long$default((String)"eventFlags", null, (int)2, null);
        objectArray = new EventField[]{this.systemField, this.platformField, this.isMPPBuild, this.languageLevelField, this.pluginInfoField, this.eventFlags};
        this.buildEvent = this.GROUP.registerVarargEvent("Build", (EventField[])objectArray);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Set metrics = new LinkedHashSet();
        List list2 = ProjectFacetManager.getInstance((Project)project2).getModulesWithFacet(KotlinFacetType.Companion.getTYPE_ID());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getModulesWithFacet(...)");
        List modulesWithFacet = list2;
        if (!((Collection)modulesWithFacet).isEmpty()) {
            Iterable $this$forEach$iv = modulesWithFacet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Module it = (Module)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                String buildSystem = this.getBuildSystemType(it);
                String platform2 = ConfigureKotlinInProjectUtilsKt.getPlatform(it);
                Object object = KotlinFacet.Companion.get(it);
                String languageLevel2 = object != null && (object = (KotlinFacetConfiguration)object.getConfiguration()) != null && (object = object.getSettings()) != null && (object = object.getLanguageLevel()) != null ? object.getVersionString() : null;
                EventPair[] eventPairArray = new EventPair[]{this.systemField.with((Object)buildSystem), this.platformField.with((Object)platform2), this.languageLevelField.with((Object)languageLevel2), this.isMPPBuild.with((Object)(KotlinFacetUtils.isMultiPlatformModule(it) || KotlinFacetUtils.isNewMultiPlatformModule(it) ? 1 : 0)), this.pluginInfoField.with((Object)KotlinIdePlugin.INSTANCE.getPluginInfo()), this.eventFlags.with((Object)KotlinASStatisticsEventFlags.INSTANCE.calculateAndPackEventsFlagsToLong(it))};
                metrics.add(this.buildEvent.metric(eventPairArray));
            }
        }
        return metrics;
    }

    private final String getBuildSystemType(Module it) {
        String string;
        BuildSystemType buildSystem = BuildSystemTypeKt.getBuildSystemType(it);
        if (buildSystem == BuildSystemType.JPS) {
            string = "JPS";
        } else {
            String string2 = buildSystem.toString().toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"maven", (boolean)false, (int)2, null)) {
                string = "Maven";
            } else {
                String string3 = buildSystem.toString().toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = StringsKt.contains$default((CharSequence)string3, (CharSequence)"gradle", (boolean)false, (int)2, null) ? "Gradle" : "unknown";
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> composePlatformFields() {
        Collection<CallSite> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new List[2];
        Object object = new String[]{"jvm", "jvm.android", "js", "wasm", "wasm.js", "wasm.wasi", "wasm.unknown", "common", "native.unknown", "unknown"};
        objectArray[0] = CollectionsKt.listOf((Object[])object);
        object = KonanTarget.Companion.getPredefinedTargets().keySet();
        int n = 1;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CallSite)((Object)("native." + (String)it)));
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = collection;
        return CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }
}

