/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.usagesSearch.operators;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.analysis.KotlinBaseAnalysisBundle;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.search.ExpectActualUtils;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.idea.search.ReceiverTypeSearcherInfo;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinRequestResultProcessor;
import org.jetbrains.kotlin.idea.search.usagesSearch.ExpressionsOfTypeProcessor;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.BinaryOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.ContainsOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.DestructuringDeclarationReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.IndexingOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.InvokeOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.IteratorOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.OperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.PropertyDelegationOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.UnaryOperatorReferenceSearcher;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001'BC\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u0002H$J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH$J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H$J\u0015\u0010#\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010$J\u0006\u0010%\u001a\u00020\u0019J\f\u0010&\u001a\u00020\u0011*\u00020\u0007H\u0002R\u0016\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher;", "TReferenceElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "", "targetDeclaration", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "optimizer", "Lcom/intellij/psi/search/SearchRequestCollector;", "options", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;", "wordsToSearch", "", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/search/SearchScope;Lcom/intellij/util/Processor;Lcom/intellij/psi/search/SearchRequestCollector;Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;Ljava/util/List;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getTargetDeclaration", "()Lcom/intellij/psi/PsiElement;", "doPlainSearch", "", "scope", "extractReference", "element", "isReferenceToCheck", "", "ref", "processPossibleReceiverExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "processReferenceElement", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "run", "logPresentation", "Companion", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nOperatorReferenceSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorReferenceSearcher.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher\n+ 2 ExpressionsOfTypeProcessor.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/ExpressionsOfTypeProcessor$Companion\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,347:1\n80#2,2:348\n80#2,2:367\n80#2,2:369\n80#2,2:371\n11383#3,9:350\n13309#3:359\n13310#3:361\n11392#3:362\n11065#3:375\n11400#3,3:376\n1#4:360\n1549#5:363\n1620#5,3:364\n1855#5,2:373\n*S KotlinDebug\n*F\n+ 1 OperatorReferenceSearcher.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher\n*L\n65#1:348,2\n211#1:367,2\n220#1:369,2\n240#1:371,2\n70#1:350,9\n70#1:359\n70#1:361\n70#1:362\n323#1:375\n323#1:376,3\n70#1:360\n73#1:363\n73#1:364,3\n279#1:373,2\n*E\n"})
public abstract class OperatorReferenceSearcher<TReferenceElement extends KtElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement targetDeclaration;
    @NotNull
    private final SearchScope searchScope;
    @NotNull
    private final Processor<? super PsiReference> consumer;
    @NotNull
    private final SearchRequestCollector optimizer;
    @NotNull
    private final KotlinReferencesSearchOptions options;
    @NotNull
    private final List<String> wordsToSearch;
    @NotNull
    private final Project project;

    public OperatorReferenceSearcher(@NotNull PsiElement targetDeclaration, @NotNull SearchScope searchScope2, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchRequestCollector optimizer, @NotNull KotlinReferencesSearchOptions options2, @NotNull List<String> wordsToSearch) {
        Intrinsics.checkNotNullParameter((Object)targetDeclaration, (String)"targetDeclaration");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)optimizer, (String)"optimizer");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Intrinsics.checkNotNullParameter(wordsToSearch, (String)"wordsToSearch");
        this.targetDeclaration = targetDeclaration;
        this.searchScope = searchScope2;
        this.consumer = consumer;
        this.optimizer = optimizer;
        this.options = options2;
        this.wordsToSearch = wordsToSearch;
        Project project2 = this.targetDeclaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.project = project2;
    }

    @NotNull
    protected final PsiElement getTargetDeclaration() {
        return this.targetDeclaration;
    }

    protected abstract void processPossibleReceiverExpression(@NotNull KtExpression var1);

    @Nullable
    protected abstract PsiReference extractReference(@NotNull KtElement var1);

    protected abstract boolean isReferenceToCheck(@NotNull PsiReference var1);

    /*
     * WARNING - void declaration
     */
    protected final boolean processReferenceElement(@NotNull TReferenceElement element3) {
        void $this$mapTo$iv$iv;
        KtDeclaration $this$forEach$iv$iv$iv;
        Collection destination$iv$iv;
        Object $this$mapNotNull$iv;
        Collection collection;
        Intrinsics.checkNotNullParameter(element3, (String)"element");
        PsiReference psiReference = this.extractReference((KtElement)element3);
        if (psiReference == null) {
            return true;
        }
        PsiReference reference2 = psiReference;
        ExpressionsOfTypeProcessor.Companion this_$iv = ExpressionsOfTypeProcessor.Companion;
        boolean $i$f$testLog = false;
        Collection collection2 = this_$iv.getTestLog();
        if (collection2 != null) {
            collection = collection2;
            boolean bl = false;
            collection.add((String)("Resolved " + ExpressionsOfTypeProcessor.Companion.logPresentation((PsiElement)element3)));
        }
        if (reference2.isReferenceTo(this.targetDeclaration)) {
            return this.consumer.process((Object)reference2);
        }
        ResolveResult[] resolveResultArray = reference2 instanceof PsiPolyVariantReference ? (ResolveResult[])reference2 : null;
        if (resolveResultArray != null && (resolveResultArray = resolveResultArray.multiResolve(false)) != null) {
            void $this$mapNotNullTo$iv$iv;
            $this$mapNotNull$iv = resolveResultArray;
            boolean $i$f$mapNotNull = false;
            ResolveResult[] resolveResultArray2 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                KtDeclaration it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                PsiElement psiElement2 = it.getElement();
                if ((psiElement2 instanceof KtDeclaration ? (KtDeclaration)psiElement2 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
        } else {
            return true;
        }
        List currentTargets = (List)destination$iv$iv;
        if (!(this.targetDeclaration instanceof KtDeclaration)) {
            return true;
        }
        KtDeclaration ktDeclaration = ExpectActualUtils.INSTANCE.expectedDeclarationIfAny((KtDeclaration)this.targetDeclaration);
        if (ktDeclaration == null) {
            ktDeclaration = (KtDeclaration)this.targetDeclaration;
        }
        KtDeclaration expectedTarget = ktDeclaration;
        Iterable $this$map$iv = currentTargets;
        boolean $i$f$map = false;
        $this$mapNotNull$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            $this$forEach$iv$iv$iv = (KtDeclaration)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            KtDeclaration ktDeclaration2 = ExpectActualUtils.INSTANCE.expectedDeclarationIfAny((KtDeclaration)it);
            if (ktDeclaration2 == null) {
                ktDeclaration2 = it;
            }
            collection.add(ktDeclaration2);
        }
        return ((List)destination$iv$iv2).contains(expectedTarget) ? this.consumer.process((Object)reference2) : true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        PsiElement psiElement2;
        ReceiverTypeSearcherInfo receiverTypeSearcherInfo = (ReceiverTypeSearcherInfo)ActionsKt.runReadAction((Function0)((Function0)new Function0<ReceiverTypeSearcherInfo>(this){
            final /* synthetic */ OperatorReferenceSearcher<TReferenceElement> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ReceiverTypeSearcherInfo invoke() {
                return KotlinSearchUsagesSupport.SearchUtils.INSTANCE.getReceiverTypeSearcherInfo(this.this$0.getTargetDeclaration(), this.this$0 instanceof DestructuringDeclarationReferenceSearcher);
            }
        }));
        if (receiverTypeSearcherInfo == null) {
            return;
        }
        ReceiverTypeSearcherInfo receiverTypeSearcherInfo2 = receiverTypeSearcherInfo;
        PsiElement klass2 = receiverTypeSearcherInfo2.component1();
        Function1<KtDeclaration, Boolean> containsTypeOrDerivedInside = receiverTypeSearcherInfo2.component2();
        HashSet inProgress = (HashSet)Companion.SearchesInProgress.INSTANCE.get();
        if (klass2 != null) {
            if (!inProgress.add(klass2)) {
                ExpressionsOfTypeProcessor.Companion this_$iv = ExpressionsOfTypeProcessor.Companion;
                boolean $i$f$testLog = false;
                Collection<String> collection = this_$iv.getTestLog();
                if (collection == null) return;
                Collection<String> collection2 = collection;
                boolean bl = false;
                collection2.add("ExpressionOfTypeProcessor is already started for " + ActionsKt.runReadAction((Function0)((Function0)new Function0<String>(klass2){
                    final /* synthetic */ PsiElement $klass;
                    {
                        this.$klass = $klass;
                        super(0);
                    }

                    public final String invoke() {
                        PsiElement psiElement2 = this.$klass;
                        Object object = psiElement2 instanceof PsiClass ? (PsiClass)psiElement2 : null;
                        if (object == null || (object = object.getQualifiedName()) == null) {
                            PsiElement psiElement3 = this.$klass;
                            PsiNamedElement psiNamedElement = psiElement3 instanceof PsiNamedElement ? (PsiNamedElement)psiElement3 : null;
                            object = psiNamedElement != null ? psiNamedElement.getName() : null;
                            if (object == null) {
                                object = this.$klass.getText();
                            }
                        }
                        return object;
                    }
                })) + ". Exit for operator " + ExpressionsOfTypeProcessor.Companion.logPresentation(this.targetDeclaration) + ".");
                return;
            }
        } else if (!inProgress.add(this.targetDeclaration)) {
            ExpressionsOfTypeProcessor.Companion this_$iv = ExpressionsOfTypeProcessor.Companion;
            boolean $i$f$testLog = false;
            Collection<String> collection = this_$iv.getTestLog();
            if (collection == null) return;
            Collection<String> collection3 = collection;
            boolean bl = false;
            collection3.add("ExpressionOfTypeProcessor is already started for operator " + ExpressionsOfTypeProcessor.Companion.logPresentation(this.targetDeclaration) + ". Exit.");
            return;
        }
        try {
            new ExpressionsOfTypeProcessor(containsTypeOrDerivedInside, klass2, this.searchScope, this.project, (Function1<? super KtExpression, Unit>)((Function1)new Function1<KtExpression, Unit>(this){
                final /* synthetic */ OperatorReferenceSearcher<TReferenceElement> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull KtExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    this.this$0.processPossibleReceiverExpression(expression2);
                }
            }), (Function1<? super SearchScope, Unit>)((Function1)new Function1<SearchScope, Unit>(this){
                final /* synthetic */ OperatorReferenceSearcher<TReferenceElement> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull SearchScope searchScope2) {
                    Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
                    OperatorReferenceSearcher.access$doPlainSearch(this.this$0, searchScope2);
                }
            })).run();
            psiElement2 = klass2;
        }
        catch (Throwable throwable) {
            PsiElement psiElement3 = klass2;
            if (psiElement3 == null) {
                psiElement3 = this.targetDeclaration;
            }
            inProgress.remove(psiElement3);
            throw throwable;
        }
        PsiElement psiElement4 = psiElement2;
        if (psiElement2 == null) {
            psiElement4 = this.targetDeclaration;
        }
        inProgress.remove(psiElement4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doPlainSearch(SearchScope scope2) {
        ExpressionsOfTypeProcessor.Companion this_$iv = ExpressionsOfTypeProcessor.Companion;
        boolean $i$f$testLog = false;
        Collection<String> collection = this_$iv.getTestLog();
        if (collection != null) {
            Collection<String> collection2 = collection;
            int n = 0;
            collection2.add("Used plain search of " + ExpressionsOfTypeProcessor.Companion.logPresentation(this.targetDeclaration) + " in " + this.logPresentation(scope2));
        }
        ProgressIndicator progress = ProgressWrapper.unwrap((ProgressIndicator)ProgressIndicatorProvider.getGlobalProgressIndicator());
        if (scope2 instanceof LocalSearchScope) {
            PsiElement[] psiElementArray = ((LocalSearchScope)scope2).getScope();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getScope(...)");
            for (PsiElement element3 : psiElementArray) {
                if (!(element3 instanceof KtElement)) continue;
                ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(element3, progress, this){
                    final /* synthetic */ PsiElement $element;
                    final /* synthetic */ ProgressIndicator $progress;
                    final /* synthetic */ OperatorReferenceSearcher<TReferenceElement> this$0;
                    {
                        this.$element = $element;
                        this.$progress = $progress;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        if (((KtElement)this.$element).isValid()) {
                            void $this$forEachDescendantOfType$iv$iv$iv$iv;
                            void $this$collectDescendantsOfTypeTo$iv$iv$iv;
                            void $this$collectDescendantsOfType$iv;
                            ProgressIndicator progressIndicator = this.$progress;
                            if (progressIndicator != null) {
                                progressIndicator.checkCanceled();
                            }
                            ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
                            PsiElement psiElement2 = this.$element;
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"$element");
                            Object object = psiElement2;
                            Function1 predicate$iv = (Function1)new Function1<KtElement, Boolean>(this.this$0, refs){
                                final /* synthetic */ OperatorReferenceSearcher<TReferenceElement> this$0;
                                final /* synthetic */ ArrayList<PsiReference> $refs;
                                {
                                    this.this$0 = $receiver;
                                    this.$refs = $refs;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull KtElement it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    PsiReference psiReference = this.this$0.extractReference(it);
                                    if (psiReference == null) {
                                        return false;
                                    }
                                    PsiReference ref = psiReference;
                                    this.$refs.add(ref);
                                    return true;
                                }
                            };
                            boolean $i$f$collectDescendantsOfType = false;
                            void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
                            boolean $i$f$collectDescendantsOfType2 = false;
                            void var8_8 = $this$collectDescendantsOfType$iv$iv;
                            Collection to$iv$iv$iv = new ArrayList<E>();
                            boolean $i$f$collectDescendantsOfTypeTo = false;
                            void var11_11 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
                            Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtElement, Unit>(predicate$iv, to$iv$iv$iv){
                                final /* synthetic */ Function1 $predicate;
                                final /* synthetic */ Collection $to;
                                {
                                    this.$predicate = $predicate;
                                    this.$to = $to;
                                }

                                /*
                                 * Ignored method signature, as it can't be verified against descriptor
                                 */
                                public final void invoke(PsiElement it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                                        this.$to.add(it);
                                    }
                                }
                            };
                            boolean $i$f$forEachDescendantOfType = false;
                            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
                            $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                                final /* synthetic */ Function1 $action;
                                {
                                    this.$action = $action;
                                }

                                public void visitElement(PsiElement element3) {
                                    Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                                    PsiElement it = element3;
                                    boolean bl = false;
                                    super.visitElement(element3);
                                    if (element3 instanceof KtElement) {
                                        this.$action.invoke((Object)element3);
                                    }
                                }
                            });
                            object = (List)to$iv$iv$iv;
                            if (object.isEmpty()) {
                                boolean bl = false;
                                return;
                            }
                            List elements2 = (List)object;
                            PsiFile $this$safeAs$iv = ((KtElement)this.$element).getContainingFile();
                            boolean $i$f$safeAs = false;
                            PsiFile psiFile2 = $this$safeAs$iv;
                            if (!(psiFile2 instanceof KtFile)) {
                                psiFile2 = null;
                            }
                            KtFile ktFile2 = (KtFile)psiFile2;
                            if (ktFile2 != null) {
                                KotlinSearchUsagesSupport.SearchUtils.INSTANCE.forceResolveReferences(ktFile2, elements2);
                            }
                            for (PsiReference ref : refs) {
                                ProgressIndicator progressIndicator2 = this.$progress;
                                if (progressIndicator2 != null) {
                                    progressIndicator2.checkCanceled();
                                }
                                if (!ref.isReferenceTo(this.this$0.getTargetDeclaration())) continue;
                                OperatorReferenceSearcher.access$getConsumer$p(this.this$0).process((Object)ref);
                            }
                        }
                    }
                }));
            }
        } else {
            Intrinsics.checkNotNull((Object)scope2, (String)"null cannot be cast to non-null type com.intellij.psi.search.GlobalSearchScope");
            GlobalSearchScope cfr_ignored_0 = (GlobalSearchScope)scope2;
            if (!((Collection)this.wordsToSearch).isEmpty()) {
                PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)this.targetDeclaration);
                if (psiNamedElement == null) {
                    return;
                }
                PsiNamedElement unwrappedElement = psiNamedElement;
                KotlinRequestResultProcessor resultProcessor2 = new KotlinRequestResultProcessor((PsiElement)unwrappedElement, null, (Function1)new Function1<PsiReference, Boolean>(this){
                    final /* synthetic */ OperatorReferenceSearcher<TReferenceElement> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull PsiReference ref) {
                        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                        return this.this$0.isReferenceToCheck(ref);
                    }
                }, this.options, 2, null);
                Iterable $this$forEach$iv = this.wordsToSearch;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    this.optimizer.searchWord(it, (SearchScope)KotlinScopeUtils.restrictToKotlinSources((GlobalSearchScope)scope2), (short)1, true, (PsiElement)unwrappedElement, (RequestResultProcessor)resultProcessor2);
                }
            } else {
                PsiManager psiManager = PsiManager.getInstance((Project)this.project);
                Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
                PsiManager psiManager2 = psiManager;
                ProgressIndicator progressIndicator = progress;
                if (progressIndicator != null) {
                    progressIndicator.pushState();
                }
                ProgressIndicator progressIndicator2 = progress;
                if (progressIndicator2 != null) {
                    progressIndicator2.setText(KotlinBaseAnalysisBundle.message("searching.for.implicit.usages", new Object[0]));
                }
                ProgressIndicator progressIndicator3 = progress;
                if (progressIndicator3 != null) {
                    progressIndicator3.setIndeterminate(false);
                }
                try {
                    Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<Collection<VirtualFile>>(scope2){
                        final /* synthetic */ SearchScope $scope;
                        {
                            this.$scope = $scope;
                            super(0);
                        }

                        @NotNull
                        public final Collection<VirtualFile> invoke() {
                            return FileTypeIndex.getFiles((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)((GlobalSearchScope)this.$scope));
                        }
                    }));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                    Collection files2 = (Collection)object;
                    Iterator iterator2 = files2.iterator();
                    int n = 0;
                    while (iterator2.hasNext()) {
                        int index = n++;
                        VirtualFile file2 = (VirtualFile)iterator2.next();
                        ProgressIndicator progressIndicator4 = progress;
                        if (progressIndicator4 != null) {
                            progressIndicator4.checkCanceled();
                        }
                        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(file2, progress, index, (Collection<VirtualFile>)files2, psiManager2, this){
                            final /* synthetic */ VirtualFile $file;
                            final /* synthetic */ ProgressIndicator $progress;
                            final /* synthetic */ int $index;
                            final /* synthetic */ Collection<VirtualFile> $files;
                            final /* synthetic */ PsiManager $psiManager;
                            final /* synthetic */ OperatorReferenceSearcher<TReferenceElement> this$0;
                            {
                                this.$file = $file;
                                this.$progress = $progress;
                                this.$index = $index;
                                this.$files = $files;
                                this.$psiManager = $psiManager;
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                block4: {
                                    if (!this.$file.isValid()) break block4;
                                    ProgressIndicator progressIndicator = this.$progress;
                                    if (progressIndicator != null) {
                                        progressIndicator.setFraction((double)this.$index / (double)this.$files.size());
                                    }
                                    ProgressIndicator progressIndicator2 = this.$progress;
                                    if (progressIndicator2 != null) {
                                        progressIndicator2.setText2(this.$file.getPath());
                                    }
                                    PsiFile $this$safeAs$iv = this.$psiManager.findFile(this.$file);
                                    boolean $i$f$safeAs = false;
                                    PsiFile psiFile2 = $this$safeAs$iv;
                                    if (!(psiFile2 instanceof KtFile)) {
                                        psiFile2 = null;
                                    }
                                    KtFile ktFile2 = (KtFile)psiFile2;
                                    if (ktFile2 != null) {
                                        KtFile ktFile3 = ktFile2;
                                        OperatorReferenceSearcher<TReferenceElement> operatorReferenceSearcher = this.this$0;
                                        KtFile it = ktFile3;
                                        boolean bl = false;
                                        OperatorReferenceSearcher.access$doPlainSearch(operatorReferenceSearcher, (SearchScope)new LocalSearchScope((PsiElement)it));
                                    }
                                }
                            }
                        }));
                    }
                }
                finally {
                    ProgressIndicator progressIndicator5 = progress;
                    if (progressIndicator5 != null) {
                        progressIndicator5.popState();
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String logPresentation(SearchScope $this$logPresentation) {
        String string;
        SearchScope searchScope2 = $this$logPresentation;
        if (Intrinsics.areEqual((Object)searchScope2, (Object)this.searchScope)) {
            string = "whole search scope";
        } else if (searchScope2 instanceof LocalSearchScope) {
            void $this$mapTo$iv$iv;
            PsiElement[] psiElementArray = ((LocalSearchScope)$this$logPresentation).getScope();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getScope(...)");
            Object[] $this$map$iv = psiElementArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void element3;
                PsiElement psiElement2 = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add("    " + ActionsKt.runReadAction((Function0)((Function0)new Function0<String>((PsiElement)element3){
                    final /* synthetic */ PsiElement $element;
                    {
                        this.$element = $element;
                        super(0);
                    }

                    public final String invoke() {
                        Object object;
                        PsiElement psiElement2 = this.$element;
                        if (psiElement2 instanceof KtFunctionLiteral) {
                            object = ((KtFunctionLiteral)this.$element).getText();
                        } else if (psiElement2 instanceof KtWhenEntry) {
                            if (((KtWhenEntry)this.$element).isElse()) {
                                object = "KtWhenEntry \"else\"";
                            } else {
                                KtWhenCondition[] ktWhenConditionArray = ((KtWhenEntry)this.$element).getConditions();
                                Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
                                object = "KtWhenEntry \"" + ArraysKt.joinToString$default((Object[])ktWhenConditionArray, (CharSequence)", ", null, null, (int)0, null, (Function1)logPresentation.1.1.INSTANCE, (int)30, null) + "\"";
                            }
                        } else {
                            object = psiElement2 instanceof KtNamedDeclaration ? ((KtNamedDeclaration)this.$element).getNode().getElementType().toString() + ":" + ((KtNamedDeclaration)this.$element).getName() : this.$element.toString();
                        }
                        return object;
                    }
                })));
            }
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)((List)destination$iv$iv))), (CharSequence)"\n", (CharSequence)"LocalSearchScope:\n", null, (int)0, null, null, (int)60, null);
        } else {
            String string2 = $this$logPresentation.getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        }
        return string;
    }

    public static final /* synthetic */ void access$doPlainSearch(OperatorReferenceSearcher $this, SearchScope scope2) {
        $this.doPlainSearch(scope2);
    }

    public static final /* synthetic */ Processor access$getConsumer$p(OperatorReferenceSearcher $this) {
        return $this.consumer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ>\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JF\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher;", "declaration", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "optimizer", "Lcom/intellij/psi/search/SearchRequestCollector;", "options", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;", "createInReadAction", "name", "Lorg/jetbrains/kotlin/name/Name;", "SearchesInProgress", "kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nOperatorReferenceSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorReferenceSearcher.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,347:1\n275#2:348\n*S KotlinDebug\n*F\n+ 1 OperatorReferenceSearcher.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher$Companion\n*L\n88#1:348\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final OperatorReferenceSearcher<?> create(@NotNull PsiElement declaration2, @NotNull SearchScope searchScope2, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchRequestCollector optimizer, @NotNull KotlinReferencesSearchOptions options2) {
            OperatorReferenceSearcher<?> operatorReferenceSearcher;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            Intrinsics.checkNotNullParameter((Object)optimizer, (String)"optimizer");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            boolean $this$ifTrue$iv = declaration2.isValid();
            boolean $i$f$ifTrue = false;
            if ($this$ifTrue$iv) {
                boolean bl = false;
                operatorReferenceSearcher = Companion.createInReadAction(declaration2, searchScope2, consumer, optimizer, options2);
            } else {
                operatorReferenceSearcher = null;
            }
            return operatorReferenceSearcher;
        }

        private final OperatorReferenceSearcher<?> createInReadAction(PsiElement declaration2, SearchScope searchScope2, Processor<? super PsiReference> consumer, SearchRequestCollector optimizer, KotlinReferencesSearchOptions options2) {
            PsiElement psiElement2;
            PsiElement psiElement3 = declaration2;
            String string = psiElement3 instanceof KtNamedFunction ? ((KtNamedFunction)declaration2).getName() : (psiElement3 instanceof PsiMethod ? ((PsiMethod)declaration2).getName() : null);
            if (string == null) {
                return null;
            }
            String functionName = string;
            if (!Name.isValidIdentifier((String)functionName)) {
                return null;
            }
            Name name2 = Name.identifier((String)functionName);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            Name name3 = name2;
            if (declaration2 instanceof KtLightMethod) {
                KtDeclaration ktDeclaration = (KtDeclaration)((KtLightMethod)declaration2).getKotlinOrigin();
                if (ktDeclaration == null) {
                    return null;
                }
                psiElement2 = (PsiElement)ktDeclaration;
            } else {
                psiElement2 = declaration2;
            }
            PsiElement declarationToUse = psiElement2;
            return this.createInReadAction(declarationToUse, name3, consumer, optimizer, options2, searchScope2);
        }

        private final OperatorReferenceSearcher<?> createInReadAction(PsiElement declaration2, Name name2, Processor<? super PsiReference> consumer, SearchRequestCollector optimizer, KotlinReferencesSearchOptions options2, SearchScope searchScope2) {
            OperatorReferenceSearcher operatorReferenceSearcher;
            if (DataClassResolver.INSTANCE.isComponentLike(name2)) {
                if (!options2.getSearchForComponentConventions()) {
                    return null;
                }
                String string = name2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                int componentIndex = DataClassResolver.INSTANCE.getComponentIndex(string);
                return new DestructuringDeclarationReferenceSearcher(declaration2, componentIndex, searchScope2, consumer, optimizer, options2);
            }
            if (!options2.getSearchForOperatorConventions()) {
                return null;
            }
            boolean operator = !(declaration2 instanceof KtElement) || declaration2 instanceof KtNamedFunction && KotlinPsiHeuristics.isPossibleOperator((KtNamedFunction)declaration2);
            KtSingleValueToken binaryOp = (KtSingleValueToken)OperatorConventions.BINARY_OPERATION_NAMES.inverse().get((Object)name2);
            KtSingleValueToken assignmentOp = (KtSingleValueToken)OperatorConventions.ASSIGNMENT_OPERATIONS.inverse().get((Object)name2);
            KtSingleValueToken unaryOp = (KtSingleValueToken)OperatorConventions.UNARY_OPERATION_NAMES.inverse().get((Object)name2);
            if (operator && binaryOp != null) {
                KtSingleValueToken counterpartAssignmentOp = (KtSingleValueToken)OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.inverse().get((Object)binaryOp);
                Object[] objectArray = new KtSingleValueToken[]{binaryOp, counterpartAssignmentOp};
                List operationTokens = CollectionsKt.listOfNotNull((Object[])objectArray);
                operatorReferenceSearcher = new BinaryOperatorReferenceSearcher(declaration2, operationTokens, searchScope2, consumer, optimizer, options2);
            } else if (operator && assignmentOp != null) {
                operatorReferenceSearcher = new BinaryOperatorReferenceSearcher(declaration2, CollectionsKt.listOf((Object)assignmentOp), searchScope2, consumer, optimizer, options2);
            } else if (operator && unaryOp != null) {
                operatorReferenceSearcher = new UnaryOperatorReferenceSearcher(declaration2, unaryOp, searchScope2, consumer, optimizer, options2);
            } else if (operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.INVOKE)) {
                operatorReferenceSearcher = new InvokeOperatorReferenceSearcher(declaration2, searchScope2, consumer, optimizer, options2);
            } else if (operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.GET)) {
                operatorReferenceSearcher = new IndexingOperatorReferenceSearcher(declaration2, searchScope2, consumer, optimizer, options2, false);
            } else if (operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.SET)) {
                operatorReferenceSearcher = new IndexingOperatorReferenceSearcher(declaration2, searchScope2, consumer, optimizer, options2, true);
            } else if (operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.CONTAINS)) {
                operatorReferenceSearcher = new ContainsOperatorReferenceSearcher(declaration2, searchScope2, consumer, optimizer, options2);
            } else if (Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.EQUALS)) {
                Object[] objectArray = new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ};
                operatorReferenceSearcher = new BinaryOperatorReferenceSearcher(declaration2, CollectionsKt.listOf((Object[])objectArray), searchScope2, consumer, optimizer, options2);
            } else if (operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.COMPARE_TO)) {
                Object[] objectArray = new KtSingleValueToken[]{KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ};
                operatorReferenceSearcher = new BinaryOperatorReferenceSearcher(declaration2, CollectionsKt.listOf((Object[])objectArray), searchScope2, consumer, optimizer, options2);
            } else {
                operatorReferenceSearcher = operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.ITERATOR) ? (OperatorReferenceSearcher)new IteratorOperatorReferenceSearcher(declaration2, searchScope2, consumer, optimizer, options2) : (operator && (Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.GET_VALUE) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.SET_VALUE) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.PROVIDE_DELEGATE)) ? (OperatorReferenceSearcher)new PropertyDelegationOperatorReferenceSearcher(declaration2, searchScope2, consumer, optimizer, options2) : null);
            }
            return operatorReferenceSearcher;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher$Companion$SearchesInProgress;", "Ljava/lang/ThreadLocal;", "Ljava/util/HashSet;", "Lcom/intellij/psi/PsiElement;", "()V", "initialValue", "kotlin.base.analysis"})
        private static final class SearchesInProgress
        extends ThreadLocal<HashSet<PsiElement>> {
            @NotNull
            public static final SearchesInProgress INSTANCE = new SearchesInProgress();

            private SearchesInProgress() {
            }

            @Override
            @NotNull
            protected HashSet<PsiElement> initialValue() {
                return new HashSet<PsiElement>();
            }
        }
    }
}

