/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightParameter;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.conflicts.KotlinMembersNameConflictsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.CommonRenameUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.KtResolvableCollisionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J4\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J5\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0004H\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinParameterProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findCollisions", "", "newName", "", "allRenames", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "isToSearchInComments", "psiElement", "prepareRenaming", "scope", "renameElement", "usages", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "setToSearchInComments", "enabled", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nRenameKotlinParameterProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameKotlinParameterProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinParameterProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,79:1\n13309#2,2:80\n*S KotlinDebug\n*F\n+ 1 RenameKotlinParameterProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinParameterProcessor\n*L\n71#1:80,2\n*E\n"})
public final class RenameKotlinParameterProcessor
extends RenameKotlinPsiProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtParameter && (((KtParameter)element3).getOwnerFunction() instanceof KtFunction || ((KtParameter)element3).getOwnerFunction() instanceof KtPropertyAccessor) ? true : element3 instanceof KtLightParameter;
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement2) {
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        return KotlinCommonRefactoringSettings.Companion.getInstance().getRENAME_SEARCH_IN_COMMENTS_FOR_PARAMETER();
    }

    public void setToSearchInComments(@NotNull PsiElement element3, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KotlinCommonRefactoringSettings.Companion.getInstance().setRENAME_SEARCH_IN_COMMENTS_FOR_PARAMETER(enabled2);
    }

    public void findCollisions(@NotNull PsiElement element3, @NotNull String newName2, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)element3);
        KtNamedDeclaration ktNamedDeclaration = psiNamedElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiNamedElement : null;
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        SmartList collisions = new SmartList();
        KotlinMembersNameConflictsKt.checkRedeclarationConflicts(declaration2, newName2, (List)collisions);
        this.getRenameRefactoringSupport().checkUsagesRetargeting(declaration2, newName2, result2, (List)collisions);
        CollectionsKt.addAll((Collection)result2, (Iterable)((Iterable)collisions));
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element3, @NotNull SearchScope searchScope2, boolean searchInCommentsAndStrings) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)element3);
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement kotlinElement = psiElement2;
        SearchScope correctScope = kotlinElement instanceof KtParameter ? KotlinScopeUtils.or(searchScope2, CommonRenameUtilsKt.getUseScopeForRename((KtParameter)kotlinElement)) : searchScope2;
        return super.findReferences(element3, correctScope, searchInCommentsAndStrings);
    }

    @Override
    public void renameElement(@NotNull PsiElement element3, @NotNull String newName2, @NotNull UsageInfo[] usages2, @Nullable RefactoringElementListener listener2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        super.renameElement(element3, newName2, usages2, listener2);
        UsageInfo[] $this$forEach$iv = usages2;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            UsageInfo element$iv;
            UsageInfo it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            KtResolvableCollisionUsageInfo ktResolvableCollisionUsageInfo = it instanceof KtResolvableCollisionUsageInfo ? (KtResolvableCollisionUsageInfo)it : null;
            if (ktResolvableCollisionUsageInfo == null) continue;
            ktResolvableCollisionUsageInfo.apply();
        }
    }

    @Override
    public void prepareRenaming(@NotNull PsiElement element3, @NotNull String newName2, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        super.prepareRenaming(element3, newName2, allRenames, scope2);
        this.getRenameRefactoringSupport().prepareForeignUsagesRenaming(element3, newName2, allRenames, scope2);
    }
}

