/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameJavaMethodProcessor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.conflicts.KotlinMembersNameConflictsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.CommonRenameUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameRefactoringSupport;
import org.jetbrains.kotlin.idea.refactoring.rename.KtResolvableCollisionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.LostDefaultValuesInOverridingFunctionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinFunctionProcessor;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.search.ExpectActualUtils;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J<\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\bH\u0016JA\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\b2\u000b\u0010%\u001a\u00070\u0013\u00a2\u0006\u0002\b&2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130)H\u0002J4\u0010*\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130)2\u0006\u0010+\u001a\u00020\u001dH\u0016J$\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J5\u0010.\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0018002\b\u00101\u001a\u0004\u0018\u000102H\u0016\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00105\u001a\u00020\u0006H\u0016J\u0018\u00106\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00105\u001a\u00020\u0006H\u0016J(\u00107\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u00108\u001a\n\u0012\u0006\b\u0000\u0012\u00020\b09H\u0016J\u001c\u00107\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010:\u001a\u0004\u0018\u00010;2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinFunctionProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "()V", "javaMethodProcessorInstance", "Lcom/intellij/refactoring/rename/RenameJavaMethodProcessor;", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "createRenameDialog", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "nameSuggestionContext", "editor", "Lcom/intellij/openapi/editor/Editor;", "findCollisions", "", "newName", "", "allRenames", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "getJvmName", "isToSearchForTextOccurrences", "isToSearchInComments", "psiElement", "prepareOverrideRenaming", "declaration", "baseName", "Lcom/intellij/openapi/util/NlsSafe;", "newBaseName", "safeNewName", "", "prepareRenaming", "scope", "processFoundReferences", "allReferences", "renameElement", "usages", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "setToSearchForTextOccurrences", "enabled", "setToSearchInComments", "substituteElementToRename", "renameCallback", "Lcom/intellij/openapi/util/Pass;", "substituteForExpectOrActual", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "FunctionWithSupersWrapper", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nRenameKotlinFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameKotlinFunctionProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinFunctionProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 commonRenameUtils.kt\norg/jetbrains/kotlin/idea/refactoring/rename/CommonRenameUtilsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,295:1\n800#2,11:296\n819#2:307\n847#2,2:308\n1855#2,2:327\n1360#2:329\n1446#2,5:330\n1#3:310\n56#4,6:311\n56#4,6:317\n37#5,2:323\n13309#6,2:325\n*S KotlinDebug\n*F\n+ 1 RenameKotlinFunctionProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinFunctionProcessor\n*L\n66#1:296,11\n67#1:307\n67#1:308,2\n226#1:327,2\n230#1:329\n230#1:330,5\n102#1:311,6\n151#1:317,6\n275#1:323,2\n277#1:325,2\n*E\n"})
public final class RenameKotlinFunctionProcessor
extends RenameKotlinPsiProcessor {
    @NotNull
    private final RenameJavaMethodProcessor javaMethodProcessorInstance = new RenameJavaMethodProcessor();

    @Override
    public boolean canProcessElement(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtNamedFunction || element3 instanceof KtLightMethod && ((KtLightMethod)element3).getKotlinOrigin() instanceof KtNamedFunction || element3 instanceof FunctionWithSupersWrapper;
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement2) {
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        return KotlinCommonRefactoringSettings.Companion.getInstance().getRENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION();
    }

    public void setToSearchInComments(@NotNull PsiElement element3, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KotlinCommonRefactoringSettings.Companion.getInstance().setRENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION(enabled2);
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinCommonRefactoringSettings.Companion.getInstance().getRENAME_SEARCH_FOR_TEXT_FOR_FUNCTION();
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element3, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KotlinCommonRefactoringSettings.Companion.getInstance().setRENAME_SEARCH_FOR_TEXT_FOR_FUNCTION(enabled2);
    }

    private final String getJvmName(PsiElement element3) {
        return this.getRenameRefactoringSupport().getJvmName(element3);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PsiReference> processFoundReferences(PsiElement element3, Collection<? extends PsiReference> allReferences) {
        Collection collection;
        if (this.getJvmName(element3) == null) {
            collection = allReferences;
        } else if (element3 instanceof KtElement) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = allReferences;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtReference)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else if (element3 instanceof KtLightElement) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = allReferences;
            boolean $i$f$filterNot = false;
            Iterable $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                PsiReference it = (PsiReference)element$iv$iv;
                boolean bl = false;
                if (it instanceof KtReference) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    public void findCollisions(@NotNull PsiElement element3, @NotNull String newName2, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Object object = LightClassUtilsKt.getUnwrapped((PsiElement)element3);
        KtNamedFunction ktNamedFunction = object instanceof KtNamedFunction ? (KtNamedFunction)object : null;
        if (ktNamedFunction == null) {
            return;
        }
        KtNamedFunction declaration2 = ktNamedFunction;
        CommonRenameUtilsKt.checkConflictsAndReplaceUsageInfos(element3, allRenames, result2);
        Collection collection = result2;
        PsiElement collisions = object = new SmartList();
        boolean bl = false;
        KotlinMembersNameConflictsKt.checkRedeclarationConflicts((KtNamedDeclaration)declaration2, newName2, (List)collisions);
        this.getRenameRefactoringSupport().checkUsagesRetargeting((KtNamedDeclaration)declaration2, newName2, result2, (List)collisions);
        object = (Iterable)object;
        CollectionsKt.addAll((Collection)collection, (Iterable)object);
    }

    private final KtDeclaration substituteForExpectOrActual(PsiElement element3) {
        KtDeclaration ktDeclaration;
        PsiElement psiElement2 = element3;
        PsiNamedElement psiNamedElement = psiElement2 != null ? LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)psiElement2) : null;
        KtNamedDeclaration ktNamedDeclaration = psiNamedElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiNamedElement : null;
        if (ktNamedDeclaration != null) {
            KtNamedDeclaration el = ktNamedDeclaration;
            boolean bl = false;
            Project project2 = el.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            ktDeclaration = (KtDeclaration)ActionUtil.underModalProgress((Project)project2, (String)KotlinBundle.message((String)"progress.title.searching.for.expected.actual", (Object[])new Object[0]), () -> RenameKotlinFunctionProcessor.substituteForExpectOrActual$lambda$3$lambda$2(el));
        } else {
            ktDeclaration = null;
        }
        return ktDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element3, @Nullable Editor editor2) {
        boolean bl;
        PsiElement substitutedJavaElement;
        void project$iv;
        void canBeCancelled$iv;
        void progressTitle$iv;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtDeclaration ktDeclaration = this.substituteForExpectOrActual(element3);
        if (ktDeclaration != null) {
            KtDeclaration it = ktDeclaration;
            boolean bl2 = false;
            return (PsiElement)it;
        }
        String string = KotlinBundle.message((String)"rename.searching.for.super.declaration", (Object[])new Object[0]);
        boolean it = true;
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project bl2 = project2;
        boolean $i$f$runProcessWithProgressSynchronously2 = false;
        List deepestSuperMethods2 = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(element3){
            final /* synthetic */ PsiElement $element$inlined;
            {
                this.$element$inlined = psiElement2;
            }

            public final T compute() {
                boolean bl = false;
                return (T)((List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends PsiElement>>(this.$element$inlined){
                    final /* synthetic */ PsiElement $element;
                    {
                        this.$element = $element;
                        super(0);
                    }

                    @NotNull
                    public final List<PsiElement> invoke() {
                        return KotlinSearchUsagesSupport.SearchUtils.INSTANCE.findDeepestSuperMethodsNoWrapping(this.$element);
                    }
                })));
            }
        }, (String)progressTitle$iv, (boolean)canBeCancelled$iv, (Project)project$iv);
        if (deepestSuperMethods2.isEmpty()) {
            return element3;
        }
        if (element3 instanceof PsiMethod) {
            v1 = this.javaMethodProcessorInstance.substituteElementToRename(element3, editor2);
        } else {
            PsiElement $i$f$runProcessWithProgressSynchronously2 = LightClassUtilsKt.getUnwrapped((PsiElement)element3);
            KtNamedFunction ktNamedFunction = $i$f$runProcessWithProgressSynchronously2 instanceof KtNamedFunction ? (KtNamedFunction)$i$f$runProcessWithProgressSynchronously2 : null;
            if (ktNamedFunction == null) {
                return element3;
            }
            KtNamedFunction declaration2 = ktNamedFunction;
            List<PsiElement> chosenElements = CommonRenameUtilsKt.checkSuperMethods((KtNamedDeclaration)declaration2, deepestSuperMethods2);
            if (chosenElements.size() > 1) {
                v1 = (PsiElement)new FunctionWithSupersWrapper(declaration2, chosenElements);
            } else {
                v1 = (PsiElement)CollectionsKt.firstOrNull(chosenElements);
                if (v1 == null) {
                    v1 = substitutedJavaElement = element3;
                }
            }
        }
        if (substitutedJavaElement instanceof KtLightMethod && element3 instanceof KtDeclaration) {
            KtElement declaration2 = ((KtLightMethod)substitutedJavaElement).getKotlinOrigin();
            return (PsiElement)(declaration2 instanceof KtNamedFunction ? (KtNamedFunction)declaration2 : null);
        }
        try {
            bl = PsiElementRenameHandler.canRename((Project)element3.getProject(), (Editor)editor2, (PsiElement)substitutedJavaElement);
        }
        catch (CommonRefactoringUtil.RefactoringErrorHintException refactoringErrorHintException) {
            bl = false;
        }
        boolean canRename = bl;
        return canRename ? substitutedJavaElement : element3;
    }

    /*
     * WARNING - void declaration
     */
    public void substituteElementToRename(@NotNull PsiElement element3, @NotNull Editor editor2, @NotNull Pass<? super PsiElement> renameCallback) {
        void project$iv;
        void canBeCancelled$iv;
        void progressTitle$iv;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(renameCallback, (String)"renameCallback");
        if (!PsiElementRenameHandler.canRename((Project)element3.getProject(), (Editor)editor2, (PsiElement)element3)) {
            return;
        }
        KtDeclaration ktDeclaration = this.substituteForExpectOrActual(element3);
        if (ktDeclaration != null) {
            KtDeclaration it = ktDeclaration;
            boolean bl = false;
            RenameKotlinFunctionProcessor.substituteElementToRename$preprocessAndPass(element3, renameCallback, (PsiElement)it);
            return;
        }
        String string = KotlinBundle.message((String)"rename.searching.for.super.declaration", (Object[])new Object[0]);
        boolean it = true;
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project bl = project2;
        boolean $i$f$runProcessWithProgressSynchronously = false;
        List deepestSuperMethods2 = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(element3){
            final /* synthetic */ PsiElement $element$inlined;
            {
                this.$element$inlined = psiElement2;
            }

            public final T compute() {
                boolean bl = false;
                return (T)((List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends PsiElement>>(this.$element$inlined){
                    final /* synthetic */ PsiElement $element;
                    {
                        this.$element = $element;
                        super(0);
                    }

                    @NotNull
                    public final List<PsiElement> invoke() {
                        return KotlinSearchUsagesSupport.SearchUtils.INSTANCE.findDeepestSuperMethodsNoWrapping(this.$element);
                    }
                })));
            }
        }, (String)progressTitle$iv, (boolean)canBeCancelled$iv, (Project)project$iv);
        if (deepestSuperMethods2.isEmpty()) {
            RenameKotlinFunctionProcessor.substituteElementToRename$preprocessAndPass(element3, renameCallback, element3);
        } else if (element3 instanceof PsiMethod) {
            this.javaMethodProcessorInstance.substituteElementToRename(element3, editor2, Pass.create(arg_0 -> RenameKotlinFunctionProcessor.substituteElementToRename$lambda$8((Function1)new Function1<PsiElement, Unit>(element3, renameCallback){
                final /* synthetic */ PsiElement $element;
                final /* synthetic */ Pass<? super PsiElement> $renameCallback;
                {
                    this.$element = $element;
                    this.$renameCallback = $renameCallback;
                    super(1, Intrinsics.Kotlin.class, "preprocessAndPass", "substituteElementToRename$preprocessAndPass(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/Pass;Lcom/intellij/psi/PsiElement;)V", 0);
                }

                public final void invoke(@NotNull PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    RenameKotlinFunctionProcessor.access$substituteElementToRename$preprocessAndPass(this.$element, this.$renameCallback, p0);
                }
            }, arg_0)));
        } else {
            KtNamedFunction ktNamedFunction = element3 instanceof KtNamedFunction ? (KtNamedFunction)element3 : null;
            if (ktNamedFunction == null) {
                return;
            }
            KtNamedFunction declaration2 = ktNamedFunction;
            CommonRenameUtilsKt.checkSuperMethodsWithPopup((KtNamedDeclaration)declaration2, CollectionsKt.toList((Iterable)deepestSuperMethods2), editor2, (Function1<? super List<? extends PsiElement>, Unit>)((Function1)new Function1<List<? extends PsiElement>, Unit>(declaration2, element3, renameCallback){
                final /* synthetic */ KtNamedFunction $declaration;
                final /* synthetic */ PsiElement $element;
                final /* synthetic */ Pass<? super PsiElement> $renameCallback;
                {
                    this.$declaration = $declaration;
                    this.$element = $element;
                    this.$renameCallback = $renameCallback;
                    super(1);
                }

                public final void invoke(@NotNull List<? extends PsiElement> chosenElements) {
                    PsiElement psiElement2;
                    Intrinsics.checkNotNullParameter(chosenElements, (String)"chosenElements");
                    if (chosenElements.size() > 1) {
                        psiElement2 = (PsiElement)new FunctionWithSupersWrapper(this.$declaration, chosenElements);
                    } else {
                        psiElement2 = (PsiElement)CollectionsKt.firstOrNull(chosenElements);
                        if (psiElement2 == null) {
                            psiElement2 = this.$element;
                        }
                    }
                    RenameKotlinFunctionProcessor.access$substituteElementToRename$preprocessAndPass(this.$element, this.$renameCallback, psiElement2);
                }
            }));
        }
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project2, @NotNull PsiElement element3, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        FunctionWithSupersWrapper functionWithSupersWrapper = element3 instanceof FunctionWithSupersWrapper ? (FunctionWithSupersWrapper)element3 : null;
        PsiElement elementForDialog = functionWithSupersWrapper != null && (functionWithSupersWrapper = functionWithSupersWrapper.getOriginalDeclaration()) != null ? (PsiElement)functionWithSupersWrapper : element3;
        return new RenameDialog(project2, elementForDialog, nameSuggestionContext, editor2, element3){
            final /* synthetic */ PsiElement $element;
            {
                this.$element = $element;
                super($project, $elementForDialog, $nameSuggestionContext, $editor);
            }

            @NotNull
            protected RenameProcessor createRenameProcessor(@NotNull String newName2) {
                Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
                return new RenameProcessor(this.getProject(), this.$element, newName2, this.isSearchInComments(), this.isSearchInNonJavaFiles());
            }
        };
    }

    @Override
    public void prepareRenaming(@NotNull PsiElement element3, @NotNull String newName2, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope2) {
        KtNamedFunction namedFunction;
        Object object;
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (element3 instanceof KtLightMethod && this.getJvmName(element3) == null) {
            psiElement2 = ((KtLightMethod)element3).getKotlinOrigin();
            KtNamedFunction ktNamedFunction = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
            if (ktNamedFunction != null) {
                KtNamedFunction it = ktNamedFunction;
                boolean bl = false;
                allRenames.put((PsiElement)it, newName2);
            }
        }
        if (element3 instanceof FunctionWithSupersWrapper) {
            allRenames.remove(element3);
        }
        if ((object = (namedFunction = (psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)element3)) instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null)) == null || (object = object.getName()) == null) {
            return;
        }
        Object originalName = object;
        String safeNewName = KtPsiUtilKt.quoteIfNeeded((String)newName2);
        Object object2 = element3 instanceof FunctionWithSupersWrapper ? (FunctionWithSupersWrapper)element3 : null;
        if (object2 == null || (object2 = ((FunctionWithSupersWrapper)object2).getSupers()) == null) {
            object2 = CollectionsKt.listOf((Object)element3);
        }
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            String string;
            Object baseName;
            PsiElement declaration2 = (PsiElement)iterator2.next();
            Object object3 = declaration2 instanceof PsiNamedElement ? (PsiNamedElement)declaration2 : null;
            if (object3 == null || (object3 = object3.getName()) == null) {
                object3 = baseName = originalName;
            }
            if (Intrinsics.areEqual((Object)this.getRenameRefactoringSupport().demangleInternalName((String)baseName), (Object)originalName)) {
                KotlinRenameRefactoringSupport kotlinRenameRefactoringSupport = this.getRenameRefactoringSupport();
                String string2 = this.getRenameRefactoringSupport().getModuleNameSuffixForMangledName((String)baseName);
                Intrinsics.checkNotNull((Object)string2);
                string = kotlinRenameRefactoringSupport.mangleInternalName(newName2, string2);
            } else {
                string = newName2;
            }
            String newBaseName = string;
            this.prepareOverrideRenaming(declaration2, (String)baseName, KtPsiUtilKt.quoteIfNeeded((String)newBaseName), safeNewName, allRenames);
        }
        this.getRenameRefactoringSupport().prepareForeignUsagesRenaming(element3, newName2, allRenames, scope2);
    }

    private final void prepareOverrideRenaming(PsiElement declaration2, String baseName, String newBaseName, String safeNewName, Map<PsiElement, String> allRenames) {
        Project project2 = declaration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project3);
        Intrinsics.checkNotNullExpressionValue((Object)psiSearchHelper, (String)"getInstance(...)");
        PsiSearchHelper searchHelper = psiSearchHelper;
        List overriders = (List)ActionUtil.underModalProgress((Project)project3, (String)KotlinBundle.message((String)"rename.searching.for.all.overrides", (Object[])new Object[0]), () -> RenameKotlinFunctionProcessor.prepareOverrideRenaming$lambda$12(declaration2, allRenames, safeNewName, this, searchHelper));
        for (PsiElement originalOverrider : overriders) {
            PsiMirrorElement psiMirrorElement = originalOverrider instanceof PsiMirrorElement ? (PsiMirrorElement)originalOverrider : null;
            PsiElement psiElement2 = psiMirrorElement != null ? psiMirrorElement.getPrototype() : null;
            PsiMethod psiMethod2 = psiElement2 instanceof PsiMethod ? (PsiMethod)psiElement2 : null;
            PsiElement overrider = psiMethod2 != null ? (PsiElement)psiMethod2 : originalOverrider;
            if (overrider instanceof SyntheticElement) continue;
            Intrinsics.checkNotNull((Object)overrider, (String)"null cannot be cast to non-null type com.intellij.psi.PsiNamedElement");
            String overriderName = ((PsiNamedElement)overrider).getName();
            String newOverriderName = RefactoringUtil.suggestNewOverriderName((String)overriderName, (String)baseName, (String)newBaseName);
            if (newOverriderName == null) continue;
            RenameUtil.assertNonCompileElement((PsiElement)overrider);
            allRenames.put(overrider, newOverriderName);
        }
    }

    @Override
    public void renameElement(@NotNull PsiElement element3, @NotNull String newName2, @NotNull UsageInfo[] usages2, @Nullable RefactoringElementListener listener2) {
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
            PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)element3);
            KtNamedFunction ktNamedFunction = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
            if (ktNamedFunction != null) {
                KtNamedFunction it = ktNamedFunction;
                boolean bl2 = false;
                bl = this.getRenameRefactoringSupport().overridesNothing((KtCallableDeclaration)it);
            } else {
                bl = false;
            }
            boolean wasRequiredOverride = !bl;
            ArrayList<UsageInfo> simpleUsages = new ArrayList<UsageInfo>(usages2.length);
            SmartList ambiguousImportUsages = new SmartList();
            SmartList simpleImportUsages = new SmartList();
            this.getRenameRefactoringSupport().processForeignUsages(element3, newName2, usages2, (Function1<? super UsageInfo, Unit>)((Function1)new Function1<UsageInfo, Unit>(this, (SmartList<UsageInfo>)ambiguousImportUsages, (SmartList<UsageInfo>)simpleImportUsages, element3, newName2, simpleUsages){
                final /* synthetic */ RenameKotlinFunctionProcessor this$0;
                final /* synthetic */ SmartList<UsageInfo> $ambiguousImportUsages;
                final /* synthetic */ SmartList<UsageInfo> $simpleImportUsages;
                final /* synthetic */ PsiElement $element;
                final /* synthetic */ String $newName;
                final /* synthetic */ ArrayList<UsageInfo> $simpleUsages;
                {
                    this.this$0 = $receiver;
                    this.$ambiguousImportUsages = $ambiguousImportUsages;
                    this.$simpleImportUsages = $simpleImportUsages;
                    this.$element = $element;
                    this.$newName = $newName;
                    this.$simpleUsages = $simpleUsages;
                    super(1);
                }

                public final void invoke(@NotNull UsageInfo usage) {
                    Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
                    if (usage instanceof LostDefaultValuesInOverridingFunctionUsageInfo) {
                        ((LostDefaultValuesInOverridingFunctionUsageInfo)usage).apply();
                        return;
                    }
                    switch (renameElement.WhenMappings.$EnumSwitchMapping$0[this.this$0.importState(usage).ordinal()]) {
                        case 1: {
                            ((Collection)this.$ambiguousImportUsages).add(usage);
                            break;
                        }
                        case 2: {
                            ((Collection)this.$simpleImportUsages).add(usage);
                            break;
                        }
                        case 3: {
                            if (this.this$0.renameMangledUsageIfPossible(usage, this.$element, this.$newName)) break;
                            ((Collection)this.$simpleUsages).add(usage);
                        }
                    }
                }
            }));
            this.setAmbiguousImportUsages(element3, (List)ambiguousImportUsages);
            List usagesToRename = simpleImportUsages.isEmpty() ? (List)simpleUsages : CollectionsKt.plus((Collection)((Collection)simpleImportUsages), (Iterable)simpleUsages);
            Collection $this$toTypedArray$iv = usagesToRename;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv;
            this.renamePossiblyLightElement(element3, newName2, thisCollection$iv2.toArray(new UsageInfo[0]), listener2);
            UsageInfo[] $this$forEach$iv = usages2;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int thisCollection$iv2 = 0; thisCollection$iv2 < n; ++thisCollection$iv2) {
                UsageInfo element$iv;
                UsageInfo it = element$iv = $this$forEach$iv[thisCollection$iv2];
                boolean bl3 = false;
                KtResolvableCollisionUsageInfo ktResolvableCollisionUsageInfo = it instanceof KtResolvableCollisionUsageInfo ? (KtResolvableCollisionUsageInfo)it : null;
                if (ktResolvableCollisionUsageInfo == null) continue;
                ktResolvableCollisionUsageInfo.apply();
            }
            if (!wasRequiredOverride) break block4;
            PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped((PsiElement)element3);
            KtNamedDeclaration ktNamedDeclaration = psiElement3 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement3 : null;
            if (ktNamedDeclaration != null) {
                KtNamedDeclaration it = ktNamedDeclaration;
                boolean bl4 = false;
                this.getRenameRefactoringSupport().dropOverrideKeywordIfNecessary(it);
            }
        }
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element3, @NotNull SearchScope searchScope2, boolean searchInCommentsAndStrings) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        Collection<PsiReference> references2 = super.findReferences(element3, searchScope2, searchInCommentsAndStrings);
        return this.processFoundReferences(element3, references2);
    }

    private static final KtDeclaration substituteForExpectOrActual$lambda$3$lambda$2(KtNamedDeclaration $el) {
        Intrinsics.checkNotNullParameter((Object)$el, (String)"$el");
        return ExpectActualUtils.INSTANCE.liftToExpected((KtDeclaration)$el);
    }

    private static final void substituteElementToRename$preprocessAndPass(PsiElement $element, Pass<? super PsiElement> $renameCallback, PsiElement substitutedJavaElement) {
        KtElement ktElement;
        PsiElement elementToProcess2 = substitutedJavaElement instanceof KtLightMethod && $element instanceof KtDeclaration ? (PsiElement)((ktElement = ((KtLightMethod)substitutedJavaElement).getKotlinOrigin()) instanceof KtNamedFunction ? (KtNamedFunction)ktElement : null) : substitutedJavaElement;
        $renameCallback.accept((Object)elementToProcess2);
    }

    private static final void substituteElementToRename$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List prepareOverrideRenaming$lambda$12(PsiElement $declaration, Map $allRenames, String $safeNewName, RenameKotlinFunctionProcessor this$0, PsiSearchHelper $searchHelper) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$declaration, (String)"$declaration");
        Intrinsics.checkNotNullParameter((Object)$allRenames, (String)"$allRenames");
        Intrinsics.checkNotNullParameter((Object)$safeNewName, (String)"$safeNewName");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$searchHelper, (String)"$searchHelper");
        List<KtDeclaration> multiplatformDeclarations = $declaration instanceof KtNamedDeclaration ? ExpectActualUtils.INSTANCE.withExpectedActuals((KtDeclaration)$declaration) : CollectionsKt.listOf((Object)$declaration);
        Iterable $this$forEach$iv = multiplatformDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            $allRenames.put(it, $safeNewName);
        }
        Iterable $this$flatMap$iv = multiplatformDeclarations;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiElement d = (PsiElement)element$iv$iv;
            boolean bl = false;
            KotlinRenameRefactoringSupport kotlinRenameRefactoringSupport = this$0.getRenameRefactoringSupport();
            SearchScope searchScope2 = $searchHelper.getUseScope(d);
            Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"getUseScope(...)");
            Iterable list$iv$iv = kotlinRenameRefactoringSupport.findAllOverridingMethods(d, searchScope2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ void access$substituteElementToRename$preprocessAndPass(PsiElement $element, Pass $renameCallback, PsiElement substitutedJavaElement) {
        RenameKotlinFunctionProcessor.substituteElementToRename$preprocessAndPass($element, (Pass<? super PsiElement>)$renameCallback, substitutedJavaElement);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\r\b\u0001\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0096\u0001J\u0018\u0010\u0014\u001a\u00020\u00102\r\b\u0001\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0096\u0001J \u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\r\b\u0001\u0010\u0011\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0013H\u0096\u0001J1\u0010\u0017\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\r\b\u0001\u0010\u0011\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00132\u000f\b\u0001\u0010\u0018\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0019H\u0096\u0001J1\u0010\u001a\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\r\b\u0001\u0010\u0011\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00132\u000f\b\u0001\u0010\u0018\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0019H\u0096\u0001J1\u0010\u001b\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u0011\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u0018\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001JA\u0010\u001c\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u0011\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u0018\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u001d\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001J?\u0010\u001e\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\r\b\u0001\u0010\u0011\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00132\r\b\u0001\u0010\u0018\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00132\u000e\u0010\u001d\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001J\u0018\u0010\u001f\u001a\u00020\u00102\r\b\u0001\u0010\u0011\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0013H\u0097\u0001J\t\u0010 \u001a\u00020\u0010H\u0097\u0001J\u0011\u0010!\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001J\t\u0010\"\u001a\u00020\u0010H\u0096\u0001J)\u0010#\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u0018\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001J\u0018\u0010$\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u00192\u0006\u0010\u0011\u001a\u00020%H\u0097\u0001J\u0018\u0010&\u001a\t\u0018\u00010'\u00a2\u0006\u0002\b\u00192\u0006\u0010\u0011\u001a\u00020%H\u0097\u0001J6\u0010(\u001a*\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u0013 \u0016*\u0014\u0012\u000b\b\u0001\u0012\u00070\u0007\u00a2\u0006\u0002\b\u00130)\u00a2\u0006\u0002\b\u00130)\u00a2\u0006\u0002\b\u0013H\u0097\u0001\u00a2\u0006\u0002\u0010*J\u0011\u0010+\u001a\n \u0016*\u0004\u0018\u00010,0,H\u0097\u0001J\u0010\u0010-\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0019H\u0097\u0001JD\u0010.\u001a\t\u0018\u0001H/\u00a2\u0006\u0002\b\u0019\"\u0010\b\u0000\u0010/*\n \u0016*\u0004\u0018\u000100002\u001b\b\u0001\u0010\u0011\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u0001H/H/01\u00a2\u0006\u0002\b\u0013H\u0097\u0001\u00a2\u0006\u0002\u00102J\u0011\u00103\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001J\u001b\u00104\u001a\n \u0016*\u0004\u0018\u000105052\b\b\u0001\u0010\u0011\u001a\u00020%H\u0096\u0001J\u000e\u00106\u001a\u000707\u00a2\u0006\u0002\b\u0013H\u0097\u0001J\u0011\u00108\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001J\u0011\u00109\u001a\n \u0016*\u0004\u0018\u00010:0:H\u0097\u0001J\u0015\u0010;\u001a\u000e\u0018\u00010<\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b=H\u0097\u0001J\u0011\u0010>\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001J\u0011\u0010?\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001J\u0011\u0010@\u001a\n \u0016*\u0004\u0018\u00010A0AH\u0097\u0001J\u0011\u0010B\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001J\u0011\u0010C\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001J\u0011\u0010D\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001J\u000e\u0010E\u001a\u00070F\u00a2\u0006\u0002\b\u0013H\u0097\u0001J\u0010\u0010G\u001a\t\u0018\u00010'\u00a2\u0006\u0002\b\u0019H\u0097\u0001J<\u0010H\u001a0\u0012\f\u0012\n \u0016*\u0004\u0018\u00010'0' \u0016*\u0017\u0012\u000e\b\u0001\u0012\n \u0016*\u0004\u0018\u00010'0'0)\u00a2\u0006\u0002\b\u00130)\u00a2\u0006\u0002\b\u0013H\u0097\u0001\u00a2\u0006\u0002\u0010IJ\u000e\u0010J\u001a\u00070K\u00a2\u0006\u0002\b\u0013H\u0097\u0001J\t\u0010L\u001a\u00020%H\u0097\u0001J\u001b\u0010M\u001a\u0014 \u0016*\t\u0018\u00010<\u00a2\u0006\u0002\b=0<\u00a2\u0006\u0002\b=H\u0097\u0001J\t\u0010N\u001a\u00020%H\u0097\u0001J\t\u0010O\u001a\u00020%H\u0097\u0001J\u0011\u0010P\u001a\n \u0016*\u0004\u0018\u00010Q0QH\u0097\u0001J\u000e\u0010R\u001a\u00070S\u00a2\u0006\u0002\b\u0013H\u0097\u0001JD\u0010T\u001a\t\u0018\u0001H/\u00a2\u0006\u0002\b\u0019\"\u0010\b\u0000\u0010/*\n \u0016*\u0004\u0018\u000100002\u001b\b\u0001\u0010\u0011\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u0001H/H/01\u00a2\u0006\u0002\b\u0013H\u0097\u0001\u00a2\u0006\u0002\u00102J\u0019\u0010U\u001a\u00020V2\u000e\u0010\u0011\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001J\t\u0010W\u001a\u00020VH\u0097\u0001J\t\u0010X\u001a\u00020VH\u0097\u0001J\t\u0010Y\u001a\u00020VH\u0097\u0001JG\u0010Z\u001a\u00020V2\r\b\u0001\u0010\u0011\u001a\u00070[\u00a2\u0006\u0002\b\u00132\r\b\u0001\u0010\u0018\u001a\u00070\\\u00a2\u0006\u0002\b\u00132\u000f\b\u0001\u0010\u001d\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u00192\r\b\u0001\u0010]\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0013H\u0096\u0001JN\u0010^\u001a\u00020\u0010\"\u0010\b\u0000\u0010/*\n \u0016*\u0004\u0018\u000100002\u001b\b\u0001\u0010\u0011\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u0001H/H/01\u00a2\u0006\u0002\b\u00132\u000f\b\u0001\u0010\u0018\u001a\t\u0018\u0001H/\u00a2\u0006\u0002\b\u0019H\u0096\u0001\u00a2\u0006\u0002\u0010_JN\u0010`\u001a\u00020\u0010\"\u0010\b\u0000\u0010/*\n \u0016*\u0004\u0018\u000100002\u001b\b\u0001\u0010\u0011\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u0001H/H/01\u00a2\u0006\u0002\b\u00132\u000f\b\u0001\u0010\u0018\u001a\t\u0018\u0001H/\u00a2\u0006\u0002\b\u0019H\u0096\u0001\u00a2\u0006\u0002\u0010_J \u0010a\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\r\b\u0001\u0010\u0011\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0013H\u0096\u0001J%\u0010b\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\u0012\b\u0001\u0010\u0011\u001a\f0<\u00a2\u0006\u0002\b=\u00a2\u0006\u0002\b\u0013H\u0096\u0001J\u0011\u0010c\u001a\u00020V2\u0006\u0010\u0011\u001a\u00020dH\u0097\u0001J\u001d\u0010e\u001a\u00020V2\u0012\b\u0001\u0010\u0011\u001a\f0f\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\bgH\u0097\u0001J\u0018\u0010e\u001a\u00020V2\r\b\u0001\u0010\u0011\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0013H\u0097\u0001J\u001b\u0010h\u001a\u0014 \u0016*\t\u0018\u00010i\u00a2\u0006\u0002\b\u00130i\u00a2\u0006\u0002\b\u0013H\u0097\u0001R\u0014\u0010\t\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006j"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinFunctionProcessor$FunctionWithSupersWrapper;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lcom/intellij/psi/PsiNamedElement;", "originalDeclaration", "supers", "", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Ljava/util/List;)V", "kotlinOrigin", "getKotlinOrigin", "()Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getOriginalDeclaration", "getSupers", "()Ljava/util/List;", "accept", "", "p0", "Lcom/intellij/psi/PsiElementVisitor;", "Lorg/jetbrains/annotations/NotNull;", "acceptChildren", "add", "kotlin.jvm.PlatformType", "addAfter", "p1", "Lorg/jetbrains/annotations/Nullable;", "addBefore", "addRange", "addRangeAfter", "p2", "addRangeBefore", "checkAdd", "checkDelete", "copy", "delete", "deleteChildRange", "findElementAt", "", "findReferenceAt", "Lcom/intellij/psi/PsiReference;", "getChildren", "", "()[Lcom/intellij/psi/PsiElement;", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "getContext", "getCopyableUserData", "T", "", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "getFirstChild", "getIcon", "Ljavax/swing/Icon;", "getLanguage", "Lcom/intellij/lang/Language;", "getLastChild", "getManager", "Lcom/intellij/psi/PsiManager;", "getName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getNavigationElement", "getNextSibling", "getNode", "Lcom/intellij/lang/ASTNode;", "getOriginalElement", "getParent", "getPrevSibling", "getProject", "Lcom/intellij/openapi/project/Project;", "getReference", "getReferences", "()[Lcom/intellij/psi/PsiReference;", "getResolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getStartOffsetInParent", "getText", "getTextLength", "getTextOffset", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "getUseScope", "Lcom/intellij/psi/search/SearchScope;", "getUserData", "isEquivalentTo", "", "isPhysical", "isValid", "isWritable", "processDeclarations", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "Lcom/intellij/psi/ResolveState;", "p3", "putCopyableUserData", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "putUserData", "replace", "setName", "textContains", "", "textMatches", "", "Lorg/jetbrains/annotations/NonNls;", "textToCharArray", "", "kotlin.refactorings.common"})
    private static final class FunctionWithSupersWrapper
    implements KtLightElement<KtNamedFunction, KtNamedFunction>,
    PsiNamedElement {
        @NotNull
        private final KtNamedFunction originalDeclaration;
        @NotNull
        private final List<PsiElement> supers;

        public FunctionWithSupersWrapper(@NotNull KtNamedFunction originalDeclaration, @NotNull List<? extends PsiElement> supers) {
            Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
            Intrinsics.checkNotNullParameter(supers, (String)"supers");
            this.originalDeclaration = originalDeclaration;
            this.supers = supers;
        }

        @NotNull
        public final KtNamedFunction getOriginalDeclaration() {
            return this.originalDeclaration;
        }

        @NotNull
        public final List<PsiElement> getSupers() {
            return this.supers;
        }

        public void accept(@NotNull PsiElementVisitor p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            this.originalDeclaration.accept(p0);
        }

        public void acceptChildren(@NotNull PsiElementVisitor p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            this.originalDeclaration.acceptChildren(p0);
        }

        public PsiElement add(@NotNull PsiElement p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.add(p0);
        }

        public PsiElement addAfter(@NotNull PsiElement p0, @Nullable PsiElement p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.addAfter(p0, p1);
        }

        public PsiElement addBefore(@NotNull PsiElement p0, @Nullable PsiElement p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.addBefore(p0, p1);
        }

        public PsiElement addRange(PsiElement p0, PsiElement p1) {
            return this.originalDeclaration.addRange(p0, p1);
        }

        public PsiElement addRangeAfter(PsiElement p0, PsiElement p1, PsiElement p2) {
            return this.originalDeclaration.addRangeAfter(p0, p1, p2);
        }

        public PsiElement addRangeBefore(@NotNull PsiElement p0, @NotNull PsiElement p1, PsiElement p2) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            return this.originalDeclaration.addRangeBefore(p0, p1, p2);
        }

        @Deprecated(message="Deprecated in Java")
        public void checkAdd(@NotNull PsiElement p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            this.originalDeclaration.checkAdd(p0);
        }

        @Deprecated(message="Deprecated in Java")
        public void checkDelete() {
            this.originalDeclaration.checkDelete();
        }

        public PsiElement copy() {
            return this.originalDeclaration.copy();
        }

        public void delete() {
            this.originalDeclaration.delete();
        }

        public void deleteChildRange(PsiElement p0, PsiElement p1) {
            this.originalDeclaration.deleteChildRange(p0, p1);
        }

        @Nullable
        @Contract(pure=true)
        public PsiElement findElementAt(int p0) {
            return this.originalDeclaration.findElementAt(p0);
        }

        @Nullable
        @Contract(pure=true)
        public PsiReference findReferenceAt(int p0) {
            return this.originalDeclaration.findReferenceAt(p0);
        }

        @Contract(pure=true)
        @NotNull
        public PsiElement[] getChildren() {
            return this.originalDeclaration.getChildren();
        }

        @Contract(pure=true)
        public PsiFile getContainingFile() {
            return this.originalDeclaration.getContainingFile();
        }

        @Nullable
        @Contract(pure=true)
        public PsiElement getContext() {
            return this.originalDeclaration.getContext();
        }

        @Nullable
        @Contract(pure=true)
        public <T> T getCopyableUserData(@NotNull Key<T> p0) {
            Intrinsics.checkNotNullParameter(p0, (String)"p0");
            return (T)this.originalDeclaration.getCopyableUserData(p0);
        }

        @Contract(pure=true)
        public PsiElement getFirstChild() {
            return this.originalDeclaration.getFirstChild();
        }

        public Icon getIcon(@Iconable.IconFlags int p0) {
            return this.originalDeclaration.getIcon(p0);
        }

        @NotNull
        @Contract(pure=true)
        public Language getLanguage() {
            return this.originalDeclaration.getLanguage();
        }

        @Contract(pure=true)
        public PsiElement getLastChild() {
            return this.originalDeclaration.getLastChild();
        }

        @Contract(pure=true)
        public PsiManager getManager() {
            return (PsiManager)this.originalDeclaration.getManager();
        }

        @Nullable
        @NlsSafe
        public String getName() {
            return this.originalDeclaration.getName();
        }

        @Contract(pure=true)
        public PsiElement getNavigationElement() {
            return this.originalDeclaration.getNavigationElement();
        }

        @Contract(pure=true)
        public PsiElement getNextSibling() {
            return this.originalDeclaration.getNextSibling();
        }

        @Contract(pure=true)
        public ASTNode getNode() {
            return this.originalDeclaration.getNode();
        }

        @Contract(pure=true)
        public PsiElement getOriginalElement() {
            return this.originalDeclaration.getOriginalElement();
        }

        @Contract(pure=true)
        public PsiElement getParent() {
            return this.originalDeclaration.getParent();
        }

        @Contract(pure=true)
        public PsiElement getPrevSibling() {
            return this.originalDeclaration.getPrevSibling();
        }

        @NotNull
        @Contract(pure=true)
        public Project getProject() {
            return this.originalDeclaration.getProject();
        }

        @Nullable
        @Contract(pure=true)
        public PsiReference getReference() {
            return this.originalDeclaration.getReference();
        }

        @Contract(pure=true)
        @NotNull
        public PsiReference[] getReferences() {
            return this.originalDeclaration.getReferences();
        }

        @NotNull
        @Contract(pure=true)
        public GlobalSearchScope getResolveScope() {
            return this.originalDeclaration.getResolveScope();
        }

        @Contract(pure=true)
        public int getStartOffsetInParent() {
            return this.originalDeclaration.getStartOffsetInParent();
        }

        @Contract(pure=true)
        @NlsSafe
        public String getText() {
            return this.originalDeclaration.getText();
        }

        @Contract(pure=true)
        public int getTextLength() {
            return this.originalDeclaration.getTextLength();
        }

        @Contract(pure=true)
        public int getTextOffset() {
            return this.originalDeclaration.getTextOffset();
        }

        @Contract(pure=true)
        public TextRange getTextRange() {
            return this.originalDeclaration.getTextRange();
        }

        @NotNull
        @Contract(pure=true)
        public SearchScope getUseScope() {
            return this.originalDeclaration.getUseScope();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> p0) {
            Intrinsics.checkNotNullParameter(p0, (String)"p0");
            return (T)this.originalDeclaration.getUserData(p0);
        }

        @Contract(pure=true)
        public boolean isEquivalentTo(PsiElement p0) {
            return this.originalDeclaration.isEquivalentTo(p0);
        }

        @Contract(pure=true)
        public boolean isPhysical() {
            return this.originalDeclaration.isPhysical();
        }

        @Contract(pure=true)
        public boolean isValid() {
            return this.originalDeclaration.isValid();
        }

        @Contract(pure=true)
        public boolean isWritable() {
            return this.originalDeclaration.isWritable();
        }

        public boolean processDeclarations(@NotNull PsiScopeProcessor p0, @NotNull ResolveState p1, @Nullable PsiElement p2, @NotNull PsiElement p3) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
            return this.originalDeclaration.processDeclarations(p0, p1, p2, p3);
        }

        public <T> void putCopyableUserData(@NotNull Key<T> p0, @Nullable T p1) {
            Intrinsics.checkNotNullParameter(p0, (String)"p0");
            this.originalDeclaration.putCopyableUserData(p0, p1);
        }

        public <T> void putUserData(@NotNull Key<T> p0, @Nullable T p1) {
            Intrinsics.checkNotNullParameter(p0, (String)"p0");
            this.originalDeclaration.putUserData(p0, p1);
        }

        public PsiElement replace(@NotNull PsiElement p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.replace(p0);
        }

        public PsiElement setName(@NlsSafe @NotNull String p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.setName(p0);
        }

        @Contract(pure=true)
        public boolean textContains(char p0) {
            return this.originalDeclaration.textContains(p0);
        }

        @Contract(pure=true)
        public boolean textMatches(@NotNull @NonNls CharSequence p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.textMatches(p0);
        }

        @Contract(pure=true)
        public boolean textMatches(@NotNull PsiElement p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.textMatches(p0);
        }

        @Contract(pure=true)
        public char[] textToCharArray() {
            return this.originalDeclaration.textToCharArray();
        }

        @NotNull
        public KtNamedFunction getKotlinOrigin() {
            return this.originalDeclaration;
        }
    }
}

