/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveDialogBase;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.CommonMoveClassesOrPackagesUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggestionProvider;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.ModelResultWithFUSData;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinNestedClassesToUpperLevelModel;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

public class MoveKotlinNestedClassesToUpperLevelDialog
extends MoveDialogBase {
    @NonNls
    private static final String RECENTS_KEY = MoveKotlinNestedClassesToUpperLevelDialog.class.getName() + ".RECENTS_KEY";
    private final Project project;
    private final KtClassOrObject innerClass;
    private final ClassDescriptor innerClassDescriptor;
    private final PsiElement targetContainer;
    private EditorTextField classNameField;
    private NameSuggestionsField parameterField;
    private JCheckBox passOuterClassCheckBox;
    private JPanel panel;
    private JCheckBox searchInCommentsCheckBox;
    private JCheckBox searchForTextOccurrencesCheckBox;
    private PackageNameReferenceEditorCombo packageNameField;
    private JLabel packageNameLabel;
    private JLabel classNameLabel;
    private JLabel parameterNameLabel;
    private JPanel openInEditorPanel;
    private BitSet initializedCheckBoxesState;

    public MoveKotlinNestedClassesToUpperLevelDialog(@NotNull Project project2, @NotNull KtClassOrObject innerClass, @NotNull PsiElement targetContainer) {
        if (project2 == null) {
            MoveKotlinNestedClassesToUpperLevelDialog.$$$reportNull$$$0(0);
        }
        if (innerClass == null) {
            MoveKotlinNestedClassesToUpperLevelDialog.$$$reportNull$$$0(1);
        }
        if (targetContainer == null) {
            MoveKotlinNestedClassesToUpperLevelDialog.$$$reportNull$$$0(2);
        }
        super(project2, true);
        this.project = project2;
        this.innerClass = innerClass;
        this.targetContainer = targetContainer;
        this.$$$setupUI$$$();
        this.innerClassDescriptor = (ClassDescriptor)ResolutionUtils.unsafeResolveToDescriptor((KtDeclaration)innerClass, BodyResolveMode.FULL);
        this.setTitle(KotlinBundle.message((String)"title.move.nested.classes.to.upper.level", (Object[])new Object[0]));
        this.init();
        this.packageNameLabel.setLabelFor(this.packageNameField.getChildComponent());
        this.classNameLabel.setLabelFor((Component)this.classNameField);
        this.parameterNameLabel.setLabelFor((Component)this.parameterField);
        this.openInEditorPanel.add((Component)this.initOpenInEditorCb(), "East");
    }

    private void createUIComponents() {
        this.parameterField = new NameSuggestionsField(this.project);
        this.packageNameField = new PackageNameReferenceEditorCombo("", this.project, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
    }

    protected String getMovePropertySuffix() {
        return KotlinBundle.message((String)"text.nested.classes.to.upper.level", (Object[])new Object[0]);
    }

    protected String getHelpId() {
        return "refactoring.moveInner";
    }

    protected String getCbTitle() {
        return KotlinBundle.message((String)"checkbox.text.open.moved.files.in.editor", (Object[])new Object[0]);
    }

    public String getClassName() {
        return this.classNameField.getText().trim();
    }

    @Nullable
    public String getParameterName() {
        return this.parameterField != null ? this.parameterField.getEnteredName() : null;
    }

    private boolean isThisNeeded() {
        return this.innerClass instanceof KtClass && MoveUtilKt.traverseOuterInstanceReferences((KtNamedDeclaration)this.innerClass, true);
    }

    @Nullable
    private FqName getTargetPackageFqName() {
        return MoveUtilKt.getTargetPackageFqName(this.targetContainer);
    }

    @NotNull
    private KotlinType getOuterInstanceType() {
        SimpleType simpleType = ((ClassDescriptor)this.innerClassDescriptor.getContainingDeclaration()).getDefaultType();
        if (simpleType == null) {
            MoveKotlinNestedClassesToUpperLevelDialog.$$$reportNull$$$0(3);
        }
        return simpleType;
    }

    private BitSet getCheckboxesState(boolean applyDefaults) {
        BitSet state = new BitSet(3);
        state.set(0, !applyDefaults && this.searchInCommentsCheckBox.isSelected());
        state.set(1, !applyDefaults && this.searchForTextOccurrencesCheckBox.isSelected());
        state.set(2, this.passOuterClassCheckBox.isSelected());
        return state;
    }

    protected void init() {
        this.classNameField.setText(this.innerClass.getName());
        this.classNameField.selectAll();
        if (this.innerClass instanceof KtClass && ((KtClass)this.innerClass).isInner()) {
            this.passOuterClassCheckBox.setSelected(true);
            this.passOuterClassCheckBox.addItemListener(e -> this.parameterField.setEnabled(this.passOuterClassCheckBox.isSelected()));
        } else {
            this.passOuterClassCheckBox.setSelected(false);
            this.passOuterClassCheckBox.setEnabled(false);
            this.parameterField.setEnabled(false);
        }
        if (this.passOuterClassCheckBox.isEnabled()) {
            boolean thisNeeded = this.isThisNeeded();
            this.passOuterClassCheckBox.setSelected(thisNeeded);
            this.parameterField.setEnabled(thisNeeded);
        }
        this.passOuterClassCheckBox.addItemListener(e -> {
            boolean selected = this.passOuterClassCheckBox.isSelected();
            this.parameterField.getComponent().setEnabled(selected);
        });
        if (!(this.targetContainer instanceof PsiDirectory)) {
            this.packageNameField.setVisible(false);
            this.packageNameLabel.setVisible(false);
        }
        if (this.innerClass instanceof KtClass && ((KtClass)this.innerClass).isInner()) {
            KtClassBody innerClassBody = this.innerClass.getBody();
            Object validator2 = innerClassBody != null ? new Fe10KotlinNewDeclarationNameValidator((PsiElement)innerClassBody, (PsiElement)null, KotlinNameSuggestionProvider.ValidatorTarget.PARAMETER, Collections.emptyList()) : new CollectingNameValidator();
            List<String> suggestions2 = Fe10KotlinNameSuggester.INSTANCE.suggestNamesByType(this.getOuterInstanceType(), (Function1<? super String, Boolean>)validator2, "outer");
            this.parameterField.setSuggestions(ArrayUtil.toStringArray(suggestions2));
        } else {
            this.parameterField.getComponent().setEnabled(false);
        }
        FqName packageFqName = this.getTargetPackageFqName();
        if (packageFqName != null) {
            this.packageNameField.prependItem(packageFqName.asString());
        }
        KotlinRefactoringSettings settings2 = KotlinRefactoringSettings.getInstance();
        this.searchForTextOccurrencesCheckBox.setSelected(settings2.MOVE_TO_UPPER_LEVEL_SEARCH_FOR_TEXT);
        this.searchInCommentsCheckBox.setSelected(settings2.MOVE_TO_UPPER_LEVEL_SEARCH_IN_COMMENTS);
        super.init();
        this.initializedCheckBoxesState = this.getCheckboxesState(true);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classNameField;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.move.moveInner.MoveInnerDialog";
    }

    protected JComponent createNorthPanel() {
        return this.panel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    private Model getModel() {
        return new MoveKotlinNestedClassesToUpperLevelModelWithUIChooser(this.project, this.innerClass, this.targetContainer, this.getParameterName(), this.getClassName(), this.passOuterClassCheckBox.isSelected(), this.searchInCommentsCheckBox.isSelected(), this.searchForTextOccurrencesCheckBox.isSelected(), this.packageNameField.getText(), this.isOpenInEditor());
    }

    protected void doAction() {
        ModelResultWithFUSData modelResult;
        try {
            modelResult = this.getModel().computeModelResult();
        }
        catch (ConfigurationException e) {
            this.setErrorHtml(e.getMessageHtml());
            return;
        }
        KotlinRefactoringSettings settings2 = KotlinRefactoringSettings.getInstance();
        settings2.MOVE_TO_UPPER_LEVEL_SEARCH_FOR_TEXT = this.searchForTextOccurrencesCheckBox.isSelected();
        settings2.MOVE_TO_UPPER_LEVEL_SEARCH_IN_COMMENTS = this.searchInCommentsCheckBox.isSelected();
        this.saveOpenInEditorOption();
        MoveUtilKt.logFusForMoveRefactoring(modelResult.getElementsCount(), modelResult.getEntityToMove(), modelResult.getDestination(), this.getCheckboxesState(false).equals(this.initializedCheckBoxesState), () -> this.invokeRefactoring(modelResult.getProcessor()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JLabel jLabel2;
        EditorTextField editorTextField;
        JLabel jLabel3;
        JPanel jPanel2;
        this.createUIComponents();
        this.panel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.classNameLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinNestedClassesToUpperLevelDialog.class).getString("class.name.prompt"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.classNameField = editorTextField = new EditorTextField();
        jPanel2.add((Component)editorTextField, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox = new NonFocusableCheckBox();
        this.passOuterClassCheckBox = nonFocusableCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinNestedClassesToUpperLevelDialog.class).getString("pass.outer.class.instance.as.parameter"));
        jPanel2.add((Component)nonFocusableCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.parameterNameLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinNestedClassesToUpperLevelDialog.class).getString("parameter.name.prompt"));
        jPanel2.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        NameSuggestionsField nameSuggestionsField = this.parameterField;
        jPanel2.add((Component)nameSuggestionsField, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 5));
        jPanel2.add((Component)jPanel3, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.searchInCommentsCheckBox = nonFocusableCheckBox2;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinNestedClassesToUpperLevelDialog.class).getString("search.in.comments.and.strings"));
        Component component2 = jPanel3.add((Component)nonFocusableCheckBox2);
        NonFocusableCheckBox nonFocusableCheckBox3 = new NonFocusableCheckBox();
        this.searchForTextOccurrencesCheckBox = nonFocusableCheckBox3;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox3, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinNestedClassesToUpperLevelDialog.class).getString("search.for.text.occurrences"));
        Component component3 = jPanel3.add((Component)nonFocusableCheckBox3);
        this.packageNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinNestedClassesToUpperLevelDialog.class).getString("label.text.package.name"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PackageNameReferenceEditorCombo packageNameReferenceEditorCombo = this.packageNameField;
        jPanel2.add((Component)packageNameReferenceEditorCombo, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.openInEditorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(8, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetContainer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesToUpperLevelDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesToUpperLevelDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterInstanceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class MoveKotlinNestedClassesToUpperLevelModelWithUIChooser
    extends MoveKotlinNestedClassesToUpperLevelModel {
        public MoveKotlinNestedClassesToUpperLevelModelWithUIChooser(@NotNull Project project2, @NotNull KtClassOrObject innerClass, @NotNull PsiElement target2, @Nullable String parameter, @NotNull String className, boolean passOuterClass, boolean searchInComments, boolean isSearchInNonJavaFiles, @NotNull String packageName, boolean isOpenInEditor) {
            if (project2 == null) {
                MoveKotlinNestedClassesToUpperLevelModelWithUIChooser.$$$reportNull$$$0(0);
            }
            if (innerClass == null) {
                MoveKotlinNestedClassesToUpperLevelModelWithUIChooser.$$$reportNull$$$0(1);
            }
            if (target2 == null) {
                MoveKotlinNestedClassesToUpperLevelModelWithUIChooser.$$$reportNull$$$0(2);
            }
            if (className == null) {
                MoveKotlinNestedClassesToUpperLevelModelWithUIChooser.$$$reportNull$$$0(3);
            }
            if (packageName == null) {
                MoveKotlinNestedClassesToUpperLevelModelWithUIChooser.$$$reportNull$$$0(4);
            }
            super(project2, innerClass, target2, parameter, className, passOuterClass, searchInComments, isSearchInNonJavaFiles, packageName, isOpenInEditor);
        }

        @Override
        @Nullable
        protected VirtualFile chooseSourceRoot(@NotNull PackageWrapper newPackage, @NotNull List<? extends VirtualFile> contentSourceRoots, @Nullable PsiDirectory initialDir) {
            if (newPackage == null) {
                MoveKotlinNestedClassesToUpperLevelModelWithUIChooser.$$$reportNull$$$0(5);
            }
            if (contentSourceRoots == null) {
                MoveKotlinNestedClassesToUpperLevelModelWithUIChooser.$$$reportNull$$$0(6);
            }
            return CommonMoveClassesOrPackagesUtil.chooseSourceRoot((PackageWrapper)newPackage, contentSourceRoots, (PsiDirectory)initialDir);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "innerClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newPackage";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentSourceRoots";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesToUpperLevelDialog$MoveKotlinNestedClassesToUpperLevelModelWithUIChooser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseSourceRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

