/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.move.MoveConflictUsages;
import org.jetbrains.kotlin.idea.refactoring.move.MoveConflictsFoundException;
import org.jetbrains.kotlin.idea.refactoring.move.MoveFilesWithDeclarationsViewDescriptor;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BU\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016H\u0014\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\tH\u0014J\u001b\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0014\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u001d\u001a\u00020\u000b2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u001fH\u0014J\b\u0010 \u001a\u00020\u001bH\u0002J3\u0010!\u001a\u00020\u000b2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\t0#2\u0010\u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0017\u0018\u00010\u0016H\u0014\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/MoveToKotlinFileProcessor;", "Lcom/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "sourceFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "targetFileName", "", "searchInComments", "", "searchInNonJavaFiles", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "prepareSuccessfulCallback", "Ljava/lang/Runnable;", "throwOnConflicts", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/psi/PsiDirectory;Ljava/lang/String;ZZLcom/intellij/refactoring/move/MoveCallback;Ljava/lang/Runnable;Z)V", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "getCommandName", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "preprocessUsages", "refUsages", "Lcom/intellij/openapi/util/Ref;", "renameFileTemporarilyIfNeeded", "showConflicts", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/util/containers/MultiMap;[Lcom/intellij/usageView/UsageInfo;)Z", "kotlin.idea"})
public final class MoveToKotlinFileProcessor
extends MoveFilesOrDirectoriesProcessor {
    @NotNull
    private final KtFile sourceFile;
    @NotNull
    private final PsiDirectory targetDirectory;
    @NotNull
    private final String targetFileName;
    private final boolean throwOnConflicts;

    @JvmOverloads
    public MoveToKotlinFileProcessor(@NotNull Project project2, @NotNull KtFile sourceFile2, @NotNull PsiDirectory targetDirectory2, @NotNull String targetFileName, boolean searchInComments, boolean searchInNonJavaFiles, @Nullable MoveCallback moveCallback, @NotNull Runnable prepareSuccessfulCallback, boolean throwOnConflicts) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceFile2, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)targetDirectory2, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)targetFileName, (String)"targetFileName");
        Intrinsics.checkNotNullParameter((Object)prepareSuccessfulCallback, (String)"prepareSuccessfulCallback");
        KtFile[] ktFileArray = new KtFile[]{sourceFile2};
        super(project2, (PsiElement[])ktFileArray, targetDirectory2, true, searchInComments, searchInNonJavaFiles, moveCallback, prepareSuccessfulCallback);
        this.sourceFile = sourceFile2;
        this.targetDirectory = targetDirectory2;
        this.targetFileName = targetFileName;
        this.throwOnConflicts = throwOnConflicts;
    }

    public /* synthetic */ MoveToKotlinFileProcessor(Project project2, KtFile ktFile2, PsiDirectory psiDirectory, String string, boolean bl, boolean bl2, MoveCallback moveCallback, Runnable runnable, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            Runnable runnable2 = EmptyRunnable.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)runnable2, (String)"INSTANCE");
            runnable = runnable2;
        }
        if ((n & 0x100) != 0) {
            bl3 = false;
        }
        this(project2, ktFile2, psiDirectory, string, bl, bl2, moveCallback, runnable, bl3);
    }

    @NotNull
    protected String getCommandName() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.sourceFile.getName(), (String)"getName(...)");
        return KotlinBundle.message((String)"text.move.file.0", (Object[])objectArray);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        PsiElement[] psiElementArray = new PsiElement[]{this.sourceFile};
        return new MoveFilesWithDeclarationsViewDescriptor(psiElementArray, this.targetDirectory);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        Intrinsics.checkNotNullParameter(refUsages, (String)"refUsages");
        Pair<MultiMap<PsiElement, String>, UsageInfo[]> pair = MoveConflictUsages.Companion.preprocess(refUsages);
        MultiMap conflicts2 = (MultiMap)pair.component1();
        UsageInfo[] usages2 = (UsageInfo[])pair.component2();
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts2, usages2);
    }

    protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts2, @Nullable UsageInfo[] usages2) {
        Intrinsics.checkNotNullParameter(conflicts2, (String)"conflicts");
        if (this.throwOnConflicts && !conflicts2.isEmpty()) {
            throw new MoveConflictsFoundException();
        }
        return super.showConflicts(conflicts2, usages2);
    }

    private final void renameFileTemporarilyIfNeeded() {
        if (this.targetDirectory.findFile(this.sourceFile.getName()) == null) {
            return;
        }
        PsiDirectory psiDirectory = this.sourceFile.getContainingDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory containingDirectory = psiDirectory;
        String string = UniqueNameGenerator.generateUniqueName((String)"temp", (String)"", (String)".kt", arg_0 -> MoveToKotlinFileProcessor.renameFileTemporarilyIfNeeded$lambda$0((Function1)new Function1<String, Boolean>(containingDirectory){
            final /* synthetic */ PsiDirectory $containingDirectory;
            {
                this.$containingDirectory = $containingDirectory;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                return this.$containingDirectory.findFile(it) == null;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
        String temporaryName2 = string;
        this.sourceFile.setName(temporaryName2);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        this.renameFileTemporarilyIfNeeded();
        super.performRefactoring(usages2);
        this.sourceFile.setName(this.targetFileName);
    }

    @JvmOverloads
    public MoveToKotlinFileProcessor(@NotNull Project project2, @NotNull KtFile sourceFile2, @NotNull PsiDirectory targetDirectory2, @NotNull String targetFileName, boolean searchInComments, boolean searchInNonJavaFiles, @Nullable MoveCallback moveCallback, @NotNull Runnable prepareSuccessfulCallback) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceFile2, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)targetDirectory2, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)targetFileName, (String)"targetFileName");
        Intrinsics.checkNotNullParameter((Object)prepareSuccessfulCallback, (String)"prepareSuccessfulCallback");
        this(project2, sourceFile2, targetDirectory2, targetFileName, searchInComments, searchInNonJavaFiles, moveCallback, prepareSuccessfulCallback, false, 256, null);
    }

    @JvmOverloads
    public MoveToKotlinFileProcessor(@NotNull Project project2, @NotNull KtFile sourceFile2, @NotNull PsiDirectory targetDirectory2, @NotNull String targetFileName, boolean searchInComments, boolean searchInNonJavaFiles, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceFile2, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)targetDirectory2, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)targetFileName, (String)"targetFileName");
        this(project2, sourceFile2, targetDirectory2, targetFileName, searchInComments, searchInNonJavaFiles, moveCallback, null, false, 384, null);
    }

    private static final boolean renameFileTemporarilyIfNeeded$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

