/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableAnalysisUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionData;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IParameter;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.OutputValue;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.Parameter;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.TypeDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.TypeParameter;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0013\u001a\u00020\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\u00022\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00180\u0015H\u0016J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0002H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u00022\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010&\u001a\u00020\u0002H\u0016J\f\u0010-\u001a\u00020\u001a*\u00020\u0002H\u0016J\f\u0010.\u001a\u00020\u001a*\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\b\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/KotlinTypeDescriptor;", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/TypeDescriptor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "data", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/ExtractionData;", "(Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/ExtractionData;)V", "booleanType", "getBooleanType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "nothingType", "getNothingType", "nullableAnyType", "getNullableAnyType", "targetScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "unitType", "getUnitType", "createListType", "argTypes", "", "createTuple", "outputValues", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue;", "isResolvableInScope", "", "typeToCheck", "typeParameters", "", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/TypeParameter;", "renderForMessage", "", "param", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IParameter;", "ktNamedDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "renderType", "kotlinType", "isReceiver", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "renderTypeWithoutApproximation", "returnType", "typeArguments", "isError", "isMeaningful", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nextractableAnalysisUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extractableAnalysisUtil.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/KotlinTypeDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,743:1\n1549#2:744\n1620#2,3:745\n1549#2:748\n1620#2,3:749\n*S KotlinDebug\n*F\n+ 1 extractableAnalysisUtil.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/KotlinTypeDescriptor\n*L\n427#1:744\n427#1:745,3\n436#1:748\n436#1:749,3\n*E\n"})
public final class KotlinTypeDescriptor
implements TypeDescriptor<KotlinType> {
    @NotNull
    private final ExtractionData data;
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final KotlinType booleanType;
    @NotNull
    private final KotlinType unitType;
    @NotNull
    private final KotlinType nothingType;
    @NotNull
    private final KotlinType nullableAnyType;
    @NotNull
    private final LexicalScope targetScope;

    public KotlinTypeDescriptor(@NotNull ExtractionData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        KtFile ktFile2 = this.data.getCommonParent().getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        this.module = ResolutionUtils.findModuleDescriptor((KtElement)ktFile2);
        SimpleType simpleType = this.module.getBuiltIns().getBooleanType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getBooleanType(...)");
        this.booleanType = (KotlinType)simpleType;
        SimpleType simpleType2 = this.module.getBuiltIns().getUnitType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getUnitType(...)");
        this.unitType = (KotlinType)simpleType2;
        SimpleType simpleType3 = this.module.getBuiltIns().getNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"getNothingType(...)");
        this.nothingType = (KotlinType)simpleType3;
        SimpleType simpleType4 = this.module.getBuiltIns().getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType4, (String)"getNullableAnyType(...)");
        this.nullableAnyType = (KotlinType)simpleType4;
        this.targetScope = ScopeUtils.getResolutionScope(this.data.getTargetSibling(), this.data.getBindingContext(), ResolutionUtils.getResolutionFacade(this.data.getCommonParent()));
    }

    @Override
    public boolean isMeaningful(@NotNull KotlinType $this$isMeaningful) {
        Intrinsics.checkNotNullParameter((Object)$this$isMeaningful, (String)"<this>");
        return !KotlinBuiltIns.isUnit((KotlinType)$this$isMeaningful) && !KotlinBuiltIns.isNothing((KotlinType)$this$isMeaningful);
    }

    @Override
    public boolean isError(@NotNull KotlinType $this$isError) {
        Intrinsics.checkNotNullParameter((Object)$this$isError, (String)"<this>");
        return KotlinTypeKt.isError((KotlinType)$this$isError);
    }

    @Override
    @NotNull
    public KotlinType getBooleanType() {
        return this.booleanType;
    }

    @Override
    @NotNull
    public KotlinType getUnitType() {
        return this.unitType;
    }

    @Override
    @NotNull
    public KotlinType getNothingType() {
        return this.nothingType;
    }

    @Override
    @NotNull
    public KotlinType getNullableAnyType() {
        return this.nullableAnyType;
    }

    @Override
    @NotNull
    public KotlinType createListType(@NotNull List<? extends KotlinType> argTypes) {
        Intrinsics.checkNotNullParameter(argTypes, (String)"argTypes");
        KotlinType kotlinType = org.jetbrains.kotlin.types.TypeUtils.substituteParameters((ClassDescriptor)this.module.getBuiltIns().getList(), Collections.singletonList(CommonSupertypes.commonSupertype((Collection)argTypes)));
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"substituteParameters(...)");
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KotlinType createTuple(@NotNull List<? extends OutputValue<KotlinType>> outputValues) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
        switch (outputValues.size()) {
            case 1: {
                return (KotlinType)((OutputValue)CollectionsKt.first(outputValues)).getValueType();
            }
            case 2: {
                ClassDescriptor classDescriptor2 = DescriptorUtilsKt.resolveTopLevelClass((ModuleDescriptor)this.module, (FqName)new FqName("kotlin.Pair"), (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
                classDescriptor = classDescriptor2;
                Intrinsics.checkNotNull((Object)classDescriptor2);
                break;
            }
            case 3: {
                ClassDescriptor classDescriptor3 = DescriptorUtilsKt.resolveTopLevelClass((ModuleDescriptor)this.module, (FqName)new FqName("kotlin.Triple"), (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
                classDescriptor = classDescriptor3;
                Intrinsics.checkNotNull((Object)classDescriptor3);
                break;
            }
            default: {
                return ExtractableAnalysisUtilKt.getDefaultReturnType(this.module.getBuiltIns());
            }
        }
        ClassDescriptor boxingClass = classDescriptor;
        Iterable iterable = outputValues;
        ClassDescriptor classDescriptor4 = boxingClass;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OutputValue outputValue = (OutputValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((KotlinType)it.getValueType());
        }
        KotlinType kotlinType = org.jetbrains.kotlin.types.TypeUtils.substituteParameters((ClassDescriptor)classDescriptor4, (List)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"substituteParameters(...)");
        return kotlinType;
    }

    @Override
    @Nullable
    public KotlinType returnType(@NotNull KtNamedDeclaration ktNamedDeclaration) {
        CallableDescriptor descriptor2;
        Intrinsics.checkNotNullParameter((Object)ktNamedDeclaration, (String)"ktNamedDeclaration");
        Object object = this.data.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)ktNamedDeclaration);
        CallableDescriptor callableDescriptor = descriptor2 = object instanceof CallableDescriptor ? (CallableDescriptor)object : null;
        return callableDescriptor != null ? callableDescriptor.getReturnType() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KotlinType> typeArguments(@NotNull KotlinType kotlinType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        Iterable $this$map$iv = kotlinType.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String renderType(@NotNull KotlinType kotlinType, boolean isReceiver, @NotNull Variance variance) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        Intrinsics.checkNotNullParameter((Object)variance, (String)"variance");
        String renderType2 = IdeDescriptorRenderers.SOURCE_CODE.renderType(kotlinType);
        return FunctionTypesKt.isFunctionType((KotlinType)kotlinType) && isReceiver ? "(" + renderType2 + ")" : renderType2;
    }

    @Override
    @NotNull
    public String renderTypeWithoutApproximation(@NotNull KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        return ExtractableAnalysisUtilKt.access$renderForMessage(kotlinType);
    }

    @Override
    @Nullable
    public String renderForMessage(@NotNull KtNamedDeclaration ktNamedDeclaration) {
        Intrinsics.checkNotNullParameter((Object)ktNamedDeclaration, (String)"ktNamedDeclaration");
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.data.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)ktNamedDeclaration);
        return declarationDescriptor != null ? ExtractableAnalysisUtilKt.access$renderForMessage(declarationDescriptor) : null;
    }

    @Override
    @NotNull
    public String renderForMessage(@NotNull IParameter<KotlinType> param2) {
        Intrinsics.checkNotNullParameter(param2, (String)"param");
        return ExtractableAnalysisUtilKt.access$renderForMessage(((Parameter)param2).getOriginalDescriptor());
    }

    @Override
    public boolean isResolvableInScope(@NotNull KotlinType typeToCheck, @NotNull Set<TypeParameter> typeParameters2) {
        boolean bl;
        PsiElement psiElement2;
        TypeParameterDescriptor parameterTypeDescriptor;
        Intrinsics.checkNotNullParameter((Object)typeToCheck, (String)"typeToCheck");
        Intrinsics.checkNotNullParameter(typeParameters2, (String)"typeParameters");
        ClassifierDescriptor classifierDescriptor = typeToCheck.getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = parameterTypeDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
        if (typeParameterDescriptor != null) {
            TypeParameterDescriptor it = typeParameterDescriptor;
            boolean bl2 = false;
            psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)it));
        } else {
            psiElement2 = null;
        }
        PsiElement psiElement3 = psiElement2;
        KtTypeParameter typeParameter = psiElement3 instanceof KtTypeParameter ? (KtTypeParameter)psiElement3 : null;
        if (TypeUtils.isResolvableInScope$default(typeToCheck, this.targetScope, true, false, 4, null)) {
            bl = true;
        } else if (typeParameter != null) {
            typeParameters2.add(new TypeParameter(typeParameter, ExtractUtilKt.collectRelevantConstraints(typeParameter)));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }
}

