/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.cutPaste;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsEditorCookie;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsIntentionAction;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsProcessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "MoveDeclarationsPass", "Registrar", "kotlin.idea"})
public final class MoveDeclarationsPassFactory
implements TextEditorHighlightingPassFactory {
    @NotNull
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return new MoveDeclarationsPass(project2, file2, editor2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsPassFactory$MoveDeclarationsPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "buildHighlightingInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "kotlin.idea"})
    private static final class MoveDeclarationsPass
    extends TextEditorHighlightingPass {
        @NotNull
        private final Project project;
        @NotNull
        private final PsiFile file;
        @NotNull
        private final Editor editor;

        public MoveDeclarationsPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            super(project2, editor2.getDocument(), true);
            this.project = project2;
            this.file = file2;
            this.editor = editor2;
        }

        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            HighlightInfo info2 = this.buildHighlightingInfo();
            if (info2 != null) {
                BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.project, (PsiFile)this.file, (Document)this.myDocument, (int)0, (int)this.file.getTextLength(), (Collection)CollectionsKt.listOf((Object)info2), (int)this.getId());
            }
        }

        public void doApplyInformationToEditor() {
        }

        private final HighlightInfo buildHighlightingInfo() {
            MoveDeclarationsEditorCookie moveDeclarationsEditorCookie = (MoveDeclarationsEditorCookie)this.editor.getUserData(MoveDeclarationsEditorCookie.Companion.getKEY());
            if (moveDeclarationsEditorCookie == null) {
                return null;
            }
            MoveDeclarationsEditorCookie cookie = moveDeclarationsEditorCookie;
            if (cookie.getModificationCount() != PsiModificationTracker.getInstance((Project)this.project).getModificationCount()) {
                return null;
            }
            MoveDeclarationsProcessor processor2 = MoveDeclarationsProcessor.Companion.build(this.file, cookie);
            if (processor2 == null) {
                this.editor.putUserData(MoveDeclarationsEditorCookie.Companion.getKEY(), null);
                return null;
            }
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION);
            TextRange textRange = RangeMarkersKt.getAsTextRange((RangeMarker)cookie.getBounds());
            Intrinsics.checkNotNull((Object)textRange);
            return builder2.range(textRange).registerFix((IntentionAction)new MoveDeclarationsIntentionAction(processor2, cookie.getBounds(), cookie.getModificationCount()), null, null, null, null).createUnconditionally();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsPassFactory$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar2, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)registrar2, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            registrar2.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)new MoveDeclarationsPassFactory(), TextEditorHighlightingPassRegistrar.Anchor.BEFORE, 3, true, true);
        }
    }
}

