/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.MakeModuleOptInFix;
import org.jetbrains.kotlin.idea.quickfix.OptInFixesUtils;
import org.jetbrains.kotlin.idea.quickfix.UseOptInFileAnnotationFix;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFileLevelFixesFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "findFileAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nOptInFileLevelFixesFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInFileLevelFixesFactory.kt\norg/jetbrains/kotlin/idea/quickfix/OptInFileLevelFixesFactory\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n58#2,2:73\n28#2,12:75\n288#3,2:87\n*S KotlinDebug\n*F\n+ 1 OptInFileLevelFixesFactory.kt\norg/jetbrains/kotlin/idea/quickfix/OptInFileLevelFixesFactory\n*L\n31#1:73,2\n31#1:75,12\n67#1:87,2\n*E\n"})
public final class OptInFileLevelFixesFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final OptInFileLevelFixesFactory INSTANCE = new OptInFileLevelFixesFactory();

    private OptInFileLevelFixesFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        PsiElement psiElement2;
        PsiElement psiElement3;
        block10: {
            void $this$findParentInFile$iv$iv;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement $this$findParentOfType_u24default$iv = diagnostic.getPsiElement();
            boolean strict$iv = true;
            boolean $i$f$findParentOfType = false;
            PsiElement psiElement4 = $this$findParentOfType_u24default$iv;
            boolean withSelf$iv$iv = false;
            boolean $i$f$findParentInFile = false;
            if ($this$findParentInFile$iv$iv instanceof PsiFile) {
                psiElement3 = null;
            } else {
                for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv.getParent(); current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                    PsiElement it$iv = current$iv$iv;
                    boolean bl = false;
                    if (it$iv instanceof KtElement) {
                        psiElement3 = current$iv$iv;
                        break block10;
                    }
                    if (current$iv$iv instanceof PsiFile) break;
                }
                psiElement3 = psiElement2 = null;
            }
        }
        if (!(psiElement3 instanceof KtElement)) {
            psiElement2 = null;
        }
        KtElement ktElement = (KtElement)((PsiElement)((KtElement)psiElement2));
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement element3 = ktElement;
        FqName fqName2 = OptInFixesUtils.INSTANCE.annotationFqName(diagnostic);
        if (fqName2 == null) {
            return CollectionsKt.emptyList();
        }
        FqName annotationFqName = fqName2;
        ModuleDescriptor moduleDescriptor = ResolutionUtils.getResolutionFacade(element3).getModuleDescriptor();
        ClassDescriptor classDescriptor = DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)moduleDescriptor, (FqName)annotationFqName, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
        if (classDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor annotationClassDescriptor = classDescriptor;
        if (!OptInFixesUtils.INSTANCE.annotationIsVisible(annotationClassDescriptor, element3, ResolutionUtils.analyze$default(element3, null, 1, null))) {
            return CollectionsKt.emptyList();
        }
        FqName optInFqName = OptInFixesUtils.INSTANCE.optInFqName(moduleDescriptor);
        List result2 = new ArrayList();
        KtFile ktFile2 = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile containingFile = ktFile2;
        Module module2 = GenericPsiUtils.getModule((PsiElement)containingFile);
        KtAnnotationEntry ktAnnotationEntry = this.findFileAnnotation(containingFile, optInFqName);
        result2.add(new UseOptInFileAnnotationFix(containingFile, optInFqName, annotationFqName, (SmartPsiElementPointer<KtAnnotationEntry>)(ktAnnotationEntry != null ? SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)ktAnnotationEntry)) : null)));
        if (module2 != null) {
            result2.add(new MakeModuleOptInFix(containingFile, module2, annotationFqName));
        }
        return result2;
    }

    private final KtAnnotationEntry findFileAnnotation(KtFile file2, FqName annotationFqName) {
        KtAnnotationEntry ktAnnotationEntry;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)file2, BodyResolveMode.PARTIAL);
        Object object = file2.getFileAnnotationList();
        if (object != null && (object = object.getAnnotationEntries()) != null) {
            Object v2;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                    boolean bl = false;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)entry);
                    if (!Intrinsics.areEqual((Object)(annotationDescriptor != null ? annotationDescriptor.getFqName() : null), (Object)annotationFqName)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            ktAnnotationEntry = v2;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }
}

