/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInspection.util.IntentionName;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0007J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFixUtils;", "", "()V", "getActionName", "", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "containingDeclarationNames", "", "invoke", "", "overriddenNonOverridableMembers", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "kotlin.fir.frontend-independent"})
public final class MakeOverriddenMemberOpenFixUtils {
    @NotNull
    public static final MakeOverriddenMemberOpenFixUtils INSTANCE = new MakeOverriddenMemberOpenFixUtils();

    private MakeOverriddenMemberOpenFixUtils() {
    }

    public final void invoke(@NotNull List<? extends KtCallableDeclaration> overriddenNonOverridableMembers) {
        Intrinsics.checkNotNullParameter(overriddenNonOverridableMembers, (String)"overriddenNonOverridableMembers");
        for (KtCallableDeclaration ktCallableDeclaration2 : overriddenNonOverridableMembers) {
            ktCallableDeclaration2.addModifier(KtTokens.OPEN_KEYWORD);
            if (!ktCallableDeclaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) continue;
            ktCallableDeclaration2.removeModifier(KtTokens.OPEN_KEYWORD);
        }
    }

    @IntentionName
    @NotNull
    public final String getActionName(@NotNull KtDeclaration element3, @NotNull List<String> containingDeclarationNames) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(containingDeclarationNames, (String)"containingDeclarationNames");
        if (containingDeclarationNames.size() == 1) {
            String name2 = containingDeclarationNames.get(0) + "." + element3.getName();
            Object[] objectArray = new Object[]{name2 + " " + KtTokens.OPEN_KEYWORD};
            return KotlinBundle.message((String)"make.0", (Object[])objectArray);
        }
        List sortedDeclarationNames = CollectionsKt.sorted((Iterable)containingDeclarationNames);
        String declarations2 = CollectionsKt.joinToString$default((Iterable)sortedDeclarationNames.subList(0, sortedDeclarationNames.size() - 1), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " and " + CollectionsKt.last((List)sortedDeclarationNames);
        Object[] objectArray = new Object[]{String.valueOf(element3.getName()), declarations2};
        return KotlinBundle.message((String)"make.0.in.1.open", (Object[])objectArray);
    }
}

