/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven;

import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectNotificationAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManager;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/maven/MavenKotlinBuildSystemDependencyManager;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinBuildSystemDependencyManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "addDependency", "", "module", "Lcom/intellij/openapi/module/Module;", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "findPomFile", "Lcom/intellij/psi/xml/XmlFile;", "getBuildScriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isApplicable", "", "isProjectSyncInProgress", "isProjectSyncPending", "startProjectSync", "kotlin.maven"})
public final class MavenKotlinBuildSystemDependencyManager
implements KotlinBuildSystemDependencyManager {
    @NotNull
    private final Project project;

    public MavenKotlinBuildSystemDependencyManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    public boolean isApplicable(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return ProjectStructureUtils.isMavenModule(module2);
    }

    private final XmlFile findPomFile(Module module2) {
        PsiFile psiFile2 = KotlinMavenConfigurator.Companion.findModulePomFile(module2);
        return psiFile2 instanceof XmlFile ? (XmlFile)psiFile2 : null;
    }

    @Override
    public void addDependency(@NotNull Module module2, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)libraryDescriptor, (String)"libraryDescriptor");
        XmlFile xmlFile = this.findPomFile(module2);
        if (xmlFile == null) {
            return;
        }
        XmlFile pomFile = xmlFile;
        PomFile pomFile2 = PomFile.Companion.forFileOrNull(pomFile);
        if (pomFile2 == null) {
            return;
        }
        PomFile pom2 = pomFile2;
        String string = libraryDescriptor.getPreferredVersion();
        if (string == null && (string = libraryDescriptor.getMaxVersion()) == null) {
            string = libraryDescriptor.getMinVersion();
        }
        String version2 = string;
        MavenId mavenId = new MavenId(libraryDescriptor.getLibraryGroupId(), libraryDescriptor.getLibraryArtifactId(), version2);
        DependencyScope dependencyScope = libraryDescriptor.getPreferredScope();
        MavenArtifactScope scope2 = switch (dependencyScope == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dependencyScope.ordinal()]) {
            case 1 -> MavenArtifactScope.COMPILE;
            case 2 -> MavenArtifactScope.TEST;
            case 3 -> MavenArtifactScope.RUNTIME;
            case 4 -> MavenArtifactScope.PROVIDED;
            default -> MavenArtifactScope.COMPILE;
        };
        PomFile.addDependency$default(pom2, mavenId, scope2, null, false, null, 28, null);
    }

    @Override
    @Nullable
    public VirtualFile getBuildScriptFile(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        XmlFile xmlFile = this.findPomFile(module2);
        return xmlFile != null ? xmlFile.getVirtualFile() : null;
    }

    @Override
    public boolean isProjectSyncPending() {
        boolean isNotificationVisible = (Boolean)ExternalSystemProjectNotificationAware.Companion.isNotificationVisibleProperty(this.project, new ProjectSystemId("MAVEN")).get();
        return isNotificationVisible;
    }

    @Override
    public boolean isProjectSyncInProgress() {
        return false;
    }

    @Override
    public void startProjectSync() {
        ExternalSystemProjectTracker.Companion.getInstance(this.project).scheduleProjectRefresh();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DependencyScope.values().length];
            try {
                nArray[DependencyScope.COMPILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyScope.TEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyScope.RUNTIME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyScope.PROVIDED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

