/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SingleFileSourcesTracker;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonMoveClassesOrPackagesUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.FqNameUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2ChangePackageDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.K2ChangePackageRefactoringProcessor;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/PackageDirectoryMismatchInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ChangePackageFix", "MoveFileToPackageFix", "kotlin.code-insight.inspections.k2"})
public final class PackageDirectoryMismatchInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (KtVisitor)new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPackageDirective(@NotNull KtPackageDirective directive) {
                TextRange textRange;
                FqName fqNameWithImplicitPrefix;
                Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
                Project project2 = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                Project project3 = project2;
                KtFile ktFile2 = directive.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
                KtFile file2 = ktFile2;
                if (file2.getTextLength() == 0 || InjectedLanguageManager.getInstance((Project)project3).isInjectedFragment((PsiFile)file2) || PackageUtilsKt.packageMatchesDirectoryOrImplicit(file2)) {
                    return;
                }
                List fixes2 = new ArrayList<E>();
                String string = directive.getQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
                String qualifiedName2 = string;
                String dirName = ((CharSequence)qualifiedName2).length() == 0 ? KotlinBundle.message((String)"fix.move.file.to.package.dir.name.text", (Object[])new Object[0]) : "'" + StringsKt.replace$default((String)qualifiedName2, (char)'.', (char)'/', (boolean)false, (int)4, null) + "'";
                Project project4 = file2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                SingleFileSourcesTracker singleFileSourcesTracker = SingleFileSourcesTracker.Companion.getInstance(project4);
                VirtualFile virtualFile2 = file2.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
                boolean isSingleFileSource = singleFileSourcesTracker.isSingleFileSource(virtualFile2);
                if (!isSingleFileSource) {
                    ((Collection)fixes2).add(new MoveFileToPackageFix(dirName));
                }
                FqName fqNameByDirectory = PackageUtilsKt.getFqNameByDirectory((PsiFile)file2);
                if (fqNameByDirectory.isRoot()) {
                    ((Collection)fixes2).add(new ChangePackageFix(KotlinBundle.message((String)"fix.move.file.to.package.dir.name.text", (Object[])new Object[0]), fqNameByDirectory));
                } else if (FqNameUtils.hasIdentifiersOnly(fqNameByDirectory)) {
                    ((Collection)fixes2).add(new ChangePackageFix("'" + fqNameByDirectory.asString() + "'", fqNameByDirectory));
                }
                PsiDirectory psiDirectory = file2.getParent();
                Object object = fqNameWithImplicitPrefix = psiDirectory != null ? PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory) : null;
                if (!isSingleFileSource && fqNameWithImplicitPrefix != null && !Intrinsics.areEqual((Object)fqNameWithImplicitPrefix, (Object)fqNameByDirectory)) {
                    ((Collection)fixes2).add(new ChangePackageFix("'" + fqNameWithImplicitPrefix.asString() + "'", fqNameWithImplicitPrefix));
                }
                if (directive.getTextLength() != 0) {
                    textRange = directive.getTextRange();
                } else {
                    KtDeclaration ktDeclaration = (KtDeclaration)CollectionsKt.firstOrNull((List)file2.getDeclarations());
                    if (ktDeclaration != null) {
                        KtDeclaration it = ktDeclaration;
                        boolean bl = false;
                        textRange = TextRange.from((int)PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)), (int)1);
                    } else {
                        textRange = null;
                    }
                }
                TextRange textRange2 = textRange;
                Collection $this$toTypedArray$iv = fixes2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                this.$holder.registerProblem((PsiElement)file2, textRange2, KotlinBundle.message((String)"text.package.directive.dont.match.file.location", (Object[])new Object[0]), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/PackageDirectoryMismatchInspection$ChangePackageFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "packageName", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getPackageName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "getFamilyName", "getName", "startInWriteAction", "", "kotlin.code-insight.inspections.k2"})
    private static final class ChangePackageFix
    implements LocalQuickFix {
        @NotNull
        private final String packageName;
        @NotNull
        private final FqName packageFqName;

        public ChangePackageFix(@NotNull String packageName, @NotNull FqName packageFqName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            this.packageName = packageName;
            this.packageFqName = packageFqName;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"fix.change.package.family", (Object[])new Object[0]);
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.packageName};
            return KotlinBundle.message((String)"fix.change.package.text", (Object[])objectArray);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtFile ktFile2 = psiElement2 instanceof KtFile ? (KtFile)psiElement2 : null;
            if (ktFile2 == null) {
                return;
            }
            KtFile file2 = ktFile2;
            Project project3 = file2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            K2ChangePackageDescriptor changePkgDescriptor = new K2ChangePackageDescriptor(project3, SetsKt.setOf((Object)file2), this.packageFqName, false, false);
            new K2ChangePackageRefactoringProcessor(changePkgDescriptor).run();
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull ProblemDescriptor previewDescriptor) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
            PsiElement psiElement2 = previewDescriptor.getPsiElement();
            KtFile ktFile2 = psiElement2 instanceof KtFile ? (KtFile)psiElement2 : null;
            if (ktFile2 == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
                return intentionPreviewInfo;
            }
            KtFile file2 = ktFile2;
            KtPackageDirective ktPackageDirective = file2.getPackageDirective();
            if (ktPackageDirective == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
                return intentionPreviewInfo;
            }
            KtPackageDirective packageDirective = ktPackageDirective;
            packageDirective.setFqName(this.packageFqName);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
            return intentionPreviewInfo;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/PackageDirectoryMismatchInspection$MoveFileToPackageFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "dirName", "", "(Ljava/lang/String;)V", "getDirName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "startInWriteAction", "", "kotlin.code-insight.inspections.k2"})
    private static final class MoveFileToPackageFix
    implements LocalQuickFix {
        @NotNull
        private final String dirName;

        public MoveFileToPackageFix(@NotNull String dirName) {
            Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
            this.dirName = dirName;
        }

        @NotNull
        public final String getDirName() {
            return this.dirName;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"fix.move.file.to.package.family", (Object[])new Object[0]);
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.dirName};
            return KotlinBundle.message((String)"fix.move.file.to.package.text", (Object[])objectArray);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtFile ktFile2 = psiElement2 instanceof KtFile ? (KtFile)psiElement2 : null;
            if (ktFile2 == null) {
                return;
            }
            KtFile file2 = ktFile2;
            KtPackageDirective ktPackageDirective = file2.getPackageDirective();
            if (ktPackageDirective == null) {
                return;
            }
            KtPackageDirective directive = ktPackageDirective;
            Object object = GenericPsiUtils.getModule((PsiElement)file2);
            if (object == null || (object = PackageUtilsKt.findExistingNonGeneratedKotlinSourceRootFiles(object)) == null) {
                object = ProjectRootUtilsKt.getSuitableDestinationSourceRoots(project2);
            }
            Object sourceRoots2 = object;
            PackageWrapper packageWrapper = new PackageWrapper(PsiManager.getInstance((Project)project2), directive.getQualifiedName());
            PsiFile psiFile2 = directive.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
            PsiFile fileToMove = psiFile2;
            VirtualFile virtualFile2 = (VirtualFile)CollectionsKt.singleOrNull((List)sourceRoots2);
            if (virtualFile2 == null && (virtualFile2 = CommonMoveClassesOrPackagesUtil.chooseSourceRoot((PackageWrapper)packageWrapper, (List)sourceRoots2, (PsiDirectory)fileToMove.getContainingDirectory())) == null) {
                return;
            }
            VirtualFile chosenRoot = virtualFile2;
            AutocreatingSingleSourceRootMoveDestination targetDirFactory = new AutocreatingSingleSourceRootMoveDestination(packageWrapper, chosenRoot);
            String string = targetDirFactory.verify(fileToMove);
            if (string != null) {
                String it = string;
                boolean bl = false;
                Messages.showMessageDialog((Project)project2, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            Object object2 = (PsiDirectory)ActionsKt.runWriteAction((Function0)((Function0)new Function0<PsiDirectory>(targetDirFactory, fileToMove){
                final /* synthetic */ AutocreatingSingleSourceRootMoveDestination $targetDirFactory;
                final /* synthetic */ PsiFile $fileToMove;
                {
                    this.$targetDirFactory = $targetDirFactory;
                    this.$fileToMove = $fileToMove;
                    super(0);
                }

                public final PsiDirectory invoke() {
                    return this.$targetDirFactory.getTargetDirectory(this.$fileToMove);
                }
            }));
            if (object2 == null) {
                return;
            }
            PsiDirectory targetDirectory2 = object2;
            if ((object2 = RefactoringMessageUtil.checkCanCreateFile((PsiDirectory)targetDirectory2, (String)file2.getName())) != null) {
                Object it = object2;
                boolean bl = false;
                Messages.showMessageDialog((Project)project2, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(file2, targetDirectory2){
                final /* synthetic */ KtFile $file;
                final /* synthetic */ PsiDirectory $targetDirectory;
                {
                    this.$file = $file;
                    this.$targetDirectory = $targetDirectory;
                    super(0);
                }

                public final void invoke() {
                    MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)((PsiFile)this.$file), (PsiDirectory)this.$targetDirectory);
                }
            }));
        }
    }
}

