/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFixBase;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantVisibilityModifierInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Holder", "kotlin.idea"})
public final class RedundantVisibilityModifierInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)VisitorWrappersKt.declarationVisitor((Function1)((Function1)new Function1<KtDeclaration, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtDeclaration declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                PsiElement psiElement2 = KtPsiUtilKt.visibilityModifier((KtModifierListOwner)((KtModifierListOwner)declaration2));
                if (psiElement2 == null) {
                    return;
                }
                PsiElement visibilityModifier = psiElement2;
                KtModifierKeywordToken ktModifierKeywordToken = Holder.INSTANCE.getRedundantVisibility(declaration2, true);
                if (ktModifierKeywordToken == null) {
                    return;
                }
                KtModifierKeywordToken redundantVisibility = ktModifierKeywordToken;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new IntentionWrapper(new RemoveModifierFixBase((KtModifierListOwner)declaration2, redundantVisibility, true).asIntention())};
                this.$holder.registerProblem(visibilityModifier, KotlinBundle.message((String)"redundant.visibility.modifier", (Object[])new Object[0]), localQuickFixArray);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\f\u0010\n\u001a\u00020\b*\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantVisibilityModifierInspection$Holder;", "", "()V", "getRedundantVisibility", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "skipGetters", "", "isVisibilityNeededForExplicitApiMode", "isInsideLocalOrPrivate", "setterVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nRedundantVisibilityModifierInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantVisibilityModifierInspection.kt\norg/jetbrains/kotlin/idea/inspections/RedundantVisibilityModifierInspection$Holder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
    public static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();

        private Holder() {
        }

        @Nullable
        public final KtModifierKeywordToken getRedundantVisibility(@NotNull KtDeclaration declaration2, boolean skipGetters) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            if (skipGetters && declaration2 instanceof KtPropertyAccessor && ((KtPropertyAccessor)declaration2).isGetter()) {
                return null;
            }
            PsiElement psiElement2 = KtPsiUtilKt.visibilityModifier((KtModifierListOwner)((KtModifierListOwner)declaration2));
            if (psiElement2 == null) {
                return null;
            }
            PsiElement visibilityModifier = psiElement2;
            if (this.isVisibilityNeededForExplicitApiMode(declaration2)) {
                return null;
            }
            KtModifierKeywordToken implicitVisibility2 = PsiModificationUtilsKt.implicitVisibility(declaration2);
            Object object = Intrinsics.areEqual((Object)visibilityModifier.getNode().getElementType(), (Object)implicitVisibility2) ? implicitVisibility2 : (declaration2.hasModifier(KtTokens.INTERNAL_KEYWORD) && this.isInsideLocalOrPrivate(declaration2) ? KtTokens.INTERNAL_KEYWORD : null);
            if (object == null) {
                return null;
            }
            KtModifierKeywordToken redundantVisibility = object;
            if (Intrinsics.areEqual((Object)redundantVisibility, (Object)KtTokens.PUBLIC_KEYWORD) && declaration2 instanceof KtProperty && declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD) && ((KtProperty)declaration2).isVar()) {
                DescriptorVisibility it = this.setterVisibility((KtProperty)declaration2);
                boolean bl = false;
                boolean bl2 = it != null && !Intrinsics.areEqual((Object)it, (Object)DescriptorVisibilities.PUBLIC);
                if (bl2) {
                    return null;
                }
            }
            return redundantVisibility;
        }

        public static /* synthetic */ KtModifierKeywordToken getRedundantVisibility$default(Holder holder, KtDeclaration ktDeclaration, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return holder.getRedundantVisibility(ktDeclaration, bl);
        }

        private final boolean isInsideLocalOrPrivate(KtDeclaration $this$isInsideLocalOrPrivate) {
            boolean bl;
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)$this$isInsideLocalOrPrivate);
            if (ktClassOrObject != null) {
                KtClassOrObject it = ktClassOrObject;
                boolean bl2 = false;
                bl = it.isLocal() || KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)it));
            } else {
                bl = false;
            }
            return bl;
        }

        private final boolean isVisibilityNeededForExplicitApiMode(KtDeclaration declaration2) {
            boolean isExplicitApiMode;
            boolean bl = isExplicitApiMode = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)declaration2).getFlag(AnalysisFlags.getExplicitApiMode()) != ExplicitApiMode.DISABLED;
            if (!isExplicitApiMode) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(declaration2, null, 1, null);
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = declarationDescriptor instanceof DeclarationDescriptorWithVisibility ? (DeclarationDescriptorWithVisibility)declarationDescriptor : null;
            return declarationDescriptorWithVisibility != null ? DescriptorUtilsKt.isEffectivelyPublicApi((DeclarationDescriptorWithVisibility)declarationDescriptorWithVisibility) : false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final DescriptorVisibility setterVisibility(KtProperty $this$setterVisibility) {
            PropertyDescriptor propertyDescriptor;
            PropertySetterDescriptor propertySetterDescriptor;
            DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)$this$setterVisibility);
            if (!(declarationDescriptor instanceof PropertyDescriptor)) return null;
            PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)declarationDescriptor;
            if (propertyDescriptor2 == null) {
                return null;
            }
            PropertyDescriptor descriptor2 = propertyDescriptor2;
            KtPropertyAccessor ktPropertyAccessor = $this$setterVisibility.getSetter();
            if ((ktPropertyAccessor != null ? KtPsiUtilKt.visibilityModifier((KtModifierListOwner)((KtModifierListOwner)ktPropertyAccessor)) : null) != null) {
                DescriptorVisibility visibility2;
                PropertySetterDescriptor propertySetterDescriptor2 = descriptor2.getSetter();
                Object object = visibility2 = propertySetterDescriptor2 != null ? propertySetterDescriptor2.getVisibility() : null;
                if (visibility2 != null) {
                    return visibility2;
                }
            }
            if (!(descriptor2 instanceof CallableMemberDescriptor)) return null;
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)descriptor2;
            CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
            if (callableMemberDescriptor2 == null) return null;
            Collection collection = callableMemberDescriptor2.getOverriddenDescriptors();
            if (collection == null) return null;
            Iterator iterator2 = ((Iterable)collection).iterator();
            do {
                if (!iterator2.hasNext()) return null;
                CallableMemberDescriptor callableMemberDescriptor3 = (CallableMemberDescriptor)iterator2.next();
                boolean bl = false;
                propertyDescriptor = callableMemberDescriptor3 instanceof PropertyDescriptor ? (PropertyDescriptor)callableMemberDescriptor3 : null;
            } while ((propertySetterDescriptor = propertyDescriptor != null ? propertyDescriptor.getSetter() : null) == null);
            PropertySetterDescriptor propertySetterDescriptor3 = propertySetterDescriptor;
            PropertySetterDescriptor propertySetterDescriptor4 = propertySetterDescriptor3;
            if (propertySetterDescriptor4 == null) return null;
            DescriptorVisibility descriptorVisibility = propertySetterDescriptor4.getVisibility();
            return descriptorVisibility;
        }
    }
}

