/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionSourceAsContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleJava.ErrorGradleScriptDefinition;
import org.jetbrains.kotlin.idea.gradleJava.ScriptDefinitionsUtilsKt;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.Imported;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.WithoutScriptModels;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0002 !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\"\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u001c\u001a\u00020\u0015H\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\fH\u0002J\f\u0010\u001f\u001a\u00020\u0015*\u00020\fH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u00020\u000f8\u0016X\u0097D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor;", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionSourceAsContributor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "definitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getDefinitions", "()Lkotlin/sequences/Sequence;", "definitionsByRoots", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor$LightGradleBuildRoot;", "", "id", "", "getId$annotations", "()V", "getId", "()Ljava/lang/String;", "forceReload", "", "loadGradleDefinitions", "root", "reloadIfNeeded", "workingDir", "gradleHome", "javaHome", "subscribeToGradleSettingChanges", "isError", "", "markAsError", "Companion", "LightGradleBuildRoot", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nGradleScriptDefinitionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleScriptDefinitionsProvider.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,174:1\n1747#2,3:175\n1855#2,2:187\n526#3:178\n511#3,6:179\n215#4,2:185\n76#4:189\n96#4,5:190\n*S KotlinDebug\n*F\n+ 1 GradleScriptDefinitionsProvider.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor\n*L\n82#1:175,3\n149#1:187,2\n101#1:178\n101#1:179,6\n103#1:185,2\n169#1:189\n169#1:190,5\n*E\n"})
public final class GradleScriptDefinitionsContributor
implements ScriptDefinitionSourceAsContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String id;
    @NotNull
    private final ConcurrentHashMap<LightGradleBuildRoot, List<ScriptDefinition>> definitionsByRoots;

    public GradleScriptDefinitionsContributor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.subscribeToGradleSettingChanges();
        this.id = "Gradle Kotlin DSL";
        this.definitionsByRoots = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Deprecated(message="migrating to new configuration refinement: drop usages")
    public static /* synthetic */ void getId$annotations() {
    }

    private final void markAsError(LightGradleBuildRoot $this$markAsError) {
        ((Map)this.definitionsByRoots).put($this$markAsError, CollectionsKt.listOf((Object)((Object)new ErrorGradleScriptDefinition(this.project, null, 2, null))));
    }

    private final boolean isError(LightGradleBuildRoot $this$isError) {
        boolean bl;
        block5: {
            List<ScriptDefinition> list2 = this.definitionsByRoots.get($this$isError);
            if (list2 != null) {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ScriptDefinition it = (ScriptDefinition)((Object)element$iv);
                        boolean bl2 = false;
                        if (!(it instanceof ErrorGradleScriptDefinition)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void forceReload() {
        Enumeration<LightGradleBuildRoot> enumeration = this.definitionsByRoots.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
        Iterator iterator2 = CollectionsKt.iterator(enumeration);
        while (iterator2.hasNext()) {
            LightGradleBuildRoot key = (LightGradleBuildRoot)iterator2.next();
            Intrinsics.checkNotNull((Object)key);
            this.markAsError(key);
        }
        ScriptDefinitionsManager.Companion.getInstance(this.project).reloadDefinitionsBy(this);
    }

    /*
     * WARNING - void declaration
     */
    public final void reloadIfNeeded(@NotNull String workingDir, @Nullable String gradleHome2, @Nullable String javaHome) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        LightGradleBuildRoot root = new LightGradleBuildRoot(workingDir, gradleHome2, javaHome);
        List<ScriptDefinition> value2 = this.definitionsByRoots.get(root);
        if (value2 != null) {
            if (this.isError(root)) {
                ScriptDefinitionsManager.Companion.getInstance(this.project).reloadDefinitionsBy(this);
            }
        } else {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = this.definitionsByRoots;
            boolean $i$f$filter = false;
            Object object = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((LightGradleBuildRoot)it.getKey()).getWorkingDir(), (Object)workingDir)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map rootWithChangedGradleHome = destination$iv$iv;
            if (!rootWithChangedGradleHome.isEmpty()) {
                Map $this$forEach$iv = rootWithChangedGradleHome;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = (Map.Entry)object.next();
                    boolean bl = false;
                    this.definitionsByRoots.remove(it.getKey());
                }
            }
            this.markAsError(root);
            ScriptDefinitionsManager.Companion.getInstance(this.project).reloadDefinitionsBy(this);
        }
    }

    private final List<ScriptDefinition> loadGradleDefinitions(LightGradleBuildRoot root) {
        return ScriptDefinitionsUtilsKt.loadGradleDefinitions(root.getWorkingDir(), root.getGradleHome(), root.getJavaHome(), this.project);
    }

    private final void subscribeToGradleSettingChanges() {
        GradleSettingsListener listener2 = new GradleSettingsListener(this){
            final /* synthetic */ GradleScriptDefinitionsContributor this$0;
            {
                this.this$0 = $receiver;
            }

            public void onGradleVmOptionsChange(@Nullable String oldOptions, @Nullable String newOptions) {
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }

            public void onGradleHomeChange(@Nullable String oldPath, @Nullable String newPath, @NotNull String linkedProjectPath) {
                Intrinsics.checkNotNullParameter((Object)linkedProjectPath, (String)"linkedProjectPath");
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }

            public void onServiceDirectoryPathChange(@Nullable String oldPath, @Nullable String newPath) {
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }

            public void onGradleDistributionTypeChange(@Nullable DistributionType currentValue, @NotNull String linkedProjectPath) {
                Intrinsics.checkNotNullParameter((Object)linkedProjectPath, (String)"linkedProjectPath");
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }
        };
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = GradleSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)listener2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Sequence<ScriptDefinition> getDefinitions() {
        Object $this$forEach$iv;
        Enumeration<LightGradleBuildRoot> enumeration = this.definitionsByRoots.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
        CollectionsKt.iterator(enumeration).forEachRemaining(arg_0 -> GradleScriptDefinitionsContributor._get_definitions_$lambda$3((Function1)new Function1<LightGradleBuildRoot, Unit>(this){
            final /* synthetic */ GradleScriptDefinitionsContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(LightGradleBuildRoot root) {
                Intrinsics.checkNotNull((Object)root);
                if (GradleScriptDefinitionsContributor.access$isError(this.this$0, root)) {
                    ((Map)GradleScriptDefinitionsContributor.access$getDefinitionsByRoots$p(this.this$0)).put(root, GradleScriptDefinitionsContributor.access$loadGradleDefinitions(this.this$0, root));
                }
            }
        }, arg_0));
        if (this.definitionsByRoots.isEmpty()) {
            Object object = GradleBuildRootsManager.Companion.getInstance(this.project);
            if (object != null && (object = ((GradleBuildRootsLocator)object).getAllRoots()) != null) {
                $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair pair;
                    Object element$iv = iterator2.next();
                    GradleBuildRoot it = (GradleBuildRoot)element$iv;
                    boolean bl = false;
                    String workingDir = it.getPathPrefix();
                    GradleBuildRoot gradleBuildRoot = it;
                    if (gradleBuildRoot instanceof Imported) {
                        pair = TuplesKt.to((Object)((Imported)it).getData().getGradleHome(), (Object)((Imported)it).getData().getJavaHome());
                    } else if (gradleBuildRoot instanceof WithoutScriptModels) {
                        GradleExecutionSettings settings2 = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)this.project, (String)workingDir, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                        pair = TuplesKt.to((Object)settings2.getGradleHome(), (Object)settings2.getJavaHome());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    Pair pair2 = pair;
                    String gradleHome2 = (String)pair2.component1();
                    String javaHome = (String)pair2.component2();
                    LightGradleBuildRoot root = new LightGradleBuildRoot(workingDir, gradleHome2, javaHome);
                    ((Map)this.definitionsByRoots).put(root, this.loadGradleDefinitions(root));
                }
            }
        }
        if (!((Map)this.definitionsByRoots).isEmpty()) {
            void $this$flatMapTo$iv$iv;
            Map $this$flatMap$iv = this.definitionsByRoots;
            boolean $i$f$flatMap = false;
            $this$forEach$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator3 = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator3.next();
                boolean bl = false;
                Iterable list$iv$iv = (List)it.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
        }
        ErrorGradleScriptDefinition[] errorGradleScriptDefinitionArray = new ErrorGradleScriptDefinition[]{new ErrorGradleScriptDefinition(this.project, null, 2, null)};
        return SequencesKt.sequenceOf((Object[])errorGradleScriptDefinitionArray);
    }

    private static final void _get_definitions_$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$forceReload(GradleScriptDefinitionsContributor $this) {
        $this.forceReload();
    }

    public static final /* synthetic */ List access$loadGradleDefinitions(GradleScriptDefinitionsContributor $this, LightGradleBuildRoot root) {
        return $this.loadGradleDefinitions(root);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor$Companion;", "", "()V", "getDefinitions", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "project", "Lcom/intellij/openapi/project/Project;", "workingDir", "", "gradleHome", "javaHome", "kotlin.gradle.gradle-java"})
    @SourceDebugExtension(value={"SMAP\nGradleScriptDefinitionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleScriptDefinitionsProvider.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n800#2,11:175\n*S KotlinDebug\n*F\n+ 1 GradleScriptDefinitionsProvider.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor$Companion\n*L\n31#1:175,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<ScriptDefinition> getDefinitions(@NotNull Project project2, @NotNull String workingDir, @Nullable String gradleHome2, @Nullable String javaHome) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            Iterable iterable = ScriptDefinitionContributor.Companion.getEP_NAME().getExtensions((AreaInstance)project2);
            boolean $i$f$filterIsInstance = false;
            void var8_8 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof GradleScriptDefinitionsContributor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            GradleScriptDefinitionsContributor contributor = (GradleScriptDefinitionsContributor)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            if (contributor == null) {
                ScriptUtilsKt.scriptingInfoLog("cannot find gradle script definitions contributor in ScriptDefinitionContributor.EP_NAME list: workingDir=" + workingDir + " gradleHome=" + gradleHome2);
                return null;
            }
            if (gradleHome2 == null) {
                ScriptUtilsKt.scriptingInfoLog(KotlinIdeaGradleBundle.message("error.text.unable.to.get.gradle.home.directory", new Object[0]) + ": workingDir=" + workingDir);
                return null;
            }
            LightGradleBuildRoot root = new LightGradleBuildRoot(workingDir, gradleHome2, javaHome);
            GradleScriptDefinitionsContributor $this$getDefinitions_u24lambda_u240 = contributor;
            boolean bl = false;
            if ($this$getDefinitions_u24lambda_u240.isError(root)) {
                return null;
            }
            contributor.reloadIfNeeded(workingDir, gradleHome2, javaHome);
            List definitions2 = (List)contributor.definitionsByRoots.get(root);
            if (definitions2 == null) {
                ScriptUtilsKt.scriptingInfoLog("script definitions aren't loaded yet. They should be loaded by invoking GradleScriptDefinitionsContributor.reloadIfNeeded from KotlinDslSyncListener: workingDir=" + workingDir + " gradleHome=" + gradleHome2);
                return null;
            }
            return definitions2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor$LightGradleBuildRoot;", "", "workingDir", "", "gradleHome", "javaHome", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGradleHome", "()Ljava/lang/String;", "getJavaHome", "getWorkingDir", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.gradle.gradle-java"})
    public static final class LightGradleBuildRoot {
        @NotNull
        private final String workingDir;
        @Nullable
        private final String gradleHome;
        @Nullable
        private final String javaHome;

        public LightGradleBuildRoot(@NotNull String workingDir, @Nullable String gradleHome2, @Nullable String javaHome) {
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            this.workingDir = workingDir;
            this.gradleHome = gradleHome2;
            this.javaHome = javaHome;
        }

        @NotNull
        public final String getWorkingDir() {
            return this.workingDir;
        }

        @Nullable
        public final String getGradleHome() {
            return this.gradleHome;
        }

        @Nullable
        public final String getJavaHome() {
            return this.javaHome;
        }

        @NotNull
        public final String component1() {
            return this.workingDir;
        }

        @Nullable
        public final String component2() {
            return this.gradleHome;
        }

        @Nullable
        public final String component3() {
            return this.javaHome;
        }

        @NotNull
        public final LightGradleBuildRoot copy(@NotNull String workingDir, @Nullable String gradleHome2, @Nullable String javaHome) {
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            return new LightGradleBuildRoot(workingDir, gradleHome2, javaHome);
        }

        public static /* synthetic */ LightGradleBuildRoot copy$default(LightGradleBuildRoot lightGradleBuildRoot, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = lightGradleBuildRoot.workingDir;
            }
            if ((n & 2) != 0) {
                string2 = lightGradleBuildRoot.gradleHome;
            }
            if ((n & 4) != 0) {
                string3 = lightGradleBuildRoot.javaHome;
            }
            return lightGradleBuildRoot.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "LightGradleBuildRoot(workingDir=" + this.workingDir + ", gradleHome=" + this.gradleHome + ", javaHome=" + this.javaHome + ")";
        }

        public int hashCode() {
            int result2 = this.workingDir.hashCode();
            result2 = result2 * 31 + (this.gradleHome == null ? 0 : this.gradleHome.hashCode());
            result2 = result2 * 31 + (this.javaHome == null ? 0 : this.javaHome.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof LightGradleBuildRoot)) {
                return false;
            }
            LightGradleBuildRoot lightGradleBuildRoot = (LightGradleBuildRoot)other2;
            if (!Intrinsics.areEqual((Object)this.workingDir, (Object)lightGradleBuildRoot.workingDir)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gradleHome, (Object)lightGradleBuildRoot.gradleHome)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.javaHome, (Object)lightGradleBuildRoot.javaHome);
        }
    }
}

