/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleCodeInsightCommon;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.KotlinGradleCodeInsightUtils;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a+\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\t\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0011\u001a'\u0010\u0014\u001a\u0004\u0018\u00010\u0006*\u00020\u000f2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\t\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\u0011*\u00020\u000f\u001a'\u0010\u0017\u001a\u0004\u0018\u00010\u0006*\u00020\u000f2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\t\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u0011*\u00020\u000f\u001a\u001b\u0010\u0019\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u001a*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\f\u0010\u001d\u001a\u0004\u0018\u00010\u0011*\u00020\u001c\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u0011*\u00020\u000f\"\u0010\u0010\u0000\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0003\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"DEFAULT_SCRIPT_NAME", "", "KOTLIN_BUILD_SCRIPT_NAME", "KOTLIN_SETTINGS_SCRIPT_NAME", "SETTINGS_FILE_NAME", "findBuildGradleFile", "Ljava/nio/file/Path;", "path", "fileNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "findGradleProjectStructure", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "canBeConfigured", "", "getBuildScriptFile", "(Lcom/intellij/openapi/module/Module;[Ljava/lang/String;)Ljava/nio/file/Path;", "getBuildScriptPsiFile", "getBuildScriptSettingsFile", "getBuildScriptSettingsPsiFile", "getPsiFile", "Lorg/jetbrains/annotations/Nullable;", "project", "Lcom/intellij/openapi/project/Project;", "getTopLevelBuildScriptPsiFile", "getTopLevelBuildScriptSettingsPsiFile", "kotlin.gradle.code-insight-common"})
@JvmName(name="KotlinGradleCodeInsightUtils")
@SourceDebugExtension(value={"SMAP\nKotlinGradleCodeInsightUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleCodeInsightUtils.kt\norg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinGradleCodeInsightUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,108:1\n1#2:109\n179#3,2:110\n*S KotlinDebug\n*F\n+ 1 KotlinGradleCodeInsightUtils.kt\norg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinGradleCodeInsightUtils\n*L\n102#1:110,2\n*E\n"})
public final class KotlinGradleCodeInsightUtils {
    @NonNls
    @NotNull
    private static final String DEFAULT_SCRIPT_NAME = "build.gradle";
    @NonNls
    @NotNull
    private static final String SETTINGS_FILE_NAME = "settings.gradle";
    @NonNls
    @NotNull
    private static final String KOTLIN_BUILD_SCRIPT_NAME = "build.gradle.kts";
    @NonNls
    @NotNull
    private static final String KOTLIN_SETTINGS_SCRIPT_NAME = "settings.gradle.kts";

    @Nullable
    public static final DataNode<ProjectData> findGradleProjectStructure(@NotNull PsiFile file2) {
        DataNode<ProjectData> dataNode;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2.getVirtualFile(), (Project)file2.getProject());
        if (module2 != null) {
            Module it = module2;
            boolean bl = false;
            dataNode = KotlinGradleCodeInsightUtils.findGradleProjectStructure(it);
        } else {
            dataNode = null;
        }
        return dataNode;
    }

    @Nullable
    public static final DataNode<ProjectData> findGradleProjectStructure(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module2);
        if (string == null) {
            return null;
        }
        String externalProjectPath = string;
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)module2.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)externalProjectPath);
        if (externalProjectInfo == null) {
            return null;
        }
        ExternalProjectInfo projectInfo = externalProjectInfo;
        return projectInfo.getExternalProjectStructure();
    }

    @Nullable
    public static final PsiFile getBuildScriptPsiFile(@NotNull Module $this$getBuildScriptPsiFile) {
        PsiFile psiFile2;
        Intrinsics.checkNotNullParameter((Object)$this$getBuildScriptPsiFile, (String)"<this>");
        String[] stringArray = new String[]{DEFAULT_SCRIPT_NAME, KOTLIN_BUILD_SCRIPT_NAME};
        Path path2 = KotlinGradleCodeInsightUtils.getBuildScriptFile($this$getBuildScriptPsiFile, stringArray);
        if (path2 != null) {
            Project project2 = $this$getBuildScriptPsiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            psiFile2 = KotlinGradleCodeInsightUtils.getPsiFile(path2, project2);
        } else {
            psiFile2 = null;
        }
        return psiFile2;
    }

    @Nullable
    public static final PsiFile getBuildScriptSettingsPsiFile(@NotNull Module $this$getBuildScriptSettingsPsiFile) {
        PsiFile psiFile2;
        Intrinsics.checkNotNullParameter((Object)$this$getBuildScriptSettingsPsiFile, (String)"<this>");
        String[] stringArray = new String[]{SETTINGS_FILE_NAME, KOTLIN_SETTINGS_SCRIPT_NAME};
        Path path2 = KotlinGradleCodeInsightUtils.getBuildScriptSettingsFile($this$getBuildScriptSettingsPsiFile, stringArray);
        if (path2 != null) {
            Project project2 = $this$getBuildScriptSettingsPsiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            psiFile2 = KotlinGradleCodeInsightUtils.getPsiFile(path2, project2);
        } else {
            psiFile2 = null;
        }
        return psiFile2;
    }

    @Nullable
    public static final PsiFile getTopLevelBuildScriptPsiFile(@NotNull Project $this$getTopLevelBuildScriptPsiFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getTopLevelBuildScriptPsiFile, (String)"<this>");
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)$this$getTopLevelBuildScriptPsiFile);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile projectDir = virtualFile2;
        String string = projectDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String[] stringArray = new String[]{DEFAULT_SCRIPT_NAME, KOTLIN_BUILD_SCRIPT_NAME};
        Path path2 = KotlinGradleCodeInsightUtils.findBuildGradleFile(string, stringArray);
        return path2 != null ? KotlinGradleCodeInsightUtils.getPsiFile(path2, $this$getTopLevelBuildScriptPsiFile) : null;
    }

    @Nullable
    public static final PsiFile getTopLevelBuildScriptSettingsPsiFile(@NotNull Module $this$getTopLevelBuildScriptSettingsPsiFile) {
        PsiFile psiFile2;
        Intrinsics.checkNotNullParameter((Object)$this$getTopLevelBuildScriptSettingsPsiFile, (String)"<this>");
        String string = ExternalSystemApiUtil.getExternalRootProjectPath((Module)$this$getTopLevelBuildScriptSettingsPsiFile);
        if (string == null) {
            return null;
        }
        String externalProjectPath = string;
        String[] stringArray = new String[]{SETTINGS_FILE_NAME, KOTLIN_SETTINGS_SCRIPT_NAME};
        Path path2 = KotlinGradleCodeInsightUtils.findBuildGradleFile(externalProjectPath, stringArray);
        if (path2 != null) {
            Project project2 = $this$getTopLevelBuildScriptSettingsPsiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            psiFile2 = KotlinGradleCodeInsightUtils.getPsiFile(path2, project2);
        } else {
            psiFile2 = null;
        }
        return psiFile2;
    }

    private static final Path getBuildScriptFile(Module $this$getBuildScriptFile, String ... fileNames) {
        Path it2;
        Path path2 = $this$getBuildScriptFile.getModuleNioFile().getParent();
        if (path2 != null) {
            Path moduleDir = path2;
            boolean bl = false;
            Path path3 = KotlinGradleCodeInsightUtils.findBuildGradleFile(((Object)moduleDir).toString(), Arrays.copyOf(fileNames, fileNames.length));
            if (path3 != null) {
                Path it2 = path3;
                boolean bl2 = false;
                return it2;
            }
        }
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)$this$getBuildScriptFile).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        for (VirtualFile contentRoot : virtualFileArray) {
            String string = contentRoot.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            it2 = KotlinGradleCodeInsightUtils.findBuildGradleFile(string, Arrays.copyOf(fileNames, fileNames.length));
            if (it2 == null) continue;
            Path it3 = it2;
            boolean bl = false;
            return it3;
        }
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)$this$getBuildScriptFile);
        if (string != null) {
            String externalProjectPath = string;
            boolean bl = false;
            Path path4 = KotlinGradleCodeInsightUtils.findBuildGradleFile(externalProjectPath, Arrays.copyOf(fileNames, fileNames.length));
            if (path4 != null) {
                it2 = path4;
                boolean bl3 = false;
                return it2;
            }
        }
        return null;
    }

    private static final Path getBuildScriptSettingsFile(Module $this$getBuildScriptSettingsFile, String ... fileNames) {
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)$this$getBuildScriptSettingsFile);
        if (string != null) {
            String externalProjectPath = string;
            boolean bl = false;
            return (Path)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)externalProjectPath, (Function1)getBuildScriptSettingsFile.1.1.INSTANCE), (Function1)((Function1)new Function1<String, Path>(fileNames){
                final /* synthetic */ String[] $fileNames;
                {
                    this.$fileNames = $fileNames;
                    super(1);
                }

                @Nullable
                public final Path invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return KotlinGradleCodeInsightUtils.access$findBuildGradleFile(it, Arrays.copyOf(this.$fileNames, this.$fileNames.length));
                }
            })));
        }
        return null;
    }

    private static final Path findBuildGradleFile(String path2, String ... fileNames) {
        Object v1;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])fileNames), (Function1)((Function1)new Function1<String, Path>(path2){
                final /* synthetic */ String $path;
                {
                    this.$path = $path;
                    super(1);
                }

                @NotNull
                public final Path invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Path path2 = Paths.get(this.$path + "/" + it, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    return path2;
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path p0 = (Path)element$iv;
                boolean $i$f$findBuildGradleFile$exists = false;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(p0, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final PsiFile getPsiFile(Path $this$getPsiFile, Project project2) {
        PsiFile psiFile2;
        VirtualFile virtualFile2 = VfsUtil.findFile((Path)$this$getPsiFile, (boolean)true);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            psiFile2 = PsiManager.getInstance((Project)project2).findFile(it);
        } else {
            psiFile2 = null;
        }
        return psiFile2;
    }

    public static final boolean canBeConfigured(@NotNull PsiFile $this$canBeConfigured) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeConfigured, (String)"<this>");
        return WritingAccessProvider.isPotentiallyWritable((VirtualFile)$this$canBeConfigured.getVirtualFile(), null);
    }

    public static final /* synthetic */ Path access$findBuildGradleFile(String path2, String ... fileNames) {
        return KotlinGradleCodeInsightUtils.findBuildGradleFile(path2, fileNames);
    }
}

