/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stackFrame;

import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineScopeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.VariableWithLocation;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackFrame;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackFrameProxyKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackTraceCalculatorKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrame;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.LambdaName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u0014\u00101\u001a\b\u0012\u0004\u0012\u0002020(2\u0006\u00103\u001a\u000204R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0011\"\u0004\b&\u0010\u001dR\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010+\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo;", "", "scopeVariable", "Lorg/jetbrains/kotlin/idea/debugger/core/VariableWithLocation;", "enclosingStackFrame", "visibleVariablesWithLocations", "", "depth", "", "(Lorg/jetbrains/kotlin/idea/debugger/core/VariableWithLocation;Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo;Ljava/util/List;I)V", "callLocation", "Lcom/sun/jdi/Location;", "getCallLocation", "()Lcom/sun/jdi/Location;", "setCallLocation", "(Lcom/sun/jdi/Location;)V", "getDepth", "()I", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "getEnclosingStackFrame", "()Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo;", "setEnclosingStackFrame", "(Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo;)V", "inlineScopeNumber", "getInlineScopeNumber", "setInlineScopeNumber", "(I)V", "lambdaDetails", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/LambdaName;", "getLambdaDetails", "()Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/LambdaName;", "getScopeVariable", "()Lorg/jetbrains/kotlin/idea/debugger/core/VariableWithLocation;", "surroundingScopeNumber", "getSurroundingScopeNumber", "setSurroundingScopeNumber", "visibleVariables", "", "Lcom/sun/jdi/LocalVariable;", "getVisibleVariables", "()Ljava/util/List;", "getVisibleVariablesWithLocations", "toXStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "descriptor", "Lcom/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl;", "visibleVariableProxies", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nInlineStackTraceCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineStackTraceCalculator.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,507:1\n1620#2,3:508\n1549#2:511\n1620#2,3:512\n*S KotlinDebug\n*F\n+ 1 InlineStackTraceCalculator.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo\n*L\n94#1:508,3\n100#1:511\n100#1:512,3\n*E\n"})
public final class KotlinStackFrameInfo {
    @Nullable
    private final VariableWithLocation scopeVariable;
    @Nullable
    private KotlinStackFrameInfo enclosingStackFrame;
    @NotNull
    private final List<VariableWithLocation> visibleVariablesWithLocations;
    private final int depth;
    @Nullable
    private Location callLocation;
    private int inlineScopeNumber;
    private int surroundingScopeNumber;

    public KotlinStackFrameInfo(@Nullable VariableWithLocation scopeVariable, @Nullable KotlinStackFrameInfo enclosingStackFrame, @NotNull List<VariableWithLocation> visibleVariablesWithLocations, int depth2) {
        Intrinsics.checkNotNullParameter(visibleVariablesWithLocations, (String)"visibleVariablesWithLocations");
        this.scopeVariable = scopeVariable;
        this.enclosingStackFrame = enclosingStackFrame;
        this.visibleVariablesWithLocations = visibleVariablesWithLocations;
        this.depth = depth2;
        this.inlineScopeNumber = -1;
        this.surroundingScopeNumber = -1;
    }

    @Nullable
    public final VariableWithLocation getScopeVariable() {
        return this.scopeVariable;
    }

    @Nullable
    public final KotlinStackFrameInfo getEnclosingStackFrame() {
        return this.enclosingStackFrame;
    }

    public final void setEnclosingStackFrame(@Nullable KotlinStackFrameInfo kotlinStackFrameInfo) {
        this.enclosingStackFrame = kotlinStackFrameInfo;
    }

    @NotNull
    public final List<VariableWithLocation> getVisibleVariablesWithLocations() {
        return this.visibleVariablesWithLocations;
    }

    public final int getDepth() {
        return this.depth;
    }

    @Nullable
    public final Location getCallLocation() {
        return this.callLocation;
    }

    public final void setCallLocation(@Nullable Location location2) {
        this.callLocation = location2;
    }

    public final int getInlineScopeNumber() {
        return this.inlineScopeNumber;
    }

    public final void setInlineScopeNumber(int n) {
        this.inlineScopeNumber = n;
    }

    public final int getSurroundingScopeNumber() {
        return this.surroundingScopeNumber;
    }

    public final void setSurroundingScopeNumber(int n) {
        this.surroundingScopeNumber = n;
    }

    @Nullable
    public final String getDisplayName() {
        Object object = this.scopeVariable;
        if (object == null || (object = ((VariableWithLocation)object).getName()) == null || (object = InlineScopeUtilsKt.dropInlineScopeInfo((String)object)) == null) {
            return null;
        }
        Object scopeVariableName = object;
        if (StringsKt.startsWith$default((String)scopeVariableName, (String)"$i$f$", (boolean)false, (int)2, null)) {
            return StringsKt.substringAfter$default((String)scopeVariableName, (String)"$i$f$", null, (int)2, null);
        }
        LambdaName lambdaName = this.getLambdaDetails();
        if (lambdaName != null) {
            LambdaName it = lambdaName;
            boolean bl = false;
            return "lambda '" + it.getInlineFunctionName() + "' in '" + it.getDeclarationFunctionName() + "'";
        }
        return scopeVariableName;
    }

    @Nullable
    public final LambdaName getLambdaDetails() {
        Object object = this.scopeVariable;
        if (object == null || (object = ((VariableWithLocation)object).getName()) == null) {
            return null;
        }
        Object scopeVariableName = object;
        MatchResult matchResult2 = InlineStackTraceCalculatorKt.access$getINLINE_LAMBDA_REGEX$p().matchEntire((CharSequence)scopeVariableName);
        if (matchResult2 == null) {
            return null;
        }
        MatchResult match2 = matchResult2;
        MatchResult.Destructured destructured = match2.getDestructured();
        String inlineFunctionName = (String)destructured.getMatch().getGroupValues().get(1);
        String declarationFunctionName = (String)destructured.getMatch().getGroupValues().get(2);
        return new LambdaName(inlineFunctionName, declarationFunctionName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalVariable> getVisibleVariables() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this.visibleVariablesWithLocations;
        Object object = this.enclosingStackFrame;
        if (object == null || (object = ((KotlinStackFrameInfo)object).getVisibleVariables()) == null || (object = CollectionsKt.toMutableList((Collection)((Collection)object))) == null) {
            object = new ArrayList();
        }
        Collection destination$iv = (Collection)object;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            VariableWithLocation variableWithLocation = (VariableWithLocation)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getVariable());
        }
        return StackFrameUtilsKt.filterRepeatedVariables((List)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalVariableProxyImpl> visibleVariableProxies(@NotNull StackFrameProxyImpl frameProxy) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        Iterable $this$map$iv = this.getVisibleVariables();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalVariable localVariable = (LocalVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LocalVariableProxyImpl(frameProxy, (LocalVariable)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final XStackFrame toXStackFrame(@NotNull StackFrameDescriptorImpl descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        StackFrameProxyImpl stackFrameProxyImpl = descriptor2.getFrameProxy();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"getFrameProxy(...)");
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        List<LocalVariableProxyImpl> variables2 = this.visibleVariableProxies(frameProxy);
        String string = this.getDisplayName();
        if (string != null) {
            String name2 = string;
            boolean bl = false;
            return (XStackFrame)new InlineStackFrame(this.callLocation, name2, frameProxy, this.depth, variables2, this.inlineScopeNumber, this.surroundingScopeNumber);
        }
        if (Intrinsics.areEqual((Object)descriptor2.getLocation(), (Object)this.callLocation)) {
            return (XStackFrame)new KotlinStackFrame(descriptor2, variables2);
        }
        StackFrameProxyImpl proxy = InlineStackFrameProxyKt.safeInlineStackFrameProxy(this.callLocation, 0, frameProxy, this.inlineScopeNumber, this.surroundingScopeNumber);
        return (XStackFrame)new KotlinStackFrame(proxy, variables2);
    }
}

