/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.inline.InlineScopeUtilsKt;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.base.util.DexDebugFacility;
import org.jetbrains.kotlin.idea.debugger.base.util.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.CoroutineStateMachineVisitor;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.MockStackFrame;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010\f\u001a\u0010\u0010 \u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\f\u001a\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f\u001a\u001e\u0010#\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u001bH\u0002\u001a\u0016\u0010#\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001e\u0010(\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0004\u001a\u000e\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,\u001a\u000e\u0010-\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010.\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010/\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u000202H\u0002\u001a\u0010\u00103\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\n\u00104\u001a\u00020\u0003*\u000205\u001a\u0010\u00106\u001a\b\u0012\u0004\u0012\u00020\u000307*\u000205\u001a\u001c\u00108\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0:09*\u00020,\u001a\u0010\u0010;\u001a\b\u0012\u0004\u0012\u00020&0<*\u00020,\u001a1\u0010=\u001a\u0004\u0018\u0001H>\"\b\b\u0000\u0010>*\u00020?*\u00020\u00042\u0014\u0010@\u001a\u0010\u0012\u0004\u0012\u00020B\u0012\u0006\u0012\u0004\u0018\u0001H>0A\u00a2\u0006\u0002\u0010C\u001a\n\u0010D\u001a\u00020\u0003*\u00020\f\u001a\n\u0010D\u001a\u00020\u0003*\u000205\u001a\u0010\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000307*\u000205\u001a\n\u0010F\u001a\u00020\u0003*\u00020G\u001a\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00020&0%*\u00020\f2\u0006\u0010)\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0003*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0003*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\u00a8\u0006I"}, d2={"INVOKE_SUSPEND_SIGNATURE", "", "canRunEvaluation", "", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getCanRunEvaluation", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)Z", "isInlineFunctionMarkerVariableName", "(Ljava/lang/String;)Z", "isInlineLambdaMarkerVariableName", "checkContinuationLabelField", "location", "Lcom/sun/jdi/Location;", "name", "descriptor", "owner", "continuationAsmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "doesMethodHaveSwitcher", "findElementAtLine", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "functionNameByArgument", "argument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "functionNameByLocalVariable", "getFirstMethodLocation", "getLocationOfCoroutineSuspendReturn", "resumedLocation", "getLocationOfNextInstructionAfterResume", "resumeLocation", "isInSuspendMethod", "isInlinedArgument", "localVariables", "", "Lcom/sun/jdi/LocalVariable;", "inlineArgument", "isInsideInlineArgument", "debugProcess", "isInvokeSuspendMethod", "method", "Lcom/sun/jdi/Method;", "isKotlinFakeLineNumber", "isOnSuspendReturnOrReenter", "isOneLineMethod", "lambdaOrdinalByArgument", "elementAt", "Lorg/jetbrains/kotlin/psi/KtFunction;", "lambdaOrdinalByLocalVariable", "containsKotlinStrata", "Lcom/sun/jdi/ReferenceType;", "containsKotlinStrataAsync", "Ljava/util/concurrent/CompletableFuture;", "getInlineFunctionAndArgumentVariablesToBordersMap", "", "Lkotlin/ranges/ClosedRange;", "getInlineFunctionOrArgumentVariables", "Lkotlin/sequences/Sequence;", "invokeInManagerThread", "T", "", "f", "Lkotlin/Function1;", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isInKotlinSources", "isInKotlinSourcesAsync", "isOnSuspensionPoint", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "visibleVariables", "kotlin.jvm-debugger.core"})
@JvmName(name="DebuggerUtil")
@SourceDebugExtension(value={"SMAP\ndebuggerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 debuggerUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,565:1\n766#2:566\n857#2,2:567\n1603#2,9:579\n1855#2:588\n1747#2,3:589\n1856#2:593\n1612#2:594\n28#3,2:569\n36#4,8:571\n1#5:592\n*S KotlinDebug\n*F\n+ 1 debuggerUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtil\n*L\n94#1:566\n94#1:567,2\n485#1:579,9\n485#1:588\n487#1:589,3\n485#1:593\n485#1:594\n134#1:569,2\n134#1:571,8\n485#1:592\n*E\n"})
public final class DebuggerUtil {
    @NotNull
    private static final String INVOKE_SUSPEND_SIGNATURE = "(Ljava/lang/Object;)Ljava/lang/Object;";

    public static final boolean isInKotlinSources(@NotNull Location $this$isInKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSources, (String)"<this>");
        ReferenceType referenceType = $this$isInKotlinSources.declaringType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
        return DebuggerUtil.isInKotlinSources(referenceType);
    }

    public static final boolean isInKotlinSources(@NotNull ReferenceType $this$isInKotlinSources) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSources, (String)"<this>");
                string = SafeUtilKt.safeSourceName($this$isInKotlinSources);
                if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)) == null) break block2;
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = string3;
                if (string3 != null) break block3;
            }
            string = "";
        }
        String fileExtension = string;
        return ProjectStructureUtils.getKOTLIN_FILE_EXTENSIONS().contains(fileExtension) || DebuggerUtil.containsKotlinStrata($this$isInKotlinSources);
    }

    @NotNull
    public static final CompletableFuture<Boolean> isInKotlinSourcesAsync(@NotNull ReferenceType $this$isInKotlinSourcesAsync) {
        Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSourcesAsync, (String)"<this>");
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)DebuggerUtilsAsync.sourceName((ReferenceType)$this$isInKotlinSourcesAsync).thenApply(arg_0 -> DebuggerUtil.isInKotlinSourcesAsync$lambda$0(isInKotlinSourcesAsync.1.INSTANCE, arg_0))).exceptionally(DebuggerUtil::isInKotlinSourcesAsync$lambda$1)).thenCombine(DebuggerUtil.containsKotlinStrataAsync($this$isInKotlinSourcesAsync), (arg_0, arg_1) -> DebuggerUtil.isInKotlinSourcesAsync$lambda$2(isInKotlinSourcesAsync.3.INSTANCE, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCombine(...)");
        return completionStage;
    }

    public static final boolean containsKotlinStrata(@NotNull ReferenceType $this$containsKotlinStrata) {
        Intrinsics.checkNotNullParameter((Object)$this$containsKotlinStrata, (String)"<this>");
        return $this$containsKotlinStrata.availableStrata().contains("Kotlin");
    }

    @NotNull
    public static final CompletableFuture<Boolean> containsKotlinStrataAsync(@NotNull ReferenceType $this$containsKotlinStrataAsync) {
        Intrinsics.checkNotNullParameter((Object)$this$containsKotlinStrataAsync, (String)"<this>");
        CompletionStage completionStage = DebuggerUtilsAsync.availableStrata((ReferenceType)$this$containsKotlinStrataAsync).thenApply(arg_0 -> DebuggerUtil.containsKotlinStrataAsync$lambda$3(containsKotlinStrataAsync.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    public static final boolean isInsideInlineArgument(@NotNull KtExpression inlineArgument, @NotNull Location location2, @NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)inlineArgument, (String)"inlineArgument");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        return DebuggerUtil.isInlinedArgument(DebuggerUtil.visibleVariables(location2, debugProcess), inlineArgument);
    }

    public static final boolean isInlinedArgument(@NotNull KtExpression inlineArgument, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)inlineArgument, (String)"inlineArgument");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Method method = location2.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method(...)");
        List list2 = SafeUtilKt.safeVariables(method);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return DebuggerUtil.isInlinedArgument(list2, inlineArgument);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isInlinedArgument(List<? extends LocalVariable> localVariables, KtExpression inlineArgument) {
        void $this$filterTo$iv$iv;
        if (!(inlineArgument instanceof KtFunction) && !(inlineArgument instanceof KtCallableReferenceExpression)) {
            return false;
        }
        Iterable $this$filter$iv = localVariables;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LocalVariable it = (LocalVariable)element$iv$iv;
            boolean bl = false;
            String string = it.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"$i$a$", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List markerLocalVariables = (List)destination$iv$iv;
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(inlineArgument, (List<? extends LocalVariable>)markerLocalVariables){
            final /* synthetic */ KtExpression $inlineArgument;
            final /* synthetic */ List<LocalVariable> $markerLocalVariables;
            {
                this.$inlineArgument = $inlineArgument;
                this.$markerLocalVariables = $markerLocalVariables;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block11: {
                    void $this$any$iv;
                    void $this$mapTo$iv$iv;
                    String string;
                    Integer lambdaOrdinal;
                    KtExpression ktExpression = this.$inlineArgument;
                    KtFunction ktFunction = ktExpression instanceof KtFunction ? (KtFunction)ktExpression : null;
                    if (ktFunction != null) {
                        KtFunction it = ktFunction;
                        boolean bl2 = false;
                        v1 = DebuggerUtil.access$lambdaOrdinalByArgument(it);
                    } else {
                        v1 = lambdaOrdinal = null;
                    }
                    if ((string = DebuggerUtil.access$functionNameByArgument(this.$inlineArgument)) == null) {
                        string = "unknown";
                    }
                    String functionName = string;
                    Iterable $this$map$iv = this.$markerLocalVariables;
                    boolean $i$f$map = false;
                    Iterable bl2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        LocalVariable localVariable = (LocalVariable)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        String string2 = it.name();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
                        collection.add(StringsKt.drop((String)string2, (int)5));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    KtExpression ktExpression2 = this.$inlineArgument;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            boolean bl4;
                            String variableName = (String)element$iv;
                            boolean bl5 = false;
                            if (StringsKt.startsWith$default((String)variableName, (String)"-", (boolean)false, (int)2, null)) {
                                String string3 = ClassNameCalculator.INSTANCE.getClassName((KtElement)ktExpression2);
                                if (string3 == null || (string3 = StringsKt.substringAfterLast$default((String)string3, (char)'.', null, (int)2, null)) == null) {
                                    bl4 = false;
                                } else {
                                    String lambdaClassName = string3;
                                    bl4 = Intrinsics.areEqual((Object)InlineScopeUtilsKt.dropInlineScopeInfo((String)InlineUtilsKt.dropInlineSuffix(variableName)), (Object)("-" + functionName + "-" + lambdaClassName));
                                }
                            } else {
                                Integer n = lambdaOrdinal;
                                bl4 = n != null && DebuggerUtil.access$lambdaOrdinalByLocalVariable(variableName) == n && Intrinsics.areEqual((Object)DebuggerUtil.access$functionNameByLocalVariable(variableName), (Object)functionName);
                            }
                            if (!bl4) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
    }

    @Nullable
    public static final <T> T invokeInManagerThread(@NotNull DebugProcessImpl $this$invokeInManagerThread, @NotNull Function1<? super DebuggerContextImpl, ? extends T> f2) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeInManagerThread, (String)"<this>");
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        if (DebuggerManagerThreadImpl.isManagerThread()) {
            DebuggerContextImpl debuggerContextImpl = $this$invokeInManagerThread.getDebuggerContext();
            Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getDebuggerContext(...)");
            return (T)f2.invoke((Object)debuggerContextImpl);
        }
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        DebuggerContextImpl debuggerContextImpl = $this$invokeInManagerThread.getDebuggerContext();
        $this$invokeInManagerThread.getManagerThread().invokeAndWait((DebuggerCommandImpl)new DebuggerContextCommandImpl(result2, f2, debuggerContextImpl){
            final /* synthetic */ Ref.ObjectRef<T> $result;
            final /* synthetic */ Function1<DebuggerContextImpl, T> $f;
            {
                this.$result = $result;
                this.$f = $f;
                super($super_call_param$1);
            }

            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                DebuggerContextImpl debuggerContextImpl = this.getDebuggerContext();
                Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getDebuggerContext(...)");
                this.$result.element = this.$f.invoke((Object)debuggerContextImpl);
            }
        });
        return (T)result2.element;
    }

    private static final int lambdaOrdinalByArgument(KtFunction elementAt) {
        String string = ClassNameCalculator.INSTANCE.getClassName((KtElement)elementAt);
        if (string == null) {
            return 0;
        }
        String className = string;
        Integer n = StringsKt.toIntOrNull((String)StringsKt.substringAfterLast$default((String)className, (String)"$", null, (int)2, null));
        return n != null ? n : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String functionNameByArgument(KtExpression argument2) {
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)argument2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)argument2);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)argument2);
        try {
            KaNamedFunctionSymbol kaNamedFunctionSymbol;
            KaSession $this$functionNameByArgument_u24lambda_u245 = analysisSession$iv$iv;
            boolean bl = false;
            KaFunctionSymbol kaFunctionSymbol = org.jetbrains.kotlin.idea.codeinsight.utils.InlineUtilsKt.getFunctionSymbol($this$functionNameByArgument_u24lambda_u245, argument2);
            if ((kaFunctionSymbol instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)kaFunctionSymbol : null) == null) {
                String string = null;
                return string;
            }
            KaNamedFunctionSymbol function2 = kaNamedFunctionSymbol;
            String string = function2.getName().asString();
            return string;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)argument2);
        }
    }

    private static final List<LocalVariable> visibleVariables(Location $this$visibleVariables, DebugProcessImpl debugProcess) {
        VirtualMachine virtualMachine = debugProcess.getVirtualMachineProxy().getVirtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"getVirtualMachine(...)");
        MockStackFrame stackFrame = new MockStackFrame($this$visibleVariables, virtualMachine);
        return stackFrame.visibleVariables();
    }

    private static final int lambdaOrdinalByLocalVariable(String name2) {
        int n;
        try {
            String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
            n = Integer.parseInt(StringsKt.substringBefore((String)nameWithoutPrefix, (String)"$", (String)nameWithoutPrefix));
        }
        catch (NumberFormatException e) {
            n = 0;
        }
        return n;
    }

    private static final String functionNameByLocalVariable(String name2) {
        String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
        return StringsKt.substringAfterLast((String)nameWithoutPrefix, (String)"$", (String)"unknown");
    }

    public static final boolean isOnSuspensionPoint(@NotNull StackFrameProxyImpl $this$isOnSuspensionPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$isOnSuspensionPoint, (String)"<this>");
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)$this$isOnSuspensionPoint);
        if (location2 == null) {
            return false;
        }
        Location location3 = location2;
        if (DebuggerUtil.isInSuspendMethod(location3)) {
            Location location4 = DebuggerUtil.getFirstMethodLocation(location3);
            if (location4 == null) {
                return false;
            }
            Location firstLocation = location4;
            return SafeUtilKt.safeLineNumber(firstLocation) == SafeUtilKt.safeLineNumber(location3) && firstLocation.codeIndex() != location3.codeIndex();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInSuspendMethod(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Method method = location2.method();
        String signature = method.signature();
        Type continuationAsmType = DebuggerUtil.continuationAsmType();
        Intrinsics.checkNotNull((Object)signature);
        CharSequence charSequence = signature;
        String string = continuationAsmType.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) return true;
        Intrinsics.checkNotNull((Object)method);
        if (!DebuggerUtil.isInvokeSuspendMethod(method)) return false;
        return true;
    }

    public static final boolean isInvokeSuspendMethod(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)method.signature(), (Object)INVOKE_SUSPEND_SIGNATURE);
    }

    private static final Type continuationAsmType() {
        FqName fqName2 = StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier((String)"Continuation"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
        return CodegenUtilKt.topLevelClassAsmType((FqName)fqName2);
    }

    private static final Location getFirstMethodLocation(Location location2) {
        Method method = SafeUtilKt.safeMethod(location2);
        Location location3 = method != null ? method.location() : null;
        if (location3 == null) {
            return null;
        }
        Location firstLocation = location3;
        if (SafeUtilKt.safeLineNumber(firstLocation) < 0) {
            return null;
        }
        return firstLocation;
    }

    public static final boolean isOnSuspendReturnOrReenter(@NotNull Location location2) {
        boolean isAtFirstLine;
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Location location3 = DebuggerUtil.getFirstMethodLocation(location2);
        if (location3 == null) {
            return false;
        }
        Location firstLocation = location3;
        boolean bl = isAtFirstLine = SafeUtilKt.safeLineNumber(firstLocation) == SafeUtilKt.safeLineNumber(location2);
        if (isAtFirstLine) {
            return DebuggerUtil.doesMethodHaveSwitcher(location2);
        }
        return false;
    }

    private static final boolean doesMethodHaveSwitcher(Location location2) {
        VirtualMachine virtualMachine = location2.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return false;
        }
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        MethodBytecodeUtil.visit((Method)location2.method(), (MethodVisitor)new MethodVisitor(result2, location2){
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ Location $location;
            {
                this.$result = $result;
                this.$location = $location;
                super(589824);
            }

            public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String descriptor2) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                if (!this.$result.element && DebuggerUtil.access$checkContinuationLabelField(this.$location, name2, descriptor2, owner)) {
                    this.$result.element = true;
                }
            }
        }, (boolean)false);
        return result2.element;
    }

    private static final boolean checkContinuationLabelField(Location location2, String name2, String descriptor2, String owner) {
        if (name2 == null || descriptor2 == null || owner == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)name2, (Object)"label") && Intrinsics.areEqual((Object)descriptor2, (Object)"I")) {
            String className = Type.getObjectType((String)owner).getClassName();
            String methodClassName = location2.method().declaringType().name();
            if (DebuggerUtil.isInSuspendMethod(location2)) {
                Intrinsics.checkNotNull((Object)className);
                Intrinsics.checkNotNull((Object)methodClassName);
                if (StringsKt.startsWith$default((String)className, (String)methodClassName, (boolean)false, (int)2, null)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static final int getLocationOfCoroutineSuspendReturn(@Nullable Location resumedLocation) {
        Comparable<Location> comparable = resumedLocation;
        if (comparable == null || (comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
            return -1;
        }
        Comparable<Location> resumedMethod = comparable;
        VirtualMachine virtualMachine = resumedMethod.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return -1;
        }
        CoroutineStateMachineVisitor visitor2 = new CoroutineStateMachineVisitor((Method)resumedMethod, resumedLocation);
        MethodBytecodeUtil.visit(resumedMethod, (MethodVisitor)((MethodVisitor)visitor2), (boolean)true);
        return visitor2.getFirstReturnAfterSuspensionOffset();
    }

    public static final int getLocationOfNextInstructionAfterResume(@Nullable Location resumeLocation) {
        Comparable<Location> comparable = resumeLocation;
        if (comparable == null || (comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
            return -1;
        }
        Comparable<Location> resumedMethod = comparable;
        VirtualMachine virtualMachine = resumedMethod.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return -1;
        }
        CoroutineStateMachineVisitor visitor2 = new CoroutineStateMachineVisitor((Method)resumedMethod, resumeLocation);
        MethodBytecodeUtil.visit(resumedMethod, (MethodVisitor)((MethodVisitor)visitor2), (boolean)true);
        return visitor2.getNextCallOffset();
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean isOneLineMethod(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        v0 = SafeUtilKt.safeMethod(location);
        if (v0 == null) {
            return false;
        }
        method = v0;
        allLineLocations = SafeUtilKt.safeAllLineLocations(method);
        if (allLineLocations.isEmpty()) {
            return false;
        }
        if (allLineLocations.size() == 1) {
            return true;
        }
        inlineFunctionBorders = DebuggerUtil.getInlineFunctionAndArgumentVariablesToBordersMap(method).values();
        var4_4 = allLineLocations;
        $i$f$mapNotNull = false;
        var6_6 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var11_11 = $this$forEach$iv$iv$iv.iterator();
        while (var11_11.hasNext()) {
            block9: {
                element$iv$iv = element$iv$iv$iv = var11_11.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                loc = (Location)element$iv$iv;
                $i$a$-mapNotNull-DebuggerUtil$isOneLineMethod$1 = false;
                if (DebuggerUtil.isKotlinFakeLineNumber(loc)) ** GOTO lbl-1000
                $this$any$iv = inlineFunctionBorders;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (ClosedRange)element$iv;
                        $i$a$-any-DebuggerUtil$isOneLineMethod$1$1 = false;
                        if (!it.contains((Comparable)loc)) continue;
                        v1 = true;
                        break block9;
                    }
                    v1 = false;
                }
            }
            if (!v1) {
                v2 = loc.lineNumber();
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
            if (v2 == null) continue;
            it$iv$iv = v2;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv)).size() == 1;
    }

    @Nullable
    public static final PsiElement findElementAtLine(@NotNull KtFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file2, line);
        if (n == null) {
            return null;
        }
        int lineStartOffset = n;
        Integer n2 = PsiLinesUtilsKt.getLineEndOffset((PsiFile)file2, line);
        if (n2 == null) {
            return null;
        }
        int lineEndOffset = n2;
        return (PsiElement)ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiElement>(lineStartOffset, lineEndOffset, file2){
            final /* synthetic */ int $lineStartOffset;
            final /* synthetic */ int $lineEndOffset;
            final /* synthetic */ KtFile $file;
            {
                this.$lineStartOffset = $lineStartOffset;
                this.$lineEndOffset = $lineEndOffset;
                this.$file = $file;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                PsiElement topMostElement = null;
                PsiElement elementAt = null;
                for (int offset2 = this.$lineStartOffset; !(offset2 >= this.$lineEndOffset || (elementAt = this.$file.findElementAt(offset2)) != null && (topMostElement = KotlinPsiUtils.getTopmostElementAtOffset(elementAt, offset2)) instanceof KtElement); ++offset2) {
                }
                return topMostElement;
            }
        }));
    }

    public static final boolean isKotlinFakeLineNumber(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        try {
            if (location2.lineNumber("Kotlin") == 1 && Intrinsics.areEqual((Object)location2.sourceName("Kotlin"), (Object)"fake.kt") && Intrinsics.areEqual((Object)Path.of(location2.sourcePath("Kotlin"), new String[0]), (Object)Path.of("kotlin/jvm/internal/FakeKt", new String[0]))) {
                return true;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return false;
    }

    @NotNull
    public static final Map<LocalVariable, ClosedRange<Location>> getInlineFunctionAndArgumentVariablesToBordersMap(@NotNull Method $this$getInlineFunctionAndArgumentVariablesToBordersMap) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineFunctionAndArgumentVariablesToBordersMap, (String)"<this>");
        return MapsKt.toMap((Sequence)SequencesKt.mapNotNull(DebuggerUtil.getInlineFunctionOrArgumentVariables($this$getInlineFunctionAndArgumentVariablesToBordersMap), (Function1)getInlineFunctionAndArgumentVariablesToBordersMap.1.INSTANCE));
    }

    @NotNull
    public static final Sequence<LocalVariable> getInlineFunctionOrArgumentVariables(@NotNull Method $this$getInlineFunctionOrArgumentVariables) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineFunctionOrArgumentVariables, (String)"<this>");
        List<LocalVariable> list2 = SafeUtilKt.safeVariables($this$getInlineFunctionOrArgumentVariables);
        if (list2 == null) {
            return SequencesKt.emptySequence();
        }
        List<LocalVariable> localVariables = list2;
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)localVariables), (Function1)getInlineFunctionOrArgumentVariables.1.INSTANCE);
    }

    public static final boolean getCanRunEvaluation(@NotNull DebugProcessImpl $this$canRunEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$canRunEvaluation, (String)"<this>");
        return $this$canRunEvaluation.getSuspendManager().getPausedContext() != null;
    }

    public static final boolean isInlineFunctionMarkerVariableName(@NotNull String $this$isInlineFunctionMarkerVariableName) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineFunctionMarkerVariableName, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isInlineFunctionMarkerVariableName, (String)"$i$f$", (boolean)false, (int)2, null);
    }

    public static final boolean isInlineLambdaMarkerVariableName(@NotNull String $this$isInlineLambdaMarkerVariableName) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineLambdaMarkerVariableName, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isInlineLambdaMarkerVariableName, (String)"$i$a$", (boolean)false, (int)2, null);
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$1(Throwable it) {
        if (!(DebuggerUtilsAsync.unwrap((Throwable)it) instanceof AbsentInformationException)) {
            Intrinsics.checkNotNull((Object)it);
            throw it;
        }
        return false;
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final Boolean containsKotlinStrataAsync$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$checkContinuationLabelField(Location location2, String name2, String descriptor2, String owner) {
        return DebuggerUtil.checkContinuationLabelField(location2, name2, descriptor2, owner);
    }

    public static final /* synthetic */ Type access$continuationAsmType() {
        return DebuggerUtil.continuationAsmType();
    }

    public static final /* synthetic */ String access$functionNameByArgument(KtExpression argument2) {
        return DebuggerUtil.functionNameByArgument(argument2);
    }

    public static final /* synthetic */ int access$lambdaOrdinalByArgument(KtFunction elementAt) {
        return DebuggerUtil.lambdaOrdinalByArgument(elementAt);
    }

    public static final /* synthetic */ int access$lambdaOrdinalByLocalVariable(String name2) {
        return DebuggerUtil.lambdaOrdinalByLocalVariable(name2);
    }

    public static final /* synthetic */ String access$functionNameByLocalVariable(String name2) {
        return DebuggerUtil.functionNameByLocalVariable(name2);
    }
}

