/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.progress.StepsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaUsualClassType;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u009e\u0001\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001c\u0010\t\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0012\u0004\u0018\u00010\r0\nH\u0082@\u00a2\u0006\u0002\u0010\u000e\u001a&\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u001a4\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0015H\u0003\u001a,\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u001a\u001e\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00162\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u001a\u0016\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0082@\u00a2\u0006\u0002\u0010&\u001aT\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(*\u00020\b2\u001c\u0010\t\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0012\u0004\u0018\u00010\r0\n2\u001c\u0010)\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(0\u000b\u0012\u0006\u0012\u0004\u0018\u00010\r0\nH\u0082@\u00a2\u0006\u0002\u0010*\u001a\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\b\u0012\u0004\u0012\u00020,0\u0015H\u0002\u001a\"\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015*\u00020.2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0013H\u0002\u001a\f\u00101\u001a\u0004\u0018\u00010\u0016*\u000202\u001a\u0016\u00103\u001a\u0004\u0018\u000104*\u0002052\b\b\u0002\u00106\u001a\u00020\f\u001a\u0016\u00107\u001a\u0004\u0018\u000104*\u0002052\b\b\u0002\u00106\u001a\u00020\f\u001a\f\u00108\u001a\u00020\u0013*\u000202H\u0002\u001a\f\u00109\u001a\u00020\f*\u00020:H\u0000\u001a\f\u0010;\u001a\u00020\f*\u00020<H\u0002\"\u001e\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0004\u00a8\u0006="}, d2={"FUNCTION_TYPES", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "[Ljava/lang/Class;", "cancelWhenExpired", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "condition", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fallbackHasInlinedLinesTo", "referenceType", "Lcom/sun/jdi/ReferenceType;", "line", "", "sourceCandidatesInternalName", "", "", "findFileCandidatesWithBackgroundProcess", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "sourceName", "scopes", "Lcom/intellij/psi/search/GlobalSearchScope;", "hasInlinedLinesToAsync", "Ljava/util/concurrent/CompletableFuture;", "sourcePathMatchesCandidates", "sourcePath", "waitForSmartMode", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cancelIfExpired", "T", "action", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "filterHasInlineElements", "Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$ClassNameCandidateInfo;", "findTargetClasses", "Lcom/intellij/debugger/engine/DebugProcess;", "outerClass", "lineAt", "getClassName", "Lcom/sun/jdi/Location;", "getContainingBlockOrMethod", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lcom/intellij/psi/PsiElement;", "excludingElement", "getContainingMethod", "getZeroBasedLineNumber", "isGeneratedErasedLambdaMethod", "Lcom/sun/jdi/Method;", "isSamLambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinPositionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 5 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,955:1\n766#2:956\n857#2,2:957\n1549#2:959\n1620#2,3:960\n1747#2,3:963\n1726#2,3:966\n28#3,2:969\n36#4,8:971\n310#5,11:979\n*S KotlinDebug\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManagerKt\n*L\n726#1:956\n726#1:957,2\n726#1:959\n726#1:960,3\n768#1:963,3\n833#1:966,3\n901#1:969,2\n901#1:971,8\n952#1:979,11\n*E\n"})
public final class KotlinPositionManagerKt {
    @NotNull
    private static final Class<? extends KtDeclaration>[] FUNCTION_TYPES;

    /*
     * WARNING - void declaration
     */
    private static final List<String> filterHasInlineElements(List<ClassNameProvider.ClassNameCandidateInfo> $this$filterHasInlineElements) {
        void $this$mapTo$iv$iv;
        ClassNameProvider.ClassNameCandidateInfo it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterHasInlineElements;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ClassNameProvider.ClassNameCandidateInfo)element$iv$iv;
            boolean bl = false;
            if (!it.getHasInlineElements()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ClassNameProvider.ClassNameCandidateInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    private static final CompletableFuture<Boolean> hasInlinedLinesToAsync(ReferenceType referenceType, int line, List<String> sourceCandidatesInternalName) {
        CompletableFuture completableFuture;
        if (referenceType instanceof ReferenceTypeImpl) {
            CompletableFuture completableFuture2 = ((ReferenceTypeImpl)referenceType).hasMappedLineToAsync("Kotlin", line, arg_0 -> KotlinPositionManagerKt.hasInlinedLinesToAsync$lambda$2(sourceCandidatesInternalName, arg_0));
            Intrinsics.checkNotNull((Object)completableFuture2);
            completableFuture = completableFuture2;
        } else {
            CompletableFuture completableFuture3 = CompletableFuture.completedFuture(KotlinPositionManagerKt.fallbackHasInlinedLinesTo(referenceType, line, sourceCandidatesInternalName));
            Intrinsics.checkNotNull(completableFuture3);
            completableFuture = completableFuture3;
        }
        return completableFuture;
    }

    private static final boolean fallbackHasInlinedLinesTo(ReferenceType referenceType, int line, List<String> sourceCandidatesInternalName) {
        boolean bl;
        block6: {
            List list2;
            try {
                list2 = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)referenceType, (String)"Kotlin", null, (int)line);
            }
            catch (AbsentInformationException e) {
                list2 = CollectionsKt.emptyList();
            }
            List locations = list2;
            Intrinsics.checkNotNull((Object)locations);
            Iterable $this$any$iv = locations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Location location2 = (Location)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)location2);
                    String string = SafeUtilKt.safeSourcePath(location2, "Kotlin");
                    if (string != null) {
                        String sourcePath = string;
                        return KotlinPositionManagerKt.sourcePathMatchesCandidates(sourcePath, sourceCandidatesInternalName);
                    }
                    if (!false) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean sourcePathMatchesCandidates(String sourcePath, List<String> sourceCandidatesInternalName) {
        String string = FileUtil.toSystemIndependentName((String)sourcePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String internalName = string;
        return DebuggerUtilsKt.isInnerClassOfAny(internalName, sourceCandidatesInternalName);
    }

    @RequiresBackgroundThread
    private static final List<KtFile> findFileCandidatesWithBackgroundProcess(Project project2, JvmClassName className, String sourceName2, List<? extends GlobalSearchScope> scopes2) {
        return (List)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends KtFile>>, Object>(project2, scopes2, className, sourceName2, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ List<GlobalSearchScope> $scopes;
            final /* synthetic */ JvmClassName $className;
            final /* synthetic */ String $sourceName;
            {
                this.$project = $project;
                this.$scopes = $scopes;
                this.$className = $className;
                this.$sourceName = $sourceName;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TasksKt.withBackgroundProgress((Project)this.$project, (String)KotlinDebuggerCoreBundle.message("progress.title.kt.file.search", new Object[0]), (boolean)false, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends KtFile>>, Object>(this.$project, this.$scopes, this.$className, this.$sourceName, null){
                            int label;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ List<GlobalSearchScope> $scopes;
                            final /* synthetic */ JvmClassName $className;
                            final /* synthetic */ String $sourceName;
                            {
                                this.$project = $project;
                                this.$scopes = $scopes;
                                this.$className = $className;
                                this.$sourceName = $sourceName;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        files = (List)FileBasedIndex.getInstance().ignoreDumbMode(DumbModeAccessType.RELIABLE_DATA_ONLY, (ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.project.Project java.util.List org.jetbrains.kotlin.resolve.jvm.JvmClassName java.lang.String ), ()Ljava/util/List;)((Project)this.$project, this.$scopes, (JvmClassName)this.$className, (String)this.$sourceName));
                                        Intrinsics.checkNotNull((Object)files);
                                        if (((Collection)files).isEmpty() == false) {
                                            return files;
                                        }
                                        this.label = 1;
                                        v0 = StepsKt.withProgressText((String)KotlinDebuggerCoreBundle.message("progress.text.waiting.for.smart.mode", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, null){
                                            int label;
                                            final /* synthetic */ Project $project;
                                            {
                                                this.$project = $project;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.label = 1;
                                                        Object object3 = KotlinPositionManagerKt.access$waitForSmartMode(this.$project, (Continuation)this);
                                                        if (object3 != object2) return Unit.INSTANCE;
                                                        return object2;
                                                    }
                                                    case 1: {
                                                        void $result;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object3 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v0 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl17
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl17:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = com.intellij.openapi.application.CoroutinesKt.smartReadAction((Project)this.$project, (Function0)((Function0)new Function0<List<? extends KtFile>>(this.$project, this.$scopes, this.$className, this.$sourceName){
                                            final /* synthetic */ Project $project;
                                            final /* synthetic */ List<GlobalSearchScope> $scopes;
                                            final /* synthetic */ JvmClassName $className;
                                            final /* synthetic */ String $sourceName;
                                            {
                                                this.$project = $project;
                                                this.$scopes = $scopes;
                                                this.$className = $className;
                                                this.$sourceName = $sourceName;
                                                super(0);
                                            }

                                            @NotNull
                                            public final List<KtFile> invoke() {
                                                return DebuggerUtils.findSourceFilesForClass$kotlin_jvm_debugger_core$default(DebuggerUtils.INSTANCE, this.$project, this.$scopes, this.$className, this.$sourceName, false, false, 48, null);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v1 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl25
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl25:
                                        // 2 sources

                                        return v1;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends KtFile>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final List invokeSuspend$lambda$0(Project $project, List $scopes, JvmClassName $className, String $sourceName) {
                                List files2 = DebuggerUtils.findSourceFilesForClass$kotlin_jvm_debugger_core$default(DebuggerUtils.INSTANCE, $project, $scopes, $className, $sourceName, false, false, 48, null);
                                if (!((Collection)files2).isEmpty()) {
                                    return files2;
                                }
                                return DebuggerUtils.INSTANCE.tryFindFileByClassNameAndFileName$kotlin_jvm_debugger_core($project, $className, $sourceName, $scopes);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends KtFile>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public static final KtExpression getContainingMethod(@NotNull PsiElement $this$getContainingMethod, boolean excludingElement) {
        Intrinsics.checkNotNullParameter((Object)$this$getContainingMethod, (String)"<this>");
        Class<? extends KtDeclaration>[] classArray = FUNCTION_TYPES;
        return (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getContainingMethod, (boolean)excludingElement, (Class[])Arrays.copyOf(classArray, classArray.length));
    }

    public static /* synthetic */ KtExpression getContainingMethod$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return KotlinPositionManagerKt.getContainingMethod(psiElement2, bl);
    }

    @Nullable
    public static final KtExpression getContainingBlockOrMethod(@NotNull PsiElement $this$getContainingBlockOrMethod, boolean excludingElement) {
        Intrinsics.checkNotNullParameter((Object)$this$getContainingBlockOrMethod, (String)"<this>");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add(KtBlockExpression.class);
        spreadBuilder.addSpread(FUNCTION_TYPES);
        return (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getContainingBlockOrMethod, (boolean)excludingElement, (Class[])((Class[])spreadBuilder.toArray((Object[])new Class[spreadBuilder.size()])));
    }

    public static /* synthetic */ KtExpression getContainingBlockOrMethod$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return KotlinPositionManagerKt.getContainingBlockOrMethod(psiElement2, bl);
    }

    public static final boolean isGeneratedErasedLambdaMethod(@NotNull Method $this$isGeneratedErasedLambdaMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedErasedLambdaMethod, (String)"<this>");
        String string = $this$isGeneratedErasedLambdaMethod.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        if (DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(string) && $this$isGeneratedErasedLambdaMethod.isPrivate() && $this$isGeneratedErasedLambdaMethod.isStatic()) {
            List<String> args = $this$isGeneratedErasedLambdaMethod.argumentTypeNames();
            String kotlinFunctionPrefix = "kotlin.jvm.functions.Function";
            if (args.size() >= 2) {
                String string2 = args.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
                if (StringsKt.startsWith$default((String)string2, (String)kotlinFunctionPrefix, (boolean)false, (int)2, null)) {
                    String string3 = args.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get(...)");
                    Integer parameterCount = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)string3, (CharSequence)kotlinFunctionPrefix));
                    if (parameterCount != null && args.size() == parameterCount + 1) {
                        boolean bl;
                        block8: {
                            Intrinsics.checkNotNull(args);
                            Iterable $this$all$iv = CollectionsKt.drop((Iterable)args, (int)1);
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    String it = (String)element$iv;
                                    boolean bl2 = false;
                                    if (Intrinsics.areEqual((Object)it, (Object)"java.lang.Object")) continue;
                                    bl = false;
                                    break block8;
                                }
                                bl = true;
                            }
                        }
                        if (bl) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static final int getZeroBasedLineNumber(Location $this$getZeroBasedLineNumber) {
        return DebuggerUtilsEx.getLineNumber((Location)$this$getZeroBasedLineNumber, (boolean)true);
    }

    @Nullable
    public static final String getClassName(@NotNull Location $this$getClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$getClassName, (String)"<this>");
        String string = $this$getClassName.declaringType().name();
        if (string == null) {
            return null;
        }
        String currentLocationFqName = string;
        String string2 = JvmClassName.byFqNameWithoutInnerClasses((FqName)new FqName(currentLocationFqName)).getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInternalName(...)");
        return JvmNameUtilsKt.internalNameToFqn(string2);
    }

    private static final List<ReferenceType> findTargetClasses(DebugProcess $this$findTargetClasses, ReferenceType outerClass, int lineAt) {
        ArrayList targetClasses = new ArrayList(1);
        try {
            if (!outerClass.isPrepared()) {
                return CollectionsKt.emptyList();
            }
            for (Location location2 : SafeUtilKt.safeAllLineLocations(outerClass)) {
                Method method;
                int locationLine = KotlinPositionManagerKt.getZeroBasedLineNumber(location2);
                if (locationLine < 0 || lineAt != locationLine || (method = location2.method()) == null || com.intellij.debugger.engine.DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                ((Collection)targetClasses).add(outerClass);
                break;
            }
            List nestedTypes = $this$findTargetClasses.getVirtualMachineProxy().nestedTypes(outerClass);
            for (ReferenceType nested : nestedTypes) {
                Collection collection = targetClasses;
                Intrinsics.checkNotNull((Object)nested);
                CollectionsKt.addAll((Collection)collection, (Iterable)KotlinPositionManagerKt.findTargetClasses($this$findTargetClasses, nested, lineAt));
            }
        }
        catch (AbsentInformationException nestedTypes) {
        }
        catch (ObjectCollectedException objectCollectedException) {
            return CollectionsKt.emptyList();
        }
        return targetClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isSamLambda(KtFunction $this$isSamLambda) {
        if (!($this$isSamLambda instanceof KtFunctionLiteral) && !($this$isSamLambda instanceof KtNamedFunction)) {
            return false;
        }
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)$this$isSamLambda).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)$this$isSamLambda);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)$this$isSamLambda);
        try {
            KtValueArgument ktValueArgument;
            KtCallExpression ktCallExpression;
            KaSession $this$isSamLambda_u24lambda_u245 = analysisSession$iv$iv;
            boolean bl = false;
            KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)$this$isSamLambda));
            if ((ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null) == null) {
                boolean bl2 = false;
                return bl2;
            }
            KtCallExpression parentCall2 = ktCallExpression;
            KaLifetimeOwner kaLifetimeOwner = $this$isSamLambda_u24lambda_u245.resolveToCall((KtElement)parentCall2);
            if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
                boolean bl3 = false;
                return bl3;
            }
            KaLifetimeOwner call2 = kaLifetimeOwner;
            if (KotlinPsiUtils.getContainingValueArgument(parentCall2, (KtExpression)$this$isSamLambda) == null) {
                boolean bl4 = false;
                return bl4;
            }
            KtValueArgument valueArgument = ktValueArgument;
            KaLifetimeOwner kaLifetimeOwner2 = call2.getArgumentMapping().get(valueArgument.getArgumentExpression());
            if (kaLifetimeOwner2 == null || (kaLifetimeOwner2 = (KaValueParameterSymbol)kaLifetimeOwner2.getSymbol()) == null) {
                boolean bl5 = false;
                return bl5;
            }
            KaLifetimeOwner argument2 = kaLifetimeOwner2;
            boolean bl6 = ((KaCallableSymbol)argument2).getReturnType() instanceof KaUsualClassType;
            return bl6;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)$this$isSamLambda);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final <T> Object cancelIfExpired(CoroutineScope var0, Function1<? super Continuation<? super Boolean>, ? extends Object> var1_1, Function1<? super Continuation<? super T>, ? extends Object> var2_2, Continuation<? super T> var3_3) {
        if (!(var3_3 instanceof cancelIfExpired.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var3_3){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KotlinPositionManagerKt.access$cancelIfExpired(null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = action;
                $continuation.label = 1;
                v0 = KotlinPositionManagerKt.cancelWhenExpired($this$cancelIfExpired, (Function1<? super Continuation<? super Boolean>, ? extends Object>)condition, $continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl22
            }
            case 1: {
                action = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                cancellationJob = (Job)v0;
                $continuation.L$0 = cancellationJob;
                $continuation.label = 2;
                v1 = action.invoke($continuation);
                ** if (v1 != var8_6) goto lbl30
lbl29:
                // 1 sources

                return var8_6;
lbl30:
                // 1 sources

                ** GOTO lbl37
            }
            case 2: {
                cancellationJob = (Job)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl37:
                    // 2 sources

                    var5_8 = v1;
                    return var5_8;
                }
                catch (Throwable var5_9) {
                    throw var5_9;
                }
                finally {
                    Job.DefaultImpls.cancel$default((Job)cancellationJob, null, (int)1, null);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private static final Object cancelWhenExpired(CoroutineScope var0, Function1<? super Continuation<? super Boolean>, ? extends Object> var1_1, Continuation<? super Job> var2_2) {
        if (!(var2_2 instanceof cancelWhenExpired.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KotlinPositionManagerKt.access$cancelWhenExpired(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = scope;
                $continuation.L$1 = condition;
                $continuation.label = 1;
                v0 = KotlinPositionManagerKt.cancelWhenExpired$checkExpired((Function1<? super Continuation<? super Boolean>, ? extends Object>)condition, scope, (Continuation<? super Unit>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                condition = (Function1)$continuation.L$1;
                scope = (CoroutineScope)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                return BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super Continuation<? super Boolean>, ? extends Object>)condition, scope, null){
                    int label;
                    final /* synthetic */ Function1<Continuation<? super Boolean>, Object> $condition;
                    final /* synthetic */ CoroutineScope $scope;
                    {
                        this.$condition = $condition;
                        this.$scope = $scope;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                                // 2 sources

                                while (true) {
                                    this.label = 1;
                                    v0 = KotlinPositionManagerKt.access$cancelWhenExpired$checkExpired(this.$condition, this.$scope, (Continuation)this);
                                    if (v0 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl15
                                    break;
                                }
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl15:
                                // 2 sources

                                this.label = 2;
                                v1 = DelayKt.delay((long)500L, (Continuation)((Continuation)this));
                                if (v1 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl23
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl23:
                                // 2 sources

                                ** continue;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Object waitForSmartMode(Project project2, Continuation<? super Unit> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        DumbService.Companion.getInstance(project2).runWhenSmart((Runnable)new ContextAwareRunnable((CancellableContinuation<? super Unit>)it){
            final /* synthetic */ CancellableContinuation<Unit> $it;
            {
                this.$it = $it;
            }

            public final void run() {
                ((Continuation)this.$it).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final boolean hasInlinedLinesToAsync$lambda$2(List $sourceCandidatesInternalName, String path2) {
        Intrinsics.checkNotNullParameter((Object)$sourceCandidatesInternalName, (String)"$sourceCandidatesInternalName");
        Intrinsics.checkNotNull((Object)path2);
        return KotlinPositionManagerKt.sourcePathMatchesCandidates(path2, $sourceCandidatesInternalName);
    }

    /*
     * Unable to fully structure code
     */
    private static final Object cancelWhenExpired$checkExpired(Function1<? super Continuation<? super Boolean>, ? extends Object> var0, CoroutineScope var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof cancelWhenExpired.checkExpired.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var2_2){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KotlinPositionManagerKt.access$cancelWhenExpired$checkExpired(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $scope;
                $continuation.label = 1;
                v0 = $condition.invoke((Object)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                $scope = (CoroutineScope)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    CoroutineScopeKt.cancel$default((CoroutineScope)$scope, null, (int)1, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ int access$getZeroBasedLineNumber(Location $receiver) {
        return KotlinPositionManagerKt.getZeroBasedLineNumber($receiver);
    }

    public static final /* synthetic */ boolean access$isSamLambda(KtFunction $receiver) {
        return KotlinPositionManagerKt.isSamLambda($receiver);
    }

    public static final /* synthetic */ List access$findFileCandidatesWithBackgroundProcess(Project project2, JvmClassName className, String sourceName2, List scopes2) {
        return KotlinPositionManagerKt.findFileCandidatesWithBackgroundProcess(project2, className, sourceName2, scopes2);
    }

    public static final /* synthetic */ List access$filterHasInlineElements(List $receiver) {
        return KotlinPositionManagerKt.filterHasInlineElements($receiver);
    }

    public static final /* synthetic */ Object access$cancelIfExpired(CoroutineScope $receiver, Function1 condition2, Function1 action2, Continuation $completion) {
        return KotlinPositionManagerKt.cancelIfExpired($receiver, (Function1<? super Continuation<? super Boolean>, ? extends Object>)condition2, action2, $completion);
    }

    public static final /* synthetic */ CompletableFuture access$hasInlinedLinesToAsync(ReferenceType referenceType, int line, List sourceCandidatesInternalName) {
        return KotlinPositionManagerKt.hasInlinedLinesToAsync(referenceType, line, sourceCandidatesInternalName);
    }

    public static final /* synthetic */ List access$findTargetClasses(DebugProcess $receiver, ReferenceType outerClass, int lineAt) {
        return KotlinPositionManagerKt.findTargetClasses($receiver, outerClass, lineAt);
    }

    public static final /* synthetic */ boolean access$fallbackHasInlinedLinesTo(ReferenceType referenceType, int line, List sourceCandidatesInternalName) {
        return KotlinPositionManagerKt.fallbackHasInlinedLinesTo(referenceType, line, sourceCandidatesInternalName);
    }

    public static final /* synthetic */ boolean access$sourcePathMatchesCandidates(String sourcePath, List sourceCandidatesInternalName) {
        return KotlinPositionManagerKt.sourcePathMatchesCandidates(sourcePath, sourceCandidatesInternalName);
    }

    public static final /* synthetic */ Object access$waitForSmartMode(Project project2, Continuation $completion) {
        return KotlinPositionManagerKt.waitForSmartMode(project2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$cancelWhenExpired(CoroutineScope scope2, Function1 condition2, Continuation $completion) {
        return KotlinPositionManagerKt.cancelWhenExpired(scope2, (Function1<? super Continuation<? super Boolean>, ? extends Object>)condition2, (Continuation<? super Job>)$completion);
    }

    public static final /* synthetic */ Object access$cancelWhenExpired$checkExpired(Function1 $condition, CoroutineScope $scope, Continuation $completion) {
        return KotlinPositionManagerKt.cancelWhenExpired$checkExpired((Function1<? super Continuation<? super Boolean>, ? extends Object>)$condition, $scope, (Continuation<? super Unit>)$completion);
    }

    static {
        Class[] classArray = new Class[]{KtFunction.class, KtClassInitializer.class, KtPropertyAccessor.class, KtScript.class};
        FUNCTION_TYPES = classArray;
    }
}

