/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.lang.ASTNode;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolOrigin;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.EnumUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt$getWrappingPrefixExpressionOrNull$;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt$isAnnotatedDeep$;
import org.jetbrains.kotlin.idea.codeinsight.utils.NegatedBinaryExpressionSimplificationUtils;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.parsing.ParseUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00dc\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\b2\u0006\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u00132\b\b\u0002\u0010\u001a\u001a\u00020\u0013\u001a\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"\u001a\u000e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%\u001a\u000e\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020%\u001a\u000e\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020*\u001a\u0012\u0010+\u001a\u00020 *\u00020,2\u0006\u0010-\u001a\u00020.\u001a\n\u0010/\u001a\u00020\u0013*\u00020%\u001a\u000f\u00100\u001a\u0004\u0018\u000101*\u000201H\u0086\u0010\u001a\f\u00102\u001a\u0004\u0018\u000103*\u000204\u001a\f\u00105\u001a\u0004\u0018\u00010\u001c*\u000206\u001a\n\u00107\u001a\u00020\t*\u00020\u000f\u001a\n\u00108\u001a\u00020\t*\u00020\t\u001a\f\u00109\u001a\u0004\u0018\u00010:*\u00020.\u001a\f\u0010;\u001a\u00020\u0013*\u000201H\u0002\u001a\f\u0010<\u001a\u0004\u0018\u00010\u0005*\u00020\u001e\u001a\n\u0010=\u001a\u00020\u0013*\u00020>\u001a\u0012\u0010?\u001a\u00020\u0013*\u00020\t2\u0006\u0010@\u001a\u00020\"\u001a!\u0010A\u001a\u00020\u0013*\u00020\u000e2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001R\u00020B\u00a2\u0006\u0002\u0010D\u001a\f\u0010E\u001a\u00020\u0013*\u0004\u0018\u00010\t\u001a\n\u0010F\u001a\u00020\u0013*\u00020G\u001a\n\u0010H\u001a\u00020\u0013*\u00020G\u001a\u0012\u0010I\u001a\u00020\u0013*\u00020\t2\u0006\u0010J\u001a\u00020K\u001a\n\u0010L\u001a\u00020\u0013*\u00020\t\u001a\n\u0010M\u001a\u00020\u0013*\u00020G\u001a\n\u0010N\u001a\u00020\u0013*\u00020%\u001a\n\u0010O\u001a\u00020\u0013*\u00020%\u001a\u0013\u0010P\u001a\u00020\u0013*\u00020\u000eR\u00020B\u00a2\u0006\u0002\u0010Q\u001a\u0013\u0010P\u001a\u00020\u0013*\u00020RR\u00020B\u00a2\u0006\u0002\u0010S\u001a\u0013\u0010P\u001a\u00020\u0013*\u00020>R\u00020B\u00a2\u0006\u0002\u0010T\u001a\u0013\u0010U\u001a\u00020\u0013*\u00020\tR\u00020B\u00a2\u0006\u0002\u0010V\u001a\f\u0010W\u001a\u00020\u0013*\u0004\u0018\u00010\t\u001a\n\u0010X\u001a\u00020\u0013*\u00020\t\u001a*\u0010Y\u001a\u00020\t*\u00020\t2\b\b\u0002\u0010Z\u001a\u00020\u00132\u0014\b\u0002\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\\\u001a\u0015\u0010]\u001a\u00020\u0002*\u00020\u00022\u0006\u0010^\u001a\u00020\u001cH\u0086\u0002\u001a\u0015\u0010]\u001a\u00020\u0002*\u00020\u00022\u0006\u0010^\u001a\u00020_H\u0086\u0002\u001a\n\u0010`\u001a\u00020 *\u00020a\u001a$\u0010b\u001a\u00020\t*\u0002012\u0006\u0010c\u001a\u00020,2\u0006\u0010d\u001a\u00020\t2\b\b\u0002\u0010e\u001a\u00020\u0013\u001a\f\u0010f\u001a\u0004\u0018\u00010\t*\u00020\u000e\u001a*\u0010g\u001a\u0004\u0018\u00010\t*\u00020\t2\u0006\u0010Z\u001a\u00020\u00132\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\\H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0013*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0015\u00a8\u0006h"}, d2={"KOTLIN_BUILTIN_ENUM_FUNCTION_FQ_NAMES", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/name/FqName;", "NEGATABLE_OPERATORS", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "branches", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "getBranches", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;)Ljava/util/List;", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "getCallExpression", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isSetterParameter", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;)Z", "createArgumentWithoutName", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "argument", "isVararg", "isArrayOf", "getNegatedOperatorText", "", "token", "Lcom/intellij/psi/tree/IElementType;", "removeProperty", "", "ktProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "removeRedundantGetter", "getter", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "removeRedundantSetter", "setter", "renameToUnderscore", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "appendSemicolonBeforeLambdaContainingElement", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "element", "Lcom/intellij/psi/PsiElement;", "canBeCompletelyDeleted", "expressionWithoutClassInstanceAsReceiver", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "getClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "getControlFlowElementDescription", "Lorg/jetbrains/kotlin/psi/KtContainerNode;", "getLeftMostReceiverExpression", "getLeftMostReceiverExpressionOrThis", "getWrappingPrefixExpressionOrNull", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "hasNoClassInstanceReceiver", "invertedComparison", "isAnnotatedDeep", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isBackingFieldReferenceTo", "property", "isCalling", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "fqNames", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;Lkotlin/sequences/Sequence;)Z", "isFalseConstant", "isFunInterface", "Lorg/jetbrains/kotlin/psi/KtClass;", "isInheritable", "isIntegerConstantOfValue", "value", "", "isOneIntegerConstant", "isOpen", "isRedundantGetter", "isRedundantSetter", "isReferenceToBuiltInEnumFunction", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Z", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;)Z", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "isSynthesizedFunction", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "isTrueConstant", "isZeroIntegerConstant", "negate", "reformat", "optionalBooleanExpressionCheck", "Lkotlin/Function1;", "plus", "name", "Lorg/jetbrains/kotlin/name/Name;", "removeUnnecessaryParentheses", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "replaceFirstReceiver", "factory", "newReceiver", "safeAccess", "singleArgumentExpression", "specialNegation", "kotlin.code-insight.utils"})
@SourceDebugExtension(value={"SMAP\nKotlinPsiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPsiUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/KotlinPsiUtilsKt\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,455:1\n26#2,7:456\n22#2:477\n265#3,2:463\n277#3,10:465\n299#3:475\n455#3:476\n142#3:488\n266#3:489\n277#3,10:490\n299#3:500\n1549#4:478\n1620#4,3:479\n1549#4:482\n1620#4,3:483\n1247#5,2:486\n*S KotlinDebug\n*F\n+ 1 KotlinPsiUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/KotlinPsiUtilsKt\n*L\n219#1:456,7\n316#1:477\n242#1:463,2\n242#1:465,10\n242#1:475\n313#1:476\n389#1:488\n394#1:489\n394#1:490,10\n394#1:500\n321#1:478\n321#1:479,3\n324#1:482\n324#1:483,3\n375#1:486,2\n*E\n"})
public final class KotlinPsiUtilsKt {
    @NotNull
    private static final Set<KtSingleValueToken> NEGATABLE_OPERATORS;
    @NotNull
    private static final Sequence<FqName> KOTLIN_BUILTIN_ENUM_FUNCTION_FQ_NAMES;

    @Nullable
    public static final String getControlFlowElementDescription(@NotNull KtContainerNode $this$getControlFlowElementDescription) {
        Intrinsics.checkNotNullParameter((Object)$this$getControlFlowElementDescription, (String)"<this>");
        IElementType iElementType = $this$getControlFlowElementDescription.getNode().getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.THEN)) {
            return "if";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ELSE)) {
            return "else";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BODY)) {
            PsiElement psiElement2 = $this$getControlFlowElementDescription.getParent();
            if (psiElement2 instanceof KtWhileExpression) {
                return "while";
            }
            if (psiElement2 instanceof KtDoWhileExpression) {
                return "do...while";
            }
            if (psiElement2 instanceof KtForExpression) {
                return "for";
            }
        }
        return null;
    }

    public static final boolean isRedundantGetter(@NotNull KtPropertyAccessor $this$isRedundantGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isRedundantGetter, (String)"<this>");
        if (!$this$isRedundantGetter.isGetter()) {
            return false;
        }
        KtExpression ktExpression = $this$isRedundantGetter.getBodyExpression();
        if (ktExpression == null) {
            return KotlinPsiUtilsKt.canBeCompletelyDeleted($this$isRedundantGetter);
        }
        KtExpression expression2 = ktExpression;
        KtProperty ktProperty = $this$isRedundantGetter.getProperty();
        Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getProperty(...)");
        if (KotlinPsiUtilsKt.isBackingFieldReferenceTo(expression2, ktProperty)) {
            return true;
        }
        if (expression2 instanceof KtBlockExpression) {
            boolean bl;
            List list2 = ((KtBlockExpression)expression2).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
            KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)list2);
            if (ktExpression2 == null) {
                return false;
            }
            KtExpression statement2 = ktExpression2;
            KtReturnExpression ktReturnExpression = statement2 instanceof KtReturnExpression ? (KtReturnExpression)statement2 : null;
            if (ktReturnExpression == null) {
                return false;
            }
            KtReturnExpression returnExpression = ktReturnExpression;
            KtExpression ktExpression3 = returnExpression.getReturnedExpression();
            if (ktExpression3 != null) {
                KtProperty ktProperty2 = $this$isRedundantGetter.getProperty();
                Intrinsics.checkNotNullExpressionValue((Object)ktProperty2, (String)"getProperty(...)");
                bl = KotlinPsiUtilsKt.isBackingFieldReferenceTo(ktExpression3, ktProperty2);
            } else {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public static final boolean isBackingFieldReferenceTo(@NotNull KtExpression $this$isBackingFieldReferenceTo, @NotNull KtProperty property2) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackingFieldReferenceTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return $this$isBackingFieldReferenceTo instanceof KtNameReferenceExpression && Intrinsics.areEqual((Object)((KtNameReferenceExpression)$this$isBackingFieldReferenceTo).getText(), (Object)KtTokens.FIELD_KEYWORD.getValue()) && PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)property2), (PsiElement)((PsiElement)$this$isBackingFieldReferenceTo), (boolean)false, (int)2, null);
    }

    public static final boolean canBeCompletelyDeleted(@NotNull KtPropertyAccessor $this$canBeCompletelyDeleted) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeCompletelyDeleted, (String)"<this>");
        if ($this$canBeCompletelyDeleted.getModifierList() == null) {
            return true;
        }
        List list2 = $this$canBeCompletelyDeleted.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
        if (!((Collection)list2).isEmpty()) {
            return false;
        }
        if ($this$canBeCompletelyDeleted.hasModifier(KtTokens.EXTERNAL_KEYWORD)) {
            return false;
        }
        KtModifierKeywordToken ktModifierKeywordToken = KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)$this$canBeCompletelyDeleted));
        KtProperty ktProperty = $this$canBeCompletelyDeleted.getProperty();
        Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getProperty(...)");
        return Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)ktProperty)));
    }

    public static final void removeRedundantGetter(@NotNull KtPropertyAccessor getter) {
        Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
        KtProperty ktProperty = getter.getProperty();
        Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getProperty(...)");
        KtProperty property2 = ktProperty;
        KtTypeReference accessorTypeReference = getter.getReturnTypeReference();
        if (accessorTypeReference != null && property2.getTypeReference() == null && property2.getInitializer() == null) {
            property2.setTypeReference(accessorTypeReference);
        }
        if (KotlinPsiUtilsKt.canBeCompletelyDeleted(getter)) {
            getter.delete();
        } else {
            KotlinPsiUtils.deleteBody(getter);
        }
    }

    public static final void removeProperty(@NotNull KtProperty ktProperty) {
        Intrinsics.checkNotNullParameter((Object)ktProperty, (String)"ktProperty");
        KtExpression initializer2 = ktProperty.getInitializer();
        if (initializer2 != null && !(initializer2 instanceof KtConstantExpression)) {
            CommentSaver commentSaver = new CommentSaver((PsiElement)ktProperty, false, 2, null);
            PsiElement replaced2 = ktProperty.replace((PsiElement)initializer2);
            Intrinsics.checkNotNull((Object)replaced2);
            CommentSaver.restore$default(commentSaver, replaced2, false, 2, null);
        } else {
            ktProperty.delete();
        }
    }

    public static final void renameToUnderscore(@NotNull KtCallableDeclaration declaration2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            PsiElement psiElement2 = declaration2.getNameIdentifier();
            if (psiElement2 == null) break block0;
            Project project2 = declaration2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            psiElement2.replace(new KtPsiFactory(project2, false, 2, null).createIdentifier("_"));
        }
    }

    public static final boolean isSetterParameter(@NotNull KtParameter $this$isSetterParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isSetterParameter, (String)"<this>");
        PsiElement psiElement2 = $this$isSetterParameter.getParent().getParent();
        KtPropertyAccessor ktPropertyAccessor = psiElement2 instanceof KtPropertyAccessor ? (KtPropertyAccessor)psiElement2 : null;
        return ktPropertyAccessor != null ? ktPropertyAccessor.isSetter() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isRedundantSetter(@NotNull KtPropertyAccessor $this$isRedundantSetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isRedundantSetter, (String)"<this>");
        if (!$this$isRedundantSetter.isSetter()) {
            return false;
        }
        KtExpression ktExpression = $this$isRedundantSetter.getBodyExpression();
        if (ktExpression == null) {
            return KotlinPsiUtilsKt.canBeCompletelyDeleted($this$isRedundantSetter);
        }
        KtExpression expression2 = ktExpression;
        if (!(expression2 instanceof KtBlockExpression)) return false;
        List list2 = ((KtBlockExpression)expression2).getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)list2);
        if (ktExpression2 == null) {
            return false;
        }
        KtExpression statement2 = ktExpression2;
        List list3 = $this$isRedundantSetter.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueParameters(...)");
        KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)list3);
        if (ktParameter == null) {
            return false;
        }
        KtParameter parameter = ktParameter;
        if (!(statement2 instanceof KtBinaryExpression)) return false;
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)statement2;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.EQ)) return false;
        KtExpression ktExpression3 = binaryExpression.getLeft();
        if (ktExpression3 == null) return false;
        KtProperty ktProperty = $this$isRedundantSetter.getProperty();
        Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getProperty(...)");
        if (!KotlinPsiUtilsKt.isBackingFieldReferenceTo(ktExpression3, ktProperty)) return false;
        boolean bl = true;
        if (!bl) return false;
        KtExpression ktExpression4 = binaryExpression.getRight();
        if (!Intrinsics.areEqual(ktExpression4 != null && (ktExpression4 = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)ktExpression4))) != null ? ktExpression4.resolve() : null, (Object)parameter)) return false;
        return true;
    }

    public static final void removeRedundantSetter(@NotNull KtPropertyAccessor setter) {
        Intrinsics.checkNotNullParameter((Object)setter, (String)"setter");
        if (KotlinPsiUtilsKt.canBeCompletelyDeleted(setter)) {
            setter.delete();
        } else {
            KotlinPsiUtils.deleteBody(setter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTrueConstant(@Nullable KtExpression $this$isTrueConstant) {
        if ($this$isTrueConstant == null) return false;
        ASTNode aSTNode = $this$isTrueConstant.getNode();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.BOOLEAN_CONSTANT)) return false;
        if (!Intrinsics.areEqual((Object)$this$isTrueConstant.getText(), (Object)"true")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFalseConstant(@Nullable KtExpression $this$isFalseConstant) {
        if ($this$isFalseConstant == null) return false;
        ASTNode aSTNode = $this$isFalseConstant.getNode();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.BOOLEAN_CONSTANT)) return false;
        if (!Intrinsics.areEqual((Object)$this$isFalseConstant.getText(), (Object)"false")) return false;
        return true;
    }

    @NotNull
    public static final KtExpression negate(@NotNull KtExpression $this$negate, boolean reformat, @NotNull Function1<? super KtExpression, Boolean> optionalBooleanExpressionCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$negate, (String)"<this>");
        Intrinsics.checkNotNullParameter(optionalBooleanExpressionCheck, (String)"optionalBooleanExpressionCheck");
        KtExpression specialNegation = KotlinPsiUtilsKt.specialNegation($this$negate, reformat, optionalBooleanExpressionCheck);
        if (specialNegation != null) {
            return specialNegation;
        }
        Project project2 = $this$negate.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Object[] objectArray = new Object[]{$this$negate};
        return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)new KtPsiFactory(project2, false, 2, null), (String)"!$0", (Object[])objectArray, (boolean)reformat);
    }

    public static /* synthetic */ KtExpression negate$default(KtExpression ktExpression, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            function1 = negate.1.INSTANCE;
        }
        return KotlinPsiUtilsKt.negate(ktExpression, bl, (Function1<? super KtExpression, Boolean>)function1);
    }

    private static final KtExpression specialNegation(KtExpression $this$specialNegation, boolean reformat, Function1<? super KtExpression, Boolean> optionalBooleanExpressionCheck) {
        Project project2 = $this$specialNegation.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        KtExpression ktExpression = $this$specialNegation;
        if (ktExpression instanceof KtPrefixExpression) {
            KtExpression baseExpression;
            if (Intrinsics.areEqual((Object)((KtPrefixExpression)$this$specialNegation).getOperationReference().getReferencedName(), (Object)"!") && (baseExpression = ((KtPrefixExpression)$this$specialNegation).getBaseExpression()) != null && ((Boolean)optionalBooleanExpressionCheck.invoke((Object)baseExpression)).booleanValue()) {
                return KtPsiUtil.safeDeparenthesize((KtExpression)baseExpression);
            }
        } else {
            if (ktExpression instanceof KtBinaryExpression) {
                IElementType iElementType = ((KtBinaryExpression)$this$specialNegation).getOperationToken();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
                IElementType operator = iElementType;
                if (!CollectionsKt.contains((Iterable)NEGATABLE_OPERATORS, (Object)operator)) {
                    return null;
                }
                KtExpression ktExpression2 = ((KtBinaryExpression)$this$specialNegation).getLeft();
                if (ktExpression2 == null) {
                    return null;
                }
                KtExpression left = ktExpression2;
                KtExpression ktExpression3 = ((KtBinaryExpression)$this$specialNegation).getRight();
                if (ktExpression3 == null) {
                    return null;
                }
                KtExpression right = ktExpression3;
                Object[] objectArray = new Object[]{left, KotlinPsiUtilsKt.getNegatedOperatorText(operator), right};
                return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)psiFactory, (String)"$0 $1 $2", (Object[])objectArray, (boolean)reformat);
            }
            if (ktExpression instanceof KtIsExpression) {
                Object[] objectArray = new Object[3];
                Intrinsics.checkNotNullExpressionValue((Object)((KtIsExpression)$this$specialNegation).getLeftHandSide(), (String)"getLeftHandSide(...)");
                Object object = objectArray[1] = ((KtIsExpression)$this$specialNegation).isNegated() ? "is" : "!is";
                if (((KtIsExpression)$this$specialNegation).getTypeReference() == null) {
                    Object cfr_ignored_0 = objectArray[2];
                    return null;
                }
                return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)psiFactory, (String)"$0 $1 $2", (Object[])objectArray, (boolean)reformat);
            }
            if (ktExpression instanceof KtConstantExpression) {
                String string = ((KtConstantExpression)$this$specialNegation).getText();
                return Intrinsics.areEqual((Object)string, (Object)"true") ? psiFactory.createExpression("false") : (Intrinsics.areEqual((Object)string, (Object)"false") ? psiFactory.createExpression("true") : null);
            }
        }
        return null;
    }

    private static final String getNegatedOperatorText(IElementType token) {
        KtSingleValueToken ktSingleValueToken = NegatedBinaryExpressionSimplificationUtils.INSTANCE.negate(token);
        if (ktSingleValueToken == null) {
            throw new IllegalArgumentException("The token " + token + " does not have a negated equivalent.");
        }
        KtSingleValueToken negatedOperator = ktSingleValueToken;
        String string = negatedOperator.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return string;
    }

    @NotNull
    public static final KtExpression getLeftMostReceiverExpression(@NotNull KtQualifiedExpression $this$getLeftMostReceiverExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$getLeftMostReceiverExpression, (String)"<this>");
        KtExpression ktExpression = $this$getLeftMostReceiverExpression.getReceiverExpression();
        KtQualifiedExpression ktQualifiedExpression = ktExpression instanceof KtQualifiedExpression ? (KtQualifiedExpression)ktExpression : null;
        if (ktQualifiedExpression == null || (ktQualifiedExpression = KotlinPsiUtilsKt.getLeftMostReceiverExpression(ktQualifiedExpression)) == null) {
            ktQualifiedExpression = $this$getLeftMostReceiverExpression.getReceiverExpression();
        }
        return ktQualifiedExpression;
    }

    @NotNull
    public static final KtExpression getLeftMostReceiverExpressionOrThis(@NotNull KtExpression $this$getLeftMostReceiverExpressionOrThis) {
        Intrinsics.checkNotNullParameter((Object)$this$getLeftMostReceiverExpressionOrThis, (String)"<this>");
        KtQualifiedExpression ktQualifiedExpression = $this$getLeftMostReceiverExpressionOrThis instanceof KtQualifiedExpression ? (KtQualifiedExpression)$this$getLeftMostReceiverExpressionOrThis : null;
        if (ktQualifiedExpression == null || (ktQualifiedExpression = KotlinPsiUtilsKt.getLeftMostReceiverExpression(ktQualifiedExpression)) == null) {
            ktQualifiedExpression = $this$getLeftMostReceiverExpressionOrThis;
        }
        return ktQualifiedExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtExpression replaceFirstReceiver(@NotNull KtDotQualifiedExpression $this$replaceFirstReceiver, @NotNull KtPsiFactory factory2, @NotNull KtExpression newReceiver, boolean safeAccess) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)$this$replaceFirstReceiver, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)newReceiver, (String)"newReceiver");
        if (safeAccess) {
            PsiElement psiElement2;
            void $this$replaced$iv;
            PsiElement psiElement3 = (PsiElement)$this$replaceFirstReceiver;
            Object[] objectArray = new Object[2];
            objectArray[0] = $this$replaceFirstReceiver.getReceiverExpression();
            Intrinsics.checkNotNull((Object)$this$replaceFirstReceiver.getSelectorExpression());
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0?.$1", (Object[])objectArray, (boolean)false, (int)4, null);
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement2 = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement2 = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement2 = (PsiElement)ktExpression2;
                }
            }
            ktExpression = (KtExpression)psiElement2;
        } else {
            ktExpression = (KtExpression)$this$replaceFirstReceiver;
        }
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        KtQualifiedExpression replacedExpression = (KtQualifiedExpression)ktExpression;
        KtExpression receiver2 = replacedExpression.getReceiverExpression();
        if (receiver2 instanceof KtDotQualifiedExpression) {
            ((KtDotQualifiedExpression)receiver2).replace((PsiElement)KotlinPsiUtilsKt.replaceFirstReceiver((KtDotQualifiedExpression)receiver2, factory2, newReceiver, safeAccess));
        } else {
            receiver2.replace((PsiElement)newReceiver);
        }
        return (KtExpression)replacedExpression;
    }

    public static /* synthetic */ KtExpression replaceFirstReceiver$default(KtDotQualifiedExpression ktDotQualifiedExpression, KtPsiFactory ktPsiFactory, KtExpression ktExpression, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return KotlinPsiUtilsKt.replaceFirstReceiver(ktDotQualifiedExpression, ktPsiFactory, ktExpression, bl);
    }

    @Nullable
    public static final KtCallExpression getCallExpression(@NotNull KtQualifiedExpression $this$callExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$callExpression, (String)"<this>");
        KtExpression ktExpression = $this$callExpression.getSelectorExpression();
        return ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
    }

    @Nullable
    public static final KtExpression singleArgumentExpression(@NotNull KtCallExpression $this$singleArgumentExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$singleArgumentExpression, (String)"<this>");
        List list2 = $this$singleArgumentExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
        return ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null;
    }

    public static final boolean isAnnotatedDeep(@NotNull KtTypeReference $this$isAnnotatedDeep) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnnotatedDeep, (String)"<this>");
        PsiElement $this$anyDescendantOfType_u24default$iv = (PsiElement)$this$isAnnotatedDeep;
        Function1 predicate$iv = isAnnotatedDeep$$inlined$anyDescendantOfType$default$1.INSTANCE;
        boolean $i$f$anyDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType_u24default$iv;
        boolean $i$f$findDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3 instanceof KtAnnotationEntry && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    @Nullable
    public static final ClassId getClassId(@NotNull KtConstantExpression $this$getClassId) {
        Object object;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)$this$getClassId, (String)"<this>");
        IStubElementType iStubElementType = $this$getClassId.getElementType();
        if (Intrinsics.areEqual((Object)iStubElementType, (Object)KtNodeTypes.INTEGER_CONSTANT) ? true : Intrinsics.areEqual((Object)iStubElementType, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
            String string = $this$getClassId.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            IStubElementType iStubElementType2 = $this$getClassId.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iStubElementType2, (String)"getElementType(...)");
            if (ParseUtilsKt.hasIllegalUnderscore((String)string, (IElementType)((IElementType)iStubElementType2))) {
                return null;
            }
            String string2 = $this$getClassId.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            IStubElementType iStubElementType3 = $this$getClassId.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iStubElementType3, (String)"getElementType(...)");
            serializable = ParseUtilsKt.parseNumericLiteral((String)string2, (IElementType)((IElementType)iStubElementType3));
        } else if (Intrinsics.areEqual((Object)iStubElementType, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
            String string = $this$getClassId.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            serializable = Boolean.valueOf(ParseUtilsKt.parseBoolean((String)string));
        } else {
            serializable = null;
        }
        Serializable convertedText = serializable;
        iStubElementType = $this$getClassId.getElementType();
        if (Intrinsics.areEqual((Object)iStubElementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
            if (!(convertedText instanceof Long)) {
                object = null;
            } else {
                String string = $this$getClassId.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (ParseUtilsKt.hasUnsignedLongSuffix((String)string)) {
                    object = StandardClassIds.INSTANCE.getULong();
                } else {
                    String string3 = $this$getClassId.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                    if (ParseUtilsKt.hasLongSuffix((String)string3)) {
                        object = StandardClassIds.INSTANCE.getLong();
                    } else {
                        String string4 = $this$getClassId.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                        object = ParseUtilsKt.hasUnsignedSuffix((String)string4) ? (Long.compareUnsigned(ULong.constructor-impl((long)((Number)convertedText).longValue()), ULong.constructor-impl((long)((long)-1 & 0xFFFFFFFFL))) > 0 || Long.compareUnsigned(ULong.constructor-impl((long)((Number)convertedText).longValue()), ULong.constructor-impl((long)(0L & 0xFFFFFFFFL))) < 0 ? StandardClassIds.INSTANCE.getULong() : StandardClassIds.INSTANCE.getUInt()) : (((Number)convertedText).longValue() > Integer.MAX_VALUE || ((Number)convertedText).longValue() < Integer.MIN_VALUE ? StandardClassIds.INSTANCE.getLong() : StandardClassIds.INSTANCE.getInt());
                    }
                }
            }
        } else {
            object = Intrinsics.areEqual((Object)iStubElementType, (Object)KtNodeTypes.FLOAT_CONSTANT) ? (convertedText instanceof Float ? StandardClassIds.INSTANCE.getFloat() : StandardClassIds.INSTANCE.getDouble()) : (Intrinsics.areEqual((Object)iStubElementType, (Object)KtNodeTypes.CHARACTER_CONSTANT) ? StandardClassIds.INSTANCE.getChar() : (Intrinsics.areEqual((Object)iStubElementType, (Object)KtNodeTypes.BOOLEAN_CONSTANT) ? StandardClassIds.INSTANCE.getBoolean() : null));
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIntegerConstantOfValue(@NotNull KtExpression $this$isIntegerConstantOfValue, int value2) {
        Intrinsics.checkNotNullParameter((Object)$this$isIntegerConstantOfValue, (String)"<this>");
        KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)$this$isIntegerConstantOfValue);
        if (!(ktExpression instanceof KtConstantExpression)) return false;
        KtConstantExpression ktConstantExpression = (KtConstantExpression)ktExpression;
        if (ktConstantExpression == null) {
            return false;
        }
        KtConstantExpression deparenthesized = ktConstantExpression;
        if (!Intrinsics.areEqual((Object)deparenthesized.getElementType(), (Object)KtStubElementTypes.INTEGER_CONSTANT)) return false;
        String string = deparenthesized.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Integer n = StringsKt.toIntOrNull((String)string);
        int n2 = value2;
        if (n == null) return false;
        if (n != n2) return false;
        return true;
    }

    public static final boolean isZeroIntegerConstant(@NotNull KtExpression $this$isZeroIntegerConstant) {
        Intrinsics.checkNotNullParameter((Object)$this$isZeroIntegerConstant, (String)"<this>");
        return KotlinPsiUtilsKt.isIntegerConstantOfValue($this$isZeroIntegerConstant, 0);
    }

    public static final boolean isOneIntegerConstant(@NotNull KtExpression $this$isOneIntegerConstant) {
        Intrinsics.checkNotNullParameter((Object)$this$isOneIntegerConstant, (String)"<this>");
        return KotlinPsiUtilsKt.isIntegerConstantOfValue($this$isOneIntegerConstant, 1);
    }

    public static final void appendSemicolonBeforeLambdaContainingElement(@NotNull KtPsiFactory $this$appendSemicolonBeforeLambdaContainingElement, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)$this$appendSemicolonBeforeLambdaContainingElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement previousElement = KtPsiUtil.skipSiblingsBackwardByPredicate((PsiElement)element3, KotlinPsiUtilsKt::appendSemicolonBeforeLambdaContainingElement$lambda$0);
        if (previousElement != null && previousElement instanceof KtExpression) {
            ((KtExpression)previousElement).getParent().addAfter($this$appendSemicolonBeforeLambdaContainingElement.createSemicolon(), previousElement);
        }
    }

    @Nullable
    public static final KtSingleValueToken invertedComparison(@NotNull IElementType $this$invertedComparison) {
        Intrinsics.checkNotNullParameter((Object)$this$invertedComparison, (String)"<this>");
        IElementType iElementType = $this$invertedComparison;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) ? KtTokens.GT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) ? KtTokens.LT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) ? KtTokens.LTEQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ) ? KtTokens.GTEQ : null)));
    }

    @Nullable
    public static final KtPrefixExpression getWrappingPrefixExpressionOrNull(@NotNull PsiElement $this$getWrappingPrefixExpressionOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$getWrappingPrefixExpressionOrNull, (String)"<this>");
        PsiElement $this$getLastParentOfTypeInRow$iv = $this$getWrappingPrefixExpressionOrNull;
        boolean $i$f$getLastParentOfTypeInRow = false;
        Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParents((PsiElement)$this$getLastParentOfTypeInRow$iv), (Function1)getWrappingPrefixExpressionOrNull$$inlined$getLastParentOfTypeInRow$1.INSTANCE));
        if (!(object instanceof KtParenthesizedExpression)) {
            object = null;
        }
        KtParenthesizedExpression ktParenthesizedExpression = (KtParenthesizedExpression)((PsiElement)((KtParenthesizedExpression)object));
        PsiElement psiElement2 = (ktParenthesizedExpression != null ? (PsiElement)ktParenthesizedExpression : $this$getWrappingPrefixExpressionOrNull).getParent();
        return psiElement2 instanceof KtPrefixExpression ? (KtPrefixExpression)psiElement2 : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtValueArgument> createArgumentWithoutName(@NotNull KtValueArgument argument2, boolean isVararg, boolean isArrayOf) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        if (!argument2.isNamed()) {
            PsiElement $this$copied$iv = (PsiElement)argument2;
            boolean $i$f$copied = false;
            PsiElement psiElement2 = $this$copied$iv.copy();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValueArgument");
            }
            return CollectionsKt.listOf((Object)((PsiElement)((KtValueArgument)psiElement2)));
        }
        KtExpression ktExpression = argument2.getArgumentExpression();
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression argumentExpr = ktExpression;
        KtPsiFactory psiFactory = new KtPsiFactory((KtElement)argument2, false, 2, null);
        if (isVararg && argumentExpr instanceof KtCollectionLiteralExpression) {
            void $this$mapTo$iv$iv;
            List list3 = ((KtCollectionLiteralExpression)argumentExpr).getInnerExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getInnerExpressions(...)");
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtExpression ktExpression2 = (KtExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KtPsiFactory.createArgument$default((KtPsiFactory)psiFactory, (KtExpression)it, null, (boolean)false, (boolean)false, (int)14, null));
            }
            list2 = (List)destination$iv$iv;
        } else if (isVararg && argumentExpr instanceof KtCallExpression && isArrayOf) {
            List list4 = ((KtCallExpression)argumentExpr).getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getValueArguments(...)");
            Iterable $this$map$iv = list4;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                KtValueArgument it = (KtValueArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KtPsiFactory.createArgument$default((KtPsiFactory)psiFactory, (KtExpression)it.getArgumentExpression(), null, (boolean)false, (boolean)false, (int)14, null));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.listOf((Object)KtPsiFactory.createArgument$default((KtPsiFactory)psiFactory, (KtExpression)argumentExpr, null, (boolean)isVararg, (boolean)false, (int)8, null));
        }
        return list2;
    }

    public static /* synthetic */ List createArgumentWithoutName$default(KtValueArgument ktValueArgument, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return KotlinPsiUtilsKt.createArgumentWithoutName(ktValueArgument, bl, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasNoClassInstanceReceiver(KtDotQualifiedExpression $this$hasNoClassInstanceReceiver) {
        KtElement ktElement = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)$this$hasNoClassInstanceReceiver));
        KtElement ktElement2 = ktElement;
        if (ktElement == null) return false;
        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)ktElement2);
        ktElement2 = ktReference;
        if (ktReference == null) return false;
        if ((ktElement2 = ktElement2.resolve()) == null) {
            return false;
        }
        KtElement element3 = ktElement2;
        if (element3 instanceof KtClassOrObject) return true;
        if (element3 instanceof KtConstructor) return true;
        if (element3 instanceof KtCallableDeclaration && ((KtCallableDeclaration)element3).getReceiverTypeReference() == null) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element3));
            if (ktClassOrObject == null) {
                return true;
            }
            boolean bl = ktClassOrObject instanceof KtObjectDeclaration;
            if (bl) return true;
        }
        if (element3 instanceof PsiMember) {
            if (((PsiMember)element3).hasModifier(JvmModifier.STATIC)) return true;
        }
        if (!(element3 instanceof PsiMethod)) return false;
        if (!((PsiMethod)element3).isConstructor()) return false;
        return true;
    }

    @Nullable
    public static final KtDotQualifiedExpression expressionWithoutClassInstanceAsReceiver(@NotNull KtDotQualifiedExpression $this$expressionWithoutClassInstanceAsReceiver) {
        KtDotQualifiedExpression ktDotQualifiedExpression;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$expressionWithoutClassInstanceAsReceiver, (String)"<this>");
            while (true) {
                if (KotlinPsiUtilsKt.hasNoClassInstanceReceiver($this$expressionWithoutClassInstanceAsReceiver)) {
                    ktDotQualifiedExpression = $this$expressionWithoutClassInstanceAsReceiver;
                    break block2;
                }
                KtExpression ktExpression = $this$expressionWithoutClassInstanceAsReceiver.getReceiverExpression();
                if ((ktExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null) == null) break;
                $this$expressionWithoutClassInstanceAsReceiver = $this$expressionWithoutClassInstanceAsReceiver;
            }
            ktDotQualifiedExpression = null;
        }
        return ktDotQualifiedExpression;
    }

    public static final boolean isOpen(@NotNull KtClass $this$isOpen) {
        Intrinsics.checkNotNullParameter((Object)$this$isOpen, (String)"<this>");
        return $this$isOpen.hasModifier(KtTokens.OPEN_KEYWORD);
    }

    public static final boolean isInheritable(@NotNull KtClass $this$isInheritable) {
        Intrinsics.checkNotNullParameter((Object)$this$isInheritable, (String)"<this>");
        return KotlinPsiUtilsKt.isOpen($this$isInheritable) || KtPsiUtilKt.isAbstract((KtClass)$this$isInheritable) || $this$isInheritable.isSealed();
    }

    public static final boolean isSynthesizedFunction(@NotNull KaSession $context_receiver_0, @NotNull KtExpression $this$isSynthesizedFunction) {
        KaSymbol kaSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$isSynthesizedFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        KaLifetimeOwner kaLifetimeOwner = $context_receiver_0.resolveToCall((KtElement)$this$isSynthesizedFunction);
        if (kaLifetimeOwner != null && (kaLifetimeOwner = KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) != null && (kaLifetimeOwner = kaLifetimeOwner.getPartiallyAppliedSymbol()) != null && (kaLifetimeOwner = (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(kaLifetimeOwner)) != null) {
            kaSymbol = (KaSymbol)kaLifetimeOwner;
        } else {
            KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)$this$isSynthesizedFunction));
            kaSymbol = ktReference != null ? $context_receiver_0.resolveToSymbol(ktReference) : null;
            if (kaSymbol == null) {
                return false;
            }
        }
        KaSymbol symbol2 = kaSymbol;
        return symbol2.getOrigin() == KaSymbolOrigin.SOURCE_MEMBER_GENERATED;
    }

    public static final boolean isCalling(@NotNull KaSession $context_receiver_0, @NotNull KtCallExpression $this$isCalling, @NotNull Sequence<FqName> fqNames) {
        boolean bl;
        block4: {
            FqName fqName2;
            CallableId callableId;
            KaFunctionSymbol kaFunctionSymbol;
            Object object;
            KaFunctionCall<?> kaFunctionCall;
            Intrinsics.checkNotNullParameter((Object)$this$isCalling, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
            Intrinsics.checkNotNullParameter(fqNames, (String)"fqNames");
            KtExpression ktExpression = $this$isCalling.getCalleeExpression();
            String string = ktExpression != null ? ktExpression.getText() : null;
            if (string == null) {
                return false;
            }
            String calleeText = string;
            Sequence targetFqNames2 = SequencesKt.filter(fqNames, (Function1)((Function1)new Function1<FqName, Boolean>(calleeText){
                final /* synthetic */ String $calleeText;
                {
                    this.$calleeText = $calleeText;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull FqName it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.shortName().asString(), (Object)this.$calleeText);
                }
            }));
            if (SequencesKt.none((Sequence)targetFqNames2)) {
                return false;
            }
            KaCallInfo kaCallInfo = $context_receiver_0.resolveToCall((KtElement)$this$isCalling);
            if (kaCallInfo == null || (kaFunctionCall = KaCallInfoKt.singleFunctionCallOrNull(kaCallInfo)) == null || (object = kaFunctionCall.getPartiallyAppliedSymbol()) == null || (kaFunctionSymbol = (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(object)) == null || (callableId = kaFunctionSymbol.getCallableId()) == null || (fqName2 = callableId.asSingleFqName()) == null) {
                return false;
            }
            FqName fqName3 = fqName2;
            Sequence $this$any$iv = targetFqNames2;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                FqName it = (FqName)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)fqName3)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final FqName plus(@NotNull FqName $this$plus, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        FqName fqName2 = $this$plus.child(name2);
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
        return fqName2;
    }

    @NotNull
    public static final FqName plus(@NotNull FqName $this$plus, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Name name3 = Name.identifier((String)name2);
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        return KotlinPsiUtilsKt.plus($this$plus, name3);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isReferenceToBuiltInEnumFunction(@NotNull KaSession $context_receiver_0, @NotNull KtTypeReference $this$isReferenceToBuiltInEnumFunction) {
        boolean bl;
        Class[] target2;
        Intrinsics.checkNotNullParameter((Object)$this$isReferenceToBuiltInEnumFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        PsiElement psiElement2 = $this$isReferenceToBuiltInEnumFunction.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
        PsiElement $this$getStrictParentOfType$iv = psiElement2;
        boolean $i$f$getStrictParentOfType = false;
        KtTypeArgumentList ktTypeArgumentList = (KtTypeArgumentList)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeArgumentList.class, (boolean)true);
        Class[] classArray = new Class[]{KtCallExpression.class, KtCallableDeclaration.class};
        classArray = target2 = (Class[])PsiUtilsKt.getParentOfTypes((PsiElement)((PsiElement)(ktTypeArgumentList != null ? (KtElementImplStub)ktTypeArgumentList : (KtElementImplStub)$this$isReferenceToBuiltInEnumFunction)), (boolean)true, (Class[])classArray);
        if (classArray instanceof KtCallExpression) {
            bl = KotlinPsiUtilsKt.isCalling($context_receiver_0, (KtCallExpression)target2, KOTLIN_BUILTIN_ENUM_FUNCTION_FQ_NAMES);
        } else if (classArray instanceof KtCallableDeclaration) {
            void $this$anyDescendantOfType$iv;
            $this$getStrictParentOfType$iv = (PsiElement)target2;
            Function1 predicate$iv = (Function1)new Function1<KtCallExpression, Boolean>($context_receiver_0){
                final /* synthetic */ KaSession $$context_receiver_0;
                {
                    this.$$context_receiver_0 = $$context_receiver_0;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtCallExpression it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return KotlinPsiUtilsKt.isCalling(this.$$context_receiver_0, it, (Sequence<FqName>)KotlinPsiUtilsKt.access$getKOTLIN_BUILTIN_ENUM_FUNCTION_FQ_NAMES$p()) && this.$$context_receiver_0.isUsedAsExpression((KtExpression)it);
                }
            };
            boolean $i$f$anyDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
            boolean $i$f$findDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
            Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(PsiElement element3) {
                    Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                    if (element3 instanceof KtCallExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                        this.$result.element = element3;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element3;
                    boolean bl = false;
                    super.visitElement(element3);
                }
            });
            bl = (PsiElement)result$iv$iv$iv.element != null;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isReferenceToBuiltInEnumFunction(@NotNull KaSession $context_receiver_0, @NotNull KtCallExpression $this$isReferenceToBuiltInEnumFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isReferenceToBuiltInEnumFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        KtExpression ktExpression = $this$isReferenceToBuiltInEnumFunction.getCalleeExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression calleeExpression2 = ktExpression;
        KtSimpleNameExpression ktSimpleNameExpression = calleeExpression2 instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)calleeExpression2 : null;
        return CollectionsKt.contains((Iterable)EnumUtilsKt.getENUM_STATIC_METHOD_NAMES(), (Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null)) && KotlinPsiUtilsKt.isSynthesizedFunction($context_receiver_0, calleeExpression2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isReferenceToBuiltInEnumFunction(@NotNull KaSession $context_receiver_0, @NotNull KtCallableReferenceExpression $this$isReferenceToBuiltInEnumFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isReferenceToBuiltInEnumFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        if (!EnumUtilsKt.canBeReferenceToBuiltInEnumFunction($this$isReferenceToBuiltInEnumFunction)) return false;
        KtSimpleNameExpression ktSimpleNameExpression = $this$isReferenceToBuiltInEnumFunction.getCallableReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
        if (!KotlinPsiUtilsKt.isSynthesizedFunction($context_receiver_0, (KtExpression)ktSimpleNameExpression)) return false;
        return true;
    }

    @NotNull
    public static final List<KtExpression> getBranches(@NotNull KtIfExpression $this$branches) {
        Intrinsics.checkNotNullParameter((Object)$this$branches, (String)"<this>");
        return KotlinPsiUtilsKt._get_branches_$ifBranchesOrThis((KtExpression)$this$branches);
    }

    public static final boolean isFunInterface(@NotNull KtClass $this$isFunInterface) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunInterface, (String)"<this>");
        return $this$isFunInterface.isInterface() && $this$isFunInterface.getFunKeyword() != null;
    }

    public static final void removeUnnecessaryParentheses(@NotNull KtParenthesizedExpression $this$removeUnnecessaryParentheses) {
        PsiElement replaced2;
        Intrinsics.checkNotNullParameter((Object)$this$removeUnnecessaryParentheses, (String)"<this>");
        CommentSaver commentSaver = new CommentSaver((PsiElement)$this$removeUnnecessaryParentheses, false, 2, null);
        KtExpression ktExpression = $this$removeUnnecessaryParentheses.getExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression innerExpression = ktExpression;
        PsiElement psiElement2 = $this$removeUnnecessaryParentheses.getParent();
        KtBinaryExpression binaryExpressionParent = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
        Project project2 = $this$removeUnnecessaryParentheses.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project2, false, 2, null);
        if (binaryExpressionParent != null && innerExpression instanceof KtBinaryExpression && Intrinsics.areEqual((Object)binaryExpressionParent.getRight(), (Object)$this$removeUnnecessaryParentheses)) {
            Object[] objectArray = new Object[5];
            Intrinsics.checkNotNull((Object)binaryExpressionParent.getLeft());
            Intrinsics.checkNotNullExpressionValue((Object)binaryExpressionParent.getOperationReference(), (String)"getOperationReference(...)");
            Intrinsics.checkNotNull((Object)((KtBinaryExpression)innerExpression).getLeft());
            Intrinsics.checkNotNullExpressionValue((Object)((KtBinaryExpression)innerExpression).getOperationReference(), (String)"getOperationReference(...)");
            Intrinsics.checkNotNull((Object)((KtBinaryExpression)innerExpression).getRight());
            KtExpression newElement2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0 $1 $2 $3 $4", (Object[])objectArray, (boolean)false, (int)4, null);
            PsiElement replace2 = binaryExpressionParent.replace((PsiElement)newElement2);
            String string = replace2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            v3 = replace2.replace((PsiElement)ktPsiFactory.createExpression(string));
        } else {
            v3 = replaced2 = $this$removeUnnecessaryParentheses.replace((PsiElement)innerExpression);
        }
        if (innerExpression.getFirstChild() instanceof KtLambdaExpression) {
            Intrinsics.checkNotNull((Object)replaced2);
            KotlinPsiUtilsKt.appendSemicolonBeforeLambdaContainingElement(ktPsiFactory, replaced2);
        }
        Intrinsics.checkNotNull((Object)replaced2);
        CommentSaver.restore$default(commentSaver, replaced2, false, 2, null);
    }

    private static final boolean appendSemicolonBeforeLambdaContainingElement$lambda$0(PsiElement it) {
        PsiElement psiElement2 = it;
        Intrinsics.checkNotNull((Object)psiElement2);
        return KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(psiElement2.getNode().getElementType());
    }

    private static final List<KtExpression> _get_branches_$ifBranchesOrThis(KtExpression $this$_get_branches__u24ifBranchesOrThis) {
        if (!($this$_get_branches__u24ifBranchesOrThis instanceof KtIfExpression)) {
            return CollectionsKt.listOf((Object)$this$_get_branches__u24ifBranchesOrThis);
        }
        Collection collection = CollectionsKt.listOf((Object)((KtIfExpression)$this$_get_branches__u24ifBranchesOrThis).getThen());
        KtExpression ktExpression = ((KtIfExpression)$this$_get_branches__u24ifBranchesOrThis).getElse();
        List list2 = ktExpression != null ? KotlinPsiUtilsKt._get_branches_$ifBranchesOrThis(ktExpression) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    public static final /* synthetic */ Sequence access$getKOTLIN_BUILTIN_ENUM_FUNCTION_FQ_NAMES$p() {
        return KOTLIN_BUILTIN_ENUM_FUNCTION_FQ_NAMES;
    }

    static {
        Object[] objectArray = new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ};
        NEGATABLE_OPERATORS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"enumValues", "enumValueOf"};
        KOTLIN_BUILTIN_ENUM_FUNCTION_FQ_NAMES = SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)KOTLIN_BUILTIN_ENUM_FUNCTION_FQ_NAMES.1.INSTANCE);
    }
}

