/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared.KotlinLineMarkersSharedBundle;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerOptions;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0016\u0010\b\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\n0\tj\u0002`\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\r\u001a\u00020\u0007H\u0002J.\u0010\u000e\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0016\u0010\b\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\n0\tj\u0002`\u000bH&J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u0017*\u0004\u0018\u00010\u0007H\u0002J\f\u0010\u0018\u001a\u00020\u0017*\u00020\u0007H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/AbstractKotlinLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/LineMarkerInfos;", "createLineSeparatorByElement", "element", "doCollectSlowLineMarkers", "getLineMarkerInfo", "getName", "", "getOptions", "", "Lcom/intellij/codeInsight/daemon/GutterIconDescriptor$Option;", "()[Lcom/intellij/codeInsight/daemon/GutterIconDescriptor$Option;", "canHaveSeparator", "", "wantsSeparator", "kotlin.code-insight.line-markers.shared"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinLineMarkerProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/AbstractKotlinLineMarkerProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,75:1\n18717#2,2:76\n*S KotlinDebug\n*F\n+ 1 AbstractKotlinLineMarkerProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/AbstractKotlinLineMarkerProvider\n*L\n65#1:76,2\n*E\n"})
public abstract class AbstractKotlinLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        return KotlinLineMarkersSharedBundle.message("highlighter.name.kotlin.line.markers", new Object[0]);
    }

    @NotNull
    public GutterIconDescriptor.Option[] getOptions() {
        return KotlinLineMarkerOptions.INSTANCE.getOptions();
    }

    @Nullable
    public LineMarkerInfo<PsiElement> getLineMarkerInfo(@NotNull PsiElement element3) {
        block3: {
            block4: {
                PsiElement prevSibling;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (!DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS || !this.canHaveSeparator(element3) || !this.canHaveSeparator(prevSibling = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)element3, (boolean)false, (int)1, null))) break block3;
                if (this.wantsSeparator(element3)) break block4;
                PsiElement psiElement2 = prevSibling;
                boolean bl = psiElement2 != null ? this.wantsSeparator(psiElement2) : false;
                if (!bl) break block3;
            }
            return this.createLineSeparatorByElement(element3);
        }
        return null;
    }

    private final boolean canHaveSeparator(PsiElement $this$canHaveSeparator) {
        return $this$canHaveSeparator instanceof KtFunction || $this$canHaveSeparator instanceof KtClassInitializer || $this$canHaveSeparator instanceof KtProperty && !((KtProperty)$this$canHaveSeparator).isLocal() || $this$canHaveSeparator instanceof KtObjectDeclaration && ((KtObjectDeclaration)$this$canHaveSeparator).isCompanion();
    }

    private final boolean wantsSeparator(PsiElement $this$wantsSeparator) {
        return $this$wantsSeparator instanceof KtFunction || StringUtil.getLineBreakCount((CharSequence)$this$wantsSeparator.getText()) > 0;
    }

    private final LineMarkerInfo<PsiElement> createLineSeparatorByElement(PsiElement element3) {
        PsiElement psiElement2 = PsiTreeUtil.getDeepestFirst((PsiElement)element3);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getDeepestFirst(...)");
        PsiElement anchor = psiElement2;
        LineMarkerInfo info2 = new LineMarkerInfo(anchor, anchor.getTextRange());
        info2.separatorColor = EditorColorsManager.getInstance().getGlobalScheme().getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info2.separatorPlacement = SeparatorPlacement.TOP;
        return info2;
    }

    public final void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            if (elements2.isEmpty()) {
                return;
            }
            GutterIconDescriptor.Option[] $this$none$iv = KotlinLineMarkerOptions.INSTANCE.getOptions();
            boolean $i$f$none = false;
            int n = $this$none$iv.length;
            for (int j = 0; j < n; ++j) {
                GutterIconDescriptor.Option element$iv;
                GutterIconDescriptor.Option option = element$iv = $this$none$iv[j];
                boolean bl2 = false;
                if (!option.isEnabled()) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (bl) {
            return;
        }
        PsiElement first2 = (PsiElement)CollectionsKt.first(elements2);
        Project project2 = first2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (DumbService.Companion.getInstance(project2).isDumb() || !SourceKindFilterUtils.matches(RootKindFilter.projectAndLibrarySources, first2)) {
            return;
        }
        this.doCollectSlowLineMarkers(elements2, result2);
    }

    public abstract void doCollectSlowLineMarkers(@NotNull List<? extends PsiElement> var1, @NotNull Collection<? super LineMarkerInfo<?>> var2);
}

