/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.options.RegexValidator;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.Regex;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingRule;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B:\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012!\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0018\u001a\u00020\u0003J!\u0010\u0019\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J7\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0002\u0010*R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R)\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionSettings;", "", "entityName", "", "defaultNamePattern", "setNamePatternCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getDefaultNamePattern", "()Ljava/lang/String;", "namePattern", "getNamePattern", "setNamePattern", "(Ljava/lang/String;)V", "nameRegex", "Lkotlin/text/Regex;", "getNameRegex", "()Lkotlin/text/Regex;", "setNameRegex", "(Lkotlin/text/Regex;)V", "getDefaultErrorMessage", "getNameMismatchMessage", "rules", "", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingRule;", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingRule;)Ljava/lang/String;", "getOptionController", "Lcom/intellij/codeInspection/options/OptionController;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "verifyName", "element", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "additionalCheck", "Lkotlin/Function0;", "", "(Lcom/intellij/psi/PsiNameIdentifierOwner;Lcom/intellij/codeInspection/ProblemsHolder;Lkotlin/jvm/functions/Function0;[Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingRule;)V", "kotlin.code-insight.inspections.shared"})
public final class NamingConventionInspectionSettings {
    @NotNull
    private final String entityName;
    @NotNull
    private final String defaultNamePattern;
    @NotNull
    private final Function1<String, Unit> setNamePatternCallback;
    @Nullable
    private Regex nameRegex;
    @NotNull
    private String namePattern;

    public NamingConventionInspectionSettings(@NotNull String entityName, @Language(value="RegExp") @NotNull String defaultNamePattern, @NotNull Function1<? super String, Unit> setNamePatternCallback) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        Intrinsics.checkNotNullParameter((Object)defaultNamePattern, (String)"defaultNamePattern");
        Intrinsics.checkNotNullParameter(setNamePatternCallback, (String)"setNamePatternCallback");
        this.entityName = entityName;
        this.defaultNamePattern = defaultNamePattern;
        this.setNamePatternCallback = setNamePatternCallback;
        this.nameRegex = new Regex(this.defaultNamePattern);
        this.namePattern = this.defaultNamePattern;
    }

    @NotNull
    public final String getDefaultNamePattern() {
        return this.defaultNamePattern;
    }

    @Nullable
    public final Regex getNameRegex() {
        return this.nameRegex;
    }

    public final void setNameRegex(@Nullable Regex regex) {
        this.nameRegex = regex;
    }

    @NotNull
    public final String getNamePattern() {
        return this.namePattern;
    }

    public final void setNamePattern(@NotNull String value2) {
        Regex regex;
        NamingConventionInspectionSettings namingConventionInspectionSettings;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.namePattern = value2;
        this.setNamePatternCallback.invoke((Object)value2);
        NamingConventionInspectionSettings namingConventionInspectionSettings2 = this;
        try {
            namingConventionInspectionSettings = namingConventionInspectionSettings2;
            regex = new Regex(value2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            namingConventionInspectionSettings = namingConventionInspectionSettings2;
            regex = null;
        }
        namingConventionInspectionSettings.nameRegex = regex;
    }

    public final void verifyName(@NotNull PsiNameIdentifierOwner element3, @NotNull ProblemsHolder holder, @NotNull Function0<Boolean> additionalCheck2, @NotNull NamingRule[] rules2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter(additionalCheck2, (String)"additionalCheck");
        Intrinsics.checkNotNullParameter((Object)rules2, (String)"rules");
        String name2 = element3.getName();
        PsiElement nameIdentifier = element3.getNameIdentifier();
        if (name2 != null && nameIdentifier != null) {
            Regex regex = this.nameRegex;
            boolean bl = regex != null ? !regex.matches((CharSequence)name2) : false;
            if (bl && ((Boolean)additionalCheck2.invoke()).booleanValue()) {
                String message2 = this.getNameMismatchMessage(name2, rules2);
                String descriptionTemplate = this.entityName + " " + KotlinBundle.message((String)"text.name", (Object[])new Object[0]) + " <code>#ref</code> " + message2 + " #loc";
                PsiElement psiElement2 = element3.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement2);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RenameIdentifierFix()};
                holder.registerProblem(psiElement2, descriptionTemplate, localQuickFixArray);
            }
        }
    }

    @NotNull
    public final String getNameMismatchMessage(@NotNull String name2, @NotNull NamingRule[] rules2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rules2, (String)"rules");
        if (!Intrinsics.areEqual((Object)this.namePattern, (Object)this.defaultNamePattern)) {
            return this.getDefaultErrorMessage();
        }
        String string = NamingConventionInspectionsKt.access$findRuleMessage(name2, rules2);
        if (string == null) {
            string = this.getDefaultErrorMessage();
        }
        return string;
    }

    @NotNull
    public final String getDefaultErrorMessage() {
        Object[] objectArray = new Object[]{this.namePattern};
        return KotlinBundle.message((String)"doesn.t.match.regex.0", (Object[])objectArray);
    }

    @NotNull
    public final OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.string((String)"namePattern", (String)KotlinBundle.message((String)"text.pattern", (Object[])new Object[0]), (int)30, (StringValidator)((StringValidator)new RegexValidator()))};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public final OptionController getOptionController() {
        OptionController optionController = OptionController.empty().onValue("namePattern", (KMutableProperty0)new MutablePropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((NamingConventionInspectionSettings)this.receiver).getNamePattern();
            }

            public void set(@Nullable Object value2) {
                ((NamingConventionInspectionSettings)this.receiver).setNamePattern((String)value2);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)optionController, (String)"onValue(...)");
        return optionController;
    }
}

