/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.analysis.api.projectStructure.ExtensionFileContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryUsageIndex;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderExtension;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderKt;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.UserDataModuleContainer;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfoWithExpectedBy;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.base.util.MappingIterator;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.util.SeqKt;
import org.jetbrains.kotlin.idea.base.util.SeqScope;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 B2\u00020\u0001:\u0002BCB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00122\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014\u00a2\u0006\u0002\b\u0016H\u0082\bJ.\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 J$\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010\u001f\u001a\u00020 JB\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u001a0'j\b\u0012\u0004\u0012\u00020\u001a`(2\u0006\u0010\u001f\u001a\u00020 H\u0002JB\u0010)\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u001a0'j\b\u0012\u0004\u0012\u00020\u001a`(2\u0006\u0010\u001f\u001a\u00020 H\u0002J*\u0010,\u001a\u0004\u0018\u00010\u001a2\u0006\u0010-\u001a\u00020.2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u001a0'j\b\u0012\u0004\u0012\u00020\u001a`(H\u0002J:\u0010/\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u001a0'j\b\u0012\u0004\u0012\u00020\u001a`(2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u0010\u001f\u001a\u00020 H\u0002J8\u00102\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0017\u00103\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014\u00a2\u0006\u0002\b\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u001204H\u0082\bJ(\u00105\u001a\u00020\u0012*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0002J0\u00107\u001a\u00020\u0012*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J0\u00108\u001a\u00020\u0012*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019062\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003092\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010:\u001a\u00020\u0012*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019062\u0006\u0010;\u001a\u00020<H\u0002J(\u0010=\u001a\u00020\u0012*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010>\u001a\u00020\u001e*\u00020?2\b\u0010@\u001a\u0004\u0018\u00010AH\u0002R \u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "getFileIndex", "()Lcom/intellij/openapi/roots/ProjectFileIndex;", "fileIndex$delegate", "Lkotlin/Lazy;", "libraryInfoCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache;", "getLibraryInfoCache", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache;", "libraryInfoCache$delegate", "callExtensions", "", "block", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProviderExtension;", "Lkotlin/ExtensionFunctionType;", "collect", "Lkotlin/sequences/Sequence;", "Lkotlin/Result;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLibrarySource", "", "config", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "element", "Lcom/intellij/psi/PsiElement;", "collectByLibrary", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "visited", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "collectByOrderEntry", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "collectBySdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "contextByContextualBinaryModule", "containingKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "withCallExtensions", "extensionBlock", "Lkotlin/Function0;", "collectByElement", "Lorg/jetbrains/kotlin/idea/base/util/SeqScope;", "collectByFile", "collectByLightElement", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "collectByUserData", "container", "Lorg/jetbrains/kotlin/idea/base/projectStructure/UserDataModuleContainer;", "collectSourceRelatedByFile", "isApplicable", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "contextualModuleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "Companion", "Configuration", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nModuleInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,508:1\n209#1,2:509\n199#1,4:511\n213#1,4:515\n199#1,4:519\n218#1:523\n199#1,4:524\n199#1,4:528\n209#1,2:533\n199#1,4:535\n213#1,4:539\n199#1,4:543\n218#1:547\n146#2:532\n31#3,2:548\n*S KotlinDebug\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider\n*L\n184#1:509,2\n184#1:511,4\n184#1:515,4\n184#1:519,4\n184#1:523\n210#1:524,4\n216#1:528,4\n250#1:533,2\n250#1:535,4\n250#1:539,4\n250#1:543,4\n250#1:547\n226#1:532\n413#1:548,2\n*E\n"})
public final class ModuleInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy fileIndex$delegate;
    @NotNull
    private final Lazy libraryInfoCache$delegate;
    @NotNull
    private static final Logger LOG;

    public ModuleInfoProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.fileIndex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProjectFileIndex>(this){
            final /* synthetic */ ModuleInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProjectFileIndex invoke() {
                return ProjectFileIndex.getInstance((Project)ModuleInfoProvider.access$getProject$p(this.this$0));
            }
        }));
        this.libraryInfoCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LibraryInfoCache>(this){
            final /* synthetic */ ModuleInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LibraryInfoCache invoke() {
                return LibraryInfoCache.Companion.getInstance(ModuleInfoProvider.access$getProject$p(this.this$0));
            }
        }));
    }

    private final ProjectFileIndex getFileIndex() {
        Lazy lazy = this.fileIndex$delegate;
        return (ProjectFileIndex)lazy.getValue();
    }

    private final LibraryInfoCache getLibraryInfoCache() {
        Lazy lazy = this.libraryInfoCache$delegate;
        return (LibraryInfoCache)lazy.getValue();
    }

    @NotNull
    public final Sequence<Result<IdeaModuleInfo>> collect(@NotNull PsiElement element3, @NotNull Configuration config2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        return SeqKt.seq((Function1)new Function1<SeqScope<? super Result<? extends IdeaModuleInfo>>, Unit>(this, element3, config2){
            final /* synthetic */ ModuleInfoProvider this$0;
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ Configuration $config;
            {
                this.this$0 = $receiver;
                this.$element = $element;
                this.$config = $config;
                super(1);
            }

            public final void invoke(@NotNull SeqScope<? super Result<? extends IdeaModuleInfo>> $this$seq) {
                Intrinsics.checkNotNullParameter($this$seq, (String)"$this$seq");
                ModuleInfoProvider.access$collectByElement(this.this$0, $this$seq, this.$element, this.$config);
            }
        });
    }

    public static /* synthetic */ Sequence collect$default(ModuleInfoProvider moduleInfoProvider, PsiElement psiElement2, Configuration configuration2, int n, Object object) {
        if ((n & 2) != 0) {
            configuration2 = Configuration.Companion.getDefault();
        }
        return moduleInfoProvider.collect(psiElement2, configuration2);
    }

    @NotNull
    public final Sequence<Result<IdeaModuleInfo>> collect(@NotNull VirtualFile virtualFile2, boolean isLibrarySource, @NotNull Configuration config2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        return SeqKt.seq((Function1)new Function1<SeqScope<? super Result<? extends IdeaModuleInfo>>, Unit>(this, virtualFile2, isLibrarySource, config2){
            final /* synthetic */ ModuleInfoProvider this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ boolean $isLibrarySource;
            final /* synthetic */ Configuration $config;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                this.$isLibrarySource = $isLibrarySource;
                this.$config = $config;
                super(1);
            }

            public final void invoke(@NotNull SeqScope<? super Result<? extends IdeaModuleInfo>> $this$seq) {
                Intrinsics.checkNotNullParameter($this$seq, (String)"$this$seq");
                ModuleInfoProvider.access$collectByFile(this.this$0, $this$seq, this.$virtualFile, this.$isLibrarySource, this.$config);
            }
        });
    }

    public static /* synthetic */ Sequence collect$default(ModuleInfoProvider moduleInfoProvider, VirtualFile virtualFile2, boolean bl, Configuration configuration2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            configuration2 = Configuration.Companion.getDefault();
        }
        return moduleInfoProvider.collect(virtualFile2, bl, configuration2);
    }

    private final void collectByElement(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByElement, PsiElement element3, Configuration config2) {
        KtFile containingKtFile;
        ModuleInfo moduleInfo;
        PsiFile containingFile = element3.getContainingFile();
        if (containingFile != null && (moduleInfo = KotlinProjectStructureUtils.getForcedModuleInfo(containingFile)) instanceof IdeaModuleInfo) {
            ModuleInfoProviderKt.register($this$collectByElement, (IdeaModuleInfo)moduleInfo);
        }
        if (element3 instanceof PsiDirectory) {
            VirtualFile virtualFile2 = ((PsiDirectory)element3).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            this.collectByFile($this$collectByElement, virtualFile2, false, config2);
            return;
        }
        if (element3 instanceof KtLightElement) {
            this.collectByLightElement($this$collectByElement, (KtLightElement)element3, config2);
        }
        this.collectByUserData($this$collectByElement, new UserDataModuleContainer.ForElement(element3));
        if (containingFile == null) {
            String message2 = "Analyzing element of type " + element3.getClass() + " with no containing file";
            ModuleInfoProviderKt.reportError($this$collectByElement, (Throwable)new KotlinExceptionWithAttachments(message2).withAttachment("element.kt", (Object)element3.getText()));
        }
        KtFile ktFile2 = containingKtFile = containingFile instanceof KtFile ? (KtFile)containingFile : null;
        if (containingKtFile != null) {
            ModuleInfo explicitModuleInfo;
            Object object = ((KtFile)containingFile).getVirtualFile();
            if (object != null && (object = ExtensionFileContextModuleKt.getAnalysisExtensionFileContextModule(object)) != null) {
                Object module2 = object;
                boolean bl = false;
                ModuleInfoProviderKt.register($this$collectByElement, KotlinProjectStructureUtils.getModuleInfo((KaModule)module2));
            }
            PsiElement analysisContext = KtPsiFactoryKt.getAnalysisContext((KtFile)containingKtFile);
            if (analysisContext != null) {
                this.collectByElement($this$collectByElement, analysisContext, config2);
            }
            if (KtPsiFactoryKt.getDoNotAnalyze((KtFile)containingKtFile) != null) {
                return;
            }
            Object object2 = KotlinProjectStructureUtils.getForcedModuleInfo((PsiFile)containingKtFile);
            if (object2 == null) {
                PsiFile bl = containingKtFile.getOriginalFile();
                KtFile ktFile3 = bl instanceof KtFile ? (KtFile)bl : null;
                object2 = ktFile3 != null ? KotlinProjectStructureUtils.getForcedModuleInfo((PsiFile)ktFile3) : null;
            }
            if ((explicitModuleInfo = object2) instanceof IdeaModuleInfo) {
                ModuleInfoProviderKt.register($this$collectByElement, (IdeaModuleInfo)explicitModuleInfo);
            }
            if (containingKtFile instanceof KtCodeFragment) {
                PsiElement context2 = ((KtCodeFragment)containingKtFile).getContext();
                if (context2 != null) {
                    this.collectByElement($this$collectByElement, context2, config2);
                } else {
                    String message3 = "Analyzing code fragment of type " + containingKtFile.getClass() + " with no context";
                    KotlinExceptionWithAttachments error2 = new KotlinExceptionWithAttachments(message3).withAttachment("file.kt", (Object)((KtCodeFragment)containingKtFile).getText());
                    ModuleInfoProviderKt.reportError($this$collectByElement, (Throwable)error2);
                }
            }
        }
        if (containingFile != null) {
            VirtualFile virtualFile3 = containingFile.getOriginalFile().getVirtualFile();
            if (virtualFile3 != null) {
                boolean bl;
                ModuleInfoProviderExtension extension$iv$iv;
                Iterator iterator2;
                boolean $i$f$callExtensions;
                ModuleInfoProvider this_$iv$iv;
                ModuleInfoProvider this_$iv = this;
                boolean $i$f$withCallExtensions = false;
                if (config2.getPreferModulesFromExtensions()) {
                    this_$iv$iv = this_$iv;
                    $i$f$callExtensions = false;
                    iterator2 = this_$iv$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
                    while (iterator2.hasNext()) {
                        ModuleInfoProviderExtension $this$collectByElement_u24lambda_u241 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                        bl = false;
                        $this$collectByElement_u24lambda_u241.collectByElement($this$collectByElement, element3, containingFile, virtualFile3);
                    }
                }
                boolean bl2 = false;
                boolean isLibrarySource = containingKtFile != null && this.isLibrarySource(containingKtFile, config2);
                this.collectByFile($this$collectByElement, virtualFile3, isLibrarySource, config2);
                if (!config2.getPreferModulesFromExtensions()) {
                    this_$iv$iv = this_$iv;
                    $i$f$callExtensions = false;
                    iterator2 = this_$iv$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
                    while (iterator2.hasNext()) {
                        ModuleInfoProviderExtension $this$collectByElement_u24lambda_u241 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                        bl = false;
                        $this$collectByElement_u24lambda_u241.collectByElement($this$collectByElement, element3, containingFile, virtualFile3);
                    }
                }
            } else {
                String message4 = "Analyzing element of type " + element3.getClass() + " in non-physical file of type " + containingFile.getClass();
                ModuleInfoProviderKt.reportError($this$collectByElement, (Throwable)new KotlinExceptionWithAttachments(message4).withAttachment("file.kt", (Object)containingFile.getText()));
            }
        }
    }

    private final void callExtensions(Function1<? super ModuleInfoProviderExtension, Unit> block2) {
        boolean $i$f$callExtensions = false;
        for (ModuleInfoProviderExtension extension2 : this.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList()) {
            block2.invoke((Object)extension2);
        }
    }

    private final void withCallExtensions(Configuration config2, Function1<? super ModuleInfoProviderExtension, Unit> extensionBlock, Function0<Unit> block2) {
        boolean $i$f$callExtensions;
        ModuleInfoProvider this_$iv;
        boolean $i$f$withCallExtensions = false;
        if (config2.getPreferModulesFromExtensions()) {
            this_$iv = this;
            $i$f$callExtensions = false;
            for (ModuleInfoProviderExtension extension$iv : this_$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList()) {
                extensionBlock.invoke((Object)extension$iv);
            }
        }
        block2.invoke();
        if (!config2.getPreferModulesFromExtensions()) {
            this_$iv = this;
            $i$f$callExtensions = false;
            for (ModuleInfoProviderExtension extension$iv : this_$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList()) {
                extensionBlock.invoke((Object)extension$iv);
            }
        }
    }

    private final boolean isLibrarySource(KtFile containingKtFile, Configuration config2) {
        boolean isCompiled = containingKtFile.isCompiled();
        return config2.getCreateSourceLibraryInfoForLibraryBinaries() ? isCompiled : !isCompiled;
    }

    private final void collectByLightElement(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByLightElement, KtLightElement<?, ?> element3, Configuration config2) {
        KtElement originalElement;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)element3;
        boolean $i$f$getNonStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtLightClassForDecompiledDeclaration.class, (boolean)false) != null) {
            VirtualFile virtualFile2 = element3.getContainingFile().getVirtualFile();
            if (virtualFile2 == null) {
                throw new IllegalStateException("Decompiled class should be build from physical file".toString());
            }
            VirtualFile virtualFile3 = virtualFile2;
            this.collectByFile($this$collectByLightElement, virtualFile3, false, config2);
        }
        if ((originalElement = element3.getKotlinOrigin()) != null) {
            this.collectByElement($this$collectByLightElement, (PsiElement)originalElement, config2);
        } else if (element3 instanceof KtLightClassForFacade) {
            this.collectByElement($this$collectByLightElement, (PsiElement)CollectionsKt.first((Iterable)((KtLightClassForFacade)element3).getFiles()), config2);
        } else {
            KotlinExceptionWithAttachments error2 = new KotlinExceptionWithAttachments("Light element without origin is referenced by resolve").withAttachment("element.txt", element3);
            ModuleInfoProviderKt.reportError($this$collectByLightElement, (Throwable)error2);
        }
    }

    private final void collectByFile(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByFile, VirtualFile virtualFile2, boolean isLibrarySource, Configuration config2) {
        ModuleInfoProviderExtension extension$iv$iv;
        Iterator iterator2;
        boolean $i$f$callExtensions;
        ModuleInfoProvider this_$iv$iv;
        this.collectByUserData($this$collectByFile, new UserDataModuleContainer.ForVirtualFile(virtualFile2, this.project));
        ModuleInfoProvider this_$iv = this;
        boolean $i$f$withCallExtensions = false;
        if (config2.getPreferModulesFromExtensions()) {
            this_$iv$iv = this_$iv;
            $i$f$callExtensions = false;
            iterator2 = this_$iv$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
            while (iterator2.hasNext()) {
                ModuleInfoProviderExtension $this$collectByFile_u24lambda_u243 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                boolean bl = false;
                $this$collectByFile_u24lambda_u243.collectByFile($this$collectByFile, this.project, virtualFile2, isLibrarySource, config2);
            }
        }
        boolean bl = false;
        this.collectSourceRelatedByFile($this$collectByFile, virtualFile2, config2);
        HashSet<IdeaModuleInfo> visited = new HashSet<IdeaModuleInfo>();
        $this$collectByFile.yield((Function0<? super Result<? extends IdeaModuleInfo>>)((Function0)new Function0<Result<? extends IdeaModuleInfo>>(this, virtualFile2, isLibrarySource, visited, config2){
            final /* synthetic */ ModuleInfoProvider this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ boolean $isLibrarySource;
            final /* synthetic */ HashSet<IdeaModuleInfo> $visited;
            final /* synthetic */ Configuration $config;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                this.$isLibrarySource = $isLibrarySource;
                this.$visited = $visited;
                this.$config = $config;
                super(0);
            }

            @Nullable
            public final Result<IdeaModuleInfo> invoke-xLWZpok() {
                Result result2;
                IdeaModuleInfo contextualModuleResult;
                IdeaModuleInfo ideaModuleInfo = contextualModuleResult = ModuleInfoProvider.access$contextByContextualBinaryModule(this.this$0, this.$virtualFile, this.$isLibrarySource, this.$visited, this.$config);
                if (ideaModuleInfo != null) {
                    IdeaModuleInfo ideaModuleInfo2 = ideaModuleInfo;
                    IdeaModuleInfo p0 = ideaModuleInfo2;
                    boolean bl = false;
                    result2 = Result.box-impl((Object)Result.constructor-impl((Object)p0));
                } else {
                    result2 = null;
                }
                return result2;
            }
        }));
        $this$collectByFile.yieldAll((Iterable<? super Result<? extends IdeaModuleInfo>>)new Iterable<Result<? extends IdeaModuleInfo>>(this, virtualFile2, isLibrarySource, visited, config2){
            final /* synthetic */ ModuleInfoProvider this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ boolean $isLibrarySource;
            final /* synthetic */ HashSet<IdeaModuleInfo> $visited;
            final /* synthetic */ Configuration $config;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                this.$isLibrarySource = $isLibrarySource;
                this.$visited = $visited;
                this.$config = $config;
            }

            @NotNull
            public Iterator<Result<IdeaModuleInfo>> iterator() {
                Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<List<OrderEntry>>(this.this$0, this.$virtualFile){
                    final /* synthetic */ ModuleInfoProvider this$0;
                    final /* synthetic */ VirtualFile $virtualFile;
                    {
                        this.this$0 = $receiver;
                        this.$virtualFile = $virtualFile;
                        super(0);
                    }

                    @NotNull
                    public final List<OrderEntry> invoke() {
                        return ModuleInfoProvider.access$getFileIndex(this.this$0).getOrderEntriesForFile(this.$virtualFile);
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                List orderEntries2 = (List)object;
                Iterator<E> iterator2 = orderEntries2.iterator();
                return new MappingIterator<E, T>(iterator2, (Function1)new Function1<OrderEntry, Result<? extends IdeaModuleInfo>>(this.this$0, this.$virtualFile, this.$isLibrarySource, this.$visited, this.$config){
                    final /* synthetic */ ModuleInfoProvider this$0;
                    final /* synthetic */ VirtualFile $virtualFile;
                    final /* synthetic */ boolean $isLibrarySource;
                    final /* synthetic */ HashSet<IdeaModuleInfo> $visited;
                    final /* synthetic */ Configuration $config;
                    {
                        this.this$0 = $receiver;
                        this.$virtualFile = $virtualFile;
                        this.$isLibrarySource = $isLibrarySource;
                        this.$visited = $visited;
                        this.$config = $config;
                        super(1);
                    }

                    @Nullable
                    public final Result<IdeaModuleInfo> invoke-CmtIpJM(OrderEntry orderEntry) {
                        Result result2;
                        Intrinsics.checkNotNull((Object)orderEntry);
                        IdeaModuleInfo ideaModuleInfo = ModuleInfoProvider.access$collectByOrderEntry(this.this$0, this.$virtualFile, orderEntry, this.$isLibrarySource, this.$visited, this.$config);
                        if (ideaModuleInfo != null) {
                            IdeaModuleInfo ideaModuleInfo2 = ideaModuleInfo;
                            IdeaModuleInfo p0 = ideaModuleInfo2;
                            boolean bl = false;
                            result2 = Result.box-impl((Object)Result.constructor-impl((Object)p0));
                        } else {
                            result2 = null;
                        }
                        return result2;
                    }
                });
            }
        });
        if (!config2.getPreferModulesFromExtensions()) {
            this_$iv$iv = this_$iv;
            $i$f$callExtensions = false;
            iterator2 = this_$iv$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
            while (iterator2.hasNext()) {
                ModuleInfoProviderExtension $this$collectByFile_u24lambda_u243 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                boolean bl2 = false;
                $this$collectByFile_u24lambda_u243.collectByFile($this$collectByFile, this.project, virtualFile2, isLibrarySource, config2);
            }
        }
    }

    private final IdeaModuleInfo contextByContextualBinaryModule(VirtualFile virtualFile2, boolean isLibrarySource, HashSet<IdeaModuleInfo> visited, Configuration config2) {
        GlobalSearchScope contentScope;
        IdeaModuleInfo ideaModuleInfo = config2.getContextualModuleInfo();
        if (ideaModuleInfo == null) {
            return null;
        }
        IdeaModuleInfo contextualModuleInfo = ideaModuleInfo;
        IdeaModuleInfo ideaModuleInfo2 = contextualModuleInfo;
        Object object = (ideaModuleInfo2 instanceof LibraryInfo ? true : ideaModuleInfo2 instanceof SdkInfo) ? contextualModuleInfo.getContentScope() : (contentScope = ideaModuleInfo2 instanceof LibrarySourceInfo ? ((LibrarySourceInfo)contextualModuleInfo).sourceScope() : null);
        if (contentScope == null || !contentScope.contains(virtualFile2)) {
            return null;
        }
        ideaModuleInfo2 = contextualModuleInfo;
        return ideaModuleInfo2 instanceof LibraryInfo ? this.collectByLibrary(virtualFile2, (Library)((LibraryInfo)contextualModuleInfo).getLibrary(), isLibrarySource, visited, config2) : (ideaModuleInfo2 instanceof LibrarySourceInfo ? this.collectByLibrary(virtualFile2, ((LibrarySourceInfo)contextualModuleInfo).getLibrary(), isLibrarySource, visited, config2) : (ideaModuleInfo2 instanceof SdkInfo ? this.collectBySdk(((SdkInfo)contextualModuleInfo).getSdk(), visited) : null));
    }

    private final void collectSourceRelatedByFile(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectSourceRelatedByFile, VirtualFile virtualFile2, Configuration config2) {
        $this$collectSourceRelatedByFile.yieldAll((Iterable<? super Result<? extends IdeaModuleInfo>>)new Iterable<Result<? extends IdeaModuleInfo>>(this, config2, virtualFile2){
            final /* synthetic */ ModuleInfoProvider this$0;
            final /* synthetic */ Configuration $config;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                this.$virtualFile = $virtualFile;
            }

            @NotNull
            public Iterator<Result<IdeaModuleInfo>> iterator() {
                Sequence<T> modules2 = SeqKt.seq((Function1)new Function1<SeqScope<? super Module>, Unit>(this.this$0, this.$config, this.$virtualFile){
                    final /* synthetic */ ModuleInfoProvider this$0;
                    final /* synthetic */ Configuration $config;
                    final /* synthetic */ VirtualFile $virtualFile;
                    {
                        this.this$0 = $receiver;
                        this.$config = $config;
                        this.$virtualFile = $virtualFile;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull SeqScope<? super Module> $this$seq) {
                        ModuleInfoProviderExtension extension$iv$iv;
                        Iterator<E> iterator2;
                        boolean $i$f$callExtensions;
                        void this_$iv$iv;
                        void this_$iv;
                        void config$iv;
                        Intrinsics.checkNotNullParameter($this$seq, (String)"$this$seq");
                        ModuleInfoProvider moduleInfoProvider = this.this$0;
                        Configuration configuration2 = this.$config;
                        ModuleInfoProvider moduleInfoProvider2 = this.this$0;
                        VirtualFile virtualFile2 = this.$virtualFile;
                        ModuleInfoProvider moduleInfoProvider3 = this.this$0;
                        VirtualFile virtualFile3 = this.$virtualFile;
                        boolean $i$f$withCallExtensions = false;
                        if (config$iv.getPreferModulesFromExtensions()) {
                            this_$iv$iv = this_$iv;
                            $i$f$callExtensions = false;
                            iterator2 = ModuleInfoProvider.access$getProject$p((ModuleInfoProvider)this_$iv$iv).getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
                            while (iterator2.hasNext()) {
                                ModuleInfoProviderExtension $this$invoke_u24lambda_u240 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                                boolean bl = false;
                                $this$invoke_u24lambda_u240.findContainingModules($this$seq, ModuleInfoProvider.access$getProject$p(moduleInfoProvider2), virtualFile2);
                            }
                        }
                        boolean bl = false;
                        Module module2 = (Module)ActionsKt.runReadAction((Function0)((Function0)new Function0<Module>(moduleInfoProvider3, virtualFile3){
                            final /* synthetic */ ModuleInfoProvider this$0;
                            final /* synthetic */ VirtualFile $virtualFile;
                            {
                                this.this$0 = $receiver;
                                this.$virtualFile = $virtualFile;
                                super(0);
                            }

                            @Nullable
                            public final Module invoke() {
                                return ModuleInfoProvider.access$getFileIndex(this.this$0).getModuleForFile(this.$virtualFile);
                            }
                        }));
                        if (module2 != null) {
                            Module module3 = module2;
                            boolean bl2 = false;
                            $this$seq.yield((Function0<? super Module>)((Function0)new Function0<Module>(module3){
                                final /* synthetic */ Module $module;
                                {
                                    this.$module = $module;
                                    super(0);
                                }

                                @Nullable
                                public final Module invoke() {
                                    return this.$module;
                                }
                            }));
                        }
                        if (!config$iv.getPreferModulesFromExtensions()) {
                            this_$iv$iv = this_$iv;
                            $i$f$callExtensions = false;
                            iterator2 = ModuleInfoProvider.access$getProject$p((ModuleInfoProvider)this_$iv$iv).getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
                            while (iterator2.hasNext()) {
                                ModuleInfoProviderExtension $this$invoke_u24lambda_u240 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                                boolean bl3 = false;
                                $this$invoke_u24lambda_u240.findContainingModules($this$seq, ModuleInfoProvider.access$getProject$p(moduleInfoProvider2), virtualFile2);
                            }
                        }
                    }
                });
                Iterator iterator2 = modules2.iterator();
                return new MappingIterator<K, T>(iterator2, (Function1)new Function1<Module, Result<? extends ModuleSourceInfoWithExpectedBy>>(this.this$0, this.$virtualFile){
                    final /* synthetic */ ModuleInfoProvider this$0;
                    final /* synthetic */ VirtualFile $virtualFile;
                    {
                        this.this$0 = $receiver;
                        this.$virtualFile = $virtualFile;
                        super(1);
                    }

                    @Nullable
                    public final Result<ModuleSourceInfoWithExpectedBy> invoke-CmtIpJM(@NotNull Module module2) {
                        Result result2;
                        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
                        if (module2.isDisposed()) {
                            return null;
                        }
                        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)ModuleInfoProvider.access$getProject$p(this.this$0));
                        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
                        ProjectFileIndex projectFileIndex2 = projectFileIndex;
                        KotlinSourceRootType sourceRootType = KotlinProjectStructureUtils.getKotlinSourceRootType(projectFileIndex2, this.$virtualFile);
                        ModuleSourceInfoWithExpectedBy moduleSourceInfoWithExpectedBy = KotlinProjectStructureUtils.asSourceInfo(module2, sourceRootType);
                        if (moduleSourceInfoWithExpectedBy != null) {
                            ModuleSourceInfoWithExpectedBy moduleSourceInfoWithExpectedBy2 = moduleSourceInfoWithExpectedBy;
                            ModuleSourceInfoWithExpectedBy p0 = moduleSourceInfoWithExpectedBy2;
                            boolean bl = false;
                            result2 = Result.box-impl((Object)Result.constructor-impl((Object)p0));
                        } else {
                            result2 = null;
                        }
                        return result2;
                    }
                });
            }
        });
        VirtualFile fileOrigin = ProjectStructureUtils.getOutsiderFileOrigin(this.project, virtualFile2);
        if (fileOrigin != null) {
            this.collectSourceRelatedByFile($this$collectSourceRelatedByFile, fileOrigin, config2);
        }
    }

    private final IdeaModuleInfo collectByOrderEntry(VirtualFile virtualFile2, OrderEntry orderEntry, boolean isLibrarySource, HashSet<IdeaModuleInfo> visited, Configuration config2) {
        Sdk sdk2;
        Library library2;
        if (orderEntry instanceof ModuleOrderEntry) {
            return null;
        }
        ProgressManager.checkCanceled();
        if (!orderEntry.isValid()) {
            return null;
        }
        if (orderEntry instanceof LibraryOrderEntry && (library2 = ((LibraryOrderEntry)orderEntry).getLibrary()) != null) {
            return this.collectByLibrary(virtualFile2, library2, isLibrarySource, visited, config2);
        }
        if (orderEntry instanceof JdkOrderEntry && (sdk2 = ((JdkOrderEntry)orderEntry).getJdk()) != null) {
            return this.collectBySdk(sdk2, visited);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final IdeaModuleInfo collectByLibrary(VirtualFile virtualFile, Library library, boolean isLibrarySource, HashSet<IdeaModuleInfo> visited, Configuration config) {
        block5: {
            block4: {
                var7_6 = config.getContextualModuleInfo();
                v0 = sourceContext = var7_6 instanceof ModuleSourceInfo != false ? (ModuleSourceInfo)var7_6 : null;
                if (isLibrarySource) ** GOTO lbl-1000
                var9_9 = config.getContextualModuleInfo();
                v1 = var9_9 instanceof LibrarySourceInfo != false ? (LibrarySourceInfo)var9_9 : null;
                if (Intrinsics.areEqual((Object)(v1 != null ? v1.getLibrary() : null), (Object)library)) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = useLibrarySource = false;
                }
                if (useLibrarySource || !SourceKindFilterUtils.matches(RootKindFilter.libraryClasses, this.project, virtualFile)) break block4;
                for (LibraryInfo libraryInfo : this.getLibraryInfoCache().get(library)) {
                    if (!visited.add(libraryInfo) || !this.isApplicable(libraryInfo, sourceContext)) continue;
                    return libraryInfo;
                }
                break block5;
            }
            if (!useLibrarySource && !SourceKindFilterUtils.matches(RootKindFilter.libraryFiles, this.project, virtualFile)) break block5;
            for (LibraryInfo libraryInfo : this.getLibraryInfoCache().get(library)) {
                moduleInfo = libraryInfo.getSourcesModuleInfo();
                if (!visited.add(moduleInfo) || !this.isApplicable(libraryInfo, sourceContext)) continue;
                return moduleInfo;
            }
        }
        return null;
    }

    private final IdeaModuleInfo collectBySdk(Sdk sdk2, HashSet<IdeaModuleInfo> visited) {
        SdkInfo moduleInfo = new SdkInfo(this.project, sdk2);
        if (visited.add(moduleInfo)) {
            return moduleInfo;
        }
        return null;
    }

    private final boolean isApplicable(LibraryInfo $this$isApplicable, ModuleSourceInfo contextualModuleInfo) {
        if (contextualModuleInfo == null) {
            return true;
        }
        ComponentManager $this$service$iv = (ComponentManager)$this$isApplicable.getProject();
        boolean $i$f$service = false;
        Class<LibraryUsageIndex> serviceClass$iv = LibraryUsageIndex.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        LibraryUsageIndex service2 = (LibraryUsageIndex)object;
        return service2.hasDependentModule($this$isApplicable, contextualModuleInfo.getModule());
    }

    private final void collectByUserData(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByUserData, UserDataModuleContainer container) {
        ModuleInfoProviderKt.register($this$collectByUserData, (Function0<? extends IdeaModuleInfo>)((Function0)new Function0<IdeaModuleInfo>(container){
            final /* synthetic */ UserDataModuleContainer $container;
            {
                this.$container = $container;
                super(0);
            }

            @Nullable
            public final IdeaModuleInfo invoke() {
                Module module2 = this.$container.getModule();
                JpsModuleSourceRootType<?> sourceRootType = this.$container.getCustomSourceRootType();
                if (module2 != null && sourceRootType != null) {
                    ModuleSourceInfoWithExpectedBy moduleSourceInfoWithExpectedBy = KotlinProjectStructureUtils.asSourceInfo(module2, KotlinProjectStructureUtils.getSourceRootType(sourceRootType));
                    if (moduleSourceInfoWithExpectedBy != null) {
                        ModuleSourceInfoWithExpectedBy moduleInfo = moduleSourceInfoWithExpectedBy;
                        boolean bl = false;
                        return moduleInfo;
                    }
                }
                return null;
            }
        }));
        Library library2 = container.getCustomLibrary();
        if (library2 != null) {
            Library library3 = library2;
            boolean bl = false;
            for (LibraryInfo libraryInfo : this.getLibraryInfoCache().get(library3)) {
                ModuleInfoProviderKt.register($this$collectByUserData, libraryInfo);
            }
        }
        ModuleInfoProviderKt.register($this$collectByUserData, (Function0<? extends IdeaModuleInfo>)((Function0)new Function0<IdeaModuleInfo>(container, this){
            final /* synthetic */ UserDataModuleContainer $container;
            final /* synthetic */ ModuleInfoProvider this$0;
            {
                this.$container = $container;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final IdeaModuleInfo invoke() {
                SdkInfo sdkInfo;
                Sdk sdk2 = this.$container.getCustomSdk();
                if (sdk2 != null) {
                    Sdk sdk3 = sdk2;
                    ModuleInfoProvider moduleInfoProvider = this.this$0;
                    Sdk it = sdk3;
                    boolean bl = false;
                    sdkInfo = new SdkInfo(ModuleInfoProvider.access$getProject$p(moduleInfoProvider), it);
                } else {
                    sdkInfo = null;
                }
                return sdkInfo;
            }
        }));
    }

    public static final /* synthetic */ void access$collectByElement(ModuleInfoProvider $this, SeqScope $receiver, PsiElement element3, Configuration config2) {
        $this.collectByElement($receiver, element3, config2);
    }

    public static final /* synthetic */ void access$collectByFile(ModuleInfoProvider $this, SeqScope $receiver, VirtualFile virtualFile2, boolean isLibrarySource, Configuration config2) {
        $this.collectByFile($receiver, virtualFile2, isLibrarySource, config2);
    }

    public static final /* synthetic */ ProjectFileIndex access$getFileIndex(ModuleInfoProvider $this) {
        return $this.getFileIndex();
    }

    public static final /* synthetic */ IdeaModuleInfo access$contextByContextualBinaryModule(ModuleInfoProvider $this, VirtualFile virtualFile2, boolean isLibrarySource, HashSet visited, Configuration config2) {
        return $this.contextByContextualBinaryModule(virtualFile2, isLibrarySource, visited, config2);
    }

    public static final /* synthetic */ IdeaModuleInfo access$collectByOrderEntry(ModuleInfoProvider $this, VirtualFile virtualFile2, OrderEntry orderEntry, boolean isLibrarySource, HashSet visited, Configuration config2) {
        return $this.collectByOrderEntry(virtualFile2, orderEntry, isLibrarySource, visited, config2);
    }

    static {
        Logger logger = Logger.getInstance(ModuleInfoProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$kotlin_base_project_structure", "()Lcom/intellij/openapi/diagnostic/Logger;", "findAnchorElement", "Lcom/intellij/psi/PsiElement;", "element", "getInstance", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.project-structure"})
    @SourceDebugExtension(value={"SMAP\nModuleInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,508:1\n31#2,2:509\n146#3:511\n1#4:512\n*S KotlinDebug\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Companion\n*L\n78#1:509,2\n87#1:511\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$kotlin_base_project_structure() {
            return LOG;
        }

        @NotNull
        public final ModuleInfoProvider getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ModuleInfoProvider> serviceClass$iv = ModuleInfoProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ModuleInfoProvider)object;
        }

        @Nullable
        public final PsiElement findAnchorElement(@NotNull PsiElement element3) {
            PsiElement psiElement2;
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            if (element3 instanceof PsiDirectory) {
                psiElement2 = element3;
            } else if (!(element3 instanceof KtLightElement)) {
                psiElement2 = (PsiElement)element3.getContainingFile();
            } else {
                PsiElement $this$getNonStrictParentOfType$iv = element3;
                boolean $i$f$getNonStrictParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtLightClassForDecompiledDeclaration.class, (boolean)false) != null) {
                    psiElement2 = null;
                } else if (element3 instanceof KtLightClassForFacade) {
                    psiElement2 = (PsiElement)CollectionsKt.first((Iterable)((KtLightClassForFacade)element3).getFiles());
                } else {
                    KtElement ktElement = ((KtLightElement)element3).getKotlinOrigin();
                    if (ktElement != null) {
                        PsiElement p0 = (PsiElement)ktElement;
                        boolean bl = false;
                        psiElement2 = this.findAnchorElement(p0);
                    } else {
                        psiElement2 = null;
                    }
                }
            }
            return psiElement2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "", "createSourceLibraryInfoForLibraryBinaries", "", "preferModulesFromExtensions", "contextualModuleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "(ZZLorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;)V", "getContextualModuleInfo", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "getCreateSourceLibraryInfoForLibraryBinaries", "()Z", "getPreferModulesFromExtensions", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "kotlin.base.project-structure"})
    public static final class Configuration {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean createSourceLibraryInfoForLibraryBinaries;
        private final boolean preferModulesFromExtensions;
        @Nullable
        private final IdeaModuleInfo contextualModuleInfo;
        @NotNull
        private static final Configuration Default = new Configuration(false, false, null, 7, null);

        public Configuration(boolean createSourceLibraryInfoForLibraryBinaries, boolean preferModulesFromExtensions, @Nullable IdeaModuleInfo contextualModuleInfo) {
            this.createSourceLibraryInfoForLibraryBinaries = createSourceLibraryInfoForLibraryBinaries;
            this.preferModulesFromExtensions = preferModulesFromExtensions;
            this.contextualModuleInfo = contextualModuleInfo;
        }

        public /* synthetic */ Configuration(boolean bl, boolean bl2, IdeaModuleInfo ideaModuleInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                ideaModuleInfo = null;
            }
            this(bl, bl2, ideaModuleInfo);
        }

        public final boolean getCreateSourceLibraryInfoForLibraryBinaries() {
            return this.createSourceLibraryInfoForLibraryBinaries;
        }

        public final boolean getPreferModulesFromExtensions() {
            return this.preferModulesFromExtensions;
        }

        @Nullable
        public final IdeaModuleInfo getContextualModuleInfo() {
            return this.contextualModuleInfo;
        }

        public final boolean component1() {
            return this.createSourceLibraryInfoForLibraryBinaries;
        }

        public final boolean component2() {
            return this.preferModulesFromExtensions;
        }

        @Nullable
        public final IdeaModuleInfo component3() {
            return this.contextualModuleInfo;
        }

        @NotNull
        public final Configuration copy(boolean createSourceLibraryInfoForLibraryBinaries, boolean preferModulesFromExtensions, @Nullable IdeaModuleInfo contextualModuleInfo) {
            return new Configuration(createSourceLibraryInfoForLibraryBinaries, preferModulesFromExtensions, contextualModuleInfo);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration2, boolean bl, boolean bl2, IdeaModuleInfo ideaModuleInfo, int n, Object object) {
            if ((n & 1) != 0) {
                bl = configuration2.createSourceLibraryInfoForLibraryBinaries;
            }
            if ((n & 2) != 0) {
                bl2 = configuration2.preferModulesFromExtensions;
            }
            if ((n & 4) != 0) {
                ideaModuleInfo = configuration2.contextualModuleInfo;
            }
            return configuration2.copy(bl, bl2, ideaModuleInfo);
        }

        @NotNull
        public String toString() {
            return "Configuration(createSourceLibraryInfoForLibraryBinaries=" + this.createSourceLibraryInfoForLibraryBinaries + ", preferModulesFromExtensions=" + this.preferModulesFromExtensions + ", contextualModuleInfo=" + this.contextualModuleInfo + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.createSourceLibraryInfoForLibraryBinaries);
            result2 = result2 * 31 + Boolean.hashCode(this.preferModulesFromExtensions);
            result2 = result2 * 31 + (this.contextualModuleInfo == null ? 0 : this.contextualModuleInfo.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof Configuration)) {
                return false;
            }
            Configuration configuration2 = (Configuration)other2;
            if (this.createSourceLibraryInfoForLibraryBinaries != configuration2.createSourceLibraryInfoForLibraryBinaries) {
                return false;
            }
            if (this.preferModulesFromExtensions != configuration2.preferModulesFromExtensions) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.contextualModuleInfo, (Object)configuration2.contextualModuleInfo);
        }

        public Configuration() {
            this(false, false, null, 7, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration$Companion;", "", "()V", "Default", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "getDefault", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "kotlin.base.project-structure"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Configuration getDefault() {
                return Default;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

