/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.WasmPlatform;
import org.jetbrains.kotlin.platform.WasmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.platform.wasm.WasmPlatformUnspecifiedTarget;
import org.jetbrains.kotlin.platform.wasm.WasmPlatformWithTarget;
import org.jetbrains.kotlin.platform.wasm.WasmTarget;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0002H\u0002\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0002H\u0001\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\f\u0010\u000f\u001a\u00020\t*\u00020\u0007H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0010"}, d2={"isLegacyNativeKlibComponent", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "checkKlibComponent", "componentFile", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "requestedBuiltInsPlatform", "Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;", "checkKlibWasmTarget", "manifestProperties", "Ljava/util/Properties;", "isKLibRootCandidate", "isKlibLibraryRootForPlatform", "toBuiltInsPlatform", "kotlin.base.platforms"})
@JvmName(name="KLibUtils")
@SourceDebugExtension(value={"SMAP\nKLibUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KLibUtils.kt\norg/jetbrains/kotlin/idea/base/platforms/KLibUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n12474#2,2:122\n1#3:124\n*S KotlinDebug\n*F\n+ 1 KLibUtils.kt\norg/jetbrains/kotlin/idea/base/platforms/KLibUtils\n*L\n49#1:122,2\n*E\n"})
public final class KLibUtils {
    @ApiStatus.Internal
    public static final boolean isKLibRootCandidate(@NotNull VirtualFile $this$isKLibRootCandidate) {
        Intrinsics.checkNotNullParameter((Object)$this$isKLibRootCandidate, (String)"<this>");
        return (!FileTypeRegistry.getInstance().isFileOfType($this$isKLibRootCandidate, (FileType)ArchiveFileType.INSTANCE) || Intrinsics.areEqual((Object)$this$isKLibRootCandidate.getExtension(), (Object)"klib")) && $this$isKLibRootCandidate.isDirectory();
    }

    @ApiStatus.Internal
    public static final boolean isKlibLibraryRootForPlatform(@NotNull VirtualFile $this$isKlibLibraryRootForPlatform, @NotNull TargetPlatform targetPlatform) {
        Intrinsics.checkNotNullParameter((Object)$this$isKlibLibraryRootForPlatform, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        if (!KLibUtils.isKLibRootCandidate($this$isKlibLibraryRootForPlatform)) {
            return false;
        }
        BuiltInsPlatform requestedBuiltInsPlatform = KLibUtils.toBuiltInsPlatform(targetPlatform);
        if (requestedBuiltInsPlatform == BuiltInsPlatform.NATIVE && KLibUtils.checkKlibComponent($this$isKlibLibraryRootForPlatform, targetPlatform, requestedBuiltInsPlatform)) {
            return true;
        }
        try {
            boolean bl;
            VirtualFile[] virtualFileArray = $this$isKlibLibraryRootForPlatform.getChildren();
            if (virtualFileArray != null) {
                boolean bl2;
                block7: {
                    VirtualFile[] $this$any$iv = virtualFileArray;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int j = 0; j < n; ++j) {
                        VirtualFile element$iv;
                        VirtualFile it = element$iv = $this$any$iv[j];
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!KLibUtils.checkKlibComponent(it, targetPlatform, requestedBuiltInsPlatform)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            return bl;
        }
        catch (InvalidVirtualFileAccessException e) {
            return false;
        }
    }

    private static final boolean checkKlibComponent(VirtualFile componentFile, TargetPlatform targetPlatform, BuiltInsPlatform requestedBuiltInsPlatform) {
        Properties properties = KLibUtils.manifestProperties(componentFile);
        if (properties == null) {
            return false;
        }
        Properties manifestProperties = properties;
        if (!manifestProperties.containsKey("unique_name")) {
            return false;
        }
        String string = manifestProperties.getProperty("builtins_platform");
        if (string == null) {
            return switch (WhenMappings.$EnumSwitchMapping$0[requestedBuiltInsPlatform.ordinal()]) {
                case 1 -> KLibUtils.isLegacyNativeKlibComponent(componentFile);
                case 2 -> {
                    if (!KLibUtils.isLegacyNativeKlibComponent(componentFile)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        String builtInsPlatformProperty = string;
        BuiltInsPlatform builtInsPlatform = BuiltInsPlatform.Companion.parseFromString(builtInsPlatformProperty);
        if (builtInsPlatform == null) {
            return false;
        }
        BuiltInsPlatform builtInsPlatform2 = builtInsPlatform;
        if (builtInsPlatform2 == requestedBuiltInsPlatform && requestedBuiltInsPlatform == BuiltInsPlatform.WASM) {
            return KLibUtils.checkKlibWasmTarget(manifestProperties, targetPlatform);
        }
        return builtInsPlatform2 == requestedBuiltInsPlatform;
    }

    private static final boolean checkKlibWasmTarget(Properties manifestProperties, TargetPlatform targetPlatform) {
        Object object;
        block6: {
            block5: {
                SimplePlatform simplePlatform;
                object = (SimplePlatform)CollectionsKt.singleOrNull((Iterable)targetPlatform.getComponentPlatforms());
                if (object == null) break block5;
                SimplePlatform it = simplePlatform = object;
                boolean bl = false;
                object = it instanceof WasmPlatform ? simplePlatform : null;
                if (object != null) break block6;
            }
            return false;
        }
        SimplePlatform platformWithTarget = object;
        if (platformWithTarget instanceof WasmPlatformUnspecifiedTarget) {
            return true;
        }
        WasmTarget wasmTarget = ((WasmPlatformWithTarget)platformWithTarget).getTarget();
        String string = manifestProperties.getProperty("wasm_targets");
        if (string == null) {
            return wasmTarget == WasmTarget.JS;
        }
        String parsedWasmTarget = string;
        return wasmTarget == WasmTarget.Companion.fromName(parsedWasmTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties manifestProperties(VirtualFile componentFile) {
        Object object;
        Object object2;
        block11: {
            block10: {
                VirtualFile virtualFile2;
                object2 = componentFile.findChild("manifest");
                if (object2 == null) break block10;
                VirtualFile it = virtualFile2 = object2;
                boolean bl = false;
                object2 = !it.isDirectory() ? virtualFile2 : null;
                if (object2 != null) break block11;
            }
            return null;
        }
        VirtualFile manifestFile = object2;
        try {
            Properties properties;
            object = manifestFile.getInputStream();
            Throwable throwable = null;
            try {
                Properties properties2;
                InputStream it = (InputStream)object;
                boolean bl = false;
                Properties $this$manifestProperties_u24lambda_u244_u24lambda_u243 = properties2 = new Properties();
                boolean bl2 = false;
                $this$manifestProperties_u24lambda_u244_u24lambda_u243.load(it);
                properties = properties2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = properties;
        }
        catch (IOException iOException) {
            return null;
        }
        return object;
    }

    private static final BuiltInsPlatform toBuiltInsPlatform(TargetPlatform $this$toBuiltInsPlatform) {
        BuiltInsPlatform builtInsPlatform;
        if (TargetPlatformKt.isCommon((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.COMMON;
        } else if (NativePlatformKt.isNative((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.NATIVE;
        } else if (JvmPlatformKt.isJvm((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.JVM;
        } else if (JsPlatformKt.isJs((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.JS;
        } else if (WasmPlatformKt.isWasm((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.WASM;
        } else {
            throw new IllegalArgumentException("Unknown platform " + $this$toBuiltInsPlatform);
        }
        return builtInsPlatform;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isLegacyNativeKlibComponent(VirtualFile $this$isLegacyNativeKlibComponent) {
        VirtualFile irFolder = $this$isLegacyNativeKlibComponent.findChild("ir");
        if (irFolder == null) return false;
        VirtualFile[] virtualFileArray = irFolder.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        if (((Object[])virtualFileArray).length != 0) return true;
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuiltInsPlatform.values().length];
            try {
                nArray[BuiltInsPlatform.NATIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuiltInsPlatform.COMMON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

