/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.bytecode;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBColor;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaExperimentalApi;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaCompilationResult;
import org.jetbrains.kotlin.analysis.api.components.KaCompiledFile;
import org.jetbrains.kotlin.analysis.api.components.KaCompilerFacilityKt;
import org.jetbrains.kotlin.analysis.api.components.KaCompilerTarget;
import org.jetbrains.kotlin.analysis.api.descriptors.components.KaFe10CompilerFacilityKt;
import org.jetbrains.kotlin.analysis.api.diagnostics.KaDiagnostic;
import org.jetbrains.kotlin.analysis.api.diagnostics.KaDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.actions.bytecode.BytecodeGenerationResult;
import org.jetbrains.kotlin.idea.actions.bytecode.InfinitePeriodicalTask;
import org.jetbrains.kotlin.idea.actions.bytecode.Location;
import org.jetbrains.kotlin.idea.actions.bytecode.OriginTracingClassBuilderFactory;
import org.jetbrains.kotlin.idea.actions.bytecode.TextifierWithOffsets;
import org.jetbrains.kotlin.idea.base.codeInsight.compiler.KotlinCompilerIdeAllowedErrorFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.internal.DecompileFailedException;
import org.jetbrains.kotlin.idea.internal.KotlinJvmDecompilerFacade;
import org.jetbrains.kotlin.idea.util.LongRunningReadTask;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0002\"#B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0016H\u0002J\b\u0010!\u001a\u00020\u0019H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/actions/bytecode/KotlinBytecodeToolWindow;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "decompile", "Ljavax/swing/JButton;", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.jvm.PlatformType", "enableAssertions", "Ljavax/swing/JCheckBox;", "enableInline", "enableOptimization", "jvmTargets", "Ljavax/swing/JComboBox;", "", "showOffsets", "decompileBytecode", "", "decompilerFacade", "Lorg/jetbrains/kotlin/idea/internal/KotlinJvmDecompilerFacade;", "dispose", "initOptionsPanel", "registerTasksToUpdateToolWindow", "setText", "resultText", "updateToolWindowOnOptionChange", "Companion", "UpdateBytecodeToolWindowTask", "kotlin.jvm"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKotlinBytecodeToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBytecodeToolWindow.kt\norg/jetbrains/kotlin/idea/actions/bytecode/KotlinBytecodeToolWindow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,506:1\n1549#2:507\n1620#2,3:508\n1855#2,2:513\n37#3,2:511\n*S KotlinDebug\n*F\n+ 1 KotlinBytecodeToolWindow.kt\norg/jetbrains/kotlin/idea/actions/bytecode/KotlinBytecodeToolWindow\n*L\n188#1:507\n188#1:508,3\n249#1:513,2\n188#1:511,2\n*E\n"})
public final class KotlinBytecodeToolWindow
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final Document document;
    private final Editor editor;
    @NotNull
    private final JCheckBox enableInline;
    @NotNull
    private final JCheckBox enableOptimization;
    @NotNull
    private final JCheckBox enableAssertions;
    @NotNull
    private final JCheckBox showOffsets;
    @NotNull
    private final JButton decompile;
    @NotNull
    private final JComboBox<String> jvmTargets;
    @NotNull
    private static final Logger LOG;
    private static final int UPDATE_DELAY = 1000;
    @NotNull
    private static final String DEFAULT_TEXT = "/*\nGenerated bytecode for Kotlin source file.\nNo Kotlin source file is opened.\n*/";

    /*
     * WARNING - void declaration
     */
    public KotlinBytecodeToolWindow(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super(new BorderLayout());
        this.project = project2;
        this.toolWindow = toolWindow;
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        this.document = document;
        this.editor = EditorFactory.getInstance().createEditor(this.document, this.project, (FileType)JavaFileType.INSTANCE, true);
        this.editor.setBorder(null);
        this.add(this.editor.getComponent());
        this.decompile = new JButton(KotlinJvmBundle.message("button.text.decompile", new Object[0]));
        this.enableInline = new JCheckBox(KotlinJvmBundle.message("checkbox.text.inline", new Object[0]), true);
        this.enableOptimization = new JCheckBox(KotlinJvmBundle.message("checkbox.text.optimization", new Object[0]), true);
        this.showOffsets = new JCheckBox(KotlinJvmBundle.message("checkbox.text.offsets", new Object[0]), false);
        this.enableAssertions = new JCheckBox(KotlinJvmBundle.message("checkbox.text.assertions", new Object[0]), true);
        Iterable iterable = JvmTarget.Companion.supportedValues();
        KotlinBytecodeToolWindow kotlinBytecodeToolWindow = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmTarget jvmTarget2 = (JvmTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDescription());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        kotlinBytecodeToolWindow.jvmTargets = (JComboBox)new ComboBox(objectArray);
        String description2 = JvmTarget.DEFAULT.getDescription();
        ((ComboBox)this.jvmTargets).setSelectedItem((Object)description2);
        this.setText(DEFAULT_TEXT);
        this.initOptionsPanel();
        this.registerTasksToUpdateToolWindow();
    }

    private final void initOptionsPanel() {
        JPanel optionPanel = new JPanel(new FlowLayout());
        this.add((Component)optionPanel, "North");
        JPanel $this$initOptionsPanel_u24lambda_u242 = optionPanel;
        boolean bl = false;
        $this$initOptionsPanel_u24lambda_u242.setBorder(JBUI.Borders.customLineBottom((Color)JBColor.border()));
        KotlinJvmDecompilerFacade decompilerFacade = KotlinJvmDecompilerFacade.Companion.getInstance();
        if (decompilerFacade != null) {
            $this$initOptionsPanel_u24lambda_u242.add(this.decompile);
            this.decompile.addActionListener(arg_0 -> KotlinBytecodeToolWindow.initOptionsPanel$lambda$2$lambda$1(this, decompilerFacade, arg_0));
        }
        $this$initOptionsPanel_u24lambda_u242.add(this.enableInline);
        $this$initOptionsPanel_u24lambda_u242.add(this.enableOptimization);
        $this$initOptionsPanel_u24lambda_u242.add(this.showOffsets);
        $this$initOptionsPanel_u24lambda_u242.add(this.enableAssertions);
        $this$initOptionsPanel_u24lambda_u242.add(new JLabel(KotlinJvmBundle.message("bytecode.toolwindow.label.jvm.target", new Object[0])));
        $this$initOptionsPanel_u24lambda_u242.add(this.jvmTargets);
    }

    private final void decompileBytecode(KotlinJvmDecompilerFacade decompilerFacade) {
        Editor editor2 = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Location location2 = Location.fromEditor(editor3, this.project);
        KtFile ktFile2 = location2.getKFile();
        if (ktFile2 == null) {
            return;
        }
        KtFile file2 = ktFile2;
        try {
            decompilerFacade.showDecompiledCode(file2);
        }
        catch (DecompileFailedException ex) {
            LOG.info((Throwable)ex);
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)file2.getName(), (String)"getName(...)");
            objectArray[1] = ex;
            Messages.showErrorDialog((Project)this.project, (String)KotlinJvmBundle.message("failed.to.decompile.0.1", objectArray), (String)KotlinJvmBundle.message("kotlin.bytecode.decompiler", new Object[0]));
        }
    }

    private final void registerTasksToUpdateToolWindow() {
        new InfinitePeriodicalTask(1000L, Alarm.ThreadToUse.SWING_THREAD, this, (Computable<? extends LongRunningReadTask>)((Computable)() -> KotlinBytecodeToolWindow.registerTasksToUpdateToolWindow$lambda$3(this))).start();
        Object[] objectArray = new JCheckBox[]{this.enableInline, this.enableOptimization, this.enableAssertions, this.showOffsets};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JCheckBox checkBox = (JCheckBox)element$iv;
            boolean bl = false;
            checkBox.addActionListener(arg_0 -> KotlinBytecodeToolWindow.registerTasksToUpdateToolWindow$lambda$5$lambda$4(this, arg_0));
        }
        this.jvmTargets.addActionListener(arg_0 -> KotlinBytecodeToolWindow.registerTasksToUpdateToolWindow$lambda$6(this, arg_0));
    }

    private final void updateToolWindowOnOptionChange() {
        UpdateBytecodeToolWindowTask task2 = new UpdateBytecodeToolWindowTask();
        if (task2.init()) {
            task2.run();
        }
    }

    private final void setText(String resultText) {
        ApplicationManager.getApplication().runWriteAction(() -> KotlinBytecodeToolWindow.setText$lambda$7(this, resultText));
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.editor);
    }

    private static final void initOptionsPanel$lambda$2$lambda$1(KotlinBytecodeToolWindow this$0, KotlinJvmDecompilerFacade $decompilerFacade, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.decompileBytecode($decompilerFacade);
    }

    private static final LongRunningReadTask registerTasksToUpdateToolWindow$lambda$3(KotlinBytecodeToolWindow this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.new UpdateBytecodeToolWindowTask();
    }

    private static final void registerTasksToUpdateToolWindow$lambda$5$lambda$4(KotlinBytecodeToolWindow this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateToolWindowOnOptionChange();
    }

    private static final void registerTasksToUpdateToolWindow$lambda$6(KotlinBytecodeToolWindow this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateToolWindowOnOptionChange();
    }

    private static final void setText$lambda$7(KotlinBytecodeToolWindow this$0, String $resultText) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$resultText, (String)"$resultText");
        this$0.editor.getDocument().setText((CharSequence)StringUtil.convertLineSeparators((String)$resultText));
    }

    static {
        Logger logger = Logger.getInstance(KotlinBytecodeToolWindow.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011JB\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u001c\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017j\u0002`\u001aH\u0003J,\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0002J@\u0010#\u001a&\u0012\u0004\u0012\u00020$\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017j\u0002`\u001a\u0018\u00010\u001c*\u00020%2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/actions/bytecode/KotlinBytecodeToolWindow$Companion;", "", "()V", "DEFAULT_TEXT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "UPDATE_DELAY", "", "getBytecodeForFile", "Lorg/jetbrains/kotlin/idea/actions/bytecode/BytecodeGenerationResult;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "showOffsets", "", "getRelevantClassFiles", "", "Lorg/jetbrains/kotlin/analysis/api/components/KaCompiledFile;", "outputFiles", "classFileOrigins", "", "", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/kotlin/idea/actions/bytecode/ClassFileOrigins;", "mapLines", "Lkotlin/Pair;", "text", "startLine", "endLine", "printStackTraceToString", "e", "", "compileSingleFile", "Lorg/jetbrains/kotlin/analysis/api/components/KaCompilationResult;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nKotlinBytecodeToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBytecodeToolWindow.kt\norg/jetbrains/kotlin/idea/actions/bytecode/KotlinBytecodeToolWindow$Companion\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,506:1\n28#2,2:507\n36#3,8:509\n766#4:517\n857#4,2:518\n766#4:520\n857#4,2:521\n731#4,9:524\n1549#4:533\n1620#4,2:534\n1622#4:559\n731#4,9:560\n1549#4:569\n1620#4,2:570\n1622#4:595\n1#5:523\n107#6:536\n79#6,22:537\n107#6:572\n79#6,22:573\n*S KotlinDebug\n*F\n+ 1 KotlinBytecodeToolWindow.kt\norg/jetbrains/kotlin/idea/actions/bytecode/KotlinBytecodeToolWindow$Companion\n*L\n289#1:507,2\n289#1:509,8\n364#1:517\n364#1:518,2\n368#1:520\n368#1:521,2\n407#1:524,9\n407#1:533\n407#1:534,2\n407#1:559\n422#1:560,9\n422#1:569\n422#1:570,2\n422#1:595\n407#1:536\n407#1:537,22\n422#1:572\n422#1:573,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final BytecodeGenerationResult getBytecodeForFile(@NotNull KtFile ktFile2, @NotNull CompilerConfiguration configuration2, boolean showOffsets) {
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"ktFile");
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            boolean $i$f$analyze = false;
            Project project2 = ((KtElement)ktFile2).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project2);
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)ktFile2);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)ktFile2);
            try {
                List<KaDiagnostic> diagnostics2;
                Pair<KaCompilationResult, Map<String, Set<PsiFile>>> pair;
                block15: {
                    KaSession $this$getBytecodeForFile_u24lambda_u240 = analysisSession$iv$iv;
                    boolean bl = false;
                    if (Companion.compileSingleFile($this$getBytecodeForFile_u24lambda_u240, ktFile2, configuration2) != null) break block15;
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile2.getName(), (String)"getName(...)");
                    BytecodeGenerationResult bytecodeGenerationResult = new BytecodeGenerationResult.Error(KotlinJvmBundle.message("cannot.compile.0.to.bytecode", objectArray));
                    return bytecodeGenerationResult;
                }
                try {
                    Pair<KaCompilationResult, Map<String, Set<PsiFile>>> pair2;
                    pair = pair2;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    BytecodeGenerationResult bytecodeGenerationResult = new BytecodeGenerationResult.Error(Companion.printStackTraceToString(e));
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)ktFile2);
                    return bytecodeGenerationResult;
                }
                Pair<KaCompilationResult, Map<String, Set<PsiFile>>> pair3 = pair;
                KaCompilationResult result2 = (KaCompilationResult)pair3.component1();
                Map classFileOrigins = (Map)pair3.component2();
                StringWriter writer = new StringWriter();
                KaCompilationResult kaCompilationResult = result2;
                if (kaCompilationResult instanceof KaCompilationResult.Success) {
                    PrintWriter printWriter = new PrintWriter(writer);
                    for (KaCompiledFile outputFile : Companion.getRelevantClassFiles(ktFile2, ((KaCompilationResult.Success)result2).getOutput(), classFileOrigins)) {
                        writer.append("// ================");
                        writer.append(outputFile.getPath());
                        writer.append(" =================\n");
                        Ref.IntRef offset2 = new Ref.IntRef();
                        byte[] byArray = outputFile.getContent();
                        ClassReader classReader2 = new ClassReader(offset2, byArray){
                            final /* synthetic */ Ref.IntRef $offset;
                            {
                                this.$offset = $offset;
                                super($super_call_param$1);
                            }

                            protected void readBytecodeInstructionOffset(int bytecodeOffset) {
                                this.$offset.element = bytecodeOffset;
                            }
                        };
                        Textifier textifier2 = showOffsets ? (Textifier)new TextifierWithOffsets((Function0<Integer>)((Function0)new Function0<Integer>(offset2){
                            final /* synthetic */ Ref.IntRef $offset;
                            {
                                this.$offset = $offset;
                                super(0);
                            }

                            @NotNull
                            public final Integer invoke() {
                                return this.$offset.element;
                            }
                        })) : new Textifier();
                        TraceClassVisitor traceVisitor = new TraceClassVisitor(null, (Printer)textifier2, printWriter);
                        classReader2.accept((ClassVisitor)traceVisitor, 0);
                        writer.append("\n\n");
                    }
                } else if (kaCompilationResult instanceof KaCompilationResult.Failure && !((Collection)(diagnostics2 = ((KaCompilationResult.Failure)result2).getErrors())).isEmpty()) {
                    writer.append("// Backend Errors: \n");
                    writer.append("// ================\n");
                    for (KaDiagnostic error2 : diagnostics2) {
                        writer.append("// Error");
                        if (error2 instanceof KaDiagnosticWithPsi) {
                            writer.append(" at ");
                            writer.append(((KaDiagnosticWithPsi)error2).getPsi().getContainingFile().getName());
                            CollectionsKt.joinTo$default((Iterable)((KaDiagnosticWithPsi)error2).getTextRanges(), (Appendable)writer, null, null, null, (int)0, null, null, (int)126, null);
                        }
                        writer.append(": ");
                        writer.append(error2.getDefaultMessage());
                        writer.append("\n");
                    }
                    writer.append("// ================\n\n");
                }
                String string = writer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                BytecodeGenerationResult bytecodeGenerationResult = new BytecodeGenerationResult.Bytecode(string);
                return bytecodeGenerationResult;
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)ktFile2);
            }
        }

        /*
         * Unable to fully structure code
         */
        @KaExperimentalApi
        private final List<KaCompiledFile> getRelevantClassFiles(KtFile ktFile, List<? extends KaCompiledFile> outputFiles, Map<String, ? extends Set<? extends PsiFile>> classFileOrigins) {
            $this$filter$iv = outputFiles;
            $i$f$filter = false;
            var7_7 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (KaCompiledFile)element$iv$iv;
                $i$a$-filter-KotlinBytecodeToolWindow$Companion$getRelevantClassFiles$classFiles$1 = false;
                if (!KaCompilerFacilityKt.isClassFile(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            classFiles = (List)destination$iv$iv;
            sourceFile = new File(ktFile.getVirtualFile().getPath());
            $i$f$filter = classFiles;
            $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (KaCompiledFile)element$iv$iv;
                $i$a$-filter-KotlinBytecodeToolWindow$Companion$getRelevantClassFiles$1 = false;
                if (it.getSourceFiles().contains(sourceFile)) ** GOTO lbl-1000
                v0 = classFileOrigins.get(it.getPath());
                if (v0 == null) {
                    v0 = SetsKt.emptySet();
                }
                if (v0.contains(ktFile)) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            var6_6 = (List)destination$iv$iv;
            if (var6_6.isEmpty()) {
                $i$a$-ifEmpty-KotlinBytecodeToolWindow$Companion$getRelevantClassFiles$2 = false;
                v2 = classFiles;
            } else {
                v2 = var6_6;
            }
            return (List)v2;
        }

        @KaExperimentalApi
        @ApiStatus.Internal
        @Nullable
        public final Pair<KaCompilationResult, Map<String, Set<PsiFile>>> compileSingleFile(@NotNull KaSession $this$compileSingleFile, @NotNull KtFile ktFile2, @NotNull CompilerConfiguration configuration2) {
            CompilerConfiguration compilerConfiguration;
            Intrinsics.checkNotNullParameter((Object)$this$compileSingleFile, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"ktFile");
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            CompilerConfiguration $this$compileSingleFile_u24lambda_u244 = compilerConfiguration = configuration2.copy();
            boolean bl = false;
            $this$compileSingleFile_u24lambda_u244.put(KaFe10CompilerFacilityKt.getSTUB_UNBOUND_IR_SYMBOLS(), (Object)true);
            CompilerConfiguration effectiveConfiguration = compilerConfiguration;
            ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.TEST;
            Intrinsics.checkNotNullExpressionValue((Object)classBuilderFactory, (String)"TEST");
            OriginTracingClassBuilderFactory builderFactory = new OriginTracingClassBuilderFactory(classBuilderFactory);
            KaCompilerTarget.Jvm compilerTarget = new KaCompilerTarget.Jvm((ClassBuilderFactory)builderFactory);
            KotlinCompilerIdeAllowedErrorFilter allowedErrorFilter2 = KotlinCompilerIdeAllowedErrorFilter.Companion.getInstance();
            try {
                Intrinsics.checkNotNull((Object)effectiveConfiguration);
                KaCompilationResult result2 = $this$compileSingleFile.compile(ktFile2, effectiveConfiguration, compilerTarget, (Function1<? super KaDiagnostic, Boolean>)((Function1)allowedErrorFilter2));
                return new Pair((Object)result2, builderFactory.getClassFileOrigins());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Integer, Integer> mapLines(String text2, int startLine, int endLine) {
            List list2;
            int ktLineNum;
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            boolean startFound$iv$iv;
            int endIndex$iv$iv;
            int startIndex$iv$iv;
            boolean $i$f$trim;
            CharSequence $this$trim$iv$iv;
            void $this$trim$iv;
            String line2;
            boolean bl;
            Collection collection;
            void $this$mapTo$iv$iv;
            List list3;
            boolean bl2;
            Object iterator$iv;
            int startLine2 = startLine;
            int byteCodeLine = 0;
            int byteCodeStartLine = -1;
            int byteCodeEndLine = -1;
            ArrayList<Integer> lines = new ArrayList<Integer>();
            String[] stringArray = new String[]{"\n"};
            List list4 = StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$dropLastWhile = false;
            if (!list4.isEmpty()) {
                iterator$iv = list4.listIterator(list4.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    bl2 = false;
                    if (((CharSequence)it2).length() == 0) continue;
                    list3 = CollectionsKt.take((Iterable)list4, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            Iterable iterable = list3;
            boolean $i$f$map = false;
            iterator$iv = iterable;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                $this$trim$iv = line2;
                boolean $i$f$trim2 = false;
                $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl22 = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                collection.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
            }
            for (String string : (List)destination$iv$iv) {
                if (!StringsKt.startsWith$default((String)string, (String)"LINENUMBER", (boolean)false, (int)2, null)) continue;
                String string2 = string.substring(10);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                ktLineNum = new Scanner(string2).nextInt() - 1;
                lines.add(ktLineNum);
            }
            CollectionsKt.sort((List)lines);
            for (Integer n : lines) {
                Intrinsics.checkNotNull((Object)n);
                if (n < startLine2) continue;
                startLine2 = n;
                break;
            }
            String[] stringArray2 = new String[]{"\n"};
            List list5 = StringsKt.split$default((CharSequence)text2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            $i$f$dropLastWhile = false;
            if (!list5.isEmpty()) {
                iterator$iv = list5.listIterator(list5.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    bl2 = false;
                    if (((CharSequence)it2).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)list5, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Iterable iterable2 = list2;
            $i$f$map = false;
            iterator$iv = iterable2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                line2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                $this$trim$iv = line;
                boolean $i$f$trim2 = false;
                $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl4 = false;
                    boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                collection.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
            }
            for (String string : (List)destination$iv$iv) {
                if (StringsKt.startsWith$default((String)string, (String)"LINENUMBER", (boolean)false, (int)2, null)) {
                    String string3 = string.substring(10);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    ktLineNum = new Scanner(string3).nextInt() - 1;
                    if (byteCodeStartLine < 0 && ktLineNum == startLine2) {
                        byteCodeStartLine = byteCodeLine;
                    }
                    if (byteCodeStartLine > 0 && ktLineNum > endLine) {
                        byteCodeEndLine = byteCodeLine - 1;
                        break;
                    }
                }
                if (byteCodeStartLine >= 0 && (StringsKt.startsWith$default((String)string, (String)"MAXSTACK", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string, (String)"LOCALVARIABLE", (boolean)false, (int)2, null) || ((CharSequence)string).length() == 0)) {
                    byteCodeEndLine = byteCodeLine - 1;
                    break;
                }
                ++byteCodeLine;
            }
            return byteCodeStartLine == -1 || byteCodeEndLine == -1 ? new Pair((Object)0, (Object)0) : new Pair((Object)byteCodeStartLine, (Object)byteCodeEndLine);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String printStackTraceToString(Throwable e) {
            StringWriter out = new StringWriter(1024);
            Closeable closeable = new PrintWriter(out);
            Throwable throwable = null;
            try {
                PrintWriter printWriter = (PrintWriter)closeable;
                boolean bl = false;
                e.printStackTrace(printWriter);
                String string = out.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = StringsKt.replace$default((String)string, (String)"\r", (String)"", (boolean)false, (int)4, null);
                return string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/actions/bytecode/KotlinBytecodeToolWindow$UpdateBytecodeToolWindowTask;", "Lorg/jetbrains/kotlin/idea/util/LongRunningReadTask;", "Lorg/jetbrains/kotlin/idea/actions/bytecode/Location;", "Lorg/jetbrains/kotlin/idea/actions/bytecode/BytecodeGenerationResult;", "(Lorg/jetbrains/kotlin/idea/actions/bytecode/KotlinBytecodeToolWindow;)V", "cloneRequestInfo", "location", "hideResultOnInvalidLocation", "", "onResultReady", "requestInfo", "result", "prepareRequestInfo", "processRequest", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nKotlinBytecodeToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBytecodeToolWindow.kt\norg/jetbrains/kotlin/idea/actions/bytecode/KotlinBytecodeToolWindow$UpdateBytecodeToolWindowTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,506:1\n1#2:507\n*E\n"})
    private final class UpdateBytecodeToolWindowTask
    extends LongRunningReadTask<Location, BytecodeGenerationResult> {
        public UpdateBytecodeToolWindowTask() {
            super(KotlinBytecodeToolWindow.this);
        }

        @Override
        @Nullable
        protected Location prepareRequestInfo() {
            if (!KotlinBytecodeToolWindow.this.toolWindow.isVisible()) {
                return null;
            }
            Location location2 = Location.fromEditor(FileEditorManager.getInstance((Project)KotlinBytecodeToolWindow.this.project).getSelectedTextEditor(), KotlinBytecodeToolWindow.this.project);
            if (location2.getEditor() == null) {
                return null;
            }
            KtFile file2 = location2.getKFile();
            return file2 == null || !SourceKindFilterUtils.matches(RootKindFilter.projectSources, (PsiElement)file2) ? null : location2;
        }

        @Override
        @NotNull
        protected Location cloneRequestInfo(@NotNull Location location2) {
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            Location location3 = super.cloneRequestInfo(location2);
            Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"cloneRequestInfo(...)");
            Location newLocation = location3;
            boolean bl = Intrinsics.areEqual((Object)location2, (Object)newLocation);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "cloneRequestInfo should generate same location object";
                throw new AssertionError((Object)string);
            }
            return newLocation;
        }

        @Override
        protected void hideResultOnInvalidLocation() {
            KotlinBytecodeToolWindow.this.setText(KotlinBytecodeToolWindow.DEFAULT_TEXT);
        }

        @Override
        @NotNull
        protected BytecodeGenerationResult processRequest(@NotNull Location location2) {
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            KtFile ktFile2 = location2.getKFile();
            Intrinsics.checkNotNull((Object)ktFile2);
            KtFile ktFile3 = ktFile2;
            CompilerConfiguration configuration2 = new CompilerConfiguration();
            Module containingModule = GenericPsiUtils.getModule((PsiElement)ktFile3);
            if (containingModule != null) {
                configuration2.put(CommonConfigurationKeys.MODULE_NAME, (Object)containingModule.getName());
            }
            if (!KotlinBytecodeToolWindow.this.enableInline.isSelected()) {
                configuration2.put(CommonConfigurationKeys.DISABLE_INLINE, (Object)true);
            }
            if (!KotlinBytecodeToolWindow.this.enableAssertions.isSelected()) {
                configuration2.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, (Object)true);
                configuration2.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, (Object)true);
            }
            if (!KotlinBytecodeToolWindow.this.enableOptimization.isSelected()) {
                configuration2.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, (Object)true);
            }
            Object object = KotlinBytecodeToolWindow.this.jvmTargets.getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            JvmTarget jvmTarget2 = JvmTarget.Companion.fromString((String)object);
            Intrinsics.checkNotNull((Object)jvmTarget2);
            configuration2.put(JVMConfigurationKeys.JVM_TARGET, (Object)jvmTarget2);
            configuration2.put(JVMConfigurationKeys.IR, (Object)true);
            CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)configuration2, (LanguageVersionSettings)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)ktFile3));
            return Companion.getBytecodeForFile(ktFile3, configuration2, KotlinBytecodeToolWindow.this.showOffsets.isSelected());
        }

        @Override
        protected void onResultReady(@NotNull Location requestInfo, @Nullable BytecodeGenerationResult result2) {
            Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
            Editor editor2 = requestInfo.getEditor();
            Intrinsics.checkNotNull((Object)editor2);
            Editor sourceEditor = editor2;
            if (result2 == null) {
                return;
            }
            BytecodeGenerationResult bytecodeGenerationResult = result2;
            if (bytecodeGenerationResult instanceof BytecodeGenerationResult.Error) {
                KotlinBytecodeToolWindow.this.decompile.setEnabled(false);
                KotlinBytecodeToolWindow.this.setText(((BytecodeGenerationResult.Error)result2).getText());
            } else if (bytecodeGenerationResult instanceof BytecodeGenerationResult.Bytecode) {
                KotlinBytecodeToolWindow.this.decompile.setEnabled(true);
                KotlinBytecodeToolWindow.this.setText(((BytecodeGenerationResult.Bytecode)result2).getText());
                int fileStartOffset = requestInfo.getStartOffset();
                int fileEndOffset = requestInfo.getEndOffset();
                Document document = sourceEditor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document sourceDocument = document;
                int startLine = sourceDocument.getLineNumber(fileStartOffset);
                int endLine = sourceDocument.getLineNumber(fileEndOffset);
                if (endLine > startLine && fileEndOffset > 0 && sourceDocument.getCharsSequence().charAt(fileEndOffset - 1) == '\n') {
                    --endLine;
                }
                String string = KotlinBytecodeToolWindow.this.document.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                Pair linesRange = Companion.mapLines(string, startLine, endLine);
                int endSelectionLineIndex = Math.min(((Number)linesRange.getSecond()).intValue() + 1, KotlinBytecodeToolWindow.this.document.getLineCount());
                int startOffset = KotlinBytecodeToolWindow.this.document.getLineStartOffset(((Number)linesRange.getFirst()).intValue());
                int endOffset2 = Math.min(KotlinBytecodeToolWindow.this.document.getLineStartOffset(endSelectionLineIndex), KotlinBytecodeToolWindow.this.document.getTextLength());
                KotlinBytecodeToolWindow.this.editor.getCaretModel().moveToOffset(endOffset2);
                KotlinBytecodeToolWindow.this.editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                KotlinBytecodeToolWindow.this.editor.getCaretModel().moveToOffset(startOffset);
                KotlinBytecodeToolWindow.this.editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                KotlinBytecodeToolWindow.this.editor.getSelectionModel().setSelection(startOffset, endOffset2);
            }
        }
    }
}

