/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.builder.CharacterWithDiagnostic;
import org.jetbrains.kotlin.fir.builder.Context;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirLegacyRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.builder.FirLegacyRawContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousObjectBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyAccessorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirReceiverParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirLazyBlock;
import org.jetbrains.kotlin.fir.expressions.FirLazyExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBinaryLogicExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckedSafeCallSubjectBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComparisonExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComponentCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirElvisExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirPropertyAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSafeCallExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWrappedDelegateExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.builder.FirDelegateFieldReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirImplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirTypeProjectionWithVarianceBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitTypeRefImplWithoutSource;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00aa\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\t*\u00020\n\u001a\n\u0010\f\u001a\u00020\r*\u00020\n\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\n\u001a\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a$\u0010\u0015\u001a\u00020\u0016*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a.\u0010\u0019\u001a\u00020\u001a*\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014\u001a.\u0010\u001e\u001a\u00020\u001f*\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014\u001a0\u0010!\u001a\u00020\u001a*\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\tH\u0002\u001a.\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u00142\b\u0010&\u001a\u0004\u0018\u00010\u00142\u0006\u0010'\u001a\u00020\t2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)\u001a\u0018\u0010*\u001a\u00020$2\b\u0010+\u001a\u0004\u0018\u00010\u00142\u0006\u0010,\u001a\u00020-\u001a\u001c\u0010.\u001a\u00020/*\u00020-2\b\u00100\u001a\u0004\u0018\u00010\u00142\u0006\u00101\u001a\u000202\u001a\u0098\u0001\u00109\u001a\u00020:\"\u0004\b\u0000\u0010;*\u00020<2\b\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020@2\f\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u0001042\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H;0B2\u0006\u0010C\u001a\u00020\u00182\n\b\u0002\u0010D\u001a\u0004\u0018\u00010E2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010G28\b\u0002\u0010H\u001a2\u0012\u0013\u0012\u00110J\u00a2\u0006\f\bK\u0012\b\b'\u0012\u0004\b\b(L\u0012\u0013\u0012\u00110M\u00a2\u0006\f\bK\u0012\b\b'\u0012\u0004\b\b(N\u0012\u0004\u0012\u00020:0I\u001a\u001a\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020R2\b\u0010(\u001a\u0004\u0018\u00010)\u001a\u0016\u0010S\u001a\u00020T*\u00020\u001a2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)\u001a\n\u0010U\u001a\u00020\u0018*\u00020R\u001a\u001b\u0010V\u001a\u00020\u0018*\u00020W\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\u0016\u0010X\u001a\u00020\u0018*\u00020\u00112\b\u0010'\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u001a\u0010Y\u001a\u00020Z*\u00020$2\u0006\u0010[\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0014\u001a\n\u0010\\\u001a\u00020\u0011*\u00020\u0011\u001a\u001e\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^*\b\u0012\u0004\u0012\u00020_0^2\u0006\u0010L\u001a\u00020`\u001a\n\u0010a\u001a\u00020b*\u00020c\u001a\n\u0010d\u001a\u00020b*\u00020\u0014\u001a\u001e\u0010e\u001a\u00020:\"\u0004\b\u0000\u0010;*\u00020f2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H;0B\u001a\u001c\u0010g\u001a\u0004\u0018\u00010h\"\u0004\b\u0000\u0010;2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H;0B\u001a(\u0010l\u001a\u00020\u00112\f\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00110^2\b\b\u0002\u0010n\u001a\u0002022\b\b\u0002\u0010o\u001a\u000202\u001a\u0014\u0010p\u001a\u00020\u0011*\u00020\u00112\b\u0010q\u001a\u0004\u0018\u00010\u0011\u001a\f\u0010r\u001a\u00020\u0018*\u0004\u0018\u00010`\u001a\n\u0010s\u001a\u00020t*\u00020u\u001a&\u0010v\u001a\u00020\u00182\u0006\u0010w\u001a\u00020\u00182\u0006\u0010x\u001a\u00020\u00182\u0006\u0010y\u001a\u00020\u00182\u0006\u0010z\u001a\u00020\u0018\"\u001d\u00103\u001a\n\u0012\u0004\u0012\u000205\u0018\u000104*\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108\"\u0015\u0010i\u001a\u00020\u0018*\u00020j8F\u00a2\u0006\u0006\u001a\u0004\bi\u0010k\u00f2\u0001\u0004\n\u00020\u001a\u00a8\u0006{"}, d2={"parseCharacter", "Lorg/jetbrains/kotlin/fir/builder/CharacterWithDiagnostic;", "", "escapedStringToCharacter", "text", "translateEscape", "c", "", "toBinaryName", "Lorg/jetbrains/kotlin/name/Name;", "Lcom/intellij/psi/tree/IElementType;", "toUnaryName", "toFirOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "toFirOperationOrNull", "generateNotNullOrOther", "Lorg/jetbrains/kotlin/fir/expressions/FirElvisExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "other", "baseSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "generateLazyLogicalOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "isAnd", "", "generateContainsOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "argument", "inverted", "operationReferenceSource", "generateComparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "operatorToken", "createConventionCall", "conventionName", "generateAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "qualifiedSource", "calleeReferenceSource", "name", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "generateResolvedAccessExpression", "source", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "toComponentCall", "Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;", "entrySource", "index", "", "ownerRegularOrAnonymousObjectSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "getOwnerRegularOrAnonymousObjectSymbol", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "generateAccessorsByDelegate", "", "T", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;", "delegateBuilder", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "context", "Lorg/jetbrains/kotlin/fir/builder/Context;", "isExtension", "lazyDelegateExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLazyExpression;", "lazyBodyForGeneratedAccessors", "Lorg/jetbrains/kotlin/fir/expressions/FirLazyBlock;", "bindFunction", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/FirFunctionTarget;", "Lkotlin/ParameterName;", "target", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "function", "processLegacyContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "toLegacyRawContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirLegacyRawContractDescription;", "isContractPresentFirCheck", "isContractBlockFirCheck", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "checkReceiver", "createSafeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;", "receiver", "pullUpSafeCallIfNecessary", "filterUseSiteTarget", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "convertToReceiverParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirReceiverParameter;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "asReceiverParameter", "initContainingClassAttr", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "currentDispatchReceiverType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "isUnderscore", "", "(Ljava/lang/CharSequence;)Z", "buildBalancedOrExpressionTree", "conditions", "lower", "upper", "guardedBy", "guard", "appliesToPrimaryConstructorParameter", "wrapIntoArray", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "shouldGenerateDelegatedSuperCall", "isAnySuperCall", "isExpectClass", "isEnumEntry", "hasExplicitDelegatedCalls", "raw-fir.common"})
@SourceDebugExtension(value={"SMAP\nConversionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversionUtils.kt\norg/jetbrains/kotlin/fir/builder/ConversionUtilsKt\n+ 2 FirElvisExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirElvisExpressionBuilderKt\n+ 3 FirBinaryLogicExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirBinaryLogicExpressionBuilderKt\n+ 4 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 5 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n+ 6 FirComparisonExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirComparisonExpressionBuilderKt\n+ 7 FirPropertyAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirPropertyAccessExpressionBuilderKt\n+ 8 FirResolvedNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedNamedReferenceBuilderKt\n+ 9 FirComponentCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirComponentCallBuilderKt\n+ 10 FirPropertyAccessorBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirPropertyAccessorBuilderKt\n+ 11 FirReturnExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirReturnExpressionBuilderKt\n+ 12 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 13 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 14 FirLegacyRawContractDescriptionBuilder.kt\norg/jetbrains/kotlin/fir/contracts/builder/FirLegacyRawContractDescriptionBuilderKt\n+ 15 FirCheckedSafeCallSubjectBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCheckedSafeCallSubjectBuilderKt\n+ 16 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 17 FirSafeCallExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSafeCallExpressionBuilderKt\n+ 18 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 19 FirAnnotationCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationCallBuilderKt\n+ 20 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 21 FirReceiverParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirReceiverParameterBuilderKt\n+ 22 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 23 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 24 FirThisReceiverExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirThisReceiverExpressionBuilderKt\n+ 25 FirImplicitThisReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirImplicitThisReferenceBuilderKt\n+ 26 FirDelegateFieldReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirDelegateFieldReferenceBuilderKt\n+ 27 FirCallableReferenceAccessBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCallableReferenceAccessBuilderKt\n+ 28 FirTypeProjectionWithVarianceBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirTypeProjectionWithVarianceBuilderKt\n*L\n1#1,751:1\n53#2:752\n52#3:753\n66#4:754\n66#4:757\n66#4:764\n66#4:768\n66#4:773\n41#5:755\n41#5:758\n41#5:760\n41#5:765\n41#5:769\n41#5:774\n55#6:756\n64#7:759\n64#7:761\n64#7:776\n64#7:819\n42#8:762\n42#8:777\n42#8:822\n61#9:763\n85#10:766\n85#10:770\n56#11:767\n56#11:772\n83#12:771\n36#13:775\n36#13:780\n42#14:778\n48#15:779\n43#16:781\n50#17:782\n1611#18,9:783\n1863#18:792\n1864#18:805\n1620#18:806\n827#18:808\n855#18,2:809\n1628#18,2:823\n1630#18:827\n80#19,11:793\n1#20:804\n44#21:807\n44#21:811\n1069#22,2:812\n49#23:814\n49#23:826\n80#24:815\n80#24:817\n41#25:816\n41#25:818\n39#26:820\n64#27:821\n42#28:825\n*S KotlinDebug\n*F\n+ 1 ConversionUtils.kt\norg/jetbrains/kotlin/fir/builder/ConversionUtilsKt\n*L\n179#1:752\n189#1:753\n210#1:754\n259#1:757\n424#1:764\n457#1:768\n515#1:773\n212#1:755\n261#1:758\n279#1:760\n426#1:765\n460#1:769\n518#1:774\n246#1:756\n277#1:759\n292#1:761\n525#1:776\n370#1:819\n294#1:762\n527#1:777\n384#1:822\n305#1:763\n445#1:766\n487#1:770\n456#1:767\n514#1:772\n497#1:771\n522#1:775\n610#1:780\n561#1:778\n598#1:779\n612#1:781\n618#1:782\n643#1:783,9\n643#1:792\n643#1:805\n643#1:806\n657#1:808\n657#1:809,2\n412#1:823,2\n412#1:827\n645#1:793,11\n643#1:804\n654#1:807\n665#1:811\n679#1:812,2\n727#1:814\n416#1:826\n354#1:815\n360#1:817\n356#1:816\n362#1:818\n372#1:820\n382#1:821\n413#1:825\n*E\n"})
public final class ConversionUtilsKt {
    @NotNull
    public static final CharacterWithDiagnostic parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkNotNullParameter((Object)$this$parseCharacter, (String)"<this>");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return new CharacterWithDiagnostic(DiagnosticKind.IncorrectCharacterLiteral);
        }
        String string = $this$parseCharacter.substring(1, $this$parseCharacter.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String text2 = string;
        if (((CharSequence)text2).length() == 0) {
            return new CharacterWithDiagnostic(DiagnosticKind.EmptyCharacterLiteral);
        }
        return text2.charAt(0) != '\\' ? (text2.length() == 1 ? new CharacterWithDiagnostic(text2.charAt(0)) : new CharacterWithDiagnostic(DiagnosticKind.TooManyCharactersInCharacterLiteral)) : ConversionUtilsKt.escapedStringToCharacter(text2);
    }

    @NotNull
    public static final CharacterWithDiagnostic escapedStringToCharacter(@NotNull String text2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        boolean bl2 = bl = ((CharSequence)text2).length() > 0 && text2.charAt(0) == '\\';
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Only escaped sequences must be passed to this routine: " + text2;
            throw new AssertionError((Object)string);
        }
        String string = text2.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String escape = string;
        switch (escape.length()) {
            case 0: {
                return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
            }
            case 1: {
                return ConversionUtilsKt.translateEscape(escape.charAt(0));
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                String string2 = escape.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                Integer intValue = StringsKt.toIntOrNull((String)string2, (int)16);
                if (intValue == null) break;
                return new CharacterWithDiagnostic((char)intValue.intValue());
            }
        }
        return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
    }

    @NotNull
    public static final CharacterWithDiagnostic translateEscape(char c) {
        CharacterWithDiagnostic characterWithDiagnostic;
        switch (c) {
            case 't': {
                characterWithDiagnostic = new CharacterWithDiagnostic('\t');
                break;
            }
            case 'b': {
                characterWithDiagnostic = new CharacterWithDiagnostic('\b');
                break;
            }
            case 'n': {
                characterWithDiagnostic = new CharacterWithDiagnostic('\n');
                break;
            }
            case 'r': {
                characterWithDiagnostic = new CharacterWithDiagnostic('\r');
                break;
            }
            case '\'': {
                characterWithDiagnostic = new CharacterWithDiagnostic('\'');
                break;
            }
            case '\"': {
                characterWithDiagnostic = new CharacterWithDiagnostic('\"');
                break;
            }
            case '\\': {
                characterWithDiagnostic = new CharacterWithDiagnostic('\\');
                break;
            }
            case '$': {
                characterWithDiagnostic = new CharacterWithDiagnostic('$');
                break;
            }
            default: {
                characterWithDiagnostic = new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
            }
        }
        return characterWithDiagnostic;
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toBinaryName, (String)"<this>");
        ImmutableBiMap immutableBiMap = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"BINARY_OPERATION_NAMES");
        return (Name)((Map)immutableBiMap).get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toUnaryName, (String)"<this>");
        ImmutableBiMap immutableBiMap = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"UNARY_OPERATION_NAMES");
        return (Name)((Map)immutableBiMap).get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        Intrinsics.checkNotNullParameter((Object)$this$toFirOperation, (String)"<this>");
        FirOperation firOperation = ConversionUtilsKt.toFirOperationOrNull($this$toFirOperation);
        if (firOperation == null) {
            throw new IllegalStateException(("Cannot convert element type to FIR operation: " + $this$toFirOperation).toString());
        }
        return firOperation;
    }

    @Nullable
    public static final FirOperation toFirOperationOrNull(@NotNull IElementType $this$toFirOperationOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$toFirOperationOrNull, (String)"<this>");
        IElementType iElementType = $this$toFirOperationOrNull;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) ? FirOperation.LT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) ? FirOperation.GT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ) ? FirOperation.LT_EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) ? FirOperation.GT_EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) ? FirOperation.EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ) ? FirOperation.NOT_EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ) ? FirOperation.IDENTITY : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ) ? FirOperation.NOT_IDENTITY : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQ) ? FirOperation.ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ) ? FirOperation.PLUS_ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ) ? FirOperation.MINUS_ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ) ? FirOperation.TIMES_ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ) ? FirOperation.DIV_ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ) ? FirOperation.REM_ASSIGN : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_KEYWORD) ? FirOperation.AS : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_SAFE) ? FirOperation.SAFE_AS : null)))))))))))))));
    }

    @NotNull
    public static final FirElvisExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirExpression other2, @Nullable KtSourceElement baseSource) {
        FirElvisExpressionBuilder firElvisExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$generateNotNullOrOther, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other2, (String)"other");
        boolean $i$f$buildElvisExpression = false;
        FirElvisExpressionBuilder $this$generateNotNullOrOther_u24lambda_u241 = firElvisExpressionBuilder = new FirElvisExpressionBuilder();
        boolean bl = false;
        $this$generateNotNullOrOther_u24lambda_u241.setSource(baseSource);
        $this$generateNotNullOrOther_u24lambda_u241.setLhs($this$generateNotNullOrOther);
        $this$generateNotNullOrOther_u24lambda_u241.setRhs(other2);
        return firElvisExpressionBuilder.build();
    }

    @NotNull
    public static final FirBinaryLogicExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirExpression other2, boolean isAnd, @Nullable KtSourceElement baseSource) {
        FirBinaryLogicExpressionBuilder firBinaryLogicExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$generateLazyLogicalOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other2, (String)"other");
        boolean $i$f$buildBinaryLogicExpression = false;
        FirBinaryLogicExpressionBuilder $this$generateLazyLogicalOperation_u24lambda_u242 = firBinaryLogicExpressionBuilder = new FirBinaryLogicExpressionBuilder();
        boolean bl = false;
        $this$generateLazyLogicalOperation_u24lambda_u242.setSource(baseSource);
        $this$generateLazyLogicalOperation_u24lambda_u242.setLeftOperand($this$generateLazyLogicalOperation);
        $this$generateLazyLogicalOperation_u24lambda_u242.setRightOperand(other2);
        $this$generateLazyLogicalOperation_u24lambda_u242.setKind(isAnd ? LogicOperationKind.AND : LogicOperationKind.OR);
        return firBinaryLogicExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirExpression argument2, boolean inverted, @Nullable KtSourceElement baseSource, @Nullable KtSourceElement operationReferenceSource) {
        void $this$generateContainsOperation_u24lambda_u244_u24lambda_u243;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$generateContainsOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        if (inverted) {
            KtSourceElement ktSourceElement = operationReferenceSource;
            object = ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.DesugaredInvertedContains.INSTANCE), (int)0, (int)0, (int)6, null) : null;
        } else {
            object = operationReferenceSource;
        }
        KtSourceElement resultReferenceSource = object;
        FirFunctionCall containsCall = ConversionUtilsKt.createConventionCall($this$generateContainsOperation, resultReferenceSource, baseSource, argument2, OperatorNameConventions.CONTAINS);
        if (!inverted) {
            return containsCall;
        }
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$generateContainsOperation_u24lambda_u244 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = baseSource;
        $this$generateContainsOperation_u24lambda_u244.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.DesugaredInvertedContains.INSTANCE), (int)0, (int)0, (int)6, null) : null);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$generateContainsOperation_u24lambda_u244;
        boolean bl2 = false;
        $this$generateContainsOperation_u24lambda_u244_u24lambda_u243.setSource(resultReferenceSource);
        $this$generateContainsOperation_u24lambda_u244_u24lambda_u243.setName(OperatorNameConventions.NOT);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$generateContainsOperation_u24lambda_u244.setExplicitReceiver(containsCall);
        $this$generateContainsOperation_u24lambda_u244.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    @NotNull
    public static final FirComparisonExpression generateComparisonExpression(@NotNull FirExpression $this$generateComparisonExpression, @NotNull FirExpression argument2, @NotNull IElementType operatorToken, @Nullable KtSourceElement baseSource, @Nullable KtSourceElement operationReferenceSource) {
        FirComparisonExpressionBuilder firComparisonExpressionBuilder;
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter((Object)$this$generateComparisonExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorToken, (String)"operatorToken");
        ImmutableSet immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"COMPARISON_OPERATIONS");
        if (!CollectionsKt.contains((Iterable)((Iterable)immutableSet), (Object)operatorToken)) {
            boolean $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = false;
            String $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = operatorToken + " is not in " + OperatorConventions.COMPARISON_OPERATIONS;
            throw new IllegalArgumentException($i$a$-require-ConversionUtilsKt$generateComparisonExpression$22.toString());
        }
        KtSourceElement ktSourceElement = baseSource;
        FirFunctionCall compareToCall = ConversionUtilsKt.createConventionCall($this$generateComparisonExpression, operationReferenceSource, ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.GeneratedComparisonExpression.INSTANCE), (int)0, (int)0, (int)6, null) : null, argument2, OperatorNameConventions.COMPARE_TO);
        IElementType iElementType = operatorToken;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else {
            throw new IllegalStateException(("Unknown " + operatorToken).toString());
        }
        FirOperation firOperation2 = firOperation;
        boolean $i$f$buildComparisonExpression = false;
        FirComparisonExpressionBuilder $this$generateComparisonExpression_u24lambda_u246 = firComparisonExpressionBuilder = new FirComparisonExpressionBuilder();
        boolean bl = false;
        $this$generateComparisonExpression_u24lambda_u246.setSource(baseSource);
        $this$generateComparisonExpression_u24lambda_u246.setOperation(firOperation2);
        $this$generateComparisonExpression_u24lambda_u246.setCompareToCall(compareToCall);
        return firComparisonExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirFunctionCall createConventionCall(FirExpression $this$createConventionCall, KtSourceElement operationReferenceSource, KtSourceElement baseSource, FirExpression argument2, Name conventionName) {
        void $this$createConventionCall_u24lambda_u248_u24lambda_u247;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$createConventionCall_u24lambda_u248 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        $this$createConventionCall_u24lambda_u248.setSource(baseSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$createConventionCall_u24lambda_u248;
        boolean bl2 = false;
        $this$createConventionCall_u24lambda_u248_u24lambda_u247.setSource(operationReferenceSource);
        $this$createConventionCall_u24lambda_u248_u24lambda_u247.setName(conventionName);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$createConventionCall_u24lambda_u248.setExplicitReceiver($this$createConventionCall);
        $this$createConventionCall_u24lambda_u248.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(argument2));
        $this$createConventionCall_u24lambda_u248.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateAccessExpression(@Nullable KtSourceElement qualifiedSource, @Nullable KtSourceElement calleeReferenceSource, @NotNull Name name2, @Nullable ConeDiagnostic diagnostic) {
        void $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249;
        Object object;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessExpression_u24lambda_u2410 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateAccessExpression_u24lambda_u2410.setSource(qualifiedSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessExpression_u24lambda_u2410;
        boolean bl2 = false;
        if (Intrinsics.areEqual((Object)calleeReferenceSource, (Object)qualifiedSource)) {
            KtSourceElement ktSourceElement = calleeReferenceSource;
            object = ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE), (int)0, (int)0, (int)6, null) : null;
        } else {
            object = calleeReferenceSource;
        }
        $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249.setSource((KtSourceElement)object);
        $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249.setName(name2);
        firPropertyAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        if (diagnostic != null) {
            $this$generateAccessExpression_u24lambda_u2410.getNonFatalDiagnostics().add(diagnostic);
        }
        return firPropertyAccessExpressionBuilder.build();
    }

    public static /* synthetic */ FirQualifiedAccessExpression generateAccessExpression$default(KtSourceElement ktSourceElement, KtSourceElement ktSourceElement2, Name name2, ConeDiagnostic coneDiagnostic, int n, Object object) {
        if ((n & 8) != 0) {
            coneDiagnostic = null;
        }
        return ConversionUtilsKt.generateAccessExpression(ktSourceElement, ktSourceElement2, name2, coneDiagnostic);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@Nullable KtSourceElement source, @NotNull FirVariable variable2) {
        void $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateResolvedAccessExpression_u24lambda_u2412 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateResolvedAccessExpression_u24lambda_u2412.setSource(source);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateResolvedAccessExpression_u24lambda_u2412;
        boolean bl2 = false;
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setSource(source);
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setName(variable2.getName());
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setResolvedSymbol((FirBasedSymbol)variable2.getSymbol());
        firPropertyAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firPropertyAccessExpressionBuilder.build();
    }

    @NotNull
    public static final FirComponentCall toComponentCall(@NotNull FirVariable $this$toComponentCall, @Nullable KtSourceElement entrySource, int index) {
        FirComponentCallBuilder firComponentCallBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toComponentCall, (String)"<this>");
        boolean $i$f$buildComponentCall = false;
        FirComponentCallBuilder $this$toComponentCall_u24lambda_u2413 = firComponentCallBuilder = new FirComponentCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = entrySource;
        KtSourceElement componentCallSource = ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.DesugaredComponentFunctionCall.INSTANCE), (int)0, (int)0, (int)6, null) : null;
        $this$toComponentCall_u24lambda_u2413.setSource(componentCallSource);
        $this$toComponentCall_u24lambda_u2413.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(componentCallSource, $this$toComponentCall));
        $this$toComponentCall_u24lambda_u2413.setComponentIndex(index + 1);
        return firComponentCallBuilder.build();
    }

    @Nullable
    public static final FirClassSymbol<FirClass> getOwnerRegularOrAnonymousObjectSymbol(@NotNull FirClassBuilder $this$ownerRegularOrAnonymousObjectSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$ownerRegularOrAnonymousObjectSymbol, (String)"<this>");
        FirClassBuilder firClassBuilder = $this$ownerRegularOrAnonymousObjectSymbol;
        return firClassBuilder instanceof FirAnonymousObjectBuilder ? (FirClassSymbol)((FirAnonymousObjectBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : (firClassBuilder instanceof FirRegularClassBuilder ? (FirClassSymbol)((FirRegularClassBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final <T> void generateAccessorsByDelegate(@NotNull FirPropertyBuilder $this$generateAccessorsByDelegate, @Nullable FirWrappedDelegateExpressionBuilder delegateBuilder, @NotNull FirModuleData moduleData, @Nullable FirClassSymbol<?> ownerRegularOrAnonymousObjectSymbol, @NotNull Context<T> context, boolean isExtension, @Nullable FirLazyExpression lazyDelegateExpression, @Nullable FirLazyBlock lazyBodyForGeneratedAccessors, @NotNull Function2<? super FirFunctionTarget, ? super FirFunction, Unit> bindFunction) {
        block16: {
            Intrinsics.checkNotNullParameter((Object)$this$generateAccessorsByDelegate, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Intrinsics.checkNotNullParameter(bindFunction, (String)"bindFunction");
            if (delegateBuilder == null) {
                return;
            }
            it = var10_9 = new FirDelegateFieldSymbol($this$generateAccessorsByDelegate.getSymbol().getCallableId());
            $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$delegateFieldSymbol$1 = false;
            $this$generateAccessorsByDelegate.setDelegateFieldSymbol(it);
            delegateFieldSymbol = var10_9;
            isMember = ownerRegularOrAnonymousObjectSymbol != null;
            v0 = delegateBuilder.getSource();
            fakeSource = v0 != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)v0, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE), (int)0, (int)0, (int)6, null) : null;
            isVar = $this$generateAccessorsByDelegate.isVar();
            v1 = $this$generateAccessorsByDelegate;
            v2 = lazyDelegateExpression;
            if (v2 != null) {
                v3 = v2;
            } else {
                var14_14 = $this$generateAccessorsByDelegate;
                var50_15 = v1;
                $i$a$-run-ConversionUtilsKt$generateAccessorsByDelegate$2 = false;
                $i$f$buildFunctionCall = false;
                var17_22 = new FirFunctionCallBuilder();
                var18_24 = var17_22;
                var19_27 = delegateBuilder;
                $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$2$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427.setExplicitReceiver(delegateBuilder.getExpression());
                $i$f$buildSimpleNamedReference = false;
                var23_39 = var22_37 = new FirSimpleNamedReferenceBuilder();
                var24_41 = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427;
                $i$a$-buildSimpleNamedReference-ConversionUtilsKt$generateAccessorsByDelegate$2$1$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setName(OperatorNameConventions.PROVIDE_DELEGATE);
                var24_41.setCalleeReference(var22_37.build());
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context, true), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427.setOrigin(FirFunctionCallOrigin.Operator);
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427.setSource(fakeSource);
                var19_27.setProvideDelegateCall(var17_22.build());
                v1 = var50_15;
                v3 = delegateBuilder.build();
            }
            v1.setDelegate(v3);
            if ($this$generateAccessorsByDelegate.getGetter() != null && !($this$generateAccessorsByDelegate.getGetter() instanceof FirDefaultPropertyAccessor)) break block16;
            v4 = $this$generateAccessorsByDelegate.getGetter();
            annotations = v4 != null ? v4.getAnnotations() : null;
            returnTarget = new FirFunctionTarget(null, false);
            v5 = $this$generateAccessorsByDelegate.getGetter();
            getterStatus = v5 != null ? v5.getStatus() : null;
            var17_22 = $this$generateAccessorsByDelegate.getGetter();
            if (var17_22 == null || ($this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427 = var17_22.getSource()) == null) ** GOTO lbl-1000
            it = $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$2$1 = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427;
            $i$a$-takeIf-ConversionUtilsKt$generateAccessorsByDelegate$getterElement$1 = false;
            v6 /* !! */  = var19_27 = Intrinsics.areEqual((Object)it.getKind(), (Object)KtRealSourceElementKind.INSTANCE) != false ? $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$2$1 : null;
            if (var19_27 != null && ($i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$2$1 = KtSourceElementKt.fakeElement$default((KtSourceElement)var19_27, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE), (int)0, (int)0, (int)6, null)) != null) {
                v7 = $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$2$1;
            } else lbl-1000:
            // 2 sources

            {
                v7 = fakeSource;
            }
            getterElement = v7;
            $i$f$buildPropertyAccessor = false;
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427 = new FirPropertyAccessorBuilder();
            var19_27 = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427;
            var50_15 = $this$generateAccessorsByDelegate;
            $i$a$-buildPropertyAccessor-ConversionUtilsKt$generateAccessorsByDelegate$3 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2434.setSource(getterElement);
            $this$generateAccessorsByDelegate_u24lambda_u2434.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2434.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2434.setReturnTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2434.setGetter(true);
            v8 = getterStatus;
            if (v8 == null || (v8 = v8.getVisibility()) == null) {
                v8 = (Visibility)Visibilities.Unknown.INSTANCE;
            }
            $i$a$-takeIf-ConversionUtilsKt$generateAccessorsByDelegate$getterElement$1 = it = new FirDeclarationStatusImpl((Visibility)v8, Modality.FINAL);
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = $this$generateAccessorsByDelegate_u24lambda_u2434;
            $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$3$1 = false;
            v9 = getterStatus;
            $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430.setInline(v9 != null ? v9.isInline() : $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430.isInline());
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setStatus(it);
            $this$generateAccessorsByDelegate_u24lambda_u2434.setSymbol(new FirPropertyAccessorSymbol());
            v10 = $this$generateAccessorsByDelegate_u24lambda_u2434;
            v11 = lazyBodyForGeneratedAccessors;
            if (v11 != null) {
                v12 = v11;
            } else {
                $i$f$buildReturnExpression = false;
                $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$3$1 = $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430 = new FirReturnExpressionBuilder();
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = v10;
                $i$a$-buildReturnExpression-ConversionUtilsKt$generateAccessorsByDelegate$3$2 = false;
                $i$f$buildFunctionCall = false;
                var30_50 = var29_49 = new FirFunctionCallBuilder();
                var31_52 = $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433;
                $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$3$2$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, context));
                $i$f$buildSimpleNamedReference = false;
                var35_59 = var34_57 = new FirSimpleNamedReferenceBuilder();
                var36_61 = $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432;
                $i$a$-buildSimpleNamedReference-ConversionUtilsKt$generateAccessorsByDelegate$3$2$1$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setName(OperatorNameConventions.GET_VALUE);
                var36_61.setCalleeReference(var34_57.build());
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context, false, 32, null), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.setOrigin(FirFunctionCallOrigin.Operator);
                var31_52.setResult(var29_49.build());
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433.setTarget(returnTarget);
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433.setSource(fakeSource);
                v10 = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426;
                var51_64 = $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430.build();
                v12 = new FirSingleExpressionBlock(var51_64);
            }
            v10.setBody(v12);
            if (annotations != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2434.getAnnotations().addAll((Collection<FirAnnotation>)annotations);
            }
            $this$generateAccessorsByDelegate_u24lambda_u2434.setPropertySymbol($this$generateAccessorsByDelegate.getSymbol());
            $i$f$buildPropertyAccessor = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427.build();
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427 = $i$f$buildPropertyAccessor;
            $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$4 = false;
            bindFunction.invoke((Object)returnTarget, (Object)it);
            ConversionUtilsKt.initContainingClassAttr((FirCallableDeclaration)it, context);
            var50_15.setGetter($i$f$buildPropertyAccessor);
        }
        if (isVar && ($this$generateAccessorsByDelegate.getSetter() == null || $this$generateAccessorsByDelegate.getSetter() instanceof FirDefaultPropertyAccessor)) {
            v13 = $this$generateAccessorsByDelegate.getSetter();
            annotations = v13 != null ? v13.getAnnotations() : null;
            returnTarget = new FirFunctionTarget(null, false);
            v14 = $this$generateAccessorsByDelegate.getSetter();
            parameterAnnotations = v14 != null && (v14 = v14.getValueParameters()) != null && (v14 = (FirValueParameter)CollectionsKt.firstOrNull((List)v14)) != null ? v14.getAnnotations() : null;
            v15 = $this$generateAccessorsByDelegate.getSetter();
            setterStatus = v15 != null ? v15.getStatus() : null;
            v16 = $this$generateAccessorsByDelegate.getSetter();
            if (v16 == null || (v16 = v16.getSource()) == null || (v16 = KtSourceElementKt.fakeElement$default((KtSourceElement)v16, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE), (int)0, (int)0, (int)6, null)) == null) {
                v16 = fakeSource;
            }
            setterElement = v16;
            $i$f$buildPropertyAccessor = false;
            $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$4 = new FirPropertyAccessorBuilder();
            $i$a$-buildPropertyAccessor-ConversionUtilsKt$generateAccessorsByDelegate$3 = $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$4;
            var50_15 = $this$generateAccessorsByDelegate;
            $i$a$-buildPropertyAccessor-ConversionUtilsKt$generateAccessorsByDelegate$5 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2444.setSource((KtSourceElement)setterElement);
            $this$generateAccessorsByDelegate_u24lambda_u2444.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2444.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2444.setReturnTypeRef(moduleData.getSession().getBuiltinTypes().getUnitType());
            $this$generateAccessorsByDelegate_u24lambda_u2444.setGetter(false);
            v17 = setterStatus;
            if (v17 == null || (v17 = v17.getVisibility()) == null) {
                v17 = (Visibility)Visibilities.Unknown.INSTANCE;
            }
            $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430 = new FirDeclarationStatusImpl((Visibility)v17, Modality.FINAL);
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430;
            var24_41 = $this$generateAccessorsByDelegate_u24lambda_u2444;
            $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$5$1 = false;
            v18 = setterStatus;
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2436.setInline(v18 != null ? v18.isInline() : $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2436.isInline());
            var24_41.setStatus((FirDeclarationStatus)$this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430);
            $this$generateAccessorsByDelegate_u24lambda_u2444.setSymbol(new FirPropertyAccessorSymbol());
            $i$f$buildValueParameter = false;
            var25_45 = new FirValueParameterBuilder();
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437 = var25_45;
            $i$a$-buildValueParameter-ConversionUtilsKt$generateAccessorsByDelegate$5$parameter$1 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setContainingFunctionSymbol($this$generateAccessorsByDelegate_u24lambda_u2444.getSymbol());
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setReturnTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setName(SpecialNames.IMPLICIT_SET_PARAMETER);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setSymbol(new FirValueParameterSymbol($this$generateAccessorsByDelegate.getName()));
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setCrossinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setNoinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setVararg(false);
            if (parameterAnnotations != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.getAnnotations().addAll((Collection<FirAnnotation>)parameterAnnotations);
            }
            parameter = var25_45.build();
            ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2444.getValueParameters()).add(parameter);
            v19 = $this$generateAccessorsByDelegate_u24lambda_u2444;
            v20 = lazyBodyForGeneratedAccessors;
            if (v20 != null) {
                v21 = v20;
            } else {
                $i$f$buildReturnExpression = false;
                var25_45 = new FirReturnExpressionBuilder();
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437 = var25_45;
                var24_41 = v19;
                $i$a$-buildReturnExpression-ConversionUtilsKt$generateAccessorsByDelegate$5$2 = false;
                $i$f$buildFunctionCall = false;
                $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$3$2$1 = var31_52 = new FirFunctionCallBuilder();
                var33_56 = $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443;
                $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$5$2$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, context));
                $i$f$buildSimpleNamedReference = false;
                var36_61 = new FirSimpleNamedReferenceBuilder();
                $i$a$-buildSimpleNamedReference-ConversionUtilsKt$generateAccessorsByDelegate$3$2$1$1 = var36_61;
                var38_66 = $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442;
                $i$a$-buildSimpleNamedReference-ConversionUtilsKt$generateAccessorsByDelegate$5$2$1$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2438.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2438.setName(OperatorNameConventions.SET_VALUE);
                var38_66.setCalleeReference(var36_61.build());
                $i$f$buildArgumentList = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2438 = var36_61 = new FirArgumentListBuilder();
                var38_66 = $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442;
                $i$a$-buildArgumentList-ConversionUtilsKt$generateAccessorsByDelegate$5$2$1$2 = false;
                ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441.getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context, false, 32, null));
                ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441.getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate));
                var40_68 = $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441.getArguments();
                $i$f$buildPropertyAccessExpression = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440 = var42_71 = new FirPropertyAccessExpressionBuilder();
                $i$a$-buildPropertyAccessExpression-ConversionUtilsKt$generateAccessorsByDelegate$5$2$1$2$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440.setSource(fakeSource);
                $i$f$buildResolvedNamedReference = false;
                var47_76 = var46_75 = new FirResolvedNamedReferenceBuilder();
                var48_77 = $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440;
                $i$a$-buildResolvedNamedReference-ConversionUtilsKt$generateAccessorsByDelegate$5$2$1$2$1$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setName(SpecialNames.IMPLICIT_SET_PARAMETER);
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setResolvedSymbol(parameter.getSymbol());
                var48_77.setCalleeReference(var46_75.build());
                var41_70 = var42_71.build();
                var40_68.add(var41_70);
                var38_66.setArgumentList(var36_61.build());
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442.setOrigin(FirFunctionCallOrigin.Operator);
                var33_56.setResult(var31_52.build());
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443.setTarget(returnTarget);
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443.setSource(fakeSource);
                v19 = var24_41;
                var52_79 = var25_45.build();
                v21 = new FirSingleExpressionBlock(var52_79);
            }
            v19.setBody(v21);
            if (annotations != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2444.getAnnotations().addAll((Collection<FirAnnotation>)annotations);
            }
            $this$generateAccessorsByDelegate_u24lambda_u2444.setPropertySymbol($this$generateAccessorsByDelegate.getSymbol());
            var18_26 = $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$4.build();
            $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$4 = var18_26;
            $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$6 = false;
            bindFunction.invoke((Object)returnTarget, (Object)it);
            ConversionUtilsKt.initContainingClassAttr((FirCallableDeclaration)it, context);
            var50_15.setSetter(var18_26);
        }
    }

    public static /* synthetic */ void generateAccessorsByDelegate$default(FirPropertyBuilder firPropertyBuilder, FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder, FirModuleData firModuleData, FirClassSymbol firClassSymbol, Context context2, boolean bl, FirLazyExpression firLazyExpression, FirLazyBlock firLazyBlock, Function2 function2, int n, Object object) {
        if ((n & 0x20) != 0) {
            firLazyExpression = null;
        }
        if ((n & 0x40) != 0) {
            firLazyBlock = null;
        }
        if ((n & 0x80) != 0) {
            function2 = generateAccessorsByDelegate.1.INSTANCE;
        }
        ConversionUtilsKt.generateAccessorsByDelegate(firPropertyBuilder, firWrappedDelegateExpressionBuilder, firModuleData, firClassSymbol, context2, bl, firLazyExpression, firLazyBlock, (Function2<? super FirFunctionTarget, ? super FirFunction, Unit>)function2);
    }

    @Nullable
    public static final FirContractDescription processLegacyContractDescription(@NotNull FirBlock block2, @Nullable ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        if (ConversionUtilsKt.isContractPresentFirCheck(block2)) {
            FirFunctionCall contractCall = (FirFunctionCall)FirExpressionUtilKt.replaceFirstStatement(block2, ConversionUtilsKt::processLegacyContractDescription$lambda$46);
            return ConversionUtilsKt.toLegacyRawContractDescription(contractCall, diagnostic);
        }
        return null;
    }

    @NotNull
    public static final FirLegacyRawContractDescription toLegacyRawContractDescription(@NotNull FirFunctionCall $this$toLegacyRawContractDescription, @Nullable ConeDiagnostic diagnostic) {
        FirLegacyRawContractDescriptionBuilder firLegacyRawContractDescriptionBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toLegacyRawContractDescription, (String)"<this>");
        boolean $i$f$buildLegacyRawContractDescription = false;
        FirLegacyRawContractDescriptionBuilder $this$toLegacyRawContractDescription_u24lambda_u2447 = firLegacyRawContractDescriptionBuilder = new FirLegacyRawContractDescriptionBuilder();
        boolean bl = false;
        $this$toLegacyRawContractDescription_u24lambda_u2447.setSource($this$toLegacyRawContractDescription.getSource());
        $this$toLegacyRawContractDescription_u24lambda_u2447.setContractCall($this$toLegacyRawContractDescription);
        $this$toLegacyRawContractDescription_u24lambda_u2447.setDiagnostic(diagnostic);
        return firLegacyRawContractDescriptionBuilder.build();
    }

    public static /* synthetic */ FirLegacyRawContractDescription toLegacyRawContractDescription$default(FirFunctionCall firFunctionCall, ConeDiagnostic coneDiagnostic, int n, Object object) {
        if ((n & 1) != 0) {
            coneDiagnostic = null;
        }
        return ConversionUtilsKt.toLegacyRawContractDescription(firFunctionCall, coneDiagnostic);
    }

    public static final boolean isContractPresentFirCheck(@NotNull FirBlock $this$isContractPresentFirCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractPresentFirCheck, (String)"<this>");
        FirStatement firStatement = (FirStatement)CollectionsKt.firstOrNull($this$isContractPresentFirCheck.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement firstStatement = firStatement;
        return ConversionUtilsKt.isContractBlockFirCheck(firstStatement);
    }

    public static final boolean isContractBlockFirCheck(@NotNull FirStatement $this$isContractBlockFirCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractBlockFirCheck, (String)"<this>");
        FirFunctionCall firFunctionCall = $this$isContractBlockFirCheck instanceof FirFunctionCall ? (FirFunctionCall)$this$isContractBlockFirCheck : null;
        if (firFunctionCall == null) {
            return false;
        }
        FirFunctionCall contractCall = firFunctionCall;
        if (!Intrinsics.areEqual((Object)contractCall.getCalleeReference().getName().asString(), (Object)"contract")) {
            return false;
        }
        FirExpression firExpression = contractCall.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
        if (firQualifiedAccessExpression == null) {
            return true;
        }
        FirQualifiedAccessExpression receiver2 = firQualifiedAccessExpression;
        if (!ConversionUtilsKt.checkReceiver(contractCall, "contracts")) {
            return false;
        }
        if (!ConversionUtilsKt.checkReceiver(receiver2, "kotlin")) {
            return false;
        }
        FirExpression firExpression2 = receiver2.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression2 == null) {
            return false;
        }
        FirQualifiedAccessExpression receiverOfReceiver = firQualifiedAccessExpression2;
        return receiverOfReceiver.getExplicitReceiver() == null;
    }

    private static final boolean checkReceiver(FirExpression $this$checkReceiver, String name2) {
        if (!($this$checkReceiver instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        FirExpression firExpression = ((FirQualifiedAccessExpression)$this$checkReceiver).getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression receiver2 = firQualifiedAccessExpression;
        FirReference firReference = receiver2.getCalleeReference();
        Object object = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
        if (object == null || (object = ((FirNamedReference)object).getName()) == null || (object = object.asString()) == null) {
            return false;
        }
        Object receiverName2 = object;
        return Intrinsics.areEqual((Object)receiverName2, (Object)name2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirSafeCallExpression createSafeCall(@NotNull FirQualifiedAccessExpression $this$createSafeCall, @NotNull FirExpression receiver2, @NotNull KtSourceElement source) {
        void $this$createSafeCall_u24lambda_u2452_u24lambda_u2451;
        FirSafeCallExpressionBuilder firSafeCallExpressionBuilder;
        Object $this$arguments$iv;
        void $this$createSafeCall_u24lambda_u2449_u24lambda_u2448;
        FirExpressionRef<FirExpression> firExpressionRef;
        Intrinsics.checkNotNullParameter((Object)$this$createSafeCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiver2, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean $i$f$buildCheckedSafeCallSubject = false;
        FirCheckedSafeCallSubjectBuilder firCheckedSafeCallSubjectBuilder = new FirCheckedSafeCallSubjectBuilder();
        Object $this$createSafeCall_u24lambda_u2449 = firCheckedSafeCallSubjectBuilder;
        boolean bl = false;
        FirExpressionRef<FirExpression> firExpressionRef2 = firExpressionRef = new FirExpressionRef<FirExpression>();
        FirCheckedSafeCallSubjectBuilder firCheckedSafeCallSubjectBuilder2 = $this$createSafeCall_u24lambda_u2449;
        boolean bl2 = false;
        $this$createSafeCall_u24lambda_u2449_u24lambda_u2448.bind(receiver2);
        firCheckedSafeCallSubjectBuilder2.setOriginalReceiverRef(firExpressionRef);
        KtSourceElement ktSourceElement = receiver2.getSource();
        ((FirCheckedSafeCallSubjectBuilder)$this$createSafeCall_u24lambda_u2449).setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.CheckedSafeCallSubject.INSTANCE), (int)0, (int)0, (int)6, null) : null);
        FirCheckedSafeCallSubject checkedSafeCallSubject = firCheckedSafeCallSubjectBuilder.build();
        if ($this$createSafeCall instanceof FirImplicitInvokeCall) {
            boolean $i$f$buildArgumentList = false;
            Object $this$createSafeCall_u24lambda_u2450 = $this$createSafeCall_u24lambda_u2449 = new FirArgumentListBuilder();
            boolean bl3 = false;
            ((FirArgumentListBuilder)$this$createSafeCall_u24lambda_u2450).getArguments().add(checkedSafeCallSubject);
            $this$arguments$iv = (FirCall)((Object)$this$createSafeCall);
            boolean $i$f$getArguments = false;
            ((FirArgumentListBuilder)$this$createSafeCall_u24lambda_u2450).getArguments().addAll((Collection<FirExpression>)$this$arguments$iv.getArgumentList().getArguments());
            FirArgumentList newArguments = ((FirArgumentListBuilder)$this$createSafeCall_u24lambda_u2449).build();
            ((FirImplicitInvokeCall)$this$createSafeCall).replaceArgumentList(newArguments);
        } else {
            $this$createSafeCall.replaceExplicitReceiver(checkedSafeCallSubject);
        }
        boolean $i$f$buildSafeCallExpression = false;
        FirSafeCallExpressionBuilder $this$createSafeCall_u24lambda_u2452 = firSafeCallExpressionBuilder = new FirSafeCallExpressionBuilder();
        boolean bl4 = false;
        $this$createSafeCall_u24lambda_u2452.setReceiver(receiver2);
        FirExpressionRef<FirCheckedSafeCallSubject> firExpressionRef3 = new FirExpressionRef<FirCheckedSafeCallSubject>();
        $this$arguments$iv = firExpressionRef3;
        FirSafeCallExpressionBuilder firSafeCallExpressionBuilder2 = $this$createSafeCall_u24lambda_u2452;
        boolean bl5 = false;
        $this$createSafeCall_u24lambda_u2452_u24lambda_u2451.bind((FirExpression)checkedSafeCallSubject);
        firSafeCallExpressionBuilder2.setCheckedSubjectRef(firExpressionRef3);
        $this$createSafeCall_u24lambda_u2452.setSelector($this$createSafeCall);
        $this$createSafeCall_u24lambda_u2452.setSource(source);
        return firSafeCallExpressionBuilder.build();
    }

    @NotNull
    public static final FirExpression pullUpSafeCallIfNecessary(@NotNull FirExpression $this$pullUpSafeCallIfNecessary) {
        Intrinsics.checkNotNullParameter((Object)$this$pullUpSafeCallIfNecessary, (String)"<this>");
        if (!($this$pullUpSafeCallIfNecessary instanceof FirQualifiedAccessExpression)) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirExpression firExpression = ((FirQualifiedAccessExpression)$this$pullUpSafeCallIfNecessary).getExplicitReceiver();
        FirSafeCallExpression firSafeCallExpression = firExpression instanceof FirSafeCallExpression ? (FirSafeCallExpression)firExpression : null;
        if (firSafeCallExpression == null) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirSafeCallExpression safeCall = firSafeCallExpression;
        FirStatement firStatement = safeCall.getSelector();
        FirExpression firExpression2 = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
        if (firExpression2 == null) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirExpression safeCallSelector = firExpression2;
        ((FirQualifiedAccessExpression)$this$pullUpSafeCallIfNecessary).replaceExplicitReceiver(safeCallSelector);
        safeCall.replaceSelector($this$pullUpSafeCallIfNecessary);
        return safeCall;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnnotationCall> filterUseSiteTarget(@NotNull List<? extends FirAnnotationCall> $this$filterUseSiteTarget, @NotNull AnnotationUseSiteTarget target2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterUseSiteTarget, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Iterable $this$mapNotNull$iv = $this$filterUseSiteTarget;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirAnnotationCall firAnnotationCall;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
            boolean bl2 = false;
            if (it.getUseSiteTarget() != target2) {
                firAnnotationCall = null;
            } else {
                FirAnnotationCallBuilder firAnnotationCallBuilder;
                boolean $i$f$buildAnnotationCallCopy = false;
                FirAnnotationCallBuilder copyBuilder$iv = new FirAnnotationCallBuilder();
                copyBuilder$iv.setSource(it.getSource());
                copyBuilder$iv.setUseSiteTarget(it.getUseSiteTarget());
                copyBuilder$iv.setAnnotationTypeRef(it.getAnnotationTypeRef());
                copyBuilder$iv.getTypeArguments().addAll((Collection<FirTypeProjection>)it.getTypeArguments());
                copyBuilder$iv.setArgumentList(it.getArgumentList());
                copyBuilder$iv.setCalleeReference(it.getCalleeReference());
                copyBuilder$iv.setArgumentMapping(it.getArgumentMapping());
                copyBuilder$iv.setAnnotationResolvePhase(it.getAnnotationResolvePhase());
                copyBuilder$iv.setContainingDeclarationSymbol(it.getContainingDeclarationSymbol());
                FirAnnotationCallBuilder $this$filterUseSiteTarget_u24lambda_u2454_u24lambda_u2453 = firAnnotationCallBuilder = copyBuilder$iv;
                boolean bl3 = false;
                KtSourceElement ktSourceElement = it.getSource();
                $this$filterUseSiteTarget_u24lambda_u2454_u24lambda_u2453.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.FromUseSiteTarget.INSTANCE), (int)0, (int)0, (int)6, null) : null);
                firAnnotationCall = firAnnotationCallBuilder.build();
            }
            if (firAnnotationCall == null) continue;
            FirAnnotationCall it$iv$iv = firAnnotationCall;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirReceiverParameter convertToReceiverParameter(@NotNull FirTypeRef $this$convertToReceiverParameter) {
        void $this$filterNotTo$iv$iv;
        FirReceiverParameterBuilder firReceiverParameterBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$convertToReceiverParameter, (String)"<this>");
        FirTypeRef typeRef = $this$convertToReceiverParameter;
        boolean $i$f$buildReceiverParameter = false;
        FirReceiverParameterBuilder $this$convertToReceiverParameter_u24lambda_u2456 = firReceiverParameterBuilder = new FirReceiverParameterBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = typeRef.getSource();
        $this$convertToReceiverParameter_u24lambda_u2456.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.ReceiverFromType.INSTANCE), (int)0, (int)0, (int)6, null) : null);
        Collection collection = $this$convertToReceiverParameter_u24lambda_u2456.getAnnotations();
        List<FirAnnotation> list2 = typeRef.getAnnotations();
        Intrinsics.checkNotNull(list2, (String)"null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.kotlin.fir.expressions.FirAnnotationCall>");
        CollectionsKt.addAll((Collection)collection, (Iterable)ConversionUtilsKt.filterUseSiteTarget(list2, AnnotationUseSiteTarget.RECEIVER));
        Iterable $this$filterNot$iv = typeRef.getAnnotations();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirAnnotation it = (FirAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (it.getUseSiteTarget() == AnnotationUseSiteTarget.RECEIVER) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredTypeRefAnnotations = (List)destination$iv$iv;
        if (filteredTypeRefAnnotations.size() != typeRef.getAnnotations().size()) {
            typeRef.replaceAnnotations(filteredTypeRefAnnotations);
        }
        $this$convertToReceiverParameter_u24lambda_u2456.setTypeRef(typeRef);
        return firReceiverParameterBuilder.build();
    }

    @NotNull
    public static final FirReceiverParameter asReceiverParameter(@NotNull KtSourceElement $this$asReceiverParameter) {
        FirReceiverParameterBuilder firReceiverParameterBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$asReceiverParameter, (String)"<this>");
        boolean $i$f$buildReceiverParameter = false;
        FirReceiverParameterBuilder $this$asReceiverParameter_u24lambda_u2457 = firReceiverParameterBuilder = new FirReceiverParameterBuilder();
        boolean bl = false;
        $this$asReceiverParameter_u24lambda_u2457.setSource(KtSourceElementKt.fakeElement$default((KtSourceElement)$this$asReceiverParameter, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.ReceiverFromType.INSTANCE), (int)0, (int)0, (int)6, null));
        $this$asReceiverParameter_u24lambda_u2457.setTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
        return firReceiverParameterBuilder.build();
    }

    public static final <T> void initContainingClassAttr(@NotNull FirCallableDeclaration $this$initContainingClassAttr, @NotNull Context<T> context2) {
        Intrinsics.checkNotNullParameter((Object)$this$initContainingClassAttr, (String)"<this>");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Object object = ConversionUtilsKt.currentDispatchReceiverType(context2);
        if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return;
        }
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$initContainingClassAttr, (ConeClassLikeLookupTag)object);
    }

    @Nullable
    public static final <T> ConeClassLikeType currentDispatchReceiverType(@NotNull Context<T> context2) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        return (ConeClassLikeType)CollectionsKt.lastOrNull(context2.getDispatchReceiverTypesStack());
    }

    public static final boolean isUnderscore(@NotNull CharSequence $this$isUnderscore) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isUnderscore, (String)"<this>");
            CharSequence $this$all$iv = $this$isUnderscore;
            boolean $i$f$all = false;
            for (int j = 0; j < $this$all$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(j);
                boolean bl2 = false;
                if (it == '_') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public static final FirExpression buildBalancedOrExpressionTree(@NotNull List<? extends FirExpression> conditions, int lower, int upper) {
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        int size = upper - lower + 1;
        int middle = size / 2 + lower;
        if (lower == upper) {
            return conditions.get(middle);
        }
        FirExpression leftNode = ConversionUtilsKt.buildBalancedOrExpressionTree(conditions, lower, middle - 1);
        FirExpression rightNode = ConversionUtilsKt.buildBalancedOrExpressionTree(conditions, middle, upper);
        KtSourceElement ktSourceElement = leftNode.getSource();
        if (ktSourceElement == null) {
            ktSourceElement = rightNode.getSource();
        }
        return ConversionUtilsKt.generateLazyLogicalOperation(leftNode, rightNode, false, ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.WhenCondition.INSTANCE), (int)0, (int)0, (int)6, null) : null);
    }

    public static /* synthetic */ FirExpression buildBalancedOrExpressionTree$default(List list2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = CollectionsKt.getLastIndex((List)list2);
        }
        return ConversionUtilsKt.buildBalancedOrExpressionTree(list2, n, n2);
    }

    @NotNull
    public static final FirExpression guardedBy(@NotNull FirExpression $this$guardedBy, @Nullable FirExpression guard) {
        FirExpression firExpression;
        Intrinsics.checkNotNullParameter((Object)$this$guardedBy, (String)"<this>");
        if (guard == null) {
            firExpression = $this$guardedBy;
        } else {
            KtSourceElement ktSourceElement = $this$guardedBy.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = guard.getSource();
            }
            firExpression = ConversionUtilsKt.generateLazyLogicalOperation($this$guardedBy, guard, true, ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.WhenCondition.INSTANCE), (int)0, (int)0, (int)6, null) : null);
        }
        return firExpression;
    }

    public static final boolean appliesToPrimaryConstructorParameter(@Nullable AnnotationUseSiteTarget $this$appliesToPrimaryConstructorParameter) {
        return $this$appliesToPrimaryConstructorParameter == null || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.RECEIVER || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.FILE;
    }

    @NotNull
    public static final FirResolvedTypeRef wrapIntoArray(@NotNull FirErrorTypeRef $this$wrapIntoArray) {
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$wrapIntoArray, (String)"<this>");
        FirErrorTypeRef typeRef = $this$wrapIntoArray;
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $this$wrapIntoArray_u24lambda_u2459 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        boolean bl = false;
        $this$wrapIntoArray_u24lambda_u2459.setSource(typeRef.getSource());
        ConeKotlinTypeProjectionOut[] coneKotlinTypeProjectionOutArray = new ConeKotlinTypeProjectionOut[]{new ConeKotlinTypeProjectionOut(FirTypeUtilsKt.getConeType(typeRef))};
        $this$wrapIntoArray_u24lambda_u2459.setType(TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getArray(), coneKotlinTypeProjectionOutArray, false, null, 6, null));
        $this$wrapIntoArray_u24lambda_u2459.setDelegatedTypeRef(UtilsKt.copyWithNewSourceKind((FirTypeRef)typeRef, (KtFakeSourceElementKind)KtFakeSourceElementKind.ArrayTypeFromVarargParameter.INSTANCE));
        return firResolvedTypeRefBuilder.build();
    }

    public static final boolean shouldGenerateDelegatedSuperCall(boolean isAnySuperCall, boolean isExpectClass, boolean isEnumEntry, boolean hasExplicitDelegatedCalls) {
        if (isAnySuperCall) {
            return false;
        }
        if (isExpectClass) {
            return !isEnumEntry && hasExplicitDelegatedCalls;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> FirExpression generateAccessorsByDelegate$thisRef(boolean $isExtension, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, KtSourceElement fakeSource, FirPropertyBuilder $this_generateAccessorsByDelegate, Context<T> $context, boolean forDispatchReceiver) {
        FirExpression firExpression;
        if ($isExtension && !forDispatchReceiver) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416_u24lambda_u2415;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder2 = firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416;
            boolean bl2 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416_u24lambda_u2415.setBoundSymbol($this_generateAccessorsByDelegate.getSymbol());
            firThisReceiverExpressionBuilder2.setCalleeReference(firImplicitThisReferenceBuilder.build());
            firExpression = firThisReceiverExpressionBuilder.build();
        } else if ($ownerRegularOrAnonymousObjectSymbol != null) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2417;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            FirImplicitThisReferenceBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416_u24lambda_u2415 = firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418;
            boolean bl3 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2417.setBoundSymbol((FirBasedSymbol)$ownerRegularOrAnonymousObjectSymbol);
            firThisReceiverExpressionBuilder3.setCalleeReference(firImplicitThisReferenceBuilder.build());
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418.setConeTypeOrNull((ConeKotlinType)CollectionsKt.last($context.getDispatchReceiverTypesStack()));
            firExpression = firThisReceiverExpressionBuilder.build();
        } else {
            firExpression = FirConstExpressionBuilderKt.buildLiteralExpression$default(null, (ConstantValueKind)ConstantValueKind.Null.INSTANCE, null, null, false, null, 40, null);
        }
        return firExpression;
    }

    static /* synthetic */ FirExpression generateAccessorsByDelegate$thisRef$default(boolean bl, FirClassSymbol firClassSymbol, KtSourceElement ktSourceElement, FirPropertyBuilder firPropertyBuilder, Context context2, boolean bl2, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        return ConversionUtilsKt.generateAccessorsByDelegate$thisRef(bl, firClassSymbol, ktSourceElement, firPropertyBuilder, context2, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> FirPropertyAccessExpression generateAccessorsByDelegate$delegateAccess(KtSourceElement fakeSource, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, FirDelegateFieldSymbol delegateFieldSymbol, boolean $isExtension, FirPropertyBuilder $this_generateAccessorsByDelegate, Context<T> $context) {
        void $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420.setSource(fakeSource);
        boolean $i$f$buildDelegateFieldReference = false;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder2 = firDelegateFieldReferenceBuilder = new FirDelegateFieldReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420;
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419.setSource(fakeSource);
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419.setResolvedSymbol(delegateFieldSymbol);
        firPropertyAccessExpressionBuilder2.setCalleeReference(firDelegateFieldReferenceBuilder.build());
        if ($ownerRegularOrAnonymousObjectSymbol != null) {
            $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420.setDispatchReceiver(ConversionUtilsKt.generateAccessorsByDelegate$thisRef($isExtension, $ownerRegularOrAnonymousObjectSymbol, fakeSource, $this_generateAccessorsByDelegate, $context, true));
        }
        return firPropertyAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirCallableReferenceAccess generateAccessorsByDelegate$propertyRef(KtSourceElement fakeSource, boolean isMember, boolean $isExtension, boolean isVar, FirPropertyBuilder $this_generateAccessorsByDelegate) {
        void $this$mapTo$iv;
        ConeKotlinType coneKotlinType;
        Object $i$f$buildResolvedNamedReference2;
        void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder;
        boolean $i$f$buildCallableReferenceAccess = false;
        FirCallableReferenceAccessBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425 = firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
        boolean bl = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.setSource(fakeSource);
        boolean $i$f$buildResolvedNamedReference2 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        Object object = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425;
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setSource(fakeSource);
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setName($this_generateAccessorsByDelegate.getName());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setResolvedSymbol($this_generateAccessorsByDelegate.getSymbol());
        ((FirCallableReferenceAccessBuilder)object).setCalleeReference(firResolvedNamedReferenceBuilder.build());
        if (!isMember && !$isExtension) {
            ConeClassLikeType coneClassLikeType;
            if (isVar) {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKMutableProperty0(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            } else {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKProperty0(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            }
            coneKotlinType = coneClassLikeType;
        } else if (isMember && $isExtension) {
            ConeClassLikeType coneClassLikeType;
            if (isVar) {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKMutableProperty2(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            } else {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKProperty2(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            }
            coneKotlinType = coneClassLikeType;
        } else {
            ConeClassLikeType coneClassLikeType;
            if (isVar) {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKMutableProperty1(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            } else {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKProperty1(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            }
            coneKotlinType = coneClassLikeType;
        }
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.setConeTypeOrNull(coneKotlinType);
        $i$f$buildResolvedNamedReference2 = $this_generateAccessorsByDelegate.getTypeParameters();
        Collection destination$iv = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.getTypeArguments();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder;
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv;
            object = destination$iv;
            boolean bl3 = false;
            boolean $i$f$buildTypeProjectionWithVariance = false;
            FirTypeProjectionWithVarianceBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423 = firTypeProjectionWithVarianceBuilder = new FirTypeProjectionWithVarianceBuilder();
            boolean bl4 = false;
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423.setVariance(Variance.INVARIANT);
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder2 = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423;
            boolean bl5 = false;
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.setType(new ConeTypeParameterTypeImpl(it.getSymbol().toLookupTag(), false, null, 4, null));
            firTypeProjectionWithVarianceBuilder2.setTypeRef(firResolvedTypeRefBuilder.build());
            object.add(firTypeProjectionWithVarianceBuilder.build());
        }
        return firCallableReferenceAccessBuilder.build();
    }

    private static final FirStatement processLegacyContractDescription$lambda$46(FirFunctionCall it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new FirContractCallBlock(it);
    }
}

