/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.serialization.JvmSignatureSerializer;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ClassMapperLite;
import org.jetbrains.kotlin.metadata.serialization.StringTable;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSignatureSerializer;", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSignatureSerializer;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "stringTable", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "<init>", "(Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;)V", "requiresFunctionSignature", "", "descriptor", "desc", "", "requiresPropertySignature", "mapTypeDefault", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nFirJvmSerializerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmSerializerExtension.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmSignatureSerializer\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,373:1\n26#2:374\n*S KotlinDebug\n*F\n+ 1 FirJvmSerializerExtension.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmSignatureSerializer\n*L\n369#1:374\n*E\n"})
public final class FirJvmSignatureSerializer
extends JvmSignatureSerializer<FirFunction, FirProperty> {
    public FirJvmSignatureSerializer(@NotNull FirElementAwareStringTable stringTable2) {
        Intrinsics.checkNotNullParameter((Object)stringTable2, (String)"stringTable");
        super((StringTable)stringTable2);
    }

    protected boolean requiresFunctionSignature(@NotNull FirFunction descriptor2, @NotNull String desc2) {
        FirTypeRef receiverTypeRef;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)desc2, (String)"desc");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        FirReceiverParameter firReceiverParameter = descriptor2.getReceiverParameter();
        FirTypeRef firTypeRef = receiverTypeRef = firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null;
        if (receiverTypeRef != null) {
            String string = this.mapTypeDefault(receiverTypeRef);
            if (string == null) {
                return true;
            }
            String receiverDesc = string;
            sb.append(receiverDesc);
        }
        for (FirValueParameter valueParameter : descriptor2.getValueParameters()) {
            String paramDesc;
            if (this.mapTypeDefault(valueParameter.getReturnTypeRef()) == null) {
                return true;
            }
            sb.append(paramDesc);
        }
        sb.append(")");
        FirTypeRef returnTypeRef = descriptor2.getReturnTypeRef();
        String string = this.mapTypeDefault(returnTypeRef);
        if (string == null) {
            return true;
        }
        String returnTypeDesc = string;
        sb.append(returnTypeDesc);
        return !Intrinsics.areEqual((Object)sb.toString(), (Object)desc2);
    }

    public boolean requiresPropertySignature(@NotNull FirProperty descriptor2, @NotNull String desc2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)desc2, (String)"desc");
        return !Intrinsics.areEqual((Object)desc2, (Object)this.mapTypeDefault(descriptor2.getReturnTypeRef()));
    }

    private final String mapTypeDefault(FirTypeRef typeRef) {
        ClassId classId;
        FirTypeRef $this$coneTypeSafe$iv = typeRef;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
        ClassId classId2 = classId = coneClassLikeType != null ? ConeTypeUtilsKt.getClassId(coneClassLikeType) : null;
        return classId2 == null ? null : ClassMapperLite.mapClass((String)classId2.asString());
    }
}

