/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.references.fe10.util.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/utils/InlineFunctionsCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "reifiedInlineFunctionsOnly", "", "acceptDeclaration", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "", "<init>", "(Lcom/intellij/openapi/project/Project;ZLkotlin/jvm/functions/Function1;)V", "checkResolveCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "analyzeNextIfInline", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "hasReifiedTypeParameters", "analysis-api-fe10"})
@SourceDebugExtension(value={"SMAP\nInlineFunctionsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineFunctionsCollector.kt\norg/jetbrains/kotlin/analysis/api/descriptors/utils/InlineFunctionsCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1755#2,3:53\n*S KotlinDebug\n*F\n+ 1 InlineFunctionsCollector.kt\norg/jetbrains/kotlin/analysis/api/descriptors/utils/InlineFunctionsCollector\n*L\n49#1:53,3\n*E\n"})
public final class InlineFunctionsCollector {
    @NotNull
    private final Project project;
    private final boolean reifiedInlineFunctionsOnly;
    @NotNull
    private final Function1<KtDeclarationWithBody, Unit> acceptDeclaration;

    public InlineFunctionsCollector(@NotNull Project project2, boolean reifiedInlineFunctionsOnly, @NotNull Function1<? super KtDeclarationWithBody, Unit> acceptDeclaration) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(acceptDeclaration, (String)"acceptDeclaration");
        this.project = project2;
        this.reifiedInlineFunctionsOnly = reifiedInlineFunctionsOnly;
        this.acceptDeclaration = acceptDeclaration;
    }

    public final void checkResolveCall(@Nullable ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            return;
        }
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
        CallableDescriptor descriptor2 = callableDescriptor;
        if (descriptor2 instanceof DeserializedSimpleFunctionDescriptor) {
            return;
        }
        this.analyzeNextIfInline(descriptor2);
        if (descriptor2 instanceof PropertyDescriptor) {
            for (PropertyAccessorDescriptor accessor : ((PropertyDescriptor)descriptor2).getAccessors()) {
                Intrinsics.checkNotNull((Object)accessor);
                this.analyzeNextIfInline((CallableDescriptor)accessor);
            }
        }
    }

    private final void analyzeNextIfInline(CallableDescriptor descriptor2) {
        if (!InlineUtil.isInline((DeclarationDescriptor)((DeclarationDescriptor)descriptor2)) || this.reifiedInlineFunctionsOnly && !this.hasReifiedTypeParameters(descriptor2)) {
            return;
        }
        PsiElement declaration2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.project, (DeclarationDescriptor)descriptor2);
        if (declaration2 != null && declaration2 instanceof KtDeclarationWithBody) {
            this.acceptDeclaration.invoke((Object)declaration2);
        }
    }

    private final boolean hasReifiedTypeParameters(CallableDescriptor descriptor2) {
        boolean bl;
        block3: {
            List list2 = descriptor2.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!it.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

