/*
 * Decompiled with CFR 0.152.
 */
package javaslang.control;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javaslang.Value;
import javaslang.collection.Iterator;
import javaslang.collection.LinearSeq;
import javaslang.collection.List;
import javaslang.collection.Seq;
import javaslang.control.Either;

public interface Try<T>
extends Value<T>,
Serializable {
    public static final long serialVersionUID = 1L;

    public static <T> Try<T> of(CheckedSupplier<? extends T> supplier) {
        try {
            return new Success(supplier.get());
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    public static Try<Void> run(CheckedRunnable runnable) {
        try {
            runnable.run();
            return new Success<Void>(null);
        }
        catch (Throwable t) {
            return new Failure<Void>(t);
        }
    }

    public static <T> Try<Seq<T>> sequence(Iterable<? extends Try<? extends T>> values2) {
        Objects.requireNonNull(values2, "values is null");
        LinearSeq list2 = List.empty();
        for (Try<T> value2 : values2) {
            if (value2.isFailure()) {
                return Try.failure(value2.getCause());
            }
            list2 = list2.prepend((Object)value2.get());
        }
        return Try.success(list2.reverse());
    }

    public static <T> Try<T> success(T value2) {
        return new Success(value2);
    }

    public static <T> Try<T> failure(Throwable exception) {
        return new Failure(exception);
    }

    public static <T> Try<T> narrow(Try<? extends T> t) {
        return t;
    }

    default public Try<T> andThen(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, "consumer is null");
        return this.andThenTry(consumer::accept);
    }

    default public Try<T> andThenTry(CheckedConsumer<? super T> consumer) {
        Objects.requireNonNull(consumer, "consumer is null");
        if (this.isFailure()) {
            return this;
        }
        try {
            consumer.accept(this.get());
            return this;
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    default public Try<T> andThen(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable is null");
        return this.andThenTry(runnable::run);
    }

    default public Try<T> andThenTry(CheckedRunnable runnable) {
        Objects.requireNonNull(runnable, "runnable is null");
        if (this.isFailure()) {
            return this;
        }
        try {
            runnable.run();
            return this;
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    default public Try<Throwable> failed() {
        if (this.isFailure()) {
            return new Success<Throwable>(this.getCause());
        }
        return new Failure<Throwable>(new NoSuchElementException("Success.failed()"));
    }

    default public Try<T> filter(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        return this.filterTry(predicate2::test);
    }

    default public Try<T> filterTry(CheckedPredicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        if (this.isFailure()) {
            return this;
        }
        try {
            if (predicate2.test(this.get())) {
                return this;
            }
            return new Failure(new NoSuchElementException("Predicate does not hold for " + this.get()));
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    default public <U> Try<U> flatMap(Function<? super T, ? extends Try<? extends U>> mapper2) {
        Objects.requireNonNull(mapper2, "mapper is null");
        return this.flatMapTry(mapper2::apply);
    }

    default public <U> Try<U> flatMapTry(CheckedFunction<? super T, ? extends Try<? extends U>> mapper2) {
        Objects.requireNonNull(mapper2, "mapper is null");
        if (this.isFailure()) {
            return (Failure)this;
        }
        try {
            return mapper2.apply(this.get());
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    @Override
    public T get();

    public Throwable getCause();

    @Override
    public boolean isEmpty();

    public boolean isFailure();

    @Override
    default public boolean isSingleValued() {
        return true;
    }

    public boolean isSuccess();

    @Override
    default public Iterator<T> iterator() {
        return this.isSuccess() ? Iterator.of(this.get()) : Iterator.empty();
    }

    @Override
    default public <U> Try<U> map(Function<? super T, ? extends U> mapper2) {
        Objects.requireNonNull(mapper2, "mapper is null");
        return this.mapTry(mapper2::apply);
    }

    default public <U> Try<U> mapTry(CheckedFunction<? super T, ? extends U> mapper2) {
        Objects.requireNonNull(mapper2, "mapper is null");
        if (this.isFailure()) {
            return (Failure)this;
        }
        try {
            return new Success(mapper2.apply(this.get()));
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    default public Try<T> onFailure(Consumer<? super Throwable> action2) {
        Objects.requireNonNull(action2, "action is null");
        if (this.isFailure()) {
            action2.accept(this.getCause());
        }
        return this;
    }

    default public Try<T> onSuccess(Consumer<? super T> action2) {
        Objects.requireNonNull(action2, "action is null");
        if (this.isSuccess()) {
            action2.accept(this.get());
        }
        return this;
    }

    default public Try<T> orElse(Try<? extends T> other2) {
        Objects.requireNonNull(other2, "other is null");
        return this.isSuccess() ? this : other2;
    }

    default public Try<T> orElse(Supplier<? extends Try<? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return this.isSuccess() ? this : supplier.get();
    }

    default public T getOrElseGet(Function<? super Throwable, ? extends T> other2) {
        Objects.requireNonNull(other2, "other is null");
        if (this.isFailure()) {
            return other2.apply(this.getCause());
        }
        return this.get();
    }

    default public void orElseRun(Consumer<? super Throwable> action2) {
        Objects.requireNonNull(action2, "action is null");
        if (this.isFailure()) {
            action2.accept(this.getCause());
        }
    }

    default public <X extends Throwable> T getOrElseThrow(Function<? super Throwable, X> exceptionProvider) throws X {
        Objects.requireNonNull(exceptionProvider, "exceptionProvider is null");
        if (this.isFailure()) {
            throw (Throwable)exceptionProvider.apply(this.getCause());
        }
        return this.get();
    }

    @Override
    default public Try<T> peek(Consumer<? super T> action2) {
        Objects.requireNonNull(action2, "action is null");
        if (this.isSuccess()) {
            action2.accept(this.get());
        }
        return this;
    }

    default public Try<T> recover(Function<? super Throwable, ? extends T> f2) {
        Objects.requireNonNull(f2, "f is null");
        if (this.isFailure()) {
            return Try.of(() -> f2.apply(this.getCause()));
        }
        return this;
    }

    default public Try<T> recoverWith(Function<? super Throwable, ? extends Try<? extends T>> f2) {
        Objects.requireNonNull(f2, "f is null");
        if (this.isFailure()) {
            try {
                return f2.apply(this.getCause());
            }
            catch (Throwable t) {
                return new Failure(t);
            }
        }
        return this;
    }

    default public Either<Throwable, T> toEither() {
        if (this.isFailure()) {
            return Either.left(this.getCause());
        }
        return Either.right(this.get());
    }

    default public <U> U transform(Function<? super Try<T>, ? extends U> f2) {
        Objects.requireNonNull(f2, "f is null");
        return f2.apply(this);
    }

    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    @Override
    public String toString();

    public static final class NonFatalException
    extends RuntimeException
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private NonFatalException(Throwable exception) {
            super(exception);
        }

        static NonFatalException of(Throwable exception) {
            boolean isFatal;
            Objects.requireNonNull(exception, "exception is null");
            if (exception instanceof NonFatalException) {
                return (NonFatalException)exception;
            }
            if (exception instanceof FatalException) {
                throw (FatalException)exception;
            }
            boolean bl = isFatal = exception instanceof InterruptedException || exception instanceof LinkageError || exception instanceof ThreadDeath || exception instanceof VirtualMachineError;
            if (isFatal) {
                throw new FatalException(exception);
            }
            return new NonFatalException(exception);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof NonFatalException && Arrays.deepEquals(this.getCause().getStackTrace(), ((NonFatalException)o).getCause().getStackTrace());
        }

        public int hashCode() {
            return Objects.hashCode(this.getCause());
        }

        @Override
        public String toString() {
            return "NonFatal(" + this.getCause() + ")";
        }
    }

    public static final class FatalException
    extends RuntimeException
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private FatalException(Throwable exception) {
            super(exception);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof FatalException && Arrays.deepEquals(this.getCause().getStackTrace(), ((FatalException)o).getCause().getStackTrace());
        }

        public int hashCode() {
            return Objects.hashCode(this.getCause());
        }

        @Override
        public String toString() {
            return "Fatal(" + this.getCause() + ")";
        }
    }

    public static final class Failure<T>
    implements Try<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final NonFatalException cause;

        private Failure(Throwable exception) {
            Objects.requireNonNull(exception, "exception is null");
            this.cause = NonFatalException.of(exception);
        }

        @Override
        public T get() throws NonFatalException {
            throw this.cause;
        }

        @Override
        public Throwable getCause() {
            return this.cause.getCause();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Failure && Objects.equals(this.cause, ((Failure)obj).cause);
        }

        @Override
        public String stringPrefix() {
            return "Failure";
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.cause.getCause());
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "(" + this.cause.getCause() + ")";
        }
    }

    public static final class Success<T>
    implements Try<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final T value;

        private Success(T value2) {
            this.value = value2;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Throwable getCause() {
            throw new UnsupportedOperationException("getCause on Success");
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Success && Objects.equals(this.value, ((Success)obj).value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String stringPrefix() {
            return "Success";
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "(" + this.value + ")";
        }
    }

    @FunctionalInterface
    public static interface CheckedSupplier<R> {
        public R get() throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedRunnable {
        public void run() throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedPredicate<T> {
        public boolean test(T var1) throws Throwable;

        default public CheckedPredicate<T> negate() {
            return t -> !this.test(t);
        }
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T> {
        public void accept(T var1) throws Throwable;
    }
}

