/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javaslang.Kind1;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.collection.Collections;
import javaslang.collection.HashMap;
import javaslang.collection.Iterator;
import javaslang.collection.LinkedHashMap;
import javaslang.collection.List;
import javaslang.collection.Map;
import javaslang.collection.Set;
import javaslang.control.Option;

public final class LinkedHashSet<T>
implements Kind1<LinkedHashSet<?>, T>,
Set<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final LinkedHashSet<?> EMPTY = new LinkedHashSet(LinkedHashMap.empty());
    private final LinkedHashMap<T, Object> map;

    private LinkedHashSet(LinkedHashMap<T, Object> map2) {
        this.map = map2;
    }

    public static <T> LinkedHashSet<T> empty() {
        return EMPTY;
    }

    static <T> LinkedHashSet<T> wrap(LinkedHashMap<T, Object> map2) {
        return new LinkedHashSet<T>(map2);
    }

    public static <T> Collector<T, ArrayList<T>, LinkedHashSet<T>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, LinkedHashSet> finisher = LinkedHashSet::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> LinkedHashSet<T> narrow(LinkedHashSet<? extends T> linkedHashSet) {
        return linkedHashSet;
    }

    public static <T> LinkedHashSet<T> of(T element3) {
        return LinkedHashSet.empty().add((Object)element3);
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> of(T ... elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        Map map2 = LinkedHashMap.empty();
        for (T element3 : elements2) {
            map2 = map2.put(element3, element3);
        }
        return map2.isEmpty() ? LinkedHashSet.empty() : new LinkedHashSet(map2);
    }

    public static <T> LinkedHashSet<T> tabulate(int n, Function<? super Integer, ? extends T> f2) {
        Objects.requireNonNull(f2, "f is null");
        return Collections.tabulate(n, f2, LinkedHashSet.empty(), LinkedHashSet::of);
    }

    public static <T> LinkedHashSet<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return Collections.fill(n, s, LinkedHashSet.empty(), LinkedHashSet::of);
    }

    public static <T> LinkedHashSet<T> ofAll(Iterable<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        if (elements2 instanceof LinkedHashSet) {
            return (LinkedHashSet)elements2;
        }
        LinkedHashMap<T, Object> mao = LinkedHashSet.addAll(LinkedHashMap.empty(), elements2);
        return mao.isEmpty() ? LinkedHashSet.empty() : new LinkedHashSet<T>(mao);
    }

    public static LinkedHashSet<Boolean> ofAll(boolean[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(array2));
    }

    public static LinkedHashSet<Byte> ofAll(byte[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(array2));
    }

    public static LinkedHashSet<Character> ofAll(char[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(array2));
    }

    public static LinkedHashSet<Double> ofAll(double[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(array2));
    }

    public static LinkedHashSet<Float> ofAll(float[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(array2));
    }

    public static LinkedHashSet<Integer> ofAll(int[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(array2));
    }

    public static LinkedHashSet<Long> ofAll(long[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(array2));
    }

    public static LinkedHashSet<Short> ofAll(short[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(array2));
    }

    public static LinkedHashSet<Integer> range(int from, int toExclusive) {
        return LinkedHashSet.ofAll(Iterator.range(from, toExclusive));
    }

    public static LinkedHashSet<Character> range(char from, char toExclusive) {
        return LinkedHashSet.ofAll(Iterator.range(from, toExclusive));
    }

    public static LinkedHashSet<Integer> rangeBy(int from, int toExclusive, int step2) {
        return LinkedHashSet.ofAll(Iterator.rangeBy(from, toExclusive, step2));
    }

    public static LinkedHashSet<Character> rangeBy(char from, char toExclusive, int step2) {
        return LinkedHashSet.ofAll(Iterator.rangeBy(from, toExclusive, step2));
    }

    public static LinkedHashSet<Double> rangeBy(double from, double toExclusive, double step2) {
        return LinkedHashSet.ofAll(Iterator.rangeBy(from, toExclusive, step2));
    }

    public static LinkedHashSet<Long> range(long from, long toExclusive) {
        return LinkedHashSet.ofAll(Iterator.range(from, toExclusive));
    }

    public static LinkedHashSet<Long> rangeBy(long from, long toExclusive, long step2) {
        return LinkedHashSet.ofAll(Iterator.rangeBy(from, toExclusive, step2));
    }

    public static LinkedHashSet<Integer> rangeClosed(int from, int toInclusive) {
        return LinkedHashSet.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static LinkedHashSet<Character> rangeClosed(char from, char toInclusive) {
        return LinkedHashSet.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static LinkedHashSet<Integer> rangeClosedBy(int from, int toInclusive, int step2) {
        return LinkedHashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step2));
    }

    public static LinkedHashSet<Character> rangeClosedBy(char from, char toInclusive, int step2) {
        return LinkedHashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step2));
    }

    public static LinkedHashSet<Double> rangeClosedBy(double from, double toInclusive, double step2) {
        return LinkedHashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step2));
    }

    public static LinkedHashSet<Long> rangeClosed(long from, long toInclusive) {
        return LinkedHashSet.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static LinkedHashSet<Long> rangeClosedBy(long from, long toInclusive, long step2) {
        return LinkedHashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step2));
    }

    @Override
    public LinkedHashSet<T> add(T element3) {
        return this.contains(element3) ? this : new LinkedHashSet<T>(this.map.put((Object)element3, (Object)element3));
    }

    @Override
    public LinkedHashSet<T> addAll(Iterable<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        LinkedHashMap<T, Object> that = LinkedHashSet.addAll(this.map, elements2);
        if (that.size() == this.map.size()) {
            return this;
        }
        return new LinkedHashSet<T>(that);
    }

    @Override
    public boolean contains(T element3) {
        return this.map.get(element3).isDefined();
    }

    @Override
    public LinkedHashSet<T> diff(Set<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        if (this.isEmpty() || elements2.isEmpty()) {
            return this;
        }
        return this.removeAll(elements2);
    }

    @Override
    public LinkedHashSet<T> distinct() {
        return this;
    }

    @Override
    public LinkedHashSet<T> distinctBy(Comparator<? super T> comparator2) {
        Objects.requireNonNull(comparator2, "comparator is null");
        return LinkedHashSet.ofAll(this.iterator().distinctBy(comparator2));
    }

    @Override
    public <U> LinkedHashSet<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        return LinkedHashSet.ofAll(this.iterator().distinctBy(keyExtractor));
    }

    @Override
    public LinkedHashSet<T> drop(long n) {
        if (n <= 0L) {
            return this;
        }
        return LinkedHashSet.ofAll(this.iterator().drop(n));
    }

    @Override
    public LinkedHashSet<T> dropRight(long n) {
        if (n <= 0L) {
            return this;
        }
        return LinkedHashSet.ofAll(this.iterator().dropRight(n));
    }

    @Override
    public LinkedHashSet<T> dropUntil(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        return this.dropWhile((Predicate)predicate2.negate());
    }

    @Override
    public LinkedHashSet<T> dropWhile(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        LinkedHashSet<T> dropped = LinkedHashSet.ofAll(this.iterator().dropWhile(predicate2));
        return dropped.length() == this.length() ? this : dropped;
    }

    @Override
    public LinkedHashSet<T> filter(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        LinkedHashSet<T> filtered = LinkedHashSet.ofAll(this.iterator().filter(predicate2));
        return filtered.length() == this.length() ? this : filtered;
    }

    @Override
    public <U> LinkedHashSet<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper2) {
        Objects.requireNonNull(mapper2, "mapper is null");
        if (this.isEmpty()) {
            return LinkedHashSet.empty();
        }
        LinkedHashMap that = this.foldLeft(LinkedHashMap.empty(), (tree2, t) -> LinkedHashSet.addAll(tree2, (Iterable)mapper2.apply(t)));
        return new LinkedHashSet<T>(that);
    }

    @Override
    public <U> U foldRight(U zero, BiFunction<? super T, ? super U, ? extends U> f2) {
        Objects.requireNonNull(f2, "f is null");
        return this.iterator().foldRight(zero, f2);
    }

    @Override
    public <C> Map<C, LinkedHashSet<T>> groupBy(Function<? super T, ? extends C> classifier) {
        return this.foldLeft(HashMap.empty(), (map2, t) -> {
            Object key = classifier.apply(t);
            LinkedHashSet<Object> values2 = map2.get(key).map((T ts) -> ts.add(t)).getOrElse(LinkedHashSet.of(t));
            return map2.put(key, values2);
        });
    }

    @Override
    public Iterator<LinkedHashSet<T>> grouped(long size) {
        return this.sliding(size, size);
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public T head() {
        if (this.map.isEmpty()) {
            throw new NoSuchElementException("head of empty set");
        }
        return (T)this.iterator().next();
    }

    @Override
    public Option<T> headOption() {
        return this.iterator().headOption();
    }

    @Override
    public LinkedHashSet<T> init() {
        if (this.map.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty set");
        }
        return new LinkedHashSet<T>(this.map.init());
    }

    @Override
    public Option<LinkedHashSet<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    public LinkedHashSet<T> intersect(Set<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        if (this.isEmpty() || elements2.isEmpty()) {
            return LinkedHashSet.empty();
        }
        return this.retainAll(elements2);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.iterator().map((T t) -> t._1);
    }

    @Override
    public int length() {
        return this.map.size();
    }

    @Override
    public <U> LinkedHashSet<U> map(Function<? super T, ? extends U> mapper2) {
        Objects.requireNonNull(mapper2, "mapper is null");
        if (this.isEmpty()) {
            return LinkedHashSet.empty();
        }
        LinkedHashMap that = this.foldLeft(LinkedHashMap.empty(), (tree2, t) -> {
            Object u = mapper2.apply(t);
            return tree2.put(u, u);
        });
        return new LinkedHashSet<T>(that);
    }

    @Override
    public String mkString(CharSequence prefix2, CharSequence delimiter, CharSequence suffix2) {
        return this.iterator().mkString(prefix2, delimiter, suffix2);
    }

    @Override
    public Tuple2<LinkedHashSet<T>, LinkedHashSet<T>> partition(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        Tuple2<Iterator<? super T>, Iterator<? super T>> p = this.iterator().partition(predicate2);
        return Tuple.of(LinkedHashSet.ofAll((Iterable)p._1), LinkedHashSet.ofAll((Iterable)p._2));
    }

    @Override
    public LinkedHashSet<T> peek(Consumer<? super T> action2) {
        Objects.requireNonNull(action2, "action is null");
        if (!this.isEmpty()) {
            action2.accept(this.iterator().head());
        }
        return this;
    }

    @Override
    public LinkedHashSet<T> remove(T element3) {
        Map newMap = this.map.remove((Object)element3);
        return newMap == this.map ? this : new LinkedHashSet<T>(newMap);
    }

    @Override
    public LinkedHashSet<T> removeAll(Iterable<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        Map<Object, Object> that = this.map;
        for (T element3 : elements2) {
            that = that.remove((Object)element3);
        }
        return that == this.map ? this : new LinkedHashSet<T>(that);
    }

    @Override
    public LinkedHashSet<T> replace(T currentElement, T newElement2) {
        if (!Objects.equals(currentElement, newElement2) && this.contains(currentElement)) {
            Tuple2<T, T> currentPair = Tuple.of(currentElement, currentElement);
            Tuple2<T, T> newPair = Tuple.of(newElement2, newElement2);
            Map newMap = this.map.replace(currentPair, newPair);
            return new LinkedHashSet<T>(newMap);
        }
        return this;
    }

    @Override
    public LinkedHashSet<T> replaceAll(T currentElement, T newElement2) {
        return this.replace((Object)currentElement, (Object)newElement2);
    }

    @Override
    public LinkedHashSet<T> retainAll(Iterable<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        LinkedHashMap<T, Object> kept = LinkedHashSet.addAll(LinkedHashMap.empty(), elements2);
        Map that = LinkedHashMap.empty();
        for (Object e : this) {
            if (!kept.containsKey(e)) continue;
            that = that.put(e, e);
        }
        return that.isEmpty() ? LinkedHashSet.empty() : (that.size() == this.size() ? this : new LinkedHashSet(that));
    }

    @Override
    public LinkedHashSet<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation2) {
        return this.scanLeft(zero, operation2);
    }

    @Override
    public <U> LinkedHashSet<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation2) {
        Objects.requireNonNull(operation2, "operation is null");
        return Collections.scanLeft(this, zero, operation2, new ArrayList(), (c, u) -> {
            c.add(u);
            return c;
        }, LinkedHashSet::ofAll);
    }

    @Override
    public <U> LinkedHashSet<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation2) {
        Objects.requireNonNull(operation2, "operation is null");
        return Collections.scanRight(this, zero, operation2, List.empty(), List::prepend, LinkedHashSet::ofAll);
    }

    @Override
    public Iterator<LinkedHashSet<T>> sliding(long size) {
        return this.sliding(size, 1L);
    }

    @Override
    public Iterator<LinkedHashSet<T>> sliding(long size, long step2) {
        return this.iterator().sliding(size, step2).map(LinkedHashSet::ofAll);
    }

    @Override
    public Tuple2<LinkedHashSet<T>, LinkedHashSet<T>> span(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        Tuple2<Iterator<? super T>, Iterator<? super T>> t = this.iterator().span(predicate2);
        return Tuple.of(LinkedHashSet.ofAll((Iterable)t._1), LinkedHashSet.ofAll((Iterable)t._2));
    }

    @Override
    public LinkedHashSet<T> tail() {
        if (this.map.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty set");
        }
        return this.remove((Object)this.head());
    }

    @Override
    public Option<LinkedHashSet<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    public LinkedHashSet<T> take(long n) {
        if ((long)this.map.size() <= n) {
            return this;
        }
        return LinkedHashSet.ofAll(() -> this.iterator().take(n));
    }

    @Override
    public LinkedHashSet<T> takeRight(long n) {
        if ((long)this.map.size() <= n) {
            return this;
        }
        return LinkedHashSet.ofAll(() -> this.iterator().takeRight(n));
    }

    @Override
    public LinkedHashSet<T> takeUntil(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        return this.takeWhile((Predicate)predicate2.negate());
    }

    @Override
    public LinkedHashSet<T> takeWhile(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        LinkedHashSet<T> taken = LinkedHashSet.ofAll(this.iterator().takeWhile(predicate2));
        return taken.length() == this.length() ? this : taken;
    }

    public <U> U transform(Function<? super LinkedHashSet<T>, ? extends U> f2) {
        Objects.requireNonNull(f2, "f is null");
        return f2.apply(this);
    }

    @Override
    public java.util.LinkedHashSet<T> toJavaSet() {
        return this.toJavaSet(java.util.LinkedHashSet::new);
    }

    @Override
    public LinkedHashSet<T> union(Set<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        if (this.isEmpty()) {
            if (elements2 instanceof LinkedHashSet) {
                return (LinkedHashSet)elements2;
            }
            return LinkedHashSet.ofAll(elements2);
        }
        if (elements2.isEmpty()) {
            return this;
        }
        LinkedHashMap<T, Object> that = LinkedHashSet.addAll(this.map, elements2);
        if (that.size() == this.map.size()) {
            return this;
        }
        return new LinkedHashSet<T>(that);
    }

    @Override
    public <T1, T2> Tuple2<LinkedHashSet<T1>, LinkedHashSet<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        Tuple2<Iterator<? extends T1>, Iterator<? extends T2>> t = this.iterator().unzip(unzipper);
        return Tuple.of(LinkedHashSet.ofAll((Iterable)t._1), LinkedHashSet.ofAll((Iterable)t._2));
    }

    @Override
    public <T1, T2, T3> Tuple3<LinkedHashSet<T1>, LinkedHashSet<T2>, LinkedHashSet<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        Tuple3<Iterator<? extends T1>, Iterator<? extends T2>, Iterator<? extends T3>> t = this.iterator().unzip3(unzipper);
        return Tuple.of(LinkedHashSet.ofAll((Iterable)t._1), LinkedHashSet.ofAll((Iterable)t._2), LinkedHashSet.ofAll((Iterable)t._3));
    }

    @Override
    public <U> LinkedHashSet<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        return LinkedHashSet.ofAll(this.iterator().zip(that));
    }

    @Override
    public <U> LinkedHashSet<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        return LinkedHashSet.ofAll(this.iterator().zipAll(that, thisElem, thatElem));
    }

    @Override
    public LinkedHashSet<Tuple2<T, Long>> zipWithIndex() {
        return LinkedHashSet.ofAll(this.iterator().zipWithIndex());
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LinkedHashSet) {
            LinkedHashSet that = (LinkedHashSet)o;
            return this.map.equals(that.map);
        }
        return false;
    }

    @Override
    public String stringPrefix() {
        return "LinkedHashSet";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private static <T> LinkedHashMap<T, Object> addAll(LinkedHashMap<T, Object> initial, Iterable<? extends T> additional) {
        Map<Object, Object> that = initial;
        for (T t : additional) {
            that = that.put((Object)t, (Object)t);
        }
        return that;
    }

    private Object writeReplace() {
        return new SerializationProxy<T>(this.map);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static final class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient LinkedHashMap<T, Object> map;

        SerializationProxy(LinkedHashMap<T, Object> map2) {
            this.map = map2;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(this.map.size());
            for (Tuple2 tuple2 : this.map) {
                s.writeObject(tuple2._1);
            }
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            int size = s.readInt();
            if (size < 0) {
                throw new InvalidObjectException("No elements");
            }
            Map temp = LinkedHashMap.empty();
            for (int i2 = 0; i2 < size; ++i2) {
                Object element3 = s.readObject();
                temp = temp.put(element3, element3);
            }
            this.map = temp;
        }

        private Object readResolve() {
            return this.map.isEmpty() ? LinkedHashSet.empty() : new LinkedHashSet(this.map);
        }
    }
}

