/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.ide.GeneratedSourceFileChangeTrackerImpl;
import com.intellij.ide.impl.HeadlessDataManager;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.ide.structureView.StructureViewFactory;
import com.intellij.ide.structureView.impl.StructureViewFactoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.common.DumpKt;
import com.intellij.testFramework.common.RunAllKt;
import com.intellij.testFramework.common.TestApplicationKt;
import com.intellij.testFramework.common.TestEnvironmentKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModuleRootComponentBridge;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u001a\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/testFramework/TestApplicationManager;", "", "()V", "dispose", "", "getData", "dataId", "", "setDataProvider", "provider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "intellij.platform.testFramework"})
public final class TestApplicationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final TestApplicationManager ourInstance;
    private static int testCounter;

    private TestApplicationManager() {
    }

    public final void setDataProvider(@Nullable DataProvider provider) {
        TestApplicationManager.Companion.getDataManager().setTestDataProvider(provider);
    }

    public final void setDataProvider(@Nullable DataProvider provider, @Nullable Disposable parentDisposable) {
        HeadlessDataManager headlessDataManager = TestApplicationManager.Companion.getDataManager();
        Disposable disposable = parentDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        headlessDataManager.setTestDataProvider(provider, disposable);
    }

    @Nullable
    public final Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return TestApplicationManager.Companion.getDataManager().getDataContext().getData(dataId);
    }

    public final void dispose() {
        TestApplicationKt.disposeTestApplication();
    }

    @JvmStatic
    @NotNull
    public static final TestApplicationManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @Nullable
    public static final TestApplicationManager getInstanceIfCreated() {
        return Companion.getInstanceIfCreated();
    }

    @JvmStatic
    @ApiStatus.Internal
    @TestOnly
    public static final void tearDownProjectAndApp(@NotNull Project project2) {
        Companion.tearDownProjectAndApp(project2);
    }

    @JvmStatic
    public static final void testProjectLeak() {
        Companion.testProjectLeak();
    }

    @JvmStatic
    public static final void disposeApplicationAndCheckForLeaks() {
        Companion.disposeApplicationAndCheckForLeaks();
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final void waitForProjectLeakingThreads(@NotNull Project project2) {
        Companion.waitForProjectLeakingThreads(project2);
    }

    @Deprecated(message="moved to dump.kt", replaceWith=@ReplaceWith(expression="com.intellij.testFramework.common.publishHeapDump(fileNamePrefix)", imports={}))
    @JvmStatic
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final String publishHeapDump(@NotNull String fileNamePrefix) {
        return Companion.publishHeapDump(fileNamePrefix);
    }

    public static final /* synthetic */ int access$getTestCounter$cp() {
        return testCounter;
    }

    public static final /* synthetic */ void access$setTestCounter$cp(int n) {
        testCounter = n;
    }

    static {
        TestEnvironmentKt.initializeTestEnvironment();
        ourInstance = new TestApplicationManager();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0007J\n\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0016\u001a\u00020\fH\u0007J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J,\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\n\b\u0000\u0010\u001a\u0018\u0001*\u00020\u0001\"\n\b\u0001\u0010\u0019\u0018\u0001*\u00020\u0001*\u00020\u001bH\u0082\b\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/testFramework/TestApplicationManager$Companion;", "", "()V", "dataManager", "Lcom/intellij/ide/impl/HeadlessDataManager;", "getDataManager", "()Lcom/intellij/ide/impl/HeadlessDataManager;", "ourInstance", "Lcom/intellij/testFramework/TestApplicationManager;", "testCounter", "", "disposeApplicationAndCheckForLeaks", "", "dropModuleRootCaches", "project", "Lcom/intellij/openapi/project/Project;", "getInstance", "getInstanceIfCreated", "publishHeapDump", "", "fileNamePrefix", "tearDownProjectAndApp", "testProjectLeak", "waitForProjectLeakingThreads", "serviceIfCreated", "TI", "T", "Lcom/intellij/openapi/application/Application;", "(Lcom/intellij/openapi/application/Application;)Ljava/lang/Object;", "intellij.platform.testFramework"})
    @SourceDebugExtension(value={"SMAP\nTestApplicationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestApplicationManager.kt\ncom/intellij/testFramework/TestApplicationManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,253:1\n59#2:254\n*S KotlinDebug\n*F\n+ 1 TestApplicationManager.kt\ncom/intellij/testFramework/TestApplicationManager$Companion\n*L\n224#1:254\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final HeadlessDataManager getDataManager() {
            DataManager dataManager = DataManager.getInstance();
            Intrinsics.checkNotNull((Object)dataManager, (String)"null cannot be cast to non-null type com.intellij.ide.impl.HeadlessDataManager");
            return (HeadlessDataManager)dataManager;
        }

        @JvmStatic
        @NotNull
        public final TestApplicationManager getInstance() {
            Object object = TestApplicationKt.initTestApplication();
            ResultKt.throwOnFailure((Object)object);
            return ourInstance;
        }

        @JvmStatic
        @Nullable
        public final TestApplicationManager getInstanceIfCreated() {
            if (TestApplicationKt.isApplicationInitialized()) {
                return ourInstance;
            }
            return null;
        }

        @JvmStatic
        @ApiStatus.Internal
        @TestOnly
        public final void tearDownProjectAndApp(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (project2.isDisposed()) {
                return;
            }
            boolean isLightProject = ProjectManagerImpl.Companion.isLight(project2);
            Application app = ApplicationManager.getApplication();
            Function0[] function0Array = new Function0[]{new Function0<Unit>(isLightProject, project2){
                final /* synthetic */ boolean $isLightProject;
                final /* synthetic */ Project $project;
                {
                    this.$isLightProject = $isLightProject;
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    block1: {
                        if (!this.$isLightProject) break block1;
                        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.$project;
                        boolean $i$f$serviceIfCreated = false;
                        AutoPopupController autoPopupController = (AutoPopupController)$this$serviceIfCreated$iv.getServiceIfCreated(AutoPopupController.class);
                        if (autoPopupController != null) {
                            autoPopupController.cancelAllRequests();
                        }
                    }
                }
            }, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    CodeStyle.dropTemporarySettings((Project)this.$project);
                }
            }, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    UsefulTestCase.doPostponedFormatting(this.$project);
                }
            }, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    LookupManager.hideActiveLookup((Project)this.$project);
                }
            }, new Function0<Unit>(isLightProject, project2){
                final /* synthetic */ boolean $isLightProject;
                final /* synthetic */ Project $project;
                {
                    this.$isLightProject = $isLightProject;
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    block1: {
                        if (!this.$isLightProject) break block1;
                        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.$project;
                        boolean $i$f$serviceIfCreated = false;
                        StartupManagerImpl startupManagerImpl = (StartupManagerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(StartupManager.class);
                        if (startupManagerImpl != null) {
                            startupManagerImpl.prepareForNextTest();
                        }
                    }
                }
            }, new Function0<Unit>(isLightProject, project2){
                final /* synthetic */ boolean $isLightProject;
                final /* synthetic */ Project $project;
                {
                    this.$isLightProject = $isLightProject;
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    if (this.$isLightProject) {
                        LightPlatformTestCase.tearDownSourceRoot(this.$project);
                    }
                }
            }, new Function0<Unit>(project2, app){
                final /* synthetic */ Project $project;
                final /* synthetic */ Application $app;
                {
                    this.$project = $project;
                    this.$app = $app;
                    super(0);
                }

                public final void invoke() {
                    WriteCommandAction.runWriteCommandAction((Project)this.$project, () -> tearDownProjectAndApp.7.invoke$lambda$0(this.$app));
                }

                private static final void invoke$lambda$0(Application $app) {
                    block1: {
                        Companion companion = TestApplicationManager.Companion;
                        Intrinsics.checkNotNull((Object)$app);
                        Application $this$serviceIfCreated$iv = $app;
                        boolean $i$f$serviceIfCreated = false;
                        Object object = $this$serviceIfCreated$iv.getServiceIfCreated(FileDocumentManager.class);
                        if (!(object instanceof FileDocumentManagerImpl)) {
                            object = null;
                        }
                        FileDocumentManagerImpl fileDocumentManagerImpl = (FileDocumentManagerImpl)object;
                        if (fileDocumentManagerImpl == null) break block1;
                        fileDocumentManagerImpl.dropAllUnsavedDocuments();
                    }
                }
            }, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.$project;
                        boolean $i$f$serviceIfCreated = false;
                        EditorHistoryManager editorHistoryManager = (EditorHistoryManager)$this$serviceIfCreated$iv.getServiceIfCreated(EditorHistoryManager.class);
                        if (editorHistoryManager == null) break block0;
                        editorHistoryManager.removeAllFiles();
                    }
                }
            }, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.$project;
                    boolean $i$f$serviceIfCreated = false;
                    PsiManager psiManager = (PsiManager)$this$serviceIfCreated$iv.getServiceIfCreated(PsiManager.class);
                    boolean bl = psiManager != null ? psiManager.isDisposed() : false;
                    if (bl) {
                        throw new IllegalStateException("PsiManager must be not disposed");
                    }
                }
            }, tearDownProjectAndApp.10.INSTANCE, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    LightPlatformTestCase.clearUncommittedDocuments(this.$project);
                }
            }, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    UndoManager undoManager = UndoManager.getInstance((Project)this.$project);
                    Intrinsics.checkNotNull((Object)undoManager, (String)"null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
                    ((UndoManagerImpl)undoManager).dropHistoryInTests();
                }
            }, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.$project;
                        boolean $i$f$serviceIfCreated = false;
                        TemplateDataLanguageMappings templateDataLanguageMappings = (TemplateDataLanguageMappings)$this$serviceIfCreated$iv.getServiceIfCreated(TemplateDataLanguageMappings.class);
                        if (templateDataLanguageMappings == null) break block0;
                        templateDataLanguageMappings.cleanupForNextTest();
                    }
                }
            }, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.$project;
                        boolean $i$f$serviceIfCreated = false;
                        PsiManagerImpl psiManagerImpl = (PsiManagerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(PsiManager.class);
                        if (psiManagerImpl == null) break block0;
                        psiManagerImpl.cleanupForNextTest();
                    }
                }
            }, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.$project;
                        boolean $i$f$serviceIfCreated = false;
                        StructureViewFactoryImpl structureViewFactoryImpl = (StructureViewFactoryImpl)$this$serviceIfCreated$iv.getServiceIfCreated(StructureViewFactory.class);
                        if (structureViewFactoryImpl == null) break block0;
                        structureViewFactoryImpl.cleanupForNextTest();
                    }
                }
            }, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    TestApplicationManager.Companion.waitForProjectLeakingThreads(this.$project);
                }
            }, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    com.intellij.testFramework.TestApplicationManager$Companion.access$dropModuleRootCaches(TestApplicationManager.Companion, this.$project);
                }
            }, tearDownProjectAndApp.18.INSTANCE, new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    ProjectManagerEx.Companion.getInstanceEx().forceCloseProject(this.$project);
                }
            }, tearDownProjectAndApp.20.INSTANCE, new Function0<Unit>(app){
                final /* synthetic */ Application $app;
                {
                    this.$app = $app;
                    super(0);
                }

                public final void invoke() {
                    Application application = this.$app;
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"$app");
                    Throwable throwable = TestApplicationKt.cleanApplicationStateCatching(application);
                    if (throwable != null) {
                        Throwable it = throwable;
                        boolean bl = false;
                        throw it;
                    }
                }
            }};
            RunAllKt.runAll(function0Array);
        }

        private final /* synthetic */ <T, TI> TI serviceIfCreated(Application $this$serviceIfCreated) {
            boolean $i$f$serviceIfCreated = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Object object = $this$serviceIfCreated.getServiceIfCreated(Object.class);
            Intrinsics.reifiedOperationMarker((int)2, (String)"TI");
            return (TI)object;
        }

        private final void dropModuleRootCaches(Project project2) {
            WriteAction.runAndWait(() -> Companion.dropModuleRootCaches$lambda$0(project2));
        }

        @JvmStatic
        public final void testProjectLeak() {
            if (Boolean.getBoolean("idea.test.guimode")) {
                Application application = ApplicationManager.getApplication();
                application.invokeAndWait(() -> Companion.testProjectLeak$lambda$1(application));
                ShutDownTracker.getInstance().waitFor(100L, TimeUnit.SECONDS);
                return;
            }
            this.disposeApplicationAndCheckForLeaks();
        }

        @JvmStatic
        public final void disposeApplicationAndCheckForLeaks() {
            Throwable edtThrowable2 = (Throwable)EdtTestUtilKt.runInEdtAndGet(disposeApplicationAndCheckForLeaks.edtThrowable.1.INSTANCE);
            Object[] objectArray = new Throwable[2];
            objectArray[0] = edtThrowable2;
            Function0[] function0Array = new Function0[]{disposeApplicationAndCheckForLeaks.1.INSTANCE};
            objectArray[1] = RunAllKt.runAllCatching(function0Array);
            RunAllKt.reduceAndThrow(CollectionsKt.listOfNotNull((Object[])objectArray));
        }

        @JvmStatic
        @ApiStatus.Internal
        public final void waitForProjectLeakingThreads(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (project2 instanceof ComponentManagerImpl) {
                ((ComponentManagerImpl)project2).stopServicePreloading();
            }
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project2;
            boolean $i$f$serviceIfCreated = false;
            GeneratedSourceFileChangeTrackerImpl generatedSourceFileChangeTrackerImpl = (GeneratedSourceFileChangeTrackerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(GeneratedSourceFileChangeTracker.class);
            if (generatedSourceFileChangeTrackerImpl != null) {
                generatedSourceFileChangeTrackerImpl.cancelAllAndWait(10L, TimeUnit.SECONDS);
            }
        }

        @Deprecated(message="moved to dump.kt", replaceWith=@ReplaceWith(expression="com.intellij.testFramework.common.publishHeapDump(fileNamePrefix)", imports={}))
        @JvmStatic
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final String publishHeapDump(@NotNull String fileNamePrefix) {
            Intrinsics.checkNotNullParameter((Object)fileNamePrefix, (String)"fileNamePrefix");
            return DumpKt.publishHeapDump(fileNamePrefix);
        }

        private static final void dropModuleRootCaches$lambda$0(Project $project) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            for (Module module2 : ModuleManager.Companion.getInstance($project).getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                Intrinsics.checkNotNull((Object)moduleRootManager, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModuleRootComponentBridge");
                ((ModuleRootComponentBridge)moduleRootManager).dropCaches();
            }
        }

        private static final void testProjectLeak$lambda$1(Application $application) {
            UIUtil.dispatchAllInvocationEvents();
            $application.exit(true, true, false);
        }

        public static final /* synthetic */ void access$dropModuleRootCaches(Companion $this, Project project2) {
            $this.dropModuleRootCaches(project2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

