/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public final class LiveTemplateTestUtil {
    public static void doTestTemplateExpandingAvailability(@NotNull CodeInsightTestFixture codeInsightTestFixture, @NotNull String templateKey, @NotNull String templateGroup, @NotNull String answerFilePath) {
        if (codeInsightTestFixture == null) {
            LiveTemplateTestUtil.$$$reportNull$$$0(0);
        }
        if (templateKey == null) {
            LiveTemplateTestUtil.$$$reportNull$$$0(1);
        }
        if (templateGroup == null) {
            LiveTemplateTestUtil.$$$reportNull$$$0(2);
        }
        if (answerFilePath == null) {
            LiveTemplateTestUtil.$$$reportNull$$$0(3);
        }
        TemplateImpl template = TemplateSettings.getInstance().getTemplate(templateKey, templateGroup);
        TestCase.assertNotNull((String)("Unable to find template: " + templateKey + "@" + templateGroup), (Object)template);
        Editor editor = codeInsightTestFixture.getEditor();
        Document document = editor.getDocument();
        CharSequence documentCharsSequence = document.getCharsSequence();
        CaretModel caretModel = editor.getCaretModel();
        PsiFile psiFile = codeInsightTestFixture.getFile();
        boolean isAvailable = false;
        ArrayList<Pair> markers = new ArrayList<Pair>();
        for (int offset = 0; offset < documentCharsSequence.length(); ++offset) {
            caretModel.moveToOffset(offset);
            TemplateActionContext templateActionContext = TemplateActionContext.expanding((PsiFile)psiFile, (Editor)editor);
            if (TemplateManagerImpl.isApplicable((TemplateImpl)template, (TemplateActionContext)templateActionContext)) {
                if (isAvailable) continue;
                isAvailable = true;
                markers.add(Pair.create((Object)offset, (Object)"<available>"));
                continue;
            }
            if (!isAvailable) continue;
            markers.add(Pair.create((Object)(offset - 1), (Object)"</available>"));
            isAvailable = false;
        }
        if (isAvailable) {
            markers.add(Pair.create((Object)documentCharsSequence.length(), (Object)"</available>"));
        }
        StringBuilder result2 = new StringBuilder(documentCharsSequence);
        ContainerUtil.reverse(markers).forEach(it -> result2.insert((int)((Integer)it.first), (String)it.second));
        UsefulTestCase.assertSameLinesWithFile(answerFilePath, result2.toString());
    }

    public static void doTestTemplateSurroundingAvailability(@NotNull CodeInsightTestFixture fixture, @NotNull String templateKey, @NotNull String templateGroup, @NotNull String answerFilePath) {
        if (fixture == null) {
            LiveTemplateTestUtil.$$$reportNull$$$0(4);
        }
        if (templateKey == null) {
            LiveTemplateTestUtil.$$$reportNull$$$0(5);
        }
        if (templateGroup == null) {
            LiveTemplateTestUtil.$$$reportNull$$$0(6);
        }
        if (answerFilePath == null) {
            LiveTemplateTestUtil.$$$reportNull$$$0(7);
        }
        TemplateImpl template = TemplateSettings.getInstance().getTemplate(templateKey, templateGroup);
        String templateId = templateKey + "@" + templateGroup;
        TestCase.assertNotNull((String)("Unable to find template: " + templateId), (Object)template);
        TestCase.assertTrue((String)(templateId + " is not a selection template"), (boolean)template.isSelectionTemplate());
        Editor editor = fixture.getEditor();
        SelectionModel selectionModel = editor.getSelectionModel();
        Document document = editor.getDocument();
        CharSequence documentCharsSequence = document.getCharsSequence();
        CaretModel caretModel = editor.getCaretModel();
        int caretOffset = caretModel.getOffset();
        PsiFile psiFile = fixture.getFile();
        boolean isAvailable = false;
        ArrayList<Pair> markers = new ArrayList<Pair>();
        for (int offset = 0; offset < documentCharsSequence.length(); ++offset) {
            TemplateActionContext templateActionContext;
            selectionModel.setSelection(Math.min(offset, caretOffset), Math.max(offset, caretOffset));
            if (caretOffset == offset) {
                markers.add(Pair.create((Object)offset, (Object)"<caret>"));
            }
            if (TemplateManagerImpl.isApplicable((TemplateImpl)template, (TemplateActionContext)(templateActionContext = TemplateActionContext.surrounding((PsiFile)psiFile, (Editor)editor)))) {
                if (isAvailable) continue;
                isAvailable = true;
                markers.add(Pair.create((Object)offset, (Object)"<available>"));
                continue;
            }
            if (!isAvailable) continue;
            markers.add(Pair.create((Object)(offset - 1), (Object)"</available>"));
            isAvailable = false;
        }
        if (isAvailable) {
            markers.add(Pair.create((Object)documentCharsSequence.length(), (Object)"</available>"));
        }
        StringBuilder result2 = new StringBuilder(documentCharsSequence);
        ContainerUtil.reverse(markers).forEach(it -> result2.insert((int)((Integer)it.first), (String)it.second));
        UsefulTestCase.assertSameLinesWithFile(answerFilePath, result2.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeInsightTestFixture";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateKey";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateGroup";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answerFilePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/LiveTemplateTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doTestTemplateExpandingAvailability";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doTestTemplateSurroundingAvailability";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

