/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerTestCase;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.sun.jdi.Value;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class DescriptorTestCase
extends DebuggerTestCase {
    private final Map<NodeDescriptorImpl, NodeDescriptorText> myDescriptorLog = new LinkedHashMap<NodeDescriptorImpl, NodeDescriptorText>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.atDebuggerTearDown((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> this.flushDescriptors()));
    }

    protected NodeRenderer getToStringRenderer() {
        return NodeRendererSettings.getInstance().getToStringRenderer();
    }

    protected NodeRenderer getMapRenderer() {
        return DescriptorTestCase.getAlternateCollectionRenderer("Map");
    }

    private static NodeRenderer getAlternateCollectionRenderer(String name) {
        NodeRenderer[] renderers;
        for (NodeRenderer renderer : renderers = NodeRendererSettings.getInstance().getAlternateCollectionRenderers()) {
            if (!name.equals(renderer.getName())) continue;
            return renderer;
        }
        return null;
    }

    protected NodeRenderer getMapEntryRenderer() {
        return DescriptorTestCase.getAlternateCollectionRenderer("Map.Entry");
    }

    protected NodeRenderer getHexRenderer() {
        return NodeRendererSettings.getInstance().getHexRenderer();
    }

    protected NodeRenderer getCollectionRenderer() {
        return DescriptorTestCase.getAlternateCollectionRenderer("Collection");
    }

    @Override
    protected void resume(SuspendContextImpl suspendContext) {
        final DebugProcessImpl localProcess = suspendContext.getDebugProcess();
        this.invokeRatherLater((DebuggerCommandImpl)new SuspendContextCommandImpl(suspendContext){

            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                DescriptorTestCase.this.flushDescriptors();
                localProcess.getManagerThread().schedule((DebuggerCommandImpl)localProcess.createResumeCommand(suspendContext, PrioritizedTask.Priority.LOW));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DescriptorTestCase$1", "contextAction"));
            }
        });
    }

    protected void logDescriptor(NodeDescriptorImpl descriptor, String text) {
        this.myDescriptorLog.computeIfAbsent(descriptor, k -> new NodeDescriptorText()).appendText(text);
    }

    protected void logDescriptorLabel(NodeDescriptorImpl descriptor, String label) {
        this.myDescriptorLog.computeIfAbsent((NodeDescriptorImpl)descriptor, (Function<NodeDescriptorImpl, NodeDescriptorText>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$logDescriptorLabel$2(com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl ), (Lcom/intellij/debugger/ui/impl/watch/NodeDescriptorImpl;)Lcom/intellij/debugger/impl/DescriptorTestCase$NodeDescriptorText;)((DescriptorTestCase)this)).myLabel = label;
    }

    protected void flushDescriptors() {
        this.myDescriptorLog.forEach((descriptor, text) -> text.print());
        this.myDescriptorLog.clear();
    }

    private static boolean expandOne(Tree tree) {
        boolean anyExpanded = false;
        for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
            TreeNode treeNode = (TreeNode)tree.getPathForRow(i2).getLastPathComponent();
            if (!tree.isCollapsed(i2) || treeNode.isLeaf()) continue;
            anyExpanded = true;
            tree.expandRow(i2);
            break;
        }
        return anyExpanded;
    }

    protected static void expandAll(Tree tree, Runnable wait) {
        boolean cont = true;
        while (cont) {
            cont = (Boolean)UIUtil.invokeAndWaitIfNeeded(() -> DescriptorTestCase.expandOne(tree));
            wait.run();
        }
    }

    protected void expandAll(DebuggerTree tree, Runnable runnable2) {
        this.expandAll(tree, runnable2, new HashSet(), null);
    }

    protected void expandAll(DebuggerTree tree, Runnable runnable2, Set<? super Value> alreadyExpanded, NodeFilter filter) {
        this.expandAll((Tree)tree, runnable2, alreadyExpanded, filter, tree.getDebuggerContext().getSuspendContext());
    }

    protected void expandAll(Tree tree, Runnable runnable2, Set<? super Value> alreadyExpanded, NodeFilter filter, SuspendContextImpl context2) {
        this.invokeRatherLater(context2, () -> {
            boolean anyCollapsed = false;
            for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
                boolean shouldExpand;
                TreeNode treeNode = (TreeNode)tree.getPathForRow(i2).getLastPathComponent();
                if (!tree.isCollapsed(i2) || treeNode.isLeaf()) continue;
                NodeDescriptorImpl nodeDescriptor = null;
                if (treeNode instanceof DebuggerTreeNodeImpl) {
                    nodeDescriptor = ((DebuggerTreeNodeImpl)treeNode).getDescriptor();
                }
                boolean bl = shouldExpand = filter == null || filter.shouldExpand(treeNode);
                if (shouldExpand && nodeDescriptor instanceof ValueDescriptor) {
                    Value value2 = ((ValueDescriptor)nodeDescriptor).getValue();
                    boolean bl2 = shouldExpand = !alreadyExpanded.contains(value2);
                    if (shouldExpand) {
                        alreadyExpanded.add(value2);
                    }
                }
                if (!shouldExpand) continue;
                anyCollapsed = true;
                tree.expandRow(i2);
            }
            if (anyCollapsed) {
                this.expandAll(tree, runnable2, alreadyExpanded, filter, context2);
            } else {
                runnable2.run();
            }
        });
    }

    private /* synthetic */ NodeDescriptorText lambda$logDescriptorLabel$2(NodeDescriptorImpl k) {
        return new NodeDescriptorText();
    }

    private class NodeDescriptorText {
        final List<String> myText = new SmartList();
        String myLabel;

        private NodeDescriptorText() {
        }

        void appendText(String text) {
            if (!text.equals(ContainerUtil.getLastItem(this.myText))) {
                this.myText.add(text);
            }
        }

        void print() {
            for (String text : this.myText) {
                DescriptorTestCase.this.print(text, ProcessOutputTypes.SYSTEM);
            }
            if (StringUtil.isNotEmpty((String)this.myLabel)) {
                DescriptorTestCase.this.print(this.myLabel, ProcessOutputTypes.SYSTEM);
            }
        }
    }

    protected static interface NodeFilter {
        public boolean shouldExpand(TreeNode var1);
    }
}

