/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.ClassFinder;
import com.intellij.GroupBasedTestClassFilter;
import com.intellij.NameListTestClassFilter;
import com.intellij.PatternListTestClassFilter;
import com.intellij.TestAll;
import com.intellij.TestClassesFilter;
import com.intellij.idea.ExcludeFromTestDiscovery;
import com.intellij.idea.HardwareAgentRequired;
import com.intellij.idea.IJIgnore;
import com.intellij.idea.IgnoreJUnit3;
import com.intellij.nastradamus.NastradamusClient;
import com.intellij.nastradamus.model.TestResultRequestEntity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.RunFirst;
import com.intellij.testFramework.SelfSeedingTestCase;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestSorter;
import com.intellij.testFramework.bucketing.BucketingScheme;
import com.intellij.testFramework.bucketing.CyclicCounterBucketingScheme;
import com.intellij.testFramework.bucketing.HashingBucketingScheme;
import com.intellij.testFramework.bucketing.NastradamusBucketingScheme;
import com.intellij.testFramework.bucketing.NastradamusDataCollectingBucketingScheme;
import com.intellij.testFramework.bucketing.TestsDurationBucketingScheme;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCaseLoader {
    public static final String PERFORMANCE_TESTS_ONLY_FLAG = "idea.performance.tests";
    public static final String INCLUDE_PERFORMANCE_TESTS_FLAG = "idea.include.performance.tests";
    public static final String INCLUDE_UNCONVENTIONALLY_NAMED_TESTS_FLAG = "idea.include.unconventionally.named.tests";
    public static final String RUN_ONLY_AFFECTED_TEST_FLAG = "idea.run.only.affected.tests";
    public static final String TEST_RUNNERS_COUNT_FLAG = "idea.test.runners.count";
    public static final String TEST_RUNNER_INDEX_FLAG = "idea.test.runner.index";
    public static final String HARDWARE_AGENT_REQUIRED_FLAG = "idea.hardware.agent.required";
    public static final String VERBOSE_LOG_ENABLED_FLAG = "idea.test.log.verbose";
    public static final String FAIR_BUCKETING_FLAG = "idea.fair.bucketing";
    public static final String IS_TESTS_DURATION_BUCKETING_ENABLED_FLAG = "idea.tests.duration.bucketing.enabled";
    public static final String NASTRADAMUS_TEST_DISTRIBUTOR_ENABLED_FLAG = "idea.enable.nastradamus.test.distributor";
    public static final String NASTRADAMUS_SHADOW_DATA_COLLECTION_ENABLED_FLAG = "idea.nastradamus.shadow.data.collection.enabled";
    private static final boolean PERFORMANCE_TESTS_ONLY = Boolean.getBoolean("idea.performance.tests");
    private static final boolean INCLUDE_PERFORMANCE_TESTS = Boolean.getBoolean("idea.include.performance.tests");
    private static final boolean INCLUDE_UNCONVENTIONALLY_NAMED_TESTS = Boolean.getBoolean("idea.include.unconventionally.named.tests");
    private static final boolean RUN_ONLY_AFFECTED_TESTS = Boolean.getBoolean("idea.run.only.affected.tests");
    private static final boolean RUN_WITH_TEST_DISCOVERY = System.getProperty("test.discovery.listener") != null;
    private static final boolean HARDWARE_AGENT_REQUIRED = Boolean.getBoolean("idea.hardware.agent.required");
    public static final boolean IS_VERBOSE_LOG_ENABLED = Boolean.getBoolean("idea.test.log.verbose");
    public static final int TEST_RUNNERS_COUNT = Integer.parseInt(System.getProperty("idea.test.runners.count", "1"));
    public static final int TEST_RUNNER_INDEX = Integer.parseInt(System.getProperty("idea.test.runner.index", "0"));
    private static final boolean IS_FAIR_BUCKETING = Boolean.getBoolean("idea.fair.bucketing");
    public static final boolean IS_TESTS_DURATION_BUCKETING_ENABLED = Boolean.getBoolean("idea.tests.duration.bucketing.enabled");
    public static final boolean IS_NASTRADAMUS_TEST_DISTRIBUTOR_ENABLED = Boolean.getBoolean("idea.enable.nastradamus.test.distributor");
    public static final boolean IS_NASTRADAMUS_SHADOW_DATA_COLLECTION_ENABLED = Boolean.getBoolean("idea.nastradamus.shadow.data.collection.enabled");
    private static final String ALL_TESTS_GROUP = "ALL";
    private static final boolean REVERSE_ORDER = SystemProperties.getBooleanProperty((String)"intellij.build.test.reverse.order", (boolean)false);
    private static final String PLATFORM_LITE_FIXTURE_NAME = "com.intellij.testFramework.PlatformLiteFixture";
    public static final String COMMON_TEST_GROUPS_RESOURCE_NAME = "tests/testGroups.properties";
    private final HashSet<Class<?>> myClassSet = new HashSet();
    private final List<Throwable> myClassLoadingErrors = new ArrayList<Throwable>();
    private Class<?> myFirstTestClass;
    private Class<?> myLastTestClass;
    private final TestClassesFilter myTestClassesFilter;
    private final boolean myForceLoadPerformanceTests;
    private boolean myGetClassesCalled = false;
    private static final ThreadLocal<Boolean> ourBucketingSchemeInitRecursionLock = new ThreadLocal();
    private static final Lazy<BucketingScheme> ourBucketingScheme = LazyKt.lazy(() -> {
        BucketingScheme scheme = IS_TESTS_DURATION_BUCKETING_ENABLED ? new TestsDurationBucketingScheme() : (IS_NASTRADAMUS_TEST_DISTRIBUTOR_ENABLED ? new NastradamusBucketingScheme() : (IS_FAIR_BUCKETING ? new CyclicCounterBucketingScheme() : new HashingBucketingScheme()));
        if (IS_NASTRADAMUS_SHADOW_DATA_COLLECTION_ENABLED && !(scheme instanceof NastradamusBucketingScheme)) {
            scheme = new NastradamusDataCollectingBucketingScheme(scheme);
        }
        if (ourBucketingSchemeInitRecursionLock.get() == Boolean.TRUE) {
            throw new IllegalStateException("recursion detected");
        }
        ourBucketingSchemeInitRecursionLock.set(Boolean.TRUE);
        try {
            scheme.initialize();
        }
        finally {
            ourBucketingSchemeInitRecursionLock.remove();
        }
        return scheme;
    });
    private static final Lazy<TestClassesFilterArgs> ourCommonTestClassesFilterArgs = LazyKt.lazy(() -> new TestClassesFilterArgs(TestCaseLoader.getTestPatterns(), TestCaseLoader.getTestGroups(), COMMON_TEST_GROUPS_RESOURCE_NAME));
    private static final Lazy<TestClassesFilter> ourCommonTestClassesFilter = LazyKt.lazy(() -> {
        TestClassesFilterArgs args = (TestClassesFilterArgs)ourCommonTestClassesFilterArgs.getValue();
        TestClassesFilter filter = TestCaseLoader.calcTestClassFilter(args.patterns, args.testGroupNames, args.testGroupsResourcePath);
        System.out.println("Initialized tests filter: " + filter);
        return filter;
    });
    private static final Lazy<TestClassesFilter> ourCommonCompositeTestClassesFilter = LazyKt.lazy(() -> {
        TestClassesFilter filter = TestCaseLoader.wrapAsCompositeTestClassesFilter((TestClassesFilter)ourCommonTestClassesFilter.getValue());
        System.out.println("Initialized composite tests filter: " + filter);
        return filter;
    });

    @Deprecated
    public TestCaseLoader(String classFilterName) {
        this(classFilterName, false);
    }

    @Deprecated
    public TestCaseLoader(String classFilterName, boolean forceLoadPerformanceTests) {
        this(TestCaseLoader.getFilter(TestCaseLoader.getTestPatterns(), classFilterName, TestCaseLoader.getTestGroups(), false), forceLoadPerformanceTests);
    }

    private TestCaseLoader(TestClassesFilter filter, boolean forceLoadPerformanceTests) {
        this.myForceLoadPerformanceTests = forceLoadPerformanceTests;
        this.myTestClassesFilter = filter;
        System.out.println("Using tests filter: " + this.myTestClassesFilter);
    }

    private static TestClassesFilter wrapAsCompositeTestClassesFilter(TestClassesFilter filter) {
        TestClassesFilter explicitTestsFilter;
        TestClassesFilter affectedTestsFilter = TestCaseLoader.affectedTestsFilter();
        if (affectedTestsFilter != null) {
            filter = new TestClassesFilter.And(filter, affectedTestsFilter);
        }
        if ((explicitTestsFilter = TestCaseLoader.explicitTestsFilter()) != null) {
            filter = new TestClassesFilter.And(filter, explicitTestsFilter);
        }
        return filter;
    }

    private static TestClassesFilter calcTestClassFilter(@Nullable String patterns, @Nullable List<@NotNull String> testGroupNames, @Nullable String classFilterName) {
        if (!StringUtil.isEmpty((String)patterns)) {
            System.out.println("Using patterns: [" + patterns + "]");
            return new PatternListTestClassFilter(StringUtil.split((String)patterns, (String)";"));
        }
        if (testGroupNames == null) {
            testGroupNames = Collections.emptyList();
        }
        if (testGroupNames.contains(ALL_TESTS_GROUP)) {
            System.out.println("Using all classes");
            return TestClassesFilter.ALL_CLASSES;
        }
        List<URL> groupingFileUrls = Collections.emptyList();
        if (!StringUtil.isEmpty((String)classFilterName)) {
            try {
                groupingFileUrls = Collections.list(TestCaseLoader.getClassLoader().getResources(classFilterName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List<URL> finalGroupingFileUrls = groupingFileUrls;
        TeamCityLogger.block("Loading test groups from ...", () -> System.out.println("Loading test groups from: " + finalGroupingFileUrls));
        MultiMap groups = MultiMap.createLinked();
        for (URL fileUrl : groupingFileUrls) {
            try (InputStreamReader reader = new InputStreamReader(fileUrl.openStream(), StandardCharsets.UTF_8);){
                GroupBasedTestClassFilter.readGroups(reader, (MultiMap<String, String>)groups);
            }
            catch (IOException e) {
                System.err.println("Failed to load test groups from " + fileUrl);
                e.printStackTrace();
            }
        }
        System.out.println("Using test groups: " + testGroupNames);
        HashSet<String> testGroupNameSet = new HashSet<String>(testGroupNames);
        testGroupNameSet.removeAll(groups.keySet());
        testGroupNameSet.remove("ALL_EXCLUDE_DEFINED");
        if (!testGroupNameSet.isEmpty()) {
            System.err.println("Unknown test groups: " + testGroupNameSet);
        }
        return new GroupBasedTestClassFilter((MultiMap<String, String>)groups, testGroupNames);
    }

    @Nullable
    private static String getTestPatterns() {
        return System.getProperty("intellij.build.test.patterns", System.getProperty("idea.test.patterns"));
    }

    @Nullable
    private static TestClassesFilter affectedTestsFilter() {
        if (RUN_ONLY_AFFECTED_TESTS) {
            return Stream.of(System.getProperty("intellij.build.test.affected.classes.file", ""), System.getProperty("idea.home.path", "") + "/discoveredTestClasses.txt").filter(Predicate.not(StringUtil::isEmptyOrSpaces)).map(x$0 -> Path.of(x$0, new String[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().map(path -> {
                System.out.println("Loading affected tests patterns from " + path);
                return TestCaseLoader.loadTestsFilterFromFile(path, true);
            }).orElse(null);
        }
        System.out.println("Affected tests discovery is disabled. Will run with the standard test filter");
        return null;
    }

    @Nullable
    private static TestClassesFilter explicitTestsFilter() {
        Path path;
        String fileName = System.getProperty("intellij.build.test.list.file");
        if (fileName != null && !fileName.isBlank() && Files.isRegularFile(path = Path.of(fileName, new String[0]), new LinkOption[0])) {
            System.out.println("Loading explicit tests list from " + path);
            return TestCaseLoader.loadTestsFilterFromFile(path, false);
        }
        return null;
    }

    @Nullable
    private static TestClassesFilter loadTestsFilterFromFile(Path path, boolean linesArePatterns) {
        try {
            List<String> lines2 = Files.readAllLines(path);
            if (lines2.isEmpty()) {
                return null;
            }
            if (ContainerUtil.and(lines2, String::isBlank)) {
                return null;
            }
            return linesArePatterns ? new PatternListTestClassFilter(lines2) : new NameListTestClassFilter(lines2);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static List<String> getTestGroups() {
        return StringUtil.split((String)System.getProperty("intellij.build.test.groups", System.getProperty("idea.test.group", "")).trim(), (String)";");
    }

    private boolean isPotentiallyTestCase(String className, String moduleName) {
        String classNameWithoutPackage = StringsKt.substringAfterLast((String)className, (char)'.', (String)className);
        if (!this.myForceLoadPerformanceTests && !TestCaseLoader.shouldIncludePerformanceTestCase(classNameWithoutPackage)) {
            return false;
        }
        if (!this.myTestClassesFilter.matches(className, moduleName)) {
            return false;
        }
        if (this.myFirstTestClass != null && className.equals(this.myFirstTestClass.getName())) {
            return false;
        }
        return this.myLastTestClass == null || !className.equals(this.myLastTestClass.getName());
    }

    private boolean isClassTestCase(Class<?> testCaseClass, String moduleName, boolean initializing) {
        if (this.shouldAddTestCase(testCaseClass, moduleName, true) && testCaseClass != this.myFirstTestClass && testCaseClass != this.myLastTestClass && TestFrameworkUtil.canRunTest(testCaseClass)) {
            if (initializing) {
                return true;
            }
            if (SelfSeedingTestCase.class.isAssignableFrom(testCaseClass) || TestCaseLoader.matchesCurrentBucket(testCaseClass.getName())) {
                return true;
            }
        }
        return false;
    }

    public static boolean matchesCurrentBucket(@NotNull String testIdentifier) {
        if (testIdentifier == null) {
            TestCaseLoader.$$$reportNull$$$0(0);
        }
        if (!TestCaseLoader.shouldBucketTests()) {
            return true;
        }
        return ((BucketingScheme)ourBucketingScheme.getValue()).matchesCurrentBucket(testIdentifier);
    }

    @ApiStatus.Internal
    public static List<Class<?>> loadClassesForWarmup() {
        TestCaseLoader groupsTestCaseLoader = Builder.fromDefaults().forWarmup().build();
        groupsTestCaseLoader.fillTestCases("", TestAll.getClassRoots(), true);
        List<Class<?>> testCaseClasses = groupsTestCaseLoader.getClasses(false);
        System.out.printf("Finishing warmup initialization. Found %s classes%n", testCaseClasses.size());
        if (testCaseClasses.isEmpty()) {
            System.err.println("Fair bucketing or Nastradamus is enabled, but 0 test classes were found for warmup");
        }
        return testCaseClasses;
    }

    public static void sendTestRunResultsToNastradamus() {
        if (!ourBucketingScheme.isInitialized()) {
            return;
        }
        BucketingScheme scheme = (BucketingScheme)ourBucketingScheme.getValue();
        if (!(scheme instanceof NastradamusBucketingScheme)) {
            return;
        }
        NastradamusClient client = ((NastradamusBucketingScheme)scheme).getNastradamusClient();
        if (client == null) {
            return;
        }
        try {
            TestResultRequestEntity testRunRequest = client.collectTestRunResults();
            client.sendTestRunResults(testRunRequest, IS_NASTRADAMUS_TEST_DISTRIBUTOR_ENABLED);
        }
        catch (Exception e) {
            System.err.println("Unexpected error happened during sending test results to Nastradamus");
            e.printStackTrace();
        }
    }

    public static boolean shouldBucketTests() {
        return TEST_RUNNERS_COUNT > 1;
    }

    void addFirstTest(Class<?> aClass) {
        assert (this.myFirstTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, null, false)) : "not a test: " + aClass;
        this.myFirstTestClass = aClass;
    }

    void addLastTest(Class<?> aClass) {
        assert (this.myLastTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, null, false)) : "not a test: " + aClass;
        this.myLastTestClass = aClass;
    }

    private boolean shouldAddTestCase(Class<?> testCaseClass, String moduleName, boolean checkForExclusion) {
        if (Modifier.isAbstract(testCaseClass.getModifiers())) {
            return false;
        }
        if (checkForExclusion) {
            boolean isHardwareAgentRequired;
            if (this.shouldExcludeTestClass(moduleName, testCaseClass)) {
                return false;
            }
            boolean bl = isHardwareAgentRequired = TestCaseLoader.getAnnotationInHierarchy(testCaseClass, HardwareAgentRequired.class) != null;
            if (isHardwareAgentRequired != HARDWARE_AGENT_REQUIRED) {
                return false;
            }
        }
        if (TestCase.class.isAssignableFrom(testCaseClass) || TestSuite.class.isAssignableFrom(testCaseClass)) {
            return true;
        }
        try {
            Method suiteMethod = testCaseClass.getMethod("suite", new Class[0]);
            if (Test.class.isAssignableFrom(suiteMethod.getReturnType()) && Modifier.isStatic(suiteMethod.getModifiers())) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return TestFrameworkUtil.isJUnit4TestClass(testCaseClass, false) || TestFrameworkUtil.isJUnit5TestClass(testCaseClass, false);
    }

    private boolean shouldExcludeTestClass(String moduleName, Class<?> testCaseClass) {
        if (!this.myForceLoadPerformanceTests && !TestCaseLoader.shouldIncludePerformanceTestCase(testCaseClass.getSimpleName())) {
            return true;
        }
        String className = testCaseClass.getName();
        return !this.myTestClassesFilter.matches(className, moduleName) || testCaseClass.isAnnotationPresent(IJIgnore.class) || testCaseClass.isAnnotationPresent(IgnoreJUnit3.class) || TestCaseLoader.isExcludeFromTestDiscovery(testCaseClass);
    }

    private static boolean isExcludeFromTestDiscovery(Class<?> c) {
        return RUN_WITH_TEST_DISCOVERY && TestCaseLoader.getAnnotationInHierarchy(c, ExcludeFromTestDiscovery.class) != null;
    }

    private void loadTestCases(String moduleName, Collection<String> classNamesIterator, boolean initialization) {
        for (String className : classNamesIterator) {
            if (!this.isPotentiallyTestCase(className, moduleName)) continue;
            try {
                Class<?> candidateClass = Class.forName(className, false, TestCaseLoader.getClassLoader());
                if (!this.isClassTestCase(candidateClass, moduleName, initialization)) continue;
                this.myClassSet.add(candidateClass);
            }
            catch (Throwable e) {
                String message = "Cannot load class " + className + ": " + e.getMessage();
                System.err.println(message);
                this.myClassLoadingErrors.add(new Throwable(message, e));
            }
        }
    }

    protected static ClassLoader getClassLoader() {
        return TestCaseLoader.class.getClassLoader();
    }

    public List<Throwable> getClassLoadingErrors() {
        return this.myClassLoadingErrors;
    }

    public static int getRank(Class<?> aClass) {
        if (TestCaseLoader.runFirst(aClass)) {
            return 0;
        }
        if (TestCaseLoader.isPlatformLiteFixture(aClass)) {
            return Integer.MAX_VALUE;
        }
        return 1;
    }

    private static boolean runFirst(Class<?> testClass) {
        return TestCaseLoader.getAnnotationInHierarchy(testClass, RunFirst.class) != null;
    }

    private static boolean isPlatformLiteFixture(Class<?> aClass) {
        while (aClass != null) {
            if (PLATFORM_LITE_FIXTURE_NAME.equals(aClass.getName())) {
                return true;
            }
            aClass = aClass.getSuperclass();
        }
        return false;
    }

    public int getClassesCount() {
        return this.myClassSet.size();
    }

    public List<Class<?>> getClasses() {
        return this.getClasses(true);
    }

    List<Class<?>> getClasses(boolean includeFirstAndLast) {
        this.myGetClassesCalled = true;
        ArrayList result2 = new ArrayList(this.myClassSet.size() + (includeFirstAndLast ? 2 : 0));
        if (includeFirstAndLast && this.myFirstTestClass != null) {
            result2.add(this.myFirstTestClass);
        }
        result2.addAll(TestCaseLoader.loadTestSorter().sorted(this.myClassSet.stream().toList(), TestCaseLoader::getRank));
        if (includeFirstAndLast && this.myLastTestClass != null) {
            result2.add(this.myLastTestClass);
        }
        if (IS_VERBOSE_LOG_ENABLED) {
            System.out.println("Sorted classes: ");
            result2.forEach(clazz -> System.out.println(clazz.getName()));
        }
        return result2;
    }

    private static TestSorter loadTestSorter() {
        String sorter = System.getProperty("intellij.build.test.sorter");
        if (sorter == null && IS_NASTRADAMUS_TEST_DISTRIBUTOR_ENABLED) {
            sorter = "com.intellij.nastradamus.NastradamusTestCaseSorter";
        }
        if (sorter != null) {
            try {
                TestSorter testSorter = (TestSorter)Class.forName(sorter).getConstructor(new Class[0]).newInstance(new Object[0]);
                System.out.printf("Using test sorter from %s%n", sorter);
                return testSorter;
            }
            catch (Throwable t) {
                System.err.println("Sorter initialization failed: " + sorter);
                t.printStackTrace();
            }
        }
        if (IS_VERBOSE_LOG_ENABLED) {
            System.out.println("Using default test sorter (natural order)");
        }
        final Comparator classNameComparator = REVERSE_ORDER ? Comparator.reverseOrder() : Comparator.naturalOrder();
        return new TestSorter(){

            @Override
            @NotNull
            public List<Class<?>> sorted(@NotNull List<Class<?>> testClasses, @NotNull ToIntFunction<? super Class<?>> ranker) {
                if (testClasses == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ranker == null) {
                    1.$$$reportNull$$$0(1);
                }
                List list = ContainerUtil.sorted(testClasses, Comparator.comparingInt(ranker).thenComparing(Class::getName, classNameComparator));
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testClasses";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ranker";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/TestCaseLoader$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/TestCaseLoader$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "sorted";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "sorted";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    private void clearClasses() {
        this.myClassSet.clear();
        this.myFirstTestClass = null;
        this.myLastTestClass = null;
    }

    static boolean isPerformanceTestsRun() {
        return PERFORMANCE_TESTS_ONLY;
    }

    static boolean isIncludingPerformanceTestsRun() {
        return INCLUDE_PERFORMANCE_TESTS;
    }

    public static boolean shouldIncludePerformanceTestCase(String className) {
        return TestCaseLoader.isIncludingPerformanceTestsRun() || TestCaseLoader.isPerformanceTestsRun() || !TestCaseLoader.isPerformanceTest(null, className);
    }

    static boolean isPerformanceTest(String methodName, String className) {
        return TestFrameworkUtil.isPerformanceTest(methodName, className);
    }

    @ApiStatus.Internal
    public static TestClassesFilterArgs getCommonTestClassesFilterArgs() {
        return (TestClassesFilterArgs)ourCommonTestClassesFilterArgs.getValue();
    }

    public static boolean isClassNameIncluded(String className) {
        if (!ClassFinder.isSuitableTestClassName(className, INCLUDE_UNCONVENTIONALLY_NAMED_TESTS)) {
            return false;
        }
        if ("_FirstInSuiteTest".equals(className) || "_LastInSuiteTest".equals(className)) {
            return false;
        }
        return (TestCaseLoader.isIncludingPerformanceTestsRun() || TestCaseLoader.isPerformanceTestsRun() == TestCaseLoader.isPerformanceTest(null, className)) && ((TestClassesFilter)ourCommonCompositeTestClassesFilter.getValue()).matches(className);
    }

    public static boolean isClassIncluded(String className) {
        return TestCaseLoader.matchesCurrentBucket(className);
    }

    public void fillTestCases(String rootPackage, List<? extends Path> classesRoots) {
        this.fillTestCases(rootPackage, classesRoots, false);
    }

    private void fillTestCases(String rootPackage, List<? extends Path> classesRoots, boolean warmUpPhase) {
        if (this.myGetClassesCalled) {
            throw new IllegalStateException("Cannot fill more classes after 'getClasses' was already called");
        }
        String relevantJarsRoot = System.getProperty("intellij.test.jars.location");
        boolean noRelevantJarsRoot = StringUtil.isEmptyOrSpaces((String)relevantJarsRoot);
        long t = System.nanoTime();
        for (Path path : classesRoots) {
            String fileName;
            String moduleName = fileName = path.getFileName().toString();
            if (fileName.endsWith(".jar")) {
                if (noRelevantJarsRoot || !path.startsWith(relevantJarsRoot)) continue;
                moduleName = path.getParent().getFileName().toString();
            }
            int count = this.getClassesCount();
            ClassFinder classFinder = new ClassFinder(path, rootPackage, INCLUDE_UNCONVENTIONALLY_NAMED_TESTS);
            this.loadTestCases(moduleName, classFinder.getClasses(), warmUpPhase);
            count = this.getClassesCount() - count;
            if (count <= 0) continue;
            System.out.println("Loaded " + count + " classes from class root " + path);
        }
        if (this.myClassSet.isEmpty()) {
            this.clearClasses();
        }
        t = (System.nanoTime() - t) / 1000000L;
        System.out.println("Loaded " + this.getClassesCount() + " classes in " + t + " ms");
        if (!(warmUpPhase || RUN_ONLY_AFFECTED_TESTS || this.getClassesCount() != 0 || Boolean.getBoolean("idea.tests.ignoreJUnit3EmptySuite"))) {
            System.out.println("##teamcity[message text='Expected some junit 3 or junit 4 tests to be executed, but no test classes were found. If all your tests are junit 5 and you do not expect old junit tests to be executed, please pass vm option -Didea.tests.ignoreJUnit3EmptySuite=true' status='ERROR']");
        }
    }

    @Nullable
    public static <T extends Annotation> T getAnnotationInHierarchy(@NotNull Class<?> clazz, @NotNull Class<T> annotationClass) {
        if (clazz == null) {
            TestCaseLoader.$$$reportNull$$$0(1);
        }
        if (annotationClass == null) {
            TestCaseLoader.$$$reportNull$$$0(2);
        }
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            T annotation = current.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private static TestClassesFilter getFilter(@Nullable String patterns, @Nullable String testGroupsResourcePath, @Nullable List<@NotNull String> testGroups, boolean warmup) {
        TestClassesFilter filter;
        if (((TestClassesFilterArgs)ourCommonTestClassesFilterArgs.getValue()).equals(new TestClassesFilterArgs(patterns, testGroups, testGroupsResourcePath))) {
            filter = warmup ? (TestClassesFilter)ourCommonTestClassesFilter.getValue() : (TestClassesFilter)ourCommonCompositeTestClassesFilter.getValue();
        } else {
            filter = TestCaseLoader.calcTestClassFilter(patterns, testGroups, testGroupsResourcePath);
            if (!warmup) {
                filter = TestCaseLoader.wrapAsCompositeTestClassesFilter(filter);
            }
        }
        return filter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIdentifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/TestCaseLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesCurrentBucket";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotationInHierarchy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Experimental
    public static class Builder {
        private String myTestGroupsResourcePath;
        private String myPatterns;
        private List<String> myTestGroups;
        private boolean myForceLoadPerformanceTests = false;
        private boolean myWarmup = false;

        private Builder() {
        }

        public static Builder fromEmpty() {
            return new Builder();
        }

        public static Builder fromDefaults() {
            return new Builder().withDefaults();
        }

        private Builder withDefaults() {
            this.myPatterns = TestCaseLoader.getTestPatterns();
            this.myTestGroups = TestCaseLoader.getTestGroups();
            this.myTestGroupsResourcePath = TestCaseLoader.COMMON_TEST_GROUPS_RESOURCE_NAME;
            return this;
        }

        public Builder withTestGroups(List<String> groups) {
            this.myTestGroups = groups;
            return this;
        }

        public Builder withTestGroupsResourcePath(String resourcePath) {
            this.myTestGroupsResourcePath = resourcePath;
            return this;
        }

        public Builder withPatterns(String patterns) {
            this.myPatterns = patterns;
            return this;
        }

        public Builder withForceLoadPerformanceTests(boolean flag) {
            this.myForceLoadPerformanceTests = flag;
            return this;
        }

        Builder forWarmup() {
            this.myWarmup = true;
            return this;
        }

        public TestCaseLoader build() {
            if (this.myPatterns == null && this.myTestGroups == null) {
                throw new IllegalStateException("Either withPatterns, withTestGroups, or fromDefault should be called");
            }
            TestClassesFilter filter = TestCaseLoader.getFilter(this.myPatterns, this.myTestGroupsResourcePath, this.myTestGroups, this.myWarmup);
            return new TestCaseLoader(filter, this.myForceLoadPerformanceTests);
        }
    }

    @ApiStatus.Internal
    public record TestClassesFilterArgs(@Nullable String patterns, @Nullable List<@NotNull String> testGroupNames, @Nullable String testGroupsResourcePath) {
    }
}

