/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenBuild;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProfile;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.plugins.api.MavenModelPropertiesPatcher;
import org.jetbrains.idea.maven.project.MavenArtifactIndex;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectChangesBuilder;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.server.MavenGoalExecutionResult;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenPathWrapper;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProject {
    private static final Key<MavenArtifactIndex> DEPENDENCIES_CACHE_KEY = Key.create((String)"MavenProject.DEPENDENCIES_CACHE_KEY");
    private static final Key<List<String>> FILTERS_CACHE_KEY = Key.create((String)"MavenProject.FILTERS_CACHE_KEY");
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private volatile State myState;

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static MavenProject read(DataInputStream in) throws IOException {
        String path2 = in.readUTF();
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path2);
        if (file == null) {
            return null;
        }
        try (ByteArrayInputStream bs = new ByteArrayInputStream(bytes);){
            MavenProject mavenProject2;
            try (ObjectInputStream os = new ObjectInputStream(bs);){
                MavenProject result2 = new MavenProject(file);
                result2.myState = (State)os.readObject();
                mavenProject2 = result2;
            }
            return mavenProject2;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public void write(@NotNull DataOutputStream out) throws IOException {
        if (out == null) {
            MavenProject.$$$reportNull$$$0(0);
        }
        out.writeUTF(this.getPath());
        try (BufferExposingByteArrayOutputStream bs = new BufferExposingByteArrayOutputStream();
             ObjectOutputStream os = new ObjectOutputStream((OutputStream)bs);){
            os.writeObject(this.myState);
            out.writeInt(bs.size());
            out.write(bs.getInternalBuffer(), 0, bs.size());
        }
    }

    public MavenProject(@NotNull VirtualFile file) {
        if (file == null) {
            MavenProject.$$$reportNull$$$0(1);
        }
        this.myState = new State();
        this.myFile = file;
    }

    @NotNull
    @ApiStatus.Internal
    public MavenProjectChanges updateFromReaderResult(@NotNull MavenProjectReaderResult readerResult, @NotNull MavenGeneralSettings settings, boolean keepPreviousArtifacts) {
        if (readerResult == null) {
            MavenProject.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            MavenProject.$$$reportNull$$$0(3);
        }
        State newState = this.myState.clone();
        newState.myLastReadStamp = this.myState.myLastReadStamp + 1L;
        boolean keepPreviousPlugins = keepPreviousArtifacts;
        this.doUpdateState(newState, readerResult.mavenModel, readerResult.readingProblems, readerResult.activatedProfiles, Set.of(), readerResult.nativeModelMap, settings, keepPreviousArtifacts, false, keepPreviousPlugins);
        MavenProjectChanges mavenProjectChanges = this.setState(newState);
        if (mavenProjectChanges == null) {
            MavenProject.$$$reportNull$$$0(4);
        }
        return mavenProjectChanges;
    }

    @NotNull
    @ApiStatus.Internal
    public MavenProjectChanges updateState(@NotNull MavenModel model, @Nullable String dependencyHash, @NotNull @NotNull Collection<@NotNull MavenProjectProblem> readingProblems, @NotNull MavenExplicitProfiles activatedProfiles, @NotNull Set<MavenId> unresolvedArtifactIds, @NotNull @NotNull Map<@NotNull String, @Nullable String> nativeModelMap, @NotNull MavenGeneralSettings settings, boolean keepPreviousArtifacts, boolean keepPreviousPlugins) {
        if (model == null) {
            MavenProject.$$$reportNull$$$0(5);
        }
        if (readingProblems == null) {
            MavenProject.$$$reportNull$$$0(6);
        }
        if (activatedProfiles == null) {
            MavenProject.$$$reportNull$$$0(7);
        }
        if (unresolvedArtifactIds == null) {
            MavenProject.$$$reportNull$$$0(8);
        }
        if (nativeModelMap == null) {
            MavenProject.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            MavenProject.$$$reportNull$$$0(10);
        }
        State newState = this.myState.clone();
        if (null != dependencyHash) {
            newState.myDependencyHash = dependencyHash;
        }
        this.doUpdateState(newState, model, readingProblems, activatedProfiles, unresolvedArtifactIds, nativeModelMap, settings, keepPreviousArtifacts, true, keepPreviousPlugins);
        MavenProjectChanges mavenProjectChanges = this.setState(newState);
        if (mavenProjectChanges == null) {
            MavenProject.$$$reportNull$$$0(11);
        }
        return mavenProjectChanges;
    }

    @NotNull
    @ApiStatus.Internal
    public MavenProjectChanges updateState(@NotNull @NotNull Collection<@NotNull MavenProjectProblem> readingProblems) {
        if (readingProblems == null) {
            MavenProject.$$$reportNull$$$0(12);
        }
        State newState = this.myState.clone();
        newState.myReadingProblems = readingProblems;
        MavenProjectChanges mavenProjectChanges = this.setState(newState);
        if (mavenProjectChanges == null) {
            MavenProject.$$$reportNull$$$0(13);
        }
        return mavenProjectChanges;
    }

    private void doUpdateState(State newState, @NotNull MavenModel model, @NotNull @NotNull Collection<@NotNull MavenProjectProblem> readingProblems, @NotNull MavenExplicitProfiles activatedProfiles, @NotNull Set<MavenId> unresolvedArtifactIds, @NotNull @NotNull Map<@NotNull String, @Nullable String> nativeModelMap, @NotNull MavenGeneralSettings settings, boolean keepPreviousArtifacts, boolean keepPreviousProfiles, boolean keepPreviousPlugins) {
        if (model == null) {
            MavenProject.$$$reportNull$$$0(14);
        }
        if (readingProblems == null) {
            MavenProject.$$$reportNull$$$0(15);
        }
        if (activatedProfiles == null) {
            MavenProject.$$$reportNull$$$0(16);
        }
        if (unresolvedArtifactIds == null) {
            MavenProject.$$$reportNull$$$0(17);
        }
        if (nativeModelMap == null) {
            MavenProject.$$$reportNull$$$0(18);
        }
        if (settings == null) {
            MavenProject.$$$reportNull$$$0(19);
        }
        newState.myReadingProblems = readingProblems;
        newState.myLocalRepository = settings.getEffectiveLocalRepository();
        newState.myActivatedProfilesIds = activatedProfiles;
        newState.myMavenId = model.getMavenId();
        if (model.getParent() != null) {
            newState.myParentId = model.getParent().getMavenId();
        }
        newState.myPackaging = model.getPackaging();
        newState.myName = model.getName();
        newState.myFinalName = model.getBuild().getFinalName();
        newState.myDefaultGoal = model.getBuild().getDefaultGoal();
        newState.myBuildDirectory = model.getBuild().getDirectory();
        newState.myOutputDirectory = model.getBuild().getOutputDirectory();
        newState.myTestOutputDirectory = model.getBuild().getTestOutputDirectory();
        MavenProject.doSetFolders(newState, model.getBuild());
        newState.myFilters = model.getBuild().getFilters();
        newState.myProperties = model.getProperties();
        MavenProject.doSetResolvedAttributes(newState, model, unresolvedArtifactIds, keepPreviousArtifacts, keepPreviousPlugins);
        MavenModelPropertiesPatcher.patch(newState.myProperties, newState.myPlugins);
        newState.myModulesPathsAndNames = this.collectModulePathsAndNames(model, this.getDirectory());
        Collection<String> newProfiles = MavenProject.collectProfilesIds(model.getProfiles());
        if (keepPreviousProfiles && newState.myProfilesIds != null) {
            HashSet<String> mergedProfiles = new HashSet<String>(newState.myProfilesIds);
            mergedProfiles.addAll(newProfiles);
            newState.myProfilesIds = new ArrayList<String>(mergedProfiles);
        } else {
            newState.myProfilesIds = newProfiles;
        }
        newState.myModelMap = nativeModelMap;
    }

    private MavenProjectChanges setState(State newState) {
        MavenProjectChanges changes = this.myState.getChanges(newState);
        this.myState = newState;
        return changes;
    }

    private void updateState(Consumer<State> updater) {
        State newState = this.myState.clone();
        updater.consume((Object)newState);
        this.myState = newState;
    }

    @NotNull
    Snapshot getSnapshot() {
        return new Snapshot(this.myState);
    }

    MavenProjectChanges getChangesSinceSnapshot(@NotNull Snapshot snapshot) {
        if (snapshot == null) {
            MavenProject.$$$reportNull$$$0(20);
        }
        return snapshot.myState.getChanges(this.myState);
    }

    private static void doSetResolvedAttributes(State state2, MavenModel model, Set<MavenId> unresolvedArtifactIds, boolean keepPreviousArtifacts, boolean keepPreviousPlugins) {
        HashSet<MavenId> newUnresolvedArtifacts = new HashSet<MavenId>();
        LinkedHashSet<MavenRemoteRepository> newRepositories = new LinkedHashSet<MavenRemoteRepository>();
        LinkedHashSet<MavenArtifact> newDependencies = new LinkedHashSet<MavenArtifact>();
        LinkedHashSet<MavenArtifactNode> newDependencyTree = new LinkedHashSet<MavenArtifactNode>();
        LinkedHashSet<MavenPlugin> newPlugins = new LinkedHashSet<MavenPlugin>();
        LinkedHashSet<MavenArtifact> newExtensions = new LinkedHashSet<MavenArtifact>();
        LinkedHashSet<MavenArtifact> newAnnotationProcessors = new LinkedHashSet<MavenArtifact>();
        if (keepPreviousArtifacts) {
            if (state2.myUnresolvedArtifactIds != null) {
                newUnresolvedArtifacts.addAll(state2.myUnresolvedArtifactIds);
            }
            if (state2.myRemoteRepositories != null) {
                newRepositories.addAll(state2.myRemoteRepositories);
            }
            if (state2.myDependencies != null) {
                newDependencies.addAll(state2.myDependencies);
            }
            if (state2.myDependencyTree != null) {
                newDependencyTree.addAll(state2.myDependencyTree);
            }
            if (state2.myExtensions != null) {
                newExtensions.addAll(state2.myExtensions);
            }
            if (state2.myAnnotationProcessors != null) {
                newAnnotationProcessors.addAll(state2.myAnnotationProcessors);
            }
        }
        if (keepPreviousPlugins && state2.myPlugins != null) {
            newPlugins.addAll(state2.myPlugins);
        }
        newUnresolvedArtifacts.addAll(unresolvedArtifactIds);
        newRepositories.addAll(model.getRemoteRepositories());
        newDependencyTree.addAll(model.getDependencyTree());
        newDependencies.addAll(model.getDependencies());
        newPlugins.addAll(model.getPlugins());
        newExtensions.addAll(model.getExtensions());
        state2.myUnresolvedArtifactIds = newUnresolvedArtifacts;
        state2.myRemoteRepositories = new ArrayList<MavenRemoteRepository>(newRepositories);
        state2.myDependencies = new ArrayList<MavenArtifact>(newDependencies);
        state2.myDependencyTree = new ArrayList<MavenArtifactNode>(newDependencyTree);
        state2.myPlugins = new ArrayList<MavenPlugin>(newPlugins);
        state2.myExtensions = new ArrayList<MavenArtifact>(newExtensions);
        state2.myAnnotationProcessors = new ArrayList<MavenArtifact>(newAnnotationProcessors);
    }

    @ApiStatus.Internal
    public MavenProjectChanges setFolders(MavenGoalExecutionResult.Folders folders) {
        State newState = this.myState.clone();
        MavenProject.doSetFolders(newState, folders.getSources(), folders.getTestSources(), folders.getResources(), folders.getTestResources());
        return this.setState(newState);
    }

    private static void doSetFolders(State newState, MavenBuild build) {
        MavenProject.doSetFolders(newState, build.getSources(), build.getTestSources(), build.getResources(), build.getTestResources());
    }

    private static void doSetFolders(State newState, List<String> sources, List<String> testSources, List<MavenResource> resources, List<MavenResource> testResources) {
        newState.mySources = sources;
        newState.myTestSources = testSources;
        newState.myResources = resources;
        newState.myTestResources = testResources;
    }

    private Map<String, String> collectModulePathsAndNames(MavenModel mavenModel, String baseDir2) {
        String basePath = baseDir2 + "/";
        LinkedHashMap<String, String> result2 = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> each : this.collectModulesRelativePathsAndNames(mavenModel, basePath).entrySet()) {
            result2.put(new MavenPathWrapper(basePath + each.getKey()).getPath(), each.getValue());
        }
        return result2;
    }

    private Map<String, String> collectModulesRelativePathsAndNames(MavenModel mavenModel, String basePath) {
        String extension = StringUtil.notNullize((String)this.myFile.getExtension());
        LinkedHashMap<String, String> result2 = new LinkedHashMap<String, String>();
        for (Object name : mavenModel.getModules()) {
            if (((String)(name = ((String)name).trim())).length() == 0) continue;
            String originalName = name;
            Object finalName = name = FileUtil.toSystemIndependentName((String)name);
            boolean fullPathInModuleName = ContainerUtil.exists((Object[])MavenConstants.POM_EXTENSIONS, arg_0 -> MavenProject.lambda$collectModulesRelativePathsAndNames$0((String)finalName, arg_0));
            if (!fullPathInModuleName) {
                if (!((String)name).endsWith("/")) {
                    name = (String)name + "/";
                }
                name = (String)name + "pom." + extension;
            } else {
                String systemDependentName = FileUtil.toSystemDependentName((String)(basePath + (String)name));
                if (new File(systemDependentName).isDirectory()) {
                    name = (String)name + "/pom.xml";
                }
            }
            result2.put((String)name, originalName);
        }
        return result2;
    }

    private static Collection<String> collectProfilesIds(Collection<MavenProfile> profiles2) {
        if (profiles2 == null) {
            return Collections.emptyList();
        }
        HashSet<String> result2 = new HashSet<String>(profiles2.size());
        for (MavenProfile each : profiles2) {
            result2.add(each.getId());
        }
        return result2;
    }

    public long getLastReadStamp() {
        return this.myState.myLastReadStamp;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            MavenProject.$$$reportNull$$$0(21);
        }
        return virtualFile;
    }

    @NotNull
    @NonNls
    public String getPath() {
        String string = this.myFile.getPath();
        if (string == null) {
            MavenProject.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getDirectory() {
        String string = this.myFile.getParent().getPath();
        if (string == null) {
            MavenProject.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public VirtualFile getDirectoryFile() {
        VirtualFile virtualFile = this.myFile.getParent();
        if (virtualFile == null) {
            MavenProject.$$$reportNull$$$0(24);
        }
        return virtualFile;
    }

    @Nullable
    public VirtualFile getProfilesXmlFile() {
        return MavenUtil.findProfilesXmlFile(this.myFile);
    }

    @Nullable
    public File getProfilesXmlIoFile() {
        return MavenUtil.getProfilesXmlIoFile(this.myFile);
    }

    public boolean hasReadingProblems() {
        return !this.myState.myReadingProblems.isEmpty();
    }

    @Nullable
    @NlsSafe
    public String getName() {
        return this.myState.myName;
    }

    @NotNull
    @NlsSafe
    public String getDisplayName() {
        State state2 = this.myState;
        if (StringUtil.isEmptyOrSpaces((String)state2.myName)) {
            String string = StringUtil.notNullize((String)state2.myMavenId.getArtifactId());
            if (string == null) {
                MavenProject.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = state2.myName;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public Map<String, String> getModelMap() {
        Map<String, String> map = this.myState.myModelMap;
        if (map == null) {
            MavenProject.$$$reportNull$$$0(27);
        }
        return map;
    }

    @NotNull
    public MavenId getMavenId() {
        MavenId mavenId2 = this.myState.myMavenId;
        if (mavenId2 == null) {
            MavenProject.$$$reportNull$$$0(28);
        }
        return mavenId2;
    }

    boolean isNew() {
        return null == this.myState.myMavenId;
    }

    @Nullable
    public MavenId getParentId() {
        return this.myState.myParentId;
    }

    @NotNull
    @NlsSafe
    public String getPackaging() {
        String string = this.myState.myPackaging;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getFinalName() {
        String string = this.myState.myFinalName;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getDefaultGoal() {
        return this.myState.myDefaultGoal;
    }

    @NotNull
    @NlsSafe
    public String getBuildDirectory() {
        String string = this.myState.myBuildDirectory;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getGeneratedSourcesDirectory(boolean testSources) {
        String string = this.getBuildDirectory() + (testSources ? "/generated-test-sources" : "/generated-sources");
        if (string == null) {
            MavenProject.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getAnnotationProcessorDirectory(boolean testSources) {
        if (this.getProcMode() == ProcMode.NONE) {
            MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
            Element cfg = this.getPluginGoalConfiguration(bscMavenPlugin, testSources ? "process-test" : "process");
            if (bscMavenPlugin != null && cfg == null) {
                String string = this.getBuildDirectory() + (testSources ? "/generated-sources/apt-test" : "/generated-sources/apt");
                if (string == null) {
                    MavenProject.$$$reportNull$$$0(33);
                }
                return string;
            }
            if (cfg != null) {
                Object out = MavenJDOMUtil.findChildValueByPath(cfg, "outputDirectory");
                if (out == null && (out = MavenJDOMUtil.findChildValueByPath(cfg, "defaultOutputDirectory")) == null) {
                    String string = this.getBuildDirectory() + (testSources ? "/generated-sources/apt-test" : "/generated-sources/apt");
                    if (string == null) {
                        MavenProject.$$$reportNull$$$0(34);
                    }
                    return string;
                }
                if (!new File((String)out).isAbsolute()) {
                    out = this.getDirectory() + "/" + (String)out;
                }
                String string = out;
                if (string == null) {
                    MavenProject.$$$reportNull$$$0(35);
                }
                return string;
            }
        }
        String def = this.getGeneratedSourcesDirectory(testSources) + (testSources ? "/test-annotations" : "/annotations");
        String string = MavenJDOMUtil.findChildValueByPath(this.getCompilerConfig(), testSources ? "generatedTestSourcesDirectory" : "generatedSourcesDirectory", def);
        if (string == null) {
            MavenProject.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public ProcMode getProcMode() {
        Element compilerConfiguration = this.getPluginExecutionConfiguration("org.apache.maven.plugins", "maven-compiler-plugin", "default-compile");
        if (compilerConfiguration == null) {
            compilerConfiguration = this.getCompilerConfig();
        }
        if (compilerConfiguration == null) {
            ProcMode procMode = ProcMode.BOTH;
            if (procMode == null) {
                MavenProject.$$$reportNull$$$0(37);
            }
            return procMode;
        }
        Element procElement = compilerConfiguration.getChild("proc");
        if (procElement != null) {
            String procMode = procElement.getValue();
            ProcMode procMode2 = "only".equalsIgnoreCase(procMode) ? ProcMode.ONLY : ("none".equalsIgnoreCase(procMode) ? ProcMode.NONE : ProcMode.BOTH);
            if (procMode2 == null) {
                MavenProject.$$$reportNull$$$0(38);
            }
            return procMode2;
        }
        String compilerArgument = compilerConfiguration.getChildTextTrim("compilerArgument");
        if ("-proc:none".equals(compilerArgument)) {
            ProcMode procMode = ProcMode.NONE;
            if (procMode == null) {
                MavenProject.$$$reportNull$$$0(39);
            }
            return procMode;
        }
        if ("-proc:only".equals(compilerArgument)) {
            ProcMode procMode = ProcMode.ONLY;
            if (procMode == null) {
                MavenProject.$$$reportNull$$$0(40);
            }
            return procMode;
        }
        Element compilerArguments = compilerConfiguration.getChild("compilerArgs");
        if (compilerArguments != null) {
            for (Element element : compilerArguments.getChildren()) {
                String arg = element.getValue();
                if ("-proc:none".equals(arg)) {
                    ProcMode procMode = ProcMode.NONE;
                    if (procMode == null) {
                        MavenProject.$$$reportNull$$$0(41);
                    }
                    return procMode;
                }
                if (!"-proc:only".equals(arg)) continue;
                ProcMode procMode = ProcMode.ONLY;
                if (procMode == null) {
                    MavenProject.$$$reportNull$$$0(42);
                }
                return procMode;
            }
        }
        ProcMode procMode = ProcMode.BOTH;
        if (procMode == null) {
            MavenProject.$$$reportNull$$$0(43);
        }
        return procMode;
    }

    public Map<String, String> getAnnotationProcessorOptions() {
        Element compilerConfig = this.getCompilerConfig();
        if (compilerConfig == null) {
            return Collections.emptyMap();
        }
        if (this.getProcMode() != ProcMode.NONE) {
            return MavenProject.getAnnotationProcessorOptionsFromCompilerConfig(compilerConfig);
        }
        MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
        if (bscMavenPlugin != null) {
            return MavenProject.getAnnotationProcessorOptionsFromProcessorPlugin(bscMavenPlugin);
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> getAnnotationProcessorOptionsFromCompilerConfig(Element compilerConfig) {
        Element compilerArguments;
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        String compilerArgument = compilerConfig.getChildText("compilerArgument");
        MavenProject.addAnnotationProcessorOptionFromParameterString(compilerArgument, res);
        Element compilerArgs = compilerConfig.getChild("compilerArgs");
        if (compilerArgs != null) {
            for (Element e : compilerArgs.getChildren()) {
                if (!StringUtil.equals((CharSequence)e.getName(), (CharSequence)"arg")) continue;
                String arg = e.getTextTrim();
                MavenProject.addAnnotationProcessorOption(arg, res);
            }
        }
        if ((compilerArguments = compilerConfig.getChild("compilerArguments")) != null) {
            for (Element e : compilerArguments.getChildren()) {
                String name = e.getName();
                if ((name = StringUtil.trimStart((String)name, (String)"-")).length() <= 1 || name.charAt(0) != 'A') continue;
                res.put(name.substring(1), e.getTextTrim());
            }
        }
        return res;
    }

    private static void addAnnotationProcessorOptionFromParameterString(String compilerArguments, Map<String, String> res) {
        if (!StringUtil.isEmptyOrSpaces((String)compilerArguments)) {
            ParametersList parametersList = new ParametersList();
            parametersList.addParametersString(compilerArguments);
            for (String param : parametersList.getParameters()) {
                MavenProject.addAnnotationProcessorOption(param, res);
            }
        }
    }

    private static void addAnnotationProcessorOption(String compilerArg, Map<String, String> optionsMap) {
        if (compilerArg == null || compilerArg.trim().isEmpty()) {
            return;
        }
        if (compilerArg.startsWith("-A")) {
            int idx = compilerArg.indexOf(61, 3);
            if (idx >= 0) {
                optionsMap.put(compilerArg.substring(2, idx), compilerArg.substring(idx + 1));
            } else {
                optionsMap.put(compilerArg.substring(2), "");
            }
        }
    }

    private static Map<String, String> getAnnotationProcessorOptionsFromProcessorPlugin(MavenPlugin bscMavenPlugin) {
        Element cfg = bscMavenPlugin.getGoalConfiguration("process");
        if (cfg == null) {
            cfg = bscMavenPlugin.getConfigurationElement();
        }
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        if (cfg != null) {
            String compilerArguments = cfg.getChildText("compilerArguments");
            MavenProject.addAnnotationProcessorOptionFromParameterString(compilerArguments, res);
            Element optionsElement = cfg.getChild("options");
            if (optionsElement != null) {
                for (Element option : optionsElement.getChildren()) {
                    res.put(option.getName(), option.getText());
                }
            }
        }
        return res;
    }

    public @Nullable List<@NlsSafe String> getDeclaredAnnotationProcessors() {
        ArrayList<String> result2;
        block7: {
            block6: {
                Element compilerConfig = this.getCompilerConfig();
                if (compilerConfig == null) {
                    return null;
                }
                result2 = new ArrayList<String>();
                if (this.getProcMode() == ProcMode.NONE) break block6;
                Element processors = compilerConfig.getChild("annotationProcessors");
                if (processors == null) break block7;
                for (Element element : processors.getChildren("annotationProcessor")) {
                    String processorClassName = element.getTextTrim();
                    if (processorClassName.isEmpty()) continue;
                    result2.add(processorClassName);
                }
                break block7;
            }
            MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
            if (bscMavenPlugin != null) {
                Element bscProcessors;
                Element bscCfg = bscMavenPlugin.getGoalConfiguration("process");
                if (bscCfg == null) {
                    bscCfg = bscMavenPlugin.getConfigurationElement();
                }
                if (bscCfg != null && (bscProcessors = bscCfg.getChild("processors")) != null) {
                    for (Element element : bscProcessors.getChildren("processor")) {
                        String processorClassName = element.getTextTrim();
                        if (processorClassName.isEmpty()) continue;
                        result2.add(processorClassName);
                    }
                }
            }
        }
        return result2;
    }

    @NotNull
    @NlsSafe
    public String getOutputDirectory() {
        String string = this.myState.myOutputDirectory;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getTestOutputDirectory() {
        String string = this.myState.myTestOutputDirectory;
        if (string == null) {
            MavenProject.$$$reportNull$$$0(45);
        }
        return string;
    }

    public @NotNull List<@NlsSafe String> getSources() {
        List<String> list = this.myState.mySources;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(46);
        }
        return list;
    }

    public @NotNull List<@NlsSafe String> getTestSources() {
        List<String> list = this.myState.myTestSources;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(47);
        }
        return list;
    }

    @NotNull
    public List<MavenResource> getResources() {
        List<MavenResource> list = this.myState.myResources;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public List<MavenResource> getTestResources() {
        List<MavenResource> list = this.myState.myTestResources;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(49);
        }
        return list;
    }

    public @NotNull List<@NlsSafe String> getFilters() {
        List<String> list = this.myState.myFilters;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(50);
        }
        return list;
    }

    public List<@NlsSafe String> getFilterPropertiesFiles() {
        List<String> res = this.getCachedValue(FILTERS_CACHE_KEY);
        if (res == null) {
            Element files2;
            Element propCfg = this.getPluginGoalConfiguration("org.codehaus.mojo", "properties-maven-plugin", "read-project-properties");
            if (propCfg != null && (files2 = propCfg.getChild("files")) != null) {
                res = new ArrayList<String>();
                for (Element file : files2.getChildren("file")) {
                    File f = new File(file.getValue());
                    if (!f.isAbsolute()) {
                        f = new File(this.getDirectory(), file.getValue());
                    }
                    res.add(f.getAbsolutePath());
                }
            }
            if (res == null) {
                res = this.getFilters();
            } else {
                res.addAll(this.getFilters());
            }
            res = this.putCachedValue(FILTERS_CACHE_KEY, res);
        }
        return res;
    }

    public void setConfigFileError(@Nullable String message) {
        if (message != null) {
            this.myState.myReadingProblems.add(new MavenProjectProblem(this.myFile.getPath() + "/.mvn/maven.config", message, MavenProjectProblem.ProblemType.SYNTAX, true));
        }
    }

    @Nullable
    public String getConfigFileError() {
        return this.myState.myReadingProblems.stream().filter(p -> p.getPath().endsWith("/.mvn/maven.config")).map(p -> p.getDescription()).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        State state2 = this.myState;
        synchronized (state2) {
            this.myState.resetCache();
        }
    }

    public boolean isAggregator() {
        return "pom".equals(this.getPackaging()) || !this.getModulePaths().isEmpty();
    }

    @NotNull
    public List<MavenProjectProblem> getProblems() {
        List<MavenProjectProblem> problems = this.myState.myProblemsCache;
        if (null != problems) {
            List<MavenProjectProblem> list = problems;
            if (list == null) {
                MavenProject.$$$reportNull$$$0(51);
            }
            return list;
        }
        List<MavenProjectProblem> list = this.collectProblems(null);
        if (list == null) {
            MavenProject.$$$reportNull$$$0(52);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @NotNull
    public List<MavenProjectProblem> collectProblems(Predicate<File> fileExistsPredicate) {
        State state2;
        State state3 = state2 = this.myState;
        // MONITORENTER : state3
        if (state2.myProblemsCache == null) {
            state2.myProblemsCache = MavenProject.collectProblems(this.myFile, state2, fileExistsPredicate);
        }
        List<MavenProjectProblem> list = state2.myProblemsCache;
        // MONITOREXIT : state3
        if (list != null) return list;
        MavenProject.$$$reportNull$$$0(53);
        return list;
    }

    @NotNull
    public List<MavenProjectProblem> getCacheProblems() {
        List<MavenProjectProblem> problemsCache = this.myState.myProblemsCache;
        List<Object> list = problemsCache == null ? Collections.emptyList() : problemsCache;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(54);
        }
        return list;
    }

    private static List<MavenProjectProblem> collectProblems(VirtualFile file, State state2, Predicate<File> fileExistsPredicate) {
        ArrayList<MavenProjectProblem> result2 = new ArrayList<MavenProjectProblem>();
        MavenProject.validateParent(file, state2, result2);
        result2.addAll(state2.myReadingProblems);
        for (Map.Entry<String, String> each : state2.myModulesPathsAndNames.entrySet()) {
            if (LocalFileSystem.getInstance().findFileByPath(each.getKey()) != null) continue;
            result2.add(MavenProject.createDependencyProblem(file, MavenProjectBundle.message("maven.project.problem.moduleNotFound", each.getValue())));
        }
        MavenProject.validateDependencies(file, state2, result2, fileExistsPredicate);
        MavenProject.validateExtensions(file, state2, result2);
        MavenProject.validatePlugins(file, state2, result2);
        return result2;
    }

    private static void validateParent(VirtualFile file, State state2, List<MavenProjectProblem> result2) {
        if (!MavenProject.isParentResolved(state2)) {
            result2.add(MavenProject.createDependencyProblem(file, MavenProjectBundle.message("maven.project.problem.parentNotFound", state2.myParentId)));
        }
    }

    private static void validateDependencies(VirtualFile file, State state2, List<MavenProjectProblem> result2, Predicate<File> fileExistsPredicate) {
        for (MavenArtifact each : MavenProject.getUnresolvedDependencies(state2, fileExistsPredicate)) {
            result2.add(MavenProject.createDependencyProblem(file, MavenProjectBundle.message("maven.project.problem.unresolvedDependency", each.getDisplayStringWithType())));
        }
    }

    private static void validateExtensions(VirtualFile file, State state2, List<MavenProjectProblem> result2) {
        for (MavenArtifact each : MavenProject.getUnresolvedExtensions(state2)) {
            result2.add(MavenProject.createDependencyProblem(file, MavenProjectBundle.message("maven.project.problem.unresolvedExtension", each.getDisplayStringSimple())));
        }
    }

    private static void validatePlugins(VirtualFile file, State state2, List<MavenProjectProblem> result2) {
        for (MavenPlugin each : MavenProject.getUnresolvedPlugins(state2)) {
            result2.add(MavenProject.createDependencyProblem(file, MavenProjectBundle.message("maven.project.problem.unresolvedPlugin", each)));
        }
    }

    private static MavenProjectProblem createDependencyProblem(VirtualFile file, String description) {
        return new MavenProjectProblem(file.getPath(), description, MavenProjectProblem.ProblemType.DEPENDENCY, false);
    }

    private static boolean isParentResolved(State state2) {
        return !state2.myUnresolvedArtifactIds.contains(state2.myParentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedDependencies(State state2, Predicate<File> fileExistsPredicate) {
        State state3 = state2;
        synchronized (state3) {
            if (state2.myUnresolvedDependenciesCache == null) {
                ArrayList<MavenArtifact> result2 = new ArrayList<MavenArtifact>();
                Iterator<MavenArtifact> iterator = state2.myDependencies.iterator();
                while (iterator.hasNext()) {
                    MavenArtifact each;
                    boolean resolved = (each = iterator.next()).isResolved(fileExistsPredicate);
                    each.setFileUnresolved(!resolved);
                    if (resolved) continue;
                    result2.add(each);
                }
                state2.myUnresolvedDependenciesCache = result2;
            }
            return state2.myUnresolvedDependenciesCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedExtensions(State state2) {
        State state3 = state2;
        synchronized (state3) {
            if (state2.myUnresolvedExtensionsCache == null) {
                ArrayList<MavenArtifact> result2 = new ArrayList<MavenArtifact>();
                for (MavenArtifact each : state2.myExtensions) {
                    if (!state2.myUnresolvedArtifactIds.contains(each.getMavenId()) || MavenProject.pomFileExists(state2.myLocalRepository, each)) continue;
                    result2.add(each);
                }
                state2.myUnresolvedExtensionsCache = result2;
            }
            return state2.myUnresolvedExtensionsCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedAnnotationProcessors(State state2) {
        State state3 = state2;
        synchronized (state3) {
            if (state2.myUnresolvedAnnotationProcessors == null) {
                ArrayList<MavenArtifact> result2 = new ArrayList<MavenArtifact>();
                for (MavenArtifact each : state2.myAnnotationProcessors) {
                    if (each.isResolved()) continue;
                    result2.add(each);
                }
                state2.myUnresolvedAnnotationProcessors = result2;
            }
            return state2.myUnresolvedAnnotationProcessors;
        }
    }

    private static boolean pomFileExists(File localRepository2, MavenArtifact artifact) {
        return MavenArtifactUtil.hasArtifactFile(localRepository2, artifact.getMavenId(), "pom");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenPlugin> getUnresolvedPlugins(State state2) {
        State state3 = state2;
        synchronized (state3) {
            if (state2.myUnresolvedPluginsCache == null) {
                ArrayList<MavenPlugin> result2 = new ArrayList<MavenPlugin>();
                for (MavenPlugin each : MavenProject.getDeclaredPlugins(state2)) {
                    if (MavenArtifactUtil.hasArtifactFile(state2.myLocalRepository, each.getMavenId())) continue;
                    result2.add(each);
                }
                state2.myUnresolvedPluginsCache = result2;
            }
            return state2.myUnresolvedPluginsCache;
        }
    }

    @NotNull
    public List<VirtualFile> getExistingModuleFiles() {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        Set<String> pathsInStack = this.getModulePaths();
        for (String each : pathsInStack) {
            VirtualFile f = fs.findFileByPath(each);
            if (f == null) continue;
            result2.add(f);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            MavenProject.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    @NotNull
    public Set<String> getModulePaths() {
        Set<String> set2 = this.getModulesPathsAndNames().keySet();
        if (set2 == null) {
            MavenProject.$$$reportNull$$$0(56);
        }
        return set2;
    }

    @NotNull
    public Map<String, String> getModulesPathsAndNames() {
        Map<String, String> map = this.myState.myModulesPathsAndNames;
        if (map == null) {
            MavenProject.$$$reportNull$$$0(57);
        }
        return map;
    }

    @NotNull
    public Collection<String> getProfilesIds() {
        Collection<String> collection = this.myState.myProfilesIds;
        if (collection == null) {
            MavenProject.$$$reportNull$$$0(58);
        }
        return collection;
    }

    @NotNull
    public MavenExplicitProfiles getActivatedProfilesIds() {
        MavenExplicitProfiles mavenExplicitProfiles = this.myState.myActivatedProfilesIds;
        if (mavenExplicitProfiles == null) {
            MavenProject.$$$reportNull$$$0(59);
        }
        return mavenExplicitProfiles;
    }

    @Nullable
    public String getDependencyHash() {
        return this.myState.myDependencyHash;
    }

    @NotNull
    public List<MavenArtifact> getDependencies() {
        List<MavenArtifact> list = this.myState.myDependencies;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(60);
        }
        return list;
    }

    @NotNull
    public List<MavenArtifact> getExternalAnnotationProcessors() {
        List<MavenArtifact> list = this.myState.myAnnotationProcessors;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(61);
        }
        return list;
    }

    @NotNull
    public List<MavenArtifactNode> getDependencyTree() {
        List<MavenArtifactNode> list = this.myState.myDependencyTree;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(62);
        }
        return list;
    }

    @NotNull
    public Set<String> getSupportedPackagings() {
        HashSet result2 = ContainerUtil.newHashSet((Object[])new String[]{"pom", "jar", "ejb", "ejb-client", "war", "ear", "bundle", "maven-plugin"});
        for (MavenImporter each : MavenImporter.getSuitableImporters(this)) {
            each.getSupportedPackagings(result2);
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            MavenProject.$$$reportNull$$$0(63);
        }
        return hashSet;
    }

    public Set<String> getDependencyTypesFromImporters(@NotNull SupportedRequestType type2) {
        if (type2 == null) {
            MavenProject.$$$reportNull$$$0(64);
        }
        HashSet<String> res = new HashSet<String>();
        for (MavenImporter each : MavenImporter.getSuitableImporters(this)) {
            each.getSupportedDependencyTypes(res, type2);
        }
        return res;
    }

    @NotNull
    public Set<String> getSupportedDependencyScopes() {
        HashSet result2 = ContainerUtil.newHashSet((Object[])new String[]{"compile", "provided", "runtime", "test", "system"});
        for (MavenImporter each : MavenImporter.getSuitableImporters(this)) {
            each.getSupportedDependencyScopes(result2);
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            MavenProject.$$$reportNull$$$0(65);
        }
        return hashSet;
    }

    public void addDependency(@NotNull MavenArtifact dependency) {
        if (dependency == null) {
            MavenProject.$$$reportNull$$$0(66);
        }
        this.addDependencies(List.of(dependency));
    }

    public void addDependencies(@NotNull Collection<MavenArtifact> dependencies) {
        if (dependencies == null) {
            MavenProject.$$$reportNull$$$0(67);
        }
        this.updateState((Consumer<State>)((Consumer)newState -> newState.myDependencies.addAll(dependencies)));
    }

    public void addAnnotationProcessors(@NotNull Collection<MavenArtifact> annotationProcessors) {
        if (annotationProcessors == null) {
            MavenProject.$$$reportNull$$$0(68);
        }
        this.updateState((Consumer<State>)((Consumer)newState -> newState.myAnnotationProcessors.addAll(annotationProcessors)));
    }

    @NotNull
    public List<MavenArtifact> findDependencies(@NotNull MavenProject depProject) {
        if (depProject == null) {
            MavenProject.$$$reportNull$$$0(69);
        }
        List<MavenArtifact> list = this.findDependencies(depProject.getMavenId());
        if (list == null) {
            MavenProject.$$$reportNull$$$0(70);
        }
        return list;
    }

    public List<MavenArtifact> findDependencies(@NotNull MavenId id) {
        if (id == null) {
            MavenProject.$$$reportNull$$$0(71);
        }
        return this.getDependencyArtifactIndex().findArtifacts(id);
    }

    @NotNull
    public List<MavenArtifact> findDependencies(@NonNls @Nullable String groupId, @NonNls @Nullable String artifactId) {
        List<MavenArtifact> list = this.getDependencyArtifactIndex().findArtifacts(groupId, artifactId);
        if (list == null) {
            MavenProject.$$$reportNull$$$0(72);
        }
        return list;
    }

    public boolean hasDependency(@NonNls @Nullable String groupId, @NonNls @Nullable String artifactId) {
        return this.getDependencyArtifactIndex().hasArtifact(groupId, artifactId);
    }

    public boolean hasUnresolvedArtifacts() {
        State state2 = this.myState;
        return !MavenProject.isParentResolved(state2) || !MavenProject.getUnresolvedDependencies(state2, null).isEmpty() || !MavenProject.getUnresolvedExtensions(state2).isEmpty() || !MavenProject.getUnresolvedAnnotationProcessors(state2).isEmpty();
    }

    public boolean hasUnresolvedPlugins() {
        return !MavenProject.getUnresolvedPlugins(this.myState).isEmpty();
    }

    @NotNull
    public List<MavenPlugin> getPlugins() {
        List<MavenPlugin> list = this.myState.myPlugins;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(73);
        }
        return list;
    }

    @NotNull
    public List<MavenPlugin> getDeclaredPlugins() {
        List<MavenPlugin> list = MavenProject.getDeclaredPlugins(this.myState);
        if (list == null) {
            MavenProject.$$$reportNull$$$0(74);
        }
        return list;
    }

    private static List<MavenPlugin> getDeclaredPlugins(State state2) {
        return ContainerUtil.findAll(state2.myPlugins, mavenPlugin -> !mavenPlugin.isDefault());
    }

    @Nullable
    public Element getPluginConfiguration(@Nullable String groupId, @Nullable String artifactId) {
        return this.getPluginGoalConfiguration(groupId, artifactId, null);
    }

    @Nullable
    public Element getPluginGoalConfiguration(@Nullable String groupId, @Nullable String artifactId, @Nullable String goal) {
        return this.getPluginGoalConfiguration(this.findPlugin(groupId, artifactId), goal);
    }

    @Nullable
    public Element getPluginGoalConfiguration(@Nullable MavenPlugin plugin, @Nullable String goal) {
        if (plugin == null) {
            return null;
        }
        return goal == null ? plugin.getConfigurationElement() : plugin.getGoalConfiguration(goal);
    }

    private Element getPluginExecutionConfiguration(@Nullable String groupId, @Nullable String artifactId, @NotNull String executionId) {
        MavenPlugin plugin;
        if (executionId == null) {
            MavenProject.$$$reportNull$$$0(75);
        }
        if ((plugin = this.findPlugin(groupId, artifactId)) == null) {
            return null;
        }
        return plugin.getExecutionConfiguration(executionId);
    }

    @NotNull
    private List<Element> getCompileExecutionConfigurations() {
        MavenPlugin plugin = this.findPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
        if (plugin == null) {
            List<Element> list = Collections.emptyList();
            if (list == null) {
                MavenProject.$$$reportNull$$$0(76);
            }
            return list;
        }
        List list = plugin.getCompileExecutionConfigurations();
        if (list == null) {
            MavenProject.$$$reportNull$$$0(77);
        }
        return list;
    }

    @Nullable
    public MavenPlugin findPlugin(@Nullable String groupId, @Nullable String artifactId) {
        return this.findPlugin(groupId, artifactId, false);
    }

    @Nullable
    public MavenPlugin findPlugin(@Nullable String groupId, @Nullable String artifactId, boolean explicitlyDeclaredOnly) {
        List<MavenPlugin> plugins = explicitlyDeclaredOnly ? this.getDeclaredPlugins() : this.getPlugins();
        for (MavenPlugin each : plugins) {
            if (!each.getMavenId().equals(groupId, artifactId)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public String getSourceEncoding() {
        return this.myState.myProperties.getProperty("project.build.sourceEncoding");
    }

    @Nullable
    public String getResourceEncoding(Project project2) {
        Element pluginConfiguration = this.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        if (pluginConfiguration != null) {
            String encoding = pluginConfiguration.getChildTextTrim("encoding");
            if (encoding == null) {
                return null;
            }
            if (encoding.startsWith("$")) {
                MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel(project2, this.getFile());
                if (domModel == null) {
                    MavenLog.LOG.warn("cannot get MavenDomProjectModel to find encoding");
                    return this.getSourceEncoding();
                }
                MavenPropertyResolver.resolve(encoding, domModel);
            } else {
                return encoding;
            }
        }
        return this.getSourceEncoding();
    }

    @Nullable
    public String getSourceLevel() {
        return this.getCompilerLevel("source");
    }

    @Nullable
    public String getTargetLevel() {
        return this.getCompilerLevel("target");
    }

    @Nullable
    public String getReleaseLevel() {
        return this.getCompilerLevel("release");
    }

    @Nullable
    public String getTestSourceLevel() {
        return this.getCompilerLevel("testSource");
    }

    @Nullable
    public String getTestTargetLevel() {
        return this.getCompilerLevel("testTarget");
    }

    @Nullable
    public String getTestReleaseLevel() {
        return this.getCompilerLevel("testRelease");
    }

    @Nullable
    private String getCompilerLevel(String level) {
        List<Element> configs = this.getCompilerConfigs();
        if (configs.size() == 1) {
            return this.getCompilerLevel(level, configs.get(0));
        }
        return configs.stream().map(element -> MavenJDOMUtil.findChildValueByPath(element, level)).filter(Objects::nonNull).map(propertyValue -> LanguageLevel.parse((String)propertyValue)).map(languageLevel -> languageLevel == null ? LanguageLevel.HIGHEST : languageLevel).max(Comparator.naturalOrder()).map(l -> l.toJavaVersion().toFeatureString()).orElseGet(() -> this.myState.myProperties.getProperty("maven.compiler." + level));
    }

    private String getCompilerLevel(String level, Element config) {
        String result2 = MavenJDOMUtil.findChildValueByPath(config, level);
        if (result2 == null) {
            result2 = this.myState.myProperties.getProperty("maven.compiler." + level);
        }
        return result2;
    }

    @Nullable
    private Element getCompilerConfig() {
        Element executionConfiguration = this.getPluginExecutionConfiguration("org.apache.maven.plugins", "maven-compiler-plugin", "default-compile");
        if (executionConfiguration != null) {
            return executionConfiguration;
        }
        return this.getPluginConfiguration("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    @NotNull
    private List<Element> getCompilerConfigs() {
        List<Element> configurations = this.getCompileExecutionConfigurations();
        if (!configurations.isEmpty()) {
            List<Element> list = configurations;
            if (list == null) {
                MavenProject.$$$reportNull$$$0(78);
            }
            return list;
        }
        Element configuration = this.getPluginConfiguration("org.apache.maven.plugins", "maven-compiler-plugin");
        List list = ContainerUtil.createMaybeSingletonList((Object)configuration);
        if (list == null) {
            MavenProject.$$$reportNull$$$0(79);
        }
        return list;
    }

    @NotNull
    public Properties getProperties() {
        Properties properties = this.myState.myProperties;
        if (properties == null) {
            MavenProject.$$$reportNull$$$0(80);
        }
        return properties;
    }

    @NotNull
    public Map<String, String> getMavenConfig() {
        return this.getPropertiesFromConfig(ConfigFileKind.MAVEN_CONFIG);
    }

    @NotNull
    private Map<String, String> getPropertiesFromConfig(ConfigFileKind kind) {
        Map<String, String> mavenConfig = this.getCachedValue(kind.CACHE_KEY);
        if (mavenConfig == null) {
            mavenConfig = MavenProject.readConfigFile(MavenUtil.getBaseDir(this.getDirectoryFile()).toFile(), kind);
            this.putCachedValue(kind.CACHE_KEY, mavenConfig);
        }
        Map<String, String> map = mavenConfig;
        if (map == null) {
            MavenProject.$$$reportNull$$$0(81);
        }
        return map;
    }

    @NotNull
    public Map<String, String> getJvmConfig() {
        return this.getPropertiesFromConfig(ConfigFileKind.JVM_CONFIG);
    }

    @NotNull
    public static Map<String, String> readConfigFile(File baseDir2, ConfigFileKind kind) {
        Map config;
        File configFile = new File(baseDir2 + FileUtil.toSystemDependentName((String)kind.myRelativeFilePath));
        ParametersList parametersList = new ParametersList();
        if (configFile.isFile()) {
            try {
                parametersList.addParametersString(FileUtil.loadFile((File)configFile, (String)"UTF-8"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Map map = (config = parametersList.getProperties(kind.myValueIfMissing)).isEmpty() ? Collections.emptyMap() : config;
        if (map == null) {
            MavenProject.$$$reportNull$$$0(82);
        }
        return map;
    }

    @NotNull
    public File getLocalRepository() {
        File file = this.myState.myLocalRepository;
        if (file == null) {
            MavenProject.$$$reportNull$$$0(83);
        }
        return file;
    }

    @NotNull
    public List<MavenRemoteRepository> getRemoteRepositories() {
        List<MavenRemoteRepository> list = this.myState.myRemoteRepositories;
        if (list == null) {
            MavenProject.$$$reportNull$$$0(84);
        }
        return list;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public ModuleType<? extends ModuleBuilder> getModuleType() {
        List<MavenImporter> importers = MavenImporter.getSuitableImporters(this);
        ModuleType<? extends ModuleBuilder> moduleType = importers.size() > 0 ? importers.get(0).getModuleType() : StdModuleTypes.JAVA;
        if (moduleType == null) {
            MavenProject.$$$reportNull$$$0(85);
        }
        return moduleType;
    }

    @NotNull
    public Pair<String, String> getClassifierAndExtension(@NotNull MavenArtifact artifact, @NotNull MavenExtraArtifactType type2) {
        if (artifact == null) {
            MavenProject.$$$reportNull$$$0(86);
        }
        if (type2 == null) {
            MavenProject.$$$reportNull$$$0(87);
        }
        for (MavenImporter each : MavenImporter.getSuitableImporters(this)) {
            Pair<String, String> result2 = each.getExtraArtifactClassifierAndExtension(artifact, type2);
            if (result2 == null) continue;
            Pair<String, String> pair = result2;
            if (pair == null) {
                MavenProject.$$$reportNull$$$0(88);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)type2.getDefaultClassifier(), (Object)type2.getDefaultExtension());
        if (pair == null) {
            MavenProject.$$$reportNull$$$0(89);
        }
        return pair;
    }

    public MavenArtifactIndex getDependencyArtifactIndex() {
        MavenArtifactIndex res = this.getCachedValue(DEPENDENCIES_CACHE_KEY);
        if (res == null) {
            res = MavenArtifactIndex.build(this.getDependencies());
            res = this.putCachedValue(DEPENDENCIES_CACHE_KEY, res);
        }
        return res;
    }

    @Nullable
    public <V> V getCachedValue(Key<V> key) {
        Object v = this.myState.myCache.get(key);
        return (V)v;
    }

    @NotNull
    public <V> V putCachedValue(Key<V> key, @NotNull V value) {
        Object oldValue;
        if (value == null) {
            MavenProject.$$$reportNull$$$0(90);
        }
        if ((oldValue = this.myState.myCache.putIfAbsent(key, value)) != null) {
            Object v;
            Object object = v = oldValue;
            if (object == null) {
                MavenProject.$$$reportNull$$$0(91);
            }
            return (V)object;
        }
        V v = value;
        if (v == null) {
            MavenProject.$$$reportNull$$$0(92);
        }
        return v;
    }

    public String toString() {
        return null == this.myState.myMavenId ? this.myFile.getPath() : this.getMavenId().toString();
    }

    public Updater updater() {
        return new Updater();
    }

    private static /* synthetic */ boolean lambda$collectModulesRelativePathsAndNames$0(String finalName, String ext) {
        return finalName.endsWith("." + ext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 13, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 65, 70, 72, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 88, 89, 91, 92 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readerResult";
                break;
            }
            case 3: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 88: 
            case 89: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProject";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readingProblems";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activatedProfiles";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedArtifactIds";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeModelMap";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 64: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationProcessors";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProject";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionId";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateFromReaderResult";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "updateState";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelMap";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenId";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackaging";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildDirectory";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSourcesDirectory";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessorDirectory";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcMode";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputDirectory";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestOutputDirectory";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestSources";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestResources";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblems";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProblems";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheProblems";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingModuleFiles";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePaths";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesPathsAndNames";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilesIds";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivatedProfilesIds";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalAnnotationProcessors";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyTree";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedPackagings";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedDependencyScopes";
                break;
            }
            case 70: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencies";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredPlugins";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileExecutionConfigurations";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerConfigs";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFromConfig";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "readConfigFile";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepository";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteRepositories";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierAndExtension";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "putCachedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateFromReaderResult";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 88: 
            case 89: 
            case 91: 
            case 92: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateState";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateState";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getChangesSinceSnapshot";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyTypesFromImporters";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "addDependencies";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotationProcessors";
                break;
            }
            case 69: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "findDependencies";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getPluginExecutionConfiguration";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getClassifierAndExtension";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "putCachedValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 11, 13, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 65, 70, 72, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 88, 89, 91, 92 -> new IllegalStateException(string);
        };
    }

    private static class State
    implements Cloneable,
    Serializable {
        long myLastReadStamp = 0L;
        MavenId myMavenId;
        MavenId myParentId;
        String myPackaging;
        String myName;
        String myFinalName;
        String myDefaultGoal;
        String myBuildDirectory;
        String myOutputDirectory;
        String myTestOutputDirectory;
        List<String> mySources;
        List<String> myTestSources;
        List<MavenResource> myResources;
        List<MavenResource> myTestResources;
        List<String> myFilters;
        Properties myProperties;
        List<MavenPlugin> myPlugins;
        List<MavenArtifact> myExtensions;
        List<MavenArtifact> myDependencies;
        List<MavenArtifactNode> myDependencyTree;
        List<MavenRemoteRepository> myRemoteRepositories;
        List<MavenArtifact> myAnnotationProcessors;
        Map<String, String> myModulesPathsAndNames;
        Map<String, String> myModelMap;
        Collection<String> myProfilesIds;
        MavenExplicitProfiles myActivatedProfilesIds;
        String myDependencyHash;
        Collection<MavenProjectProblem> myReadingProblems;
        Set<MavenId> myUnresolvedArtifactIds;
        File myLocalRepository;
        volatile List<MavenProjectProblem> myProblemsCache;
        volatile List<MavenArtifact> myUnresolvedDependenciesCache;
        volatile List<MavenPlugin> myUnresolvedPluginsCache;
        volatile List<MavenArtifact> myUnresolvedExtensionsCache;
        volatile List<MavenArtifact> myUnresolvedAnnotationProcessors;
        transient ConcurrentHashMap<Key<?>, Object> myCache = new ConcurrentHashMap();

        private State() {
        }

        public State clone() {
            try {
                State result2 = (State)super.clone();
                this.myCache = new ConcurrentHashMap();
                result2.resetCache();
                return result2;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        private void resetCache() {
            this.myProblemsCache = null;
            this.myUnresolvedDependenciesCache = null;
            this.myUnresolvedPluginsCache = null;
            this.myUnresolvedExtensionsCache = null;
            this.myUnresolvedAnnotationProcessors = null;
            this.myCache.clear();
        }

        public MavenProjectChanges getChanges(State newState) {
            if (this.myLastReadStamp == 0L) {
                return MavenProjectChanges.ALL;
            }
            MavenProjectChangesBuilder result2 = new MavenProjectChangesBuilder();
            result2.setHasPackagingChanges(!Objects.equals(this.myPackaging, newState.myPackaging));
            result2.setHasOutputChanges(!Objects.equals(this.myFinalName, newState.myFinalName) || !Objects.equals(this.myBuildDirectory, newState.myBuildDirectory) || !Objects.equals(this.myOutputDirectory, newState.myOutputDirectory) || !Objects.equals(this.myTestOutputDirectory, newState.myTestOutputDirectory));
            result2.setHasSourceChanges(!Comparing.equal(this.mySources, newState.mySources) || !Comparing.equal(this.myTestSources, newState.myTestSources) || !Comparing.equal(this.myResources, newState.myResources) || !Comparing.equal(this.myTestResources, newState.myTestResources));
            boolean repositoryChanged = !Comparing.equal((Object)this.myLocalRepository, (Object)newState.myLocalRepository);
            result2.setHasDependencyChanges(repositoryChanged || !Comparing.equal(this.myDependencies, newState.myDependencies));
            result2.setHasPluginChanges(repositoryChanged || !Comparing.equal(this.myPlugins, newState.myPlugins));
            result2.setHasPropertyChanges(!Comparing.equal((Object)this.myProperties, (Object)newState.myProperties));
            return result2;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.myCache = new ConcurrentHashMap();
        }
    }

    static class Snapshot {
        @NotNull
        private final State myState;

        private Snapshot(@NotNull State state2) {
            if (state2 == null) {
                Snapshot.$$$reportNull$$$0(0);
            }
            this.myState = state2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/idea/maven/project/MavenProject$Snapshot", "<init>"));
        }
    }

    public static enum ProcMode {
        BOTH,
        ONLY,
        NONE;

    }

    public static enum ConfigFileKind {
        MAVEN_CONFIG("/.mvn/maven.config", "true"),
        JVM_CONFIG("/.mvn/jvm.config", "");

        final Key<Map<String, String>> CACHE_KEY = Key.create((String)("MavenProject." + this.name()));
        final String myRelativeFilePath;
        final String myValueIfMissing;

        private ConfigFileKind(String relativeFilePath, String valueIfMissing) {
            this.myRelativeFilePath = relativeFilePath;
            this.myValueIfMissing = valueIfMissing;
        }
    }

    public class Updater {
        public Updater setDependencies(@NotNull List<MavenArtifact> dependencies) {
            if (dependencies == null) {
                Updater.$$$reportNull$$$0(0);
            }
            MavenProject.this.myState.myDependencies = dependencies;
            return this;
        }

        public Updater setProperties(@NotNull Properties properties) {
            if (properties == null) {
                Updater.$$$reportNull$$$0(1);
            }
            MavenProject.this.myState.myProperties = properties;
            return this;
        }

        public Updater setPlugins(@NotNull List<MavenPlugin> plugins) {
            if (plugins == null) {
                Updater.$$$reportNull$$$0(2);
            }
            MavenProject.this.myState.myPlugins.clear();
            MavenProject.this.myState.myPlugins.addAll(plugins);
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plugins";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProject$Updater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setDependencies";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProperties";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPlugins";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

