/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.navigator.structure.DependencyNode;
import org.jetbrains.idea.maven.navigator.structure.GroupNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.project.MavenProject;

abstract class BaseDependenciesNode
extends GroupNode {
    protected final MavenProject myMavenProject;
    private final List<DependencyNode> myChildren = new CopyOnWriteArrayList<DependencyNode>();
    private final AtomicReference<ChildrenUpdate> myChildrenUpdate = new AtomicReference();

    protected BaseDependenciesNode(MavenProjectsStructure structure, MavenSimpleNode parent, MavenProject mavenProject2) {
        super(structure, parent);
        this.myMavenProject = mavenProject2;
    }

    public MavenProject getMavenProject() {
        return this.myMavenProject;
    }

    @Override
    public boolean isVisible() {
        ChildrenUpdate childrenUpdate = this.myChildrenUpdate.get();
        if (null != childrenUpdate) {
            return !childrenUpdate.children.isEmpty();
        }
        return !this.myChildren.isEmpty();
    }

    private static boolean hasUnresolvedFile(MavenArtifactNode mavenArtifactNode) {
        if (mavenArtifactNode.getArtifact().isFileUnresolved()) {
            return true;
        }
        for (MavenArtifactNode dependency : mavenArtifactNode.getDependencies()) {
            if (!BaseDependenciesNode.hasUnresolvedFile(dependency)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MavenProjectsStructure.ErrorLevel getChildrenErrorLevel() {
        ChildrenUpdate childrenUpdate = this.myChildrenUpdate.get();
        if (null != childrenUpdate) {
            if (ContainerUtil.exists(childrenUpdate.children, mavenArtifactNode -> BaseDependenciesNode.hasUnresolvedFile(mavenArtifactNode))) {
                return MavenProjectsStructure.ErrorLevel.ERROR;
            }
            return MavenProjectsStructure.ErrorLevel.NONE;
        }
        return super.getChildrenErrorLevel();
    }

    @Override
    protected List<? extends MavenSimpleNode> doGetChildren() {
        ChildrenUpdate childrenUpdate = this.myChildrenUpdate.getAndSet(null);
        if (null != childrenUpdate) {
            this.doUpdateChildren(childrenUpdate);
        }
        return this.myChildren;
    }

    protected void updateChildren(List<MavenArtifactNode> children, MavenProject mavenProject2) {
        this.myChildrenUpdate.set(new ChildrenUpdate(children, mavenProject2));
        this.childrenChanged();
    }

    private void doUpdateChildren(ChildrenUpdate childrenUpdate) {
        List<MavenArtifactNode> children = childrenUpdate.children();
        MavenProject mavenProject2 = childrenUpdate.mavenProject();
        ArrayList<DependencyNode> newNodes = null;
        int validChildCount = 0;
        for (MavenArtifactNode each : children) {
            if (each.getState() != MavenArtifactState.ADDED && each.getState() != MavenArtifactState.CONFLICT && each.getState() != MavenArtifactState.DUPLICATE) continue;
            if (newNodes == null) {
                DependencyNode currentValidNode;
                if (validChildCount < this.myChildren.size() && (currentValidNode = this.myChildren.get(validChildCount)).getArtifact().equals((Object)each.getArtifact()) && currentValidNode.isUnresolved() == each.getArtifact().isFileUnresolved()) {
                    if (each.getState() == MavenArtifactState.ADDED) {
                        currentValidNode.updateChildren(each.getDependencies(), mavenProject2);
                    }
                    ++validChildCount;
                    continue;
                }
                newNodes = new ArrayList(children.size());
                newNodes.addAll(this.myChildren.subList(0, validChildCount));
            }
            DependencyNode newNode = this.findOrCreateNodeFor(each, mavenProject2, validChildCount);
            newNodes.add(newNode);
            if (each.getState() == MavenArtifactState.ADDED) {
                newNode.updateChildren(each.getDependencies(), mavenProject2);
            }
            newNode.updateDependency();
        }
        if (newNodes == null) {
            if (validChildCount == this.myChildren.size()) {
                return;
            }
            assert (validChildCount < this.myChildren.size());
            newNodes = new ArrayList<DependencyNode>(this.myChildren.subList(0, validChildCount));
        }
        this.myChildren.clear();
        this.myChildren.addAll(newNodes);
        this.childrenChanged();
    }

    private DependencyNode findOrCreateNodeFor(MavenArtifactNode artifact, MavenProject mavenProject2, int from) {
        for (int i2 = from; i2 < this.myChildren.size(); ++i2) {
            DependencyNode node2 = this.myChildren.get(i2);
            if (!node2.getArtifact().equals((Object)artifact.getArtifact()) || node2.isUnresolved() != artifact.getArtifact().isFileUnresolved()) continue;
            return node2;
        }
        return new DependencyNode(this.myMavenProjectsStructure, this, artifact, mavenProject2, artifact.getArtifact().isFileUnresolved());
    }

    @Override
    String getMenuId() {
        return "Maven.DependencyMenu";
    }

    private record ChildrenUpdate(List<MavenArtifactNode> children, MavenProject mavenProject) {
    }
}

