/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexHolder;
import org.jetbrains.idea.maven.indices.MavenIndexUtils;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.model.RepositoryKind;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.reposearch.DependencySearchService;

@ApiStatus.Internal
public class MavenIndices
implements Disposable {
    public static final String LOCAL_REPOSITORY_ID = "local";
    private static final Object ourDirectoryLock = new Object();
    private final MavenIndexerWrapper myIndexer;
    private final File myIndicesDir;
    private final Project myProject;
    @NotNull
    private volatile MavenIndexHolder myIndexHolder = new MavenIndexHolder(Collections.emptyList(), null);
    private volatile boolean indicesInit;
    private volatile boolean isDisposed;
    private final ReentrantLock updateIndicesLock = new ReentrantLock();

    public MavenIndices(MavenIndexerWrapper indexer, File indicesDir, Project project2) {
        this.myIndexer = indexer;
        this.myIndicesDir = indicesDir;
        this.myProject = project2;
    }

    public boolean isIndicesInit() {
        return this.indicesInit;
    }

    public boolean isNotInit() {
        return !this.indicesInit;
    }

    private static List<MavenIndex> getOldIndices(@NotNull RepositoryDiff<MavenIndex> localDiff, @NotNull RepositoryDiff<List<MavenIndex>> remoteDiff) {
        if (localDiff == null) {
            MavenIndices.$$$reportNull$$$0(0);
        }
        if (remoteDiff == null) {
            MavenIndices.$$$reportNull$$$0(1);
        }
        ArrayList<MavenIndex> oldIndices = new ArrayList<MavenIndex>((Collection)remoteDiff.oldIndices);
        if (localDiff.oldIndices != null) {
            oldIndices.add((MavenIndex)localDiff.oldIndices);
        }
        return oldIndices;
    }

    @NotNull
    private static List<MavenIndexUtils.IndexPropertyHolder> readCurrentIndexFileProperty(@NotNull File indicesDir) {
        Object[] indices;
        if (indicesDir == null) {
            MavenIndices.$$$reportNull$$$0(2);
        }
        if ((indices = indicesDir.listFiles()) == null) {
            List<MavenIndexUtils.IndexPropertyHolder> list = Collections.emptyList();
            if (list == null) {
                MavenIndices.$$$reportNull$$$0(3);
            }
            return list;
        }
        Arrays.sort(indices);
        ArrayList<MavenIndexUtils.IndexPropertyHolder> result2 = new ArrayList<MavenIndexUtils.IndexPropertyHolder>();
        for (Object each : indices) {
            if (!((File)each).isDirectory()) continue;
            try {
                MavenIndexUtils.IndexPropertyHolder propertyHolder = MavenIndexUtils.readIndexProperty((File)each);
                result2.add(propertyHolder);
            }
            catch (Exception e) {
                FileUtil.delete((File)each);
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        ArrayList<MavenIndexUtils.IndexPropertyHolder> arrayList = result2;
        if (arrayList == null) {
            MavenIndices.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public List<MavenIndex> getIndices() {
        return this.myIndexHolder.getIndices();
    }

    @NotNull
    public MavenIndexHolder getIndexHolder() {
        if (this.isDisposed) {
            throw new AlreadyDisposedException("Index was already disposed");
        }
        MavenIndexHolder mavenIndexHolder = this.myIndexHolder;
        if (mavenIndexHolder == null) {
            MavenIndices.$$$reportNull$$$0(5);
        }
        return mavenIndexHolder;
    }

    @NotNull
    private static File createNewIndexDir(File parent) {
        return MavenIndices.createNewDir(parent, "Index", 1000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static File createNewDir(File parent, String prefix, int max) {
        Object object = ourDirectoryLock;
        synchronized (object) {
            int i2 = 0;
            while (true) {
                boolean createSuccessFull;
                if (i2 >= max) {
                    throw new RuntimeException("No available dir found");
                }
                String name = prefix + i2;
                File f = new File(parent, name);
                if (!f.exists() && (createSuccessFull = f.mkdirs())) {
                    File file = f;
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 5] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (file == null) {
                        MavenIndices.$$$reportNull$$$0(6);
                    }
                    return file;
                }
                ++i2;
            }
        }
    }

    public void dispose() {
        this.isDisposed = true;
        MavenIndices.closeIndices(this.myIndexHolder.getIndices());
        this.myIndexHolder = null;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    private static void closeIndices(@NotNull List<MavenIndex> indices) {
        if (indices == null) {
            MavenIndices.$$$reportNull$$$0(7);
        }
        ArrayList<MavenIndex> list = new ArrayList<MavenIndex>(indices);
        for (MavenIndex each : list) {
            try {
                each.close(false);
            }
            catch (Exception e) {
                MavenLog.LOG.error("indices dispose error", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    @NotNull
    static RepositoryDiff<MavenIndex> getLocalDiff(@NotNull MavenRepositoryInfo localRepo, @NotNull RepositoryDiffContext context2, @Nullable MavenIndex currentLocalIndex) {
        if (localRepo == null) {
            MavenIndices.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            MavenIndices.$$$reportNull$$$0(9);
        }
        if (currentLocalIndex != null && FileUtil.pathsEqual((String)localRepo.getUrl(), (String)currentLocalIndex.getRepository().getUrl())) {
            return new RepositoryDiff<Object>(currentLocalIndex, null);
        }
        MavenIndex index = MavenIndices.createMavenIndex(LOCAL_REPOSITORY_ID, localRepo.getUrl(), RepositoryKind.LOCAL);
        return new RepositoryDiff<MavenIndex>(index, currentLocalIndex);
    }

    @VisibleForTesting
    @NotNull
    static RepositoryDiff<List<MavenIndex>> getRemoteDiff(@NotNull Map<String, Set<String>> remoteRepositoryIdsByUrl, @NotNull List<MavenIndex> currentRemoteIndex, @NotNull RepositoryDiffContext context2) {
        Map currentRemoteIndicesByUrls;
        if (remoteRepositoryIdsByUrl == null) {
            MavenIndices.$$$reportNull$$$0(10);
        }
        if (currentRemoteIndex == null) {
            MavenIndices.$$$reportNull$$$0(11);
        }
        if (context2 == null) {
            MavenIndices.$$$reportNull$$$0(12);
        }
        if ((currentRemoteIndicesByUrls = currentRemoteIndex.stream().collect(Collectors.toMap(i2 -> i2.getRepository().getUrl(), Function.identity()))).keySet().equals(remoteRepositoryIdsByUrl.keySet())) {
            return new RepositoryDiff<List<MavenIndex>>(currentRemoteIndex, Collections.emptyList());
        }
        List oldIndices = ContainerUtil.filter(currentRemoteIndex, i2 -> !remoteRepositoryIdsByUrl.containsKey(i2.getRepository().getUrl()));
        List newMavenIndices = ContainerUtil.map(remoteRepositoryIdsByUrl.entrySet(), e -> {
            MavenIndex oldIndex = (MavenIndex)currentRemoteIndicesByUrls.get(e.getKey());
            if (oldIndex != null) {
                return oldIndex;
            }
            String id = (String)((Set)e.getValue()).iterator().next();
            return MavenIndices.createMavenIndex(id, (String)e.getKey(), RepositoryKind.REMOTE);
        });
        return new RepositoryDiff<List<MavenIndex>>(newMavenIndices, oldIndices);
    }

    private static void clearDependencySearchCache(@NotNull Project project2) {
        if (project2 == null) {
            MavenIndices.$$$reportNull$$$0(13);
        }
        try {
            DependencySearchService.getInstance((Project)project2).clearCache();
        }
        catch (AlreadyDisposedException alreadyDisposedException) {
            // empty catch block
        }
    }

    @NotNull
    private static MavenIndex createMavenIndex(@NotNull String id, @NotNull String repositoryPathOrUrl, RepositoryKind repositoryKind) {
        if (id == null) {
            MavenIndices.$$$reportNull$$$0(14);
        }
        if (repositoryPathOrUrl == null) {
            MavenIndices.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDiff";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteDiff";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicesDir";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndices";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRepo";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositoryIdsByUrl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRemoteIndex";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryPathOrUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndices";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readCurrentIndexFileProperty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexHolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOldIndices";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readCurrentIndexFileProperty";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "closeIndices";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLocalDiff";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteDiff";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearDependencySearchCache";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createMavenIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    static class RepositoryDiff<T> {
        final T newIndices;
        final T oldIndices;

        private RepositoryDiff(T newIndices, T oldIndices) {
            this.newIndices = newIndices;
            this.oldIndices = oldIndices;
        }
    }

    static class RepositoryDiffContext {
        @NotNull
        final MavenIndexerWrapper indexer;
        @NotNull
        final File indicesDir;
        @Nullable
        List<MavenIndexUtils.IndexPropertyHolder> indexPropertyHolders;

        RepositoryDiffContext(@NotNull MavenIndexerWrapper indexer, @NotNull File dir2) {
            if (indexer == null) {
                RepositoryDiffContext.$$$reportNull$$$0(0);
            }
            if (dir2 == null) {
                RepositoryDiffContext.$$$reportNull$$$0(1);
            }
            this.indexer = indexer;
            this.indicesDir = dir2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dir";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/indices/MavenIndices$RepositoryDiffContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class UpdateRepositoryResult {
        List<MavenIndex> mavenIndexreated;

        UpdateRepositoryResult() {
        }
    }
}

