/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.welcome;

import com.intellij.llmInstaller.AIAssistantContentExtension;
import com.intellij.llmInstaller.LLMIcons;
import com.intellij.llmInstaller.LLMInstallerBundle;
import com.intellij.llmInstaller.ui.welcome.BaseWelcomePanel;
import com.intellij.llmInstaller.ui.welcome.FeatureWelcomePanel;
import com.intellij.llmInstaller.ui.welcome.NavigationType;
import com.intellij.llmInstaller.ui.welcome.WelcomeFeatureSelectedAction;
import com.intellij.llmInstaller.ui.welcome.WelcomeFeaturesOrderedNavigationService;
import com.intellij.llmInstaller.ui.welcome.features.WelcomeFeatureDescriptor;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.InlineBanner;
import com.intellij.ui.WebAnimationUtils;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.EmptySpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsYKt;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Base64;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel;", "Lcom/intellij/llmInstaller/ui/welcome/BaseWelcomePanel;", "project", "Lcom/intellij/openapi/project/Project;", "featureDescriptor", "Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;", "index", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;I)V", "createAnimation", "Ljavax/swing/JComponent;", "videoBytes", "", "createBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "createContent", "createDescription", "Lcom/intellij/ui/components/JBHtmlPane;", "getDefaultComponent", "llmInstallerIconsProvider", "Ljavax/swing/Icon;", "key", "", "EditorPaneWrapper", "ScalableWrapper", "intellij.llmInstaller"})
@ApiStatus.Experimental
public final class FeatureWelcomePanel
extends BaseWelcomePanel {
    @NotNull
    private final WelcomeFeatureDescriptor featureDescriptor;
    private final int index;

    public FeatureWelcomePanel(@NotNull Project project, @NotNull WelcomeFeatureDescriptor featureDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)featureDescriptor, (String)"featureDescriptor");
        super(project);
        this.featureDescriptor = featureDescriptor;
        this.index = index;
    }

    @Override
    @NotNull
    protected JComponent createContent() {
        DialogPanel dialogPanel;
        DialogPanel $this$createContent_u24lambda_u240 = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ FeatureWelcomePanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new EmptySpacingConfiguration(), (Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ FeatureWelcomePanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$customizeSpacingConfiguration) {
                        byte[] it;
                        FeatureWelcomePanel featureWelcomePanel;
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
                        byte[] byArray = FeatureWelcomePanel.access$getFeatureDescriptor$p(this.this$0).getWebmPreviewData();
                        if (byArray != null) {
                            object = byArray;
                            featureWelcomePanel = this.this$0;
                            it = object;
                            boolean bl = false;
                            JComponent animationComponent = FeatureWelcomePanel.access$createAnimation(featureWelcomePanel, it);
                            Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(animationComponent){
                                final /* synthetic */ JComponent $animationComponent;
                                {
                                    this.$animationComponent = $animationComponent;
                                    super(1);
                                }

                                public final void invoke(@NotNull Row $this$row) {
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                    JBDimension minSize = new JBDimension(50, 10);
                                    ScalableWrapper wrapper = new ScalableWrapper(this.$animationComponent, 1.7777777777777777, minSize);
                                    $this$row.cell((JComponent)wrapper).align((Align)AlignX.FILL.INSTANCE);
                                }
                            }), (int)1, null);
                        }
                        this.this$0.title($this$customizeSpacingConfiguration, FeatureWelcomePanel.access$getFeatureDescriptor$p(this.this$0).getTitle());
                        String string = FeatureWelcomePanel.access$getFeatureDescriptor$p(this.this$0).getDescription().getAsHtml();
                        if (string != null) {
                            object = string;
                            featureWelcomePanel = this.this$0;
                            it = object;
                            boolean bl = false;
                            Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(featureWelcomePanel, (String)it){
                                final /* synthetic */ FeatureWelcomePanel this$0;
                                final /* synthetic */ String $it;
                                {
                                    this.this$0 = $receiver;
                                    this.$it = $it;
                                    super(1);
                                }

                                public final void invoke(@NotNull Row $this$row) {
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                    EditorPaneWrapper wrapper = new EditorPaneWrapper((JEditorPane)FeatureWelcomePanel.access$createDescription(this.this$0), this.$it);
                                    $this$row.cell((JComponent)wrapper).align((Align)AlignX.FILL.INSTANCE);
                                }
                            }), (int)1, null);
                        }
                        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ FeatureWelcomePanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                block1: {
                                    Pair<WelcomeFeatureDescriptor, Integer> pair;
                                    FeatureWelcomePanel featureWelcomePanel;
                                    Pair<WelcomeFeatureDescriptor, Integer> pair2;
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                    WelcomeFeaturesOrderedNavigationService navigationService = WelcomeFeaturesOrderedNavigationService.Companion.getInstance(FeatureWelcomePanel.access$getProject(this.this$0));
                                    Pair<WelcomeFeatureDescriptor, Integer> pair3 = navigationService.getPreviousFeature(FeatureWelcomePanel.access$getIndex$p(this.this$0));
                                    if (pair3 != null) {
                                        pair2 = pair3;
                                        featureWelcomePanel = this.this$0;
                                        pair = pair2;
                                        boolean bl = false;
                                        WelcomeFeatureDescriptor previousFeature = (WelcomeFeatureDescriptor)pair.component1();
                                        int previousFeatureIndex = ((Number)pair.component2()).intValue();
                                        $this$row.button(LLMInstallerBundle.INSTANCE.message("welcome.previous.feature.button", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(featureWelcomePanel, previousFeature, previousFeatureIndex){
                                            final /* synthetic */ FeatureWelcomePanel this$0;
                                            final /* synthetic */ WelcomeFeatureDescriptor $previousFeature;
                                            final /* synthetic */ int $previousFeatureIndex;
                                            {
                                                this.this$0 = $receiver;
                                                this.$previousFeature = $previousFeature;
                                                this.$previousFeatureIndex = $previousFeatureIndex;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull ActionEvent it) {
                                                block0: {
                                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                    WelcomeFeatureSelectedAction welcomeFeatureSelectedAction = this.this$0.getOnFeatureSelected();
                                                    if (welcomeFeatureSelectedAction == null) break block0;
                                                    welcomeFeatureSelectedAction.onFeatureSelected(this.$previousFeature, this.$previousFeatureIndex, this.this$0.getClass(), NavigationType.PREVIOUS);
                                                }
                                            }
                                        }).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)6, (int)7, null));
                                    }
                                    Pair<WelcomeFeatureDescriptor, Integer> pair4 = navigationService.getNextFeature(FeatureWelcomePanel.access$getIndex$p(this.this$0));
                                    if (pair4 == null) break block1;
                                    pair2 = pair4;
                                    featureWelcomePanel = this.this$0;
                                    pair = pair2;
                                    boolean bl = false;
                                    WelcomeFeatureDescriptor nextFeature = (WelcomeFeatureDescriptor)pair.component1();
                                    int nextFeatureIndex = ((Number)pair.component2()).intValue();
                                    Object[] objectArray = new Object[]{nextFeature.getTitle()};
                                    $this$row.button(LLMInstallerBundle.INSTANCE.message("welcome.next.feature.button", objectArray), (Function1)new Function1<ActionEvent, Unit>(featureWelcomePanel, nextFeature, nextFeatureIndex){
                                        final /* synthetic */ FeatureWelcomePanel this$0;
                                        final /* synthetic */ WelcomeFeatureDescriptor $nextFeature;
                                        final /* synthetic */ int $nextFeatureIndex;
                                        {
                                            this.this$0 = $receiver;
                                            this.$nextFeature = $nextFeature;
                                            this.$nextFeatureIndex = $nextFeatureIndex;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull ActionEvent it) {
                                            block0: {
                                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                WelcomeFeatureSelectedAction welcomeFeatureSelectedAction = this.this$0.getOnFeatureSelected();
                                                if (welcomeFeatureSelectedAction == null) break block0;
                                                welcomeFeatureSelectedAction.onFeatureSelected(this.$nextFeature, this.$nextFeatureIndex, this.this$0.getClass(), NavigationType.NEXT);
                                            }
                                        }
                                    });
                                }
                            }
                        }), (int)1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)24, (int)0, (int)2, null));
                        if (CollectionsKt.firstOrNull((List)AIAssistantContentExtension.Companion.getEP_NAME().getExtensionList()) == null) {
                            Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                                final /* synthetic */ FeatureWelcomePanel this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke(@NotNull Row $this$row) {
                                    void $this$invoke_u24lambda_u241;
                                    InlineBanner inlineBanner2;
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                    InlineBanner inlineBanner3 = inlineBanner2 = new InlineBanner(LLMInstallerBundle.INSTANCE.message("welcome.install.plugin.banner.message", new Object[0]), null, 2, null).setIcon(null).addAction(LLMInstallerBundle.INSTANCE.message("welcome.install.plugin.banner.action", new Object[0]), () -> createContent.4.invoke$lambda$0(this.this$0));
                                    Row row = $this$row;
                                    boolean bl = false;
                                    $this$invoke_u24lambda_u241.showCloseButton(false);
                                    row.cell((JComponent)inlineBanner2).align((Align)AlignX.FILL.INSTANCE).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)12, (int)0, (int)12, (int)5, null)).visibleIf(ComponentPredicate.Companion.fromObservableProperty$default((ComponentPredicate.Companion)ComponentPredicate.Companion, (ObservableProperty)PropertyOperationUtil.transform((ObservableProperty)((ObservableProperty)this.this$0.getOnInstallPlugin()), (Function1)createContent.3.INSTANCE), null, (int)2, null));
                                }

                                private static final void invoke$lambda$0(FeatureWelcomePanel this$0) {
                                    block0: {
                                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                        Runnable runnable = (Runnable)this$0.getOnInstallPlugin().get();
                                        if (runnable == null) break block0;
                                        runnable.run();
                                    }
                                }
                            }), (int)1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)36, (int)0, (int)2, null));
                        }
                    }
                });
            }
        }));
        boolean bl = false;
        $this$createContent_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)20, (int)20, (int)22, (int)20));
        return (JComponent)dialogPanel;
    }

    @Override
    @Nullable
    public JComponent getDefaultComponent() {
        return null;
    }

    private final JBHtmlPane createDescription() {
        JBHtmlPane jBHtmlPane;
        JBHtmlPaneStyleConfiguration styleConfiguration = new JBHtmlPaneStyleConfiguration();
        JBHtmlPaneConfiguration paneConfiguration2 = new JBHtmlPaneConfiguration((Function1)new Function1<JBHtmlPaneConfiguration.Builder, Unit>(this){
            final /* synthetic */ FeatureWelcomePanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JBHtmlPaneConfiguration.Builder $this$$receiver) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                $this$$receiver.customStyleSheet("pre {white-space: pre-wrap;} code, pre, a {overflow-wrap: anywhere;}");
                ExtendableHTMLViewFactory.Extension[] extensionArray = new ExtendableHTMLViewFactory.Extension[]{ExtendableHTMLViewFactory.Extensions.icons((Function1)((Function1)new Function1<String, Icon>((Object)this.this$0){

                    @Nullable
                    public final Icon invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return FeatureWelcomePanel.access$llmInstallerIconsProvider((FeatureWelcomePanel)this.receiver, p0);
                    }
                }))};
                $this$$receiver.extensions(extensionArray);
            }
        });
        JBHtmlPane $this$createDescription_u24lambda_u241 = jBHtmlPane = new JBHtmlPane(styleConfiguration, paneConfiguration2);
        boolean bl = false;
        $this$createDescription_u24lambda_u241.setOpaque(false);
        return jBHtmlPane;
    }

    private final Icon llmInstallerIconsProvider(String key) {
        Class<LLMIcons> iconClass = LLMIcons.class;
        String string = iconClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)key, (String)string, (boolean)false, (int)2, null) ? IconLoader.findIcon((String)key, iconClass) : null;
    }

    private final JComponent createAnimation(byte[] videoBytes) {
        JBCefBrowser browser = this.createBrowser(videoBytes);
        Component component = browser.getBrowserComponent();
        if (component != null) {
            component.addMouseListener(new MouseAdapter(browser, this, videoBytes){
                final /* synthetic */ JBCefBrowser $browser;
                final /* synthetic */ FeatureWelcomePanel this$0;
                final /* synthetic */ byte[] $videoBytes;
                {
                    this.$browser = $browser;
                    this.this$0 = $receiver;
                    this.$videoBytes = $videoBytes;
                }

                public void mouseClicked(@Nullable MouseEvent e) {
                    this.$browser.getCefBrowser().executeJavaScript("pauseVideo()", this.$browser.getCefBrowser().getURL(), 0);
                    JBDimension largeSize = new JBDimension(800, 450);
                    DialogBuilder dialogBuilder = new DialogBuilder();
                    JComponent jComponent = FeatureWelcomePanel.access$createBrowser(this.this$0, this.$videoBytes).getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                    DialogBuilder dialogBuilder2 = dialogBuilder.centerPanel((JComponent)new ScalableWrapper(jComponent, 1.7777777777777777, largeSize));
                    JBCefBrowser jBCefBrowser = this.$browser;
                    DialogBuilder $this$mouseClicked_u24lambda_u242 = dialogBuilder2;
                    boolean bl = false;
                    Function0 play2 = (Function0)new Function0<Unit>(jBCefBrowser, $this$mouseClicked_u24lambda_u242){
                        final /* synthetic */ JBCefBrowser $browser;
                        final /* synthetic */ DialogBuilder $this_apply;
                        {
                            this.$browser = $browser;
                            this.$this_apply = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            this.$browser.getCefBrowser().executeJavaScript("playVideo()", this.$browser.getCefBrowser().getURL(), 0);
                            this.$this_apply.getDialogWrapper().close(0);
                        }
                    };
                    $this$mouseClicked_u24lambda_u242.setOkOperation(() -> createAnimation.1.mouseClicked$lambda$2$lambda$0(play2));
                    $this$mouseClicked_u24lambda_u242.setCancelOperation(() -> createAnimation.1.mouseClicked$lambda$2$lambda$1(play2));
                    $this$mouseClicked_u24lambda_u242.removeAllActions();
                    $this$mouseClicked_u24lambda_u242.addCloseButton();
                    dialogBuilder2.show();
                }

                private static final void mouseClicked$lambda$2$lambda$0(Function0 $tmp0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke();
                }

                private static final void mouseClicked$lambda$2$lambda$1(Function0 $tmp0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke();
                }
            });
        }
        JComponent jComponent = browser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private final JBCefBrowser createBrowser(byte[] videoBytes) {
        String videoBase64 = Base64.getEncoder().encodeToString(videoBytes);
        Intrinsics.checkNotNull((Object)videoBase64);
        Color color = this.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
        String pageHtml = WebAnimationUtils.INSTANCE.createVideoHtmlPage(videoBase64, color);
        JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setMouseWheelEventEnable(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        JBCefBrowser browser = jBCefBrowser;
        browser.loadHTML(pageHtml);
        return browser;
    }

    public static final /* synthetic */ WelcomeFeatureDescriptor access$getFeatureDescriptor$p(FeatureWelcomePanel $this) {
        return $this.featureDescriptor;
    }

    public static final /* synthetic */ Project access$getProject(FeatureWelcomePanel $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ int access$getIndex$p(FeatureWelcomePanel $this) {
        return $this.index;
    }

    public static final /* synthetic */ JComponent access$createAnimation(FeatureWelcomePanel $this, byte[] videoBytes) {
        return $this.createAnimation(videoBytes);
    }

    public static final /* synthetic */ JBHtmlPane access$createDescription(FeatureWelcomePanel $this) {
        return $this.createDescription();
    }

    public static final /* synthetic */ Icon access$llmInstallerIconsProvider(FeatureWelcomePanel $this, String key) {
        return $this.llmInstallerIconsProvider(key);
    }

    public static final /* synthetic */ JBCefBrowser access$createBrowser(FeatureWelcomePanel $this, byte[] videoBytes) {
        return $this.createBrowser(videoBytes);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001a\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel$EditorPaneWrapper;", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JEditorPane;", "htmlText", "", "Lorg/jetbrains/annotations/Nls;", "(Ljavax/swing/JEditorPane;Ljava/lang/String;)V", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "updateUI", "", "intellij.llmInstaller"})
    private static final class EditorPaneWrapper
    extends JPanel {
        @NotNull
        private final JEditorPane component;
        @NotNull
        private final String htmlText;

        public EditorPaneWrapper(@NotNull JEditorPane component, @NotNull String htmlText) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
            super(new BorderLayout());
            this.component = component;
            this.htmlText = htmlText;
            this.component.setText(this.htmlText);
            this.add((Component)this.component, "Center");
        }

        @Override
        public void updateUI() {
            block0: {
                super.updateUI();
                String string = this.htmlText;
                if (string == null) break block0;
                String it = string;
                boolean bl = false;
                this.component.setText(this.htmlText);
            }
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Container container = this.getParent();
            if (container == null) {
                return this.getMinimumSize();
            }
            Container parent = container;
            int n = parent.getWidth();
            Insets insets = parent.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            int availableWidth = n - UiSizeUtilKt.getWidth((Insets)insets);
            this.component.setSize(new Dimension(availableWidth, Short.MAX_VALUE));
            Dimension preferredSize = this.component.getPreferredSize();
            return new Dimension(this.getMinimumSize().width, preferredSize.height);
        }

        @Override
        @NotNull
        public Dimension getMinimumSize() {
            return (Dimension)new JBDimension(50, 10);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel$ScalableWrapper;", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "proportion", "", "minSize", "Lcom/intellij/util/ui/JBDimension;", "(Ljavax/swing/JComponent;DLcom/intellij/util/ui/JBDimension;)V", "getMinSize", "()Lcom/intellij/util/ui/JBDimension;", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "intellij.llmInstaller"})
    private static final class ScalableWrapper
    extends JPanel {
        private final double proportion;
        @NotNull
        private final JBDimension minSize;

        public ScalableWrapper(@NotNull JComponent component, double proportion, @NotNull JBDimension minSize) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)minSize, (String)"minSize");
            super(new BorderLayout());
            this.proportion = proportion;
            this.minSize = minSize;
            this.add((Component)component, "Center");
        }

        @NotNull
        public final JBDimension getMinSize() {
            return this.minSize;
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Container container = this.getParent();
            if (container == null) {
                return this.getMinimumSize();
            }
            Container parent = container;
            int n = parent.getWidth();
            Insets insets = parent.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            double height = (double)(n - UiSizeUtilKt.getWidth((Insets)insets)) / this.proportion;
            return new Dimension(this.getMinimumSize().width, (int)height);
        }

        @Override
        @NotNull
        public Dimension getMinimumSize() {
            return (Dimension)this.minSize;
        }
    }
}

