/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.AbstractArrayMapOwner;
import org.jetbrains.kotlin.util.ArrayMap;
import org.jetbrains.kotlin.util.ArrayMapImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u001e\u0010\u000f\u001a\u00028\u00012\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0011H\u0084\u0002\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/util/ComponentArrayOwner;", "K", "", "V", "Lorg/jetbrains/kotlin/util/AbstractArrayMapOwner;", "()V", "arrayMap", "Lorg/jetbrains/kotlin/util/ArrayMap;", "getArrayMap", "()Lorg/jetbrains/kotlin/util/ArrayMap;", "createDiagnosticMessage", "", "id", "", "keyQualifiedName", "get", "key", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "registerComponent", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "compiler.common"})
public abstract class ComponentArrayOwner<K, V>
extends AbstractArrayMapOwner<K, V> {
    @NotNull
    private final ArrayMap<V> arrayMap = new ArrayMapImpl();

    @Override
    @NotNull
    protected final ArrayMap<V> getArrayMap() {
        return this.arrayMap;
    }

    @Override
    protected final void registerComponent(@NotNull String keyQualifiedName, @NotNull V value2) {
        Intrinsics.checkNotNullParameter((Object)keyQualifiedName, (String)"keyQualifiedName");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        int id = this.getTypeRegistry().getId(keyQualifiedName);
        try {
            this.arrayMap.set(id, value2);
        }
        catch (Exception e) {
            throw new RuntimeException(this.createDiagnosticMessage(id, keyQualifiedName), e);
        }
    }

    @NotNull
    protected final V get(@NotNull KClass<? extends K> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int id = this.getTypeRegistry().getId(key);
        V v = this.arrayMap.get(id);
        if (v == null) {
            throw new IllegalStateException(("No '" + key + "'(" + id + ") component in array: " + this).toString());
        }
        return v;
    }

    private final String createDiagnosticMessage(int id, String keyQualifiedName) {
        StringBuilder stringBuilder;
        StringBuilder $this$createDiagnosticMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$createDiagnosticMessage_u24lambda_u240.append("Error occurred during registration of component in array");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$createDiagnosticMessage_u24lambda_u240.append("Currently registered");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$createDiagnosticMessage_u24lambda_u240.append("  " + id + ": " + keyQualifiedName);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$createDiagnosticMessage_u24lambda_u240.append("Registrar:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        for (Map.Entry<String, Integer> entry : this.getTypeRegistry().allValuesThreadUnsafeForRendering().entrySet()) {
            String kClass = entry.getKey();
            int x = ((Number)entry.getValue()).intValue();
            StringBuilder stringBuilder6 = $this$createDiagnosticMessage_u24lambda_u240.append("  " + x + ": " + kClass);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        }
        StringBuilder stringBuilder7 = $this$createDiagnosticMessage_u24lambda_u240.append("Array map:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        int n = this.arrayMap.getSize();
        for (int i = 0; i < n; ++i) {
            Object element = this.arrayMap.get(i);
            if (element != null) {
                element = Reflection.getOrCreateKotlinClass(element.getClass());
            }
            StringBuilder stringBuilder8 = $this$createDiagnosticMessage_u24lambda_u240.append("  " + i + ": " + element);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }
}

